/*  lmpc -- the Little Movie Processing Centre
    Copyright (C) 1994-98 Uwe Girlich

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Uwe Girlich
    Erika-von-Brockdorff-Strasse 2
    04159 Leipzig
    Deutschland / Germany
    E-mail: Uwe.Girlich@itp.uni-leipzig.de */

/****************************************************************************\
|  uqwd.h - header file of uqwd.c, general QWD routines                      |
\****************************************************************************/


#ifndef __UQWD_H
#define __UQWD_H


#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif


#define QUAKEWORLD 4096
#define H_QWD_HINT (1<<19)


#define H_QWD_SPAWNSTATIC   (H_QWD_HINT | 1)
#define H_QWD_SPAWNBASELINE (H_QWD_HINT | 2)


#define QWD_MAX_MODELS 256
#define QWD_MAX_SOUNDS 256


#include "node.h"
#include "binblock.h"


typedef struct {
  char* filename;
  size_t filesize;
  FILE* file;
  char* precache_models[QWD_MAX_MODELS+1];
  long nummodels;
  char* precache_sounds[QWD_MAX_SOUNDS+1];
  long numsounds;
  long lastHealth;
  long lastArmor;
  long lastMinusHealth;
  long lastMinusArmor;
  unsigned char playermodel;
  int frame;
} QWD_t;
  
extern token_t QWD_token[];

extern unsigned long isQWDbin(char *filename);

extern void QWD_init(QWD_t* d, char *filename, char *mode);
extern void QWD_open(QWD_t *d, char *mode);
extern void QWD_close(QWD_t *d);
extern void QWD_done(QWD_t* d);
extern void QWD_block_read_bin(QWD_t *d, BB_t* m);
extern node* QWD_bin_to_node(BB_t* m, int opt);

      
#endif /* __UQWD_H */


/*-- file end uqwd.h --------------------------------------------------------*/
