void() respawn =
{	if (coop)
	{
		// make a copy of the dead body for appearances sake
		SolidPlayer();
		// get the spawn parms as they were at level start
		setspawnparms (self);
		// respawn		
		PutClientInServer ();
	}
	else if (deathmatch)
	{
		// make a copy of the dead body for appearances sake
		SolidPlayer();
		PutClientInServer ();
	}
	else
	{	// restart the entire server
		if(parm7)
			changelevel (mapname, startspot);
		else
			localcmd ("restart restore\n");
	}
};

float(vector v) CheckSpawnPoint =
{
	return FALSE;
};

/*
============
SelectSpawnPoint

Returns the entity to spawn at
============
*/
//@@ TODO: not fixed order!!!
entity() SelectSpawnPoint =
{//FIXME: if start on 2nd - 5th hubs, fill in correct startspot string
	entity spot;
	entity thing;
	float  pcount;
	float ok;
	
// testinfo_player_start is only found in regioned levels
	spot = find (world, classname, "testplayerstart");
	if (spot)
		return spot;
		
// choose a info_player_deathmatch point
	if(self.newclass)
	{
		spot = find(world, classname, "classchangespot");
		if(spot)
		{
			spot.think=SUB_Remove;
			thinktime spot : 1;
			return spot;
		}
	}

	if (coop)
	{
		spot = lastspawn;
		pcount = 1;
		while (pcount > 0 && pcount < 3)
		{
			spot = find(spot, classname, "info_player_coop");
			if (spot != world && 
			    (spot.targetname == startspot) ||
				(startspot == string_null && spot.spawnflags & 1))
			{
				thing = findradius(spot.origin, 64);
				ok = TRUE;
				while (thing)
				{
					if ((thing.classname == "player")||(thing.classname=="bot"))
					{
						thing = world;
						ok = FALSE;
					}
					else thing = thing.chain;
				}
				if (ok)
				{
					lastspawn = spot;
					return lastspawn;
				}
			}
			if (spot == world)
				pcount += 1;
		}
//		dprint("Resorting to info_player_start\n");
		lastspawn = find (lastspawn, classname, "info_player_start");
		if (lastspawn != world)
			return lastspawn;
	}
	else if (deathmatch)
	{
		spot = lastspawn;
		while (1)
		{
			spot = find(spot, classname, "info_player_deathmatch");
			if (spot != world)
			{
				if (spot == lastspawn)
					return lastspawn;
				pcount = 0;
				thing = findradius(spot.origin, 64);
				while(thing)
				{
					if ((thing.classname == "player")||(thing.classname=="bot"))
						pcount = pcount + 1;
					thing = thing.chain;
				}
				if (pcount == 0)
				{
					lastspawn = spot;
					return spot;
				}
			}
		}
	}

	if (startspot)
	{
		spot = world;
		pcount = 1;
		while(pcount)
		{
			spot = find (spot, classname, "info_player_start");
			if (!spot)
				pcount = 0;
			else if (spot.targetname == startspot)
				pcount = 0;
		}
	}
	
	if (!spot)
	{
		spot = find (world, classname, "info_player_start");
		if (!spot)
			error ("PutClientInServer: no info_player_start on level");
	}

	return spot;
};

void resetclient(entity cl)
{	local entity spot;
	if(deathmatch)
	{
		cl.items(-)IT_WEAPON4|IT_WEAPON2|IT_WEAPON3|IT_WEAPON4_1|IT_WEAPON4_2;
		cl.skin=0;
	}

	cl.act_state =
	cl.onfire=
	cl.healthtime=
	cl.splash_time=
	cl.decap=
	cl.frozen= 
	cl.last_attack=
	cl.attack_finished = 
	cl.plaqueflg = 0;
	cl.wallspot='0 0 0';
	cl.deathtype="";
	cl.viewentity=cl;
	cl.view_ofs = '0 0 50';
	cl.proj_ofs=' 0 0 44';
	cl.dmg = 2;   		// initial water damage
	cl.velocity = '0 0 0';
	cl.avelocity = '0 0 0';
	cl.adjust_velocity = '-999 -999 -999';
	cl.air_finished = time + 12;
	setsize (cl, '-16 -16 0', '16 16 56');	
	cl.hull=HULL_PLAYER;

	spot = SelectSpawnPoint ();
	setorigin(cl, spot.origin + '0 0 1');
	cl.angles = spot.angles;
	cl.fixangle = TRUE;		// turn this way immediately
	cl.flags(-)FL_ONGROUND;
	if (deathmatch || coop)
	{
		makevectors(cl.angles);
		GenerateTeleportEffect(cl.origin,0);
	}	
	spawn_tdeath (cl.origin, cl);
	cl.way1=
	cl.way2=
	cl.way3=
	cl.way4=
	cl.way5=world;
	cl.followpath=FALSE;
}

void newclient(entity cl)
{	local entity oldself;
	cl.takedamage = DAMAGE_YES;
        cl.yaw_speed = 60;
	cl.solid = SOLID_SLIDEBOX;
	cl.scale=1;
	cl.skin=0;
	cl.drawflags=cl.abslight=cl.effects=0;
	cl.flags(+)FL_CLIENT;
	cl.flags2(+)FL_ALIVE;
	cl.thingtype=THINGTYPE_FLESH;
//Reset all time-based fields
	cl.show_hostile = 
	cl.invisible_time=
	cl.camptime=
	cl.torchtime=
	cl.catapult_time=
	cl.safe_time=
	cl.absorb_time=
	cl.last_impact=
	cl.sheep_sound_time=
	cl.still_time=
	cl.last_onground=
	cl.invisible_finished=
	cl.invincible_time=
	cl.ring_regen_time=
	cl.rings_low=
	cl.pausetime = 
	cl.teleport_time = 
	cl.sheep_time =
	cl.super_damage_time=
	cl.haste_time =
	cl.tome_time =
	cl.camera_time=
	cl.ring_regen_time=
	cl.ring_flight_time=
	cl.ring_water_time=
	cl.ring_turning_time=
	cl.super_damage=
	cl.super_damage_low=
	cl.hasted= 
	cl.artusedelay=0;
	cl.artifact_active(-)ARTFLAG_FROZEN|ARTFLAG_STONED;
	if(cl.newclass)
	{
		bprint(cl.netname);
		bprint(" becomes a ");
		if(cl.newclass==CLASS_PALADIN)
			bprint("Paladin!\n");
		else if(cl.newclass==CLASS_CRUSADER)
			bprint("Crusader!\n");
		else if(cl.newclass==CLASS_NECROMANCER)
			bprint("Necromancer!\n");
		else
			bprint("Assassin!\n");
		cl.playerclass=cl.newclass;
		setclass(cl,cl.playerclass);
		stats_NewClass(cl);
		cl.newclass=FALSE;
	}

	if(deathmatch&&randomclass)
		cl.playerclass=CLASS_NONE;
	else if ((cl.classname=="bot")&&(fixedclass))
	{	setclass(cl,fixedclass);
	}
	else if ((cl.classname=="player")&&(!randomclass)&&(!fixedclass))
		fixedclass=self.playerclass;

	if (cl.playerclass == CLASS_NONE)
	{ // Default it to the paladin if not selected
		if (cvar("registered") != 0 || cvar("oem") != 0)
			setclass(cl,rint(random(1,4)));
		else
		{
			if (random() < 0.5)
				setclass(cl,CLASS_PALADIN);
			else
				setclass(cl,CLASS_ASSASSIN);
		}
	}
	if(cl.max_health<=0)
		stats_NewPlayer(cl);
	else
		cl.health = cl.max_health;
	if(cl.max_health<=0||cl.health<=0)
	{
		cl.health=cl.max_health=100;
	}
	cl.deadflag = DEAD_NO;

	if(!cl.weapon)
	{
		cl.items=IT_WEAPON1;
		cl.weapon=IT_WEAPON1;
		cl.oldweapon=IT_WEAPON1;
	}
	if(deathmatch)
		cl.weapon=IT_WEAPON1;

	if(coop)
	{//Need more mana in coop, especially if you die
		if(cl.bluemana<25)
			cl.bluemana=25;
		if(cl.greenmana<25)
			cl.greenmana=25;
	}

	oldself=self;
	self=cl;
	W_SetCurrentAmmo ();
	SetModelAndThinks();
	PlayerSpeed_Calc();
	self=oldself;

	if(deathmatch)
	{
		cl.effects=0;
		cl.artifact_active=ART_INVINCIBILITY;
		cl.invincible_time = time + 3;
		cl.artifact_low(+)ART_INVINCIBILITY;

		if(cl.playerclass==CLASS_CRUSADER)
			cl.skin = GLOBAL_SKIN_STONE;
		else if(cl.playerclass==CLASS_PALADIN)
			cl.effects(+)EF_BRIGHTLIGHT; 
		else if(cl.playerclass==CLASS_ASSASSIN)
			cl.colormap=140;
		else if(cl.playerclass==CLASS_NECROMANCER)
			cl.effects(+)EF_DARKLIGHT;
	}
	cl.ring_regen_time = 0;
	cl.ring_flight_time=0;	
	cl.ring_water_time=0;	
	cl.ring_turning_time=0;
	cl.ring_flight=0;		// Health of rings 0 - 100
	cl.ring_water=0;		// 
	cl.ring_turning=0;		//
	cl.ring_regeneration=0;		//
	cl.rings = 0;

	cl.idealpitch = cvar("sv_walkpitch");
	cl.button0 = cl.button1 = cl.button2 = 0;
	cl.attack_finished=time+0.5;//so no respawn fire
	cl.client_name="client";
}

void restartclient(entity cl,float TimeDiff)
{	local entity oldself;
	cl.artifact_active(-)ARTFLAG_FROZEN|ARTFLAG_STONED;
	cl.ring_flight_time = 0;
	cl.ring_flight = 0;
	cl.rings (-) RING_FLIGHT;
	cl.rings_active (-) RING_FLIGHT;

	cl.ring_regen_time += TimeDiff; 
	cl.ring_water_time += TimeDiff; 
	cl.ring_turning_time += TimeDiff; 

	cl.super_damage_time += TimeDiff; 
	cl.haste_time  += TimeDiff; 
	cl.tome_time  += TimeDiff; 
	cl.camera_time  += TimeDiff; 
	cl.torchtime += TimeDiff; 

	cl.pausetime += TimeDiff; 
	cl.teleport_time += TimeDiff; 
	cl.sheep_time += TimeDiff; 
	cl.attack_finished += TimeDiff;
	cl.catapult_time+= TimeDiff;
	cl.safe_time+= TimeDiff;
	cl.absorb_time+= TimeDiff;
	cl.last_impact+= TimeDiff;
	cl.sheep_sound_time+= TimeDiff;
	cl.still_time+= TimeDiff;
	cl.last_onground+= TimeDiff;
	cl.invincible_time+= TimeDiff;
	cl.show_hostile+= TimeDiff;
	cl.invisible_time+= TimeDiff;
	cl.camptime+= TimeDiff;
	cl.artusedelay+= TimeDiff;

	cl.light_level = 128;		// So the assassin doesn't go invisible coming out of the teleporter

	oldself=self;
	self=cl;
	SetModelAndThinks();
	PlayerSpeed_Calc();
	W_SetCurrentAmmo ();
	self=oldself;
	force_retouch = 2;		// make sure even still objects get hit
}

/*
===========
PutClientInServer

called each time a player is spawned
============
*/
void() PutClientInServer =
{	self.classname = "player";
	self.movetype = MOVETYPE_WALK;
	resetclient(self);
	newclient(self);
	
	player_frames();
	
	create_message_machine();
};


void ClientReEnter(float TimeDiff)
{
/*
	Called for living players entering a level
	(except for first starting a game)
	or when	you die any time other than on the
	first level	you started playing on.
*/
	if(!self.flags2&FL_ALIVE||self.health<1||(self.newclass&&!deathmatch&&!coop))
	{//If dead, put them in the right spot.
		self.weapon=IT_WEAPON1;
		PutClientInServer();
		return;
	}

	// Need to reset these because they could still point to entities in the previous map
	self.enemy = self.groundentity = self.chain = self.goalentity = self.dmg_inflictor = 
		self.owner = world;

	resetclient(self);
	restartclient(self,TimeDiff);

	self.movetype=MOVETYPE_WALK;

	self.think=player_frames;
	thinktime self : 0;
}

void(entity bott) resetbot=
{	bott.classname = "bot";
	bott.movetype = MOVETYPE_STEP;

	resetclient(bott);

	setbotthinks(bott);

	bott.speed=cvar("sv_maxspeed")*1.41;
	if(bott.bot_num>=BOT_5)
	{	if(bott.bot_num>=BOT_10)
		{	if(bott.bot_num>=BOT_13)
			{	bott.speed=bott.speed*1.0;
			}
			else bott.speed=bott.speed*0.96;
		}
		else bott.speed=bott.speed*0.92;
	}
	else bott.speed=bott.speed*0.88;
	if(skill<3)
	{	if(skill<2)
			bott.speed=bott.speed*0.90;
		else
			bott.speed=bott.speed*1.00;
	}
	else bott.speed=bott.speed*1.10;
};

void() BotReEnter=
{	local float aggression;
	self.enemy = self.groundentity = self.chain = self.goalentity = self.dmg_inflictor = 
		self.owner = world;
	resetbot(self);
	newclient(self);
	// set aggression (starting)
	aggression=random()*100+skill*10;
	if((self.bot_num>=BOT_3)&&(aggression>95))
		self.f1=TRUE;
	else if((self.bot_num>=BOT_12)&&((aggression>72)||(self.frags<0.6*highestfrags)))
		self.f1=TRUE;
	else if((self.bot_num>=BOT_14)&&((aggression>40)||(self.frags<0.8*highestfrags)))
		self.f1=TRUE;
	else
		self.f1=FALSE;

	self.abslight=0.75;
	self.light_level=128;
	self.nextthink = time + 0.1 + random()/10;
	self.think = self.th_stand;
	self.act_state=ACT_STAND;
};

void() BotEnter=
{	local float aggression;
	botConnect(self);
	resetbot(self);
	newclient(self);
	// set aggression (starting)
	aggression=random()*100+skill*10;
	if((self.bot_num>=BOT_3)&&(aggression>95))
		self.f1=TRUE;
	else if((self.bot_num>=BOT_12)&&((aggression>72)||(self.frags<0.6*highestfrags)))
		self.f1=TRUE;
	else if((self.bot_num>=BOT_14)&&((aggression>40)||(self.frags<0.8*highestfrags)))
		self.f1=TRUE;
	else
		self.f1=FALSE;

	self.abslight=0.75;
	self.light_level=128;
	self.nextthink = time + 0.1 + random()/10;
	self.think = self.th_stand;
	self.act_state=ACT_STAND;
	if(self.colormap<18) self.colormap=0;
	if (self.fClientNo==-1)
		remove(self);
};

void (string name, float botnum, float shirt, float pants) BotCreate =
{
	local entity	newbot;

        newbot = spawn();

	newbot.netname = name;
        newbot.fPants = pants;
	newbot.fShirt = shirt;
	newbot.bot_num=botnum;
	newbot.classname="bot";
	newbot.fClientNo= -1;

	if (teamplay)
                newbot.team = self.team;
        newbot.frags = 0;
        newbot.colormap = self.colormap;

	newbot.deadflag=DEAD_DEAD;
	newbot.movetype=MOVETYPE_NONE;
	newbot.solid=SOLID_NOT;

	newbot.nextthink = time + 0.1 + random()*5;
	newbot.think = BotEnter;
};

void () botrespawn =
{	if(intermission_running) return;
	self.deadflag=DEAD_DEAD;
	self.movetype=MOVETYPE_NONE;
	self.solid=SOLID_NOT;
	self.nextthink = time + 0.1 + random()*2;
	self.think = BotReEnter;
};

void(float r) botaddname=
{ 	local float k;
	if (r==1)
		BotCreate("Barney",BOT_1,0,1);
  	else if (r==2)
		BotCreate("Bugs",BOT_2,7,9);
  	else if (r==3)
		BotCreate("[WCA]Chuck",BOT_3,4,2);
  	else if (r==4)
		BotCreate("[WCA]Hunt",BOT_4,4,3);
  	else if (r==5)
		BotCreate("[WCA]Killer",BOT_5,4,4);
  	else if (r==6)
		BotCreate("[BC]Fazor",BOT_6,5,6);
  	else if (r==7)
		BotCreate("[BC]Demon",BOT_7,5,7);
  	else if (r==8)
		BotCreate("[BC]Boirg",BOT_8,5,8);
  	else if (r==9)
		BotCreate("Synd 7",BOT_9,6,3);
  	else if (r==10)
		BotCreate("Vilify",BOT_10,7,9);
 	else if (r==11)
		BotCreate("Van Gard",BOT_11,9,10);
  	else if (r==12)
		BotCreate("Execrate",BOT_12,11,10);
  	else if (r==13)
		BotCreate("Servile",BOT_13,11,2);
  	else if (r==14)
		BotCreate("Pluto",BOT_14,2,8);
  	else if (r==15)
		BotCreate("Abaddon",BOT_15,3,1);
  	else if (r==16)
		BotCreate("Mantas",BOT_16,4,11);
  	else if (r==17)
  	{	// our coop bot
		BotCreate("BoogeyMan",BOT_17,10,5);
  	}
  	numbots=0;
  	k=BOT_1;
  	while(k<=BOT_17)
  	{ 	if(k&indbots)
  			numbots=numbots+1;
    		k=k*2;
  	}
};

void() botremove=
{	local entity k;
	numbots=0;
	k=find(world,classname,"bot");
	while(k!=world)
	{	botDisconnect(k);
		remove(k);
		k=find(world,classname,"bot");
	}
	bprint("All bots removed\n");
	indbots=0;
};

void() bot_readd=
{	local float botstoadd,botnum,botcount;
	local entity k;
	botstoadd=indbots;
	k=find(world,classname,"bot");
	while(k!=world)
	{ 	botstoadd= botstoadd - (botstoadd & k.bot_num);
		k=find(k,classname,"bot");
	}
	if (botstoadd)
	{	botnum=BOT_1;
		botcount=1;
		while(botnum <= BOT_17)
		{ 	if(botnum & botstoadd)
				botaddname(botcount);
			botnum=botnum*2;
			botcount=botcount+1;
		}
	}
};

void () BotAdd =
{ 	local float k,botcount,botnum;
  	if(indbots==65535)
     		return;
  	botcount=floor((random()*16)+1);
  	botnum=BOT_1;
  	k=botcount;
  	while(k>1)
  	{ 	botnum=botnum*2;
    		k = k - 1;
  	} 
  	while(botnum & indbots)
  	{ 	botcount=botcount+1;
    		botnum=botnum*2;
    		if(botcount>16) 
    		{ 	botcount=1;
    			botnum=1;
    		}
  	}
  	if((indbots|botnum)==65535)
     		return;
  	indbots= indbots | botnum;
  	botaddname(botcount);
};

void (float r)	bottrytoadd=
{	local float botnum,botcount;
	botnum=BOT_1;
	botcount=1;
	while(botcount!=r)
	{	botcount=botcount+1;
		botnum=botnum*2;
	}
	if(!(botnum & indbots))
	{	indbots=indbots|botnum;
		botaddname(r);
	}
};

