/*
==============================================================================
RANKINGS.QC by Alan Kivlin <e-mail: alan.kivlin@cybersurf.co.uk>

07 / JUNE / 1997

Copyright (C) 1997 by Alan Kivlin.
==============================================================================
*/

/*
==============================================================================
clientInitMaxClients

stores in fMaxClients, the maximum number of client's allowed in the game
==============================================================================
*/

void() clientInitMaxClients =
{
   local entity ent;

   // this works by counting the number of entities created after world
   // so you must call it right at the beginning of worldspawn in WORLD.QC

   ent = nextent( world );

   while( ent.classname != "worldspawn" )
   {
      fMaxClients = fMaxClients + 1;
      ent = nextent( ent );
   }
};

/*
==============================================================================
clientBitFlag

returns the client's bit flag
==============================================================================
*/

float( float clientno ) clientBitFlag =
{
   local float bitflag;

   bitflag = 1;

   while( clientno > 0 )
   {
      bitflag = bitflag * 2;
      clientno = clientno - 1;
   }

   return bitflag;
};

/*
==============================================================================
clientIsActive

returns TRUE if the client number specified is in use by a bot or player
==============================================================================
*/

float( float clientno ) clientIsActive =
{
   if( fActiveClients & clientBitFlag( clientno ) )
      return TRUE;

   return FALSE;
};

/*
==============================================================================
clientSetUsed

marks the client's bit flag as being in use
==============================================================================
*/

void( float clientno ) clientSetUsed =
{
   fActiveClients = fActiveClients | clientBitFlag( clientno );
};

/*
==============================================================================
clientSetFree

marks the client's bit flag as being available
==============================================================================
*/

void( float clientno ) clientSetFree =
{
   fActiveClients = fActiveClients - 
      ( fActiveClients & clientBitFlag( clientno ) );
};

/*
==============================================================================
clientNextAvailable

returns the next available free client number (-1 = none available)
==============================================================================
*/

float() clientNextAvailable =
{
   local float clientno;

   clientno = 0;

   while( clientno < fMaxClients )
   {
      if( ! clientIsActive( clientno ) )
         return clientno;

      clientno = clientno + 1;
   }

   return -1;
};

/*
==============================================================================
botConnect

sample routine for connecting a bot
==============================================================================
*/

void(entity botn) botConnect =
{
   local float clientno;

   clientno = clientNextAvailable();
   botn.fClientNo = clientno;

   if( clientno == -1 )
   {
      bprint( "Unable to connect a bot, server is full.\n" );
      return;
   }

   clientSetUsed( clientno );

   botn.colormap = clientno + 1;

   msgUpdateNameToAll( botn.fClientNo, botn.netname );
   msgUpdateColorsToAll( botn.fClientNo, botn.fShirt, botn.fPants );
   msgUpdateFragsToAll( botn.fClientNo, botn.frags );
   msgUpdateClassToAll( botn.fClientNo, botn.playerclass);
   bprint( botn.netname );
   bprint( " entered the game\n" );

   // add code to initialise the bot
};

/*
==============================================================================
botDisconnect

sample routine for disconnecting a bot
==============================================================================
*/

void( entity botn ) botDisconnect =
{  if( botn.fClientNo != -1 )
   {
      // the bot's client number is not in use by a real player so we
      // must remove it's entry in the rankings

      msgUpdateNameToAll( botn.fClientNo, string_null );
      msgUpdateColorsToAll( botn.fClientNo, 0, 0 );
      msgUpdateFragsToAll( botn.fClientNo, 0 );
      msgUpdateClassToAll( botn.fClientNo, 0);

      clientSetFree( botn.fClientNo );

      botn.fClientNo = -1;
   }

   bprint( botn.netname );
   bprint( " left the game with " );
   bprint( ftos( botn.frags ) );
   bprint( " frags\n" );

   sound( botn, CHAN_BODY, "player/tornoff2.wav", 1, ATTN_NONE );

   // add code to set the bot's suicide frame, copy it to the bodyque, etc
};

/*
==============================================================================
botInvalidClientNo

moves the conflicting bot over to a free client number, if none it disconnects
==============================================================================
*/

void( float clientno ) botInvalidClientNo =
{
   local entity botn;

   botn = find( world, classname, "bot" );

   while( botn )
   {
      if( botn.fClientNo == clientno )
      {
         clientno = clientNextAvailable();

         if( clientno != -1 )
         {
            clientSetUsed( clientno );

            botn.fClientNo = clientno;
            botn.colormap = botn.fClientNo + 1;

            msgUpdateNameToAll( botn.fClientNo, botn.netname );
            msgUpdateColorsToAll( botn.fClientNo, botn.fShirt, botn.fPants );
            msgUpdateFragsToAll( botn.fClientNo, botn.frags );
	    msgUpdateClassToAll( botn.fClientNo, botn.playerclass);
         }
         else
         {
            botn.fClientNo = -1;
            botDisconnect( botn );
         }

         return;
      }

      botn = find( botn, classname, "bot" );
   }
};

/*
==============================================================================
msgUpdateNameToAll

sends an update client name message to all players in the game
==============================================================================
*/

void( float clientno, string clientname ) msgUpdateNameToAll =
{
   WriteByte( MSG_ALL, MSG_UPDATENAME );
   WriteByte( MSG_ALL, clientno );
   WriteString( MSG_ALL, clientname );
};

/*
==============================================================================
msgUpdateColorsToAll

sends an update client colors message to all players in the game
==============================================================================
*/

void( float clientno, float clientshirt, float clientpants ) msgUpdateColorsToAll =
{
   WriteByte( MSG_ALL, MSG_UPDATECOLORS );
   WriteByte( MSG_ALL, clientno );
   WriteByte( MSG_ALL, clientshirt * 16 + clientpants );
};

void( float clientno, float pclass ) msgUpdateClassToAll =
{
   WriteByte( MSG_ALL, MSG_UPDATECLASS );
   WriteByte( MSG_ALL, clientno );
   WriteByte( MSG_ALL, pclass );
};

/*
==============================================================================
msgUpdateFragsToAll

sends an update client frags message to all players in the game
==============================================================================
*/

void( float clientno, float clientfrags ) msgUpdateFragsToAll =
{  if(clientfrags>highestfrags)
	highestfrags=clientfrags;
   WriteByte( MSG_ALL, MSG_UPDATEFRAGS );
   WriteByte( MSG_ALL, clientno );
   WriteShort( MSG_ALL, clientfrags );
};

