/*
============
ClientKill

Player entered the suicide command
============
*/
void() ClientKill =
{
	bprint (self.netname);
	bprint (" suicides\n");
	self.model=self.init_model;
	GibPlayer();
	self.frags -= 2;	// extra penalty
	drop_level(self,2);
	respawn ();
};


/*
===========
ClientConnect

called when a player connects to a server
============
*/
void() ClientConnect =
{	local entity botn;
	if(!self.colormap)self.colormap=1;
	// rankings support - cronos
	self.fClientNo = self.colormap - 1;
	if(clientIsActive(self.fClientNo))
		botInvalidClientNo(self.fClientNo);
	clientSetUsed(self.fClientNo);
	botn = find( world, classname, "bot" );
	while( botn )
	{
		msgUpdateNameToAll( botn.fClientNo, botn.netname );
		msgUpdateColorsToAll( botn.fClientNo, botn.fShirt, botn.fPants );
		msgUpdateFragsToAll( botn.fClientNo, botn.frags );
		botn = find( botn, classname, "bot" );
	}

	bprint (self.netname);
	bprint (STR_JOINEDTHEGAME);
// a client connecting during an intermission can cause problems
	if (intermission_running)
		ExitIntermission ();
};


/*
===========
ClientDisconnect

called when a player disconnects from a server
============
*/
void() ClientDisconnect =
{
	if (gameover)
		return;
	// if the level end trigger has been activated, just return
	// since they aren't *really* leaving

	//rankings support - cronos
	clientSetFree(self.fClientNo);

	// let everyone else know
	bprint (self.netname);
	bprint (STR_LEFTTHEGAMEWITH);
	bprint (ftos(self.frags));
	bprint (STR_FRAGS);
	sound (self, CHAN_BODY, "player/leave.wav", 1, ATTN_NONE);
	GibPlayer();
	set_suicide_frame ();
};
