void(entity pt) makeintowaypoint;
void() waypoint_touch;

void(entity pt1,entity pt2) joinwaypoints=
{	if((pt1.way1==pt2)||(pt1.way2==pt2)||(pt1.way3==pt2)
		||(pt1.way4==pt2)||(pt1.way5==pt2)||(pt1.way6==pt2))
		return;
	if(!pt1.way1)
	{ 	pt1.way1=pt2;
		pt1.s1=0;
		pt1.f1=0;
	}
	else if(!pt1.way2) 
	{	pt1.way2=pt2;
		pt1.s2=0;
		pt1.f2=0;
	}
	else if(!pt1.way3) 
	{	pt1.way3=pt2;
		pt1.s3=0;
		pt1.f3=0;
	}
	else if(!pt1.way4) 
	{	pt1.way4=pt2;
		pt1.s4=0;
		pt1.f4=0;
	}
	else if(!pt1.way5) 
	{	pt1.way5=pt2;
		pt1.s5=0;
		pt1.f5=0;
	}
	else if(!pt1.way6) 
	{	pt1.way6=pt2;
		pt1.s6=0;
		pt1.f6=0;
	}
};

float(entity pt1,entity pt2) arelinked=
{	if((pt1.way1==pt2)||(pt1.way2==pt2)||(pt1.way3==pt2)
		||(pt1.way4==pt2)||(pt1.way5==pt2)||(pt1.way6==pt2))
		return TRUE;
	return FALSE;
};

float(entity pt1,entity pt2) indirectlink=
{	if (pt1.way1!=world) if(arelinked(pt1.way1,pt2)) return TRUE;
	if (pt1.way2!=world) if(arelinked(pt1.way2,pt2)) return TRUE;
	if (pt1.way3!=world) if(arelinked(pt1.way3,pt2)) return TRUE;
	if (pt1.way4!=world) if(arelinked(pt1.way4,pt2)) return TRUE;
	if (pt1.way5!=world) if(arelinked(pt1.way5,pt2)) return TRUE;
	if (pt1.way6!=world) if(arelinked(pt1.way6,pt2)) return TRUE;
	return FALSE;
};

void(entity pt1,entity pt2) deletelink=
{	local entity wl,w1,w2;
	if(pt1.way1==pt2) pt1.way1=world;
	else if(pt1.way2==pt2) pt1.way2=world;
	else if(pt1.way3==pt2) pt1.way3=world;
	else if(pt1.way4==pt2) pt1.way4=world;
	else if(pt1.way5==pt2) pt1.way5=world;
	else if(pt1.way6==pt2) pt1.way6=world;
	// now remove it if it is linked nowhere
	if((pt1.way1!=world)||(pt1.way2!=world)||(pt1.way3!=world)||(pt1.way4!=world)
		||(pt1.way5!=world)||(pt1.way6!=world))
		return;
	wl=wlist;
	w1=world;
	while(wl)
	{	if(wl.wnext==pt1) w1=wl;
		// what happens if one of these gets unlinked ?
		// - wooh, whole waypoint system could collapse!
		// - but we'll ignore this double deletion case for now
		if(wl.way1==pt1) wl.way1=world;
		else if(wl.way2==pt1) wl.way2=world;
		else if(wl.way3==pt1) wl.way3=world;
		else if(wl.way4==pt1) wl.way4=world;
		else if(wl.way5==pt1) wl.way5=world;
		else if(wl.way6==pt1) wl.way6=world;
		wl=wl.wnext;
	}
	if(w1==world)
	{	wlist=wlist.wnext;
		remove(w1);
	}
	else
	{	w2=w1;
		w1=w1.wnext;
		w2.wnext=w1.wnext;
		remove(w1);
	}
};

void(entity w1,entity w2) registersuccess=
{	// a successful path was traversed
	if(w1.way1==w2) w1.s1=w1.s1+1;
	else if(w1.way2==w2) w1.s2=w1.s2+1;
	else if(w1.way3==w2) w1.s3=w1.s3+1;
	else if(w1.way4==w2) w1.s4=w1.s4+1;
	else if(w1.way5==w2) w1.s5=w1.s5+1;
	else if(w1.way6==w2) w1.s6=w1.s6+1;
	else joinwaypoints(w1,w2);
};

void(entity w1,entity w2) registerfail=
{	// failed to traverse a path
	if(w1.way1==w2)
	{ 	w1.f1=w1.f1+1;	
		if(w1.f1>w1.s1*5+10) deletelink (w1,w2);
	}
	else if(w1.way2==w2)
	{ 	w1.f2=w1.f2+1;
		if(w1.f2>w1.s2*5+10) deletelink (w1,w2);
	}
	else if(w1.way3==w2) 
	{	w1.f3=w1.f3+1;
		if(w1.f3>w1.s3*5+10) deletelink (w1,w2);
	}
	else if(w1.way4==w2) 
	{	w1.f4=w1.f4+1;
		if(w1.f4>w1.s4*5+10) deletelink (w1,w2);
	}
	else if(w1.way5==w2) 
	{	w1.f5=w1.f5+1;
		if(w1.f5>w1.s5*5+10) deletelink (w1,w2);
	}
	else if(w1.way6==w2) 
	{	w1.f6=w1.f6+1;
		if(w1.f6>w1.s6*5+10) deletelink (w1,w2);
	}
};

void(entity w1, entity w2) checkjoinwaypoints=
{	local float d,incline,dist;
	local vector a1,a2;
	dist=400;
	if(longwaypointlinks) dist=1200;	// link further in premapped lvls
	a1=w1.orgwaypt;
	a2=w2.orgwaypt;
	a1_z=0;
	a2_z=0;
	incline=vlen(w1.orgwaypt - w2.orgwaypt);
	d=vlen(a1 - a2);
	if((w1!=w2)&&((incline<50)||(incline<d*1.41))&&(!indirectlink(w1,w2))&&(d<dist))
	{	traceline(w1.orgwaypt,w2.orgwaypt,TRUE,w1);
		if((trace_ent==w2)||(trace_fraction==1))
		{	joinwaypoints(w2,w1);
			joinwaypoints(w1,w2);
		}
	}
};

void(entity pt) linkwaypoint=
{	local entity head;
	// find nearest waypoints and link in
	// teleports need to link to destination
	head=nearestwaypoint(pt.orgwaypt,FALSE);
	if(head!=world) checkjoinwaypoints(pt,head);
	head=wlist;
	while(head)
	{	checkjoinwaypoints(pt,head);
		head=head.wnext;
	}
	if(pt.classname=="trigger_teleport")
	{	head = find (world, targetname, pt.target);
		if(head) joinwaypoints(pt,head);
		makeintowaypoint(head); // we should really avoid!!
	}
};

void(entity pt) makeintowaypoint=
{	local entity otherpt;
	local float vl,pc;
	// disabled for now - extremely buggy! look out for chaining touches!
	return;
	pt.way1=world;
	pt.way2=world;
	pt.way3=world;
	pt.way4=world;
	pt.way5=world;
	pt.way6=world;
	pt.iswaypoint=TRUE;
	pt.orgwaypt=entityorigin(pt);
	pc=pointcontents(pt.orgwaypt);
	if((pc==CONTENT_LAVA)||(pc==CONTENT_SLIME))
		return;
	otherpt=nearestwaypoint(pt.orgwaypt,FALSE);
	if(otherpt!=world)
	{	vl=vlen(otherpt.orgwaypt - pt.orgwaypt);
		if(vl<100) return;
	}
	linkwaypoint(pt);
	if(wlist) 
	{	pt.wnext=wlist;
		wlist=pt;
	}
	else
	{	pt.wnext=world;
		wlist=pt;
	}
	pt.oldtouch=pt.touch;
	pt.touch=waypoint_touch;
};

void(entity pt) makewaypoint=
{	pt.way1=world;
	pt.way2=world;
	pt.way3=world;
	pt.way4=world;
	pt.way5=world;
	pt.way6=world;
	pt.iswaypoint=TRUE;
	pt.orgwaypt=pt.origin;
	linkwaypoint(pt);
	if(wlist) 
	{	pt.wnext=wlist;
		wlist=pt;
	}
	else
	{	pt.wnext=world;
		wlist=pt;
	}
	pt.oldtouch=SUB_Null;
	pt.touch=waypoint_touch;
};

entity(vector org) createnewwaypoint=
{	local entity waypt;
	local float pc;
	if(stopmorewaypoints) 
		return world;
	if(numents>420)
		return world;
	pc=pointcontents(org);
	if((pc==CONTENT_LAVA)||(pc==CONTENT_SLIME)||(pc==CONTENT_WATER))
		return world;
	waypt=spawn();
  	waypt.solid = SOLID_TRIGGER;
 	waypt.movetype = MOVETYPE_NONE;
  	waypt.think = SUB_Null;
 	waypt.nextthink =time+1;
  	waypt.takedamage = DAMAGE_NO;
	waypt.owner=world;
  	waypt.classname = "botwaypoint";
	//setmodel (waypt, "models/brains.mdl");
	setmodel (waypt, "");
	setsize (waypt, '0 0 0', '0 0 0');
	setorigin (waypt, org);
	makewaypoint(waypt);
	waypt.flags=FL_ITEM;		// extra wide trigger field ?
	return waypt;
};

entity(entity lastpt,entity currpt,entity prevlast) nextwaypoint=
{	local float numpoints,nr,cpoint;
	local entity cp;
	// returns a random point to go to given
	// the current waypoint and the lastwaypoint visited
	numpoints=0;
	if((currpt.way1!=lastpt)&&(currpt.way1!=world))
		numpoints=numpoints+1;
	if((currpt.way2!=lastpt)&&(currpt.way2!=world))
		numpoints=numpoints+1;
	if((currpt.way3!=lastpt)&&(currpt.way3!=world))
		numpoints=numpoints+1;
	if((currpt.way4!=lastpt)&&(currpt.way4!=world))
		numpoints=numpoints+1;
	if((currpt.way5!=lastpt)&&(currpt.way5!=world))
		numpoints=numpoints+1;
	if((currpt.way6!=lastpt)&&(currpt.way6!=world))
		numpoints=numpoints+1;
	if(!numpoints) return lastpt;
	if((numpoints>2)&&(prevlast!=world)&&(prevlast!=currpt))
		numpoints=numpoints - 1;
	nr=random()*numpoints;
	nr=ceil(nr);
	cpoint=0;
	while(nr)
	{	cpoint=cpoint+1;
		if(cpoint>6) cpoint=1;
		if(cpoint==1) cp=currpt.way1;
		else if(cpoint==2) cp=currpt.way2;
		else if(cpoint==3) cp=currpt.way3;
		else if(cpoint==4) cp=currpt.way4;
		else if(cpoint==5) cp=currpt.way5;
		else if(cpoint==6) cp=currpt.way6;
		if((cp==world)||(cp==lastpt)||((numpoints>1)&&(cp==prevlast)&&(prevlast!=currpt))) nr=nr+1;
		nr=nr - 1;
	}
	return cp;
};

entity(vector org,float cancreate) nearestwaypoint=
{	local entity head,selected;
	local float dist,incline,vl,wpcount;
	dist=200;
	selected=world;
	wpcount=0;
	head = wlist;
	while(head)
	{	traceline(org,head.orgwaypt,TRUE,self);
		if((trace_ent==head)||(trace_fraction==1)||(org==head.orgwaypt))
		{	vl=vlen(org - head.orgwaypt);
			incline=head.orgwaypt_z - org_z;
			if (vl) incline=incline/vl;	//= sin(angle)
			if((incline<0.75)&&(vl<dist))
			{	dist=vl;
				selected=head;
			}
			if(incline<0.75) wpcount=wpcount+1;
		}
		head=head.wnext;
	}
	if(cancreate)
	{	if((!selected)||((wpcount==1)&&(dist>100))||((wpcount==2)&&(dist>100)))
		{ 	return createnewwaypoint(org);
		}
	}
	return selected;
};

entity(vector org,entity pttoexclude,float cancreate) nextnearestwaypoint=
{	local entity head,selected;
	local float dist,incline,vl,wpcount;
	dist=300;
	selected=world;
	wpcount=0;
	head = wlist;
	while(head)
	{	traceline(org,head.orgwaypt,TRUE,self);
		if((trace_ent==head)||(trace_fraction==1)||(org==head.orgwaypt))
		{	vl=vlen(org - head.orgwaypt);
			incline=org_z - head.orgwaypt_z;
			if(vl) incline=incline/vl;
			if((incline<0.75)&&(vl<dist)&&(head!=pttoexclude))
			{	dist=vl;
				selected=head;
			}
			if(incline<0.75) wpcount=wpcount+1;
		}
		head=head.wnext;
	}
	if(cancreate)
	{	if((!selected)||((wpcount==1)&&(dist>100))||((wpcount==2)&&(dist>100)))
		{ 	return createnewwaypoint(org);
		}
	}
	return selected;
};

void() waypoint_touch=
{	if(other.classname=="bot")
	{	if((other.way2==self)&&(!other.followpath))
		{	other.reachedgoal=TRUE;
		}
		if((other.way1==self)&&(other.followpath))
		{	other.reachedgoal=TRUE;
		}
	}
	if(self.oldtouchon)self.oldtouch();
};

void() setgoal=
{
	if(self.way2!=world)
	{	self.goalentity=self.way2;
		self.waytime=time;
	}
	else
	{	self.goalentity=self;
		self.waytime=0;
	}
};

void() zero_waypoints=
{
	self.way1=world;
	self.way2=world;
	self.waytime=0;
	self.goalentity=self;
	self.reachedgoal=FALSE;
};

void(entity w) waypointdetails=
{	local float sr;
	bprint("Pt:");
	bprint(vtos(w.orgwaypt));
	bprint(" Links:");
	if(w.way1) bprint("1");
	else bprint("0");
	if(w.way2) bprint("1");
	else bprint("0");
	if(w.way3) bprint("1");
	else bprint("0");
	if(w.way4) bprint("1");
	else bprint("0");
	if(w.way5) bprint("1");
	else bprint("0");
	if(w.way6) bprint("1");
	else bprint("0");
	bprint(" Srates:");
	if((w.s1)||(w.f1)) sr=w.s1/(w.s1+w.f1);
	else sr=0;
	bprint(ftos(sr));
	bprint(" ");
	if((w.s2)||(w.f2)) sr=w.s2/(w.s2+w.f2);
	else sr=0;
	bprint(ftos(sr));
	bprint(" ");
	if((w.s3)||(w.f3)) sr=w.s3/(w.s3+w.f3);
	else sr=0;
	bprint(ftos(sr));
	bprint(" ");
	if((w.s4)||(w.f4)) sr=w.s4/(w.s4+w.f4);
	else sr=0;
	bprint(ftos(sr));
	bprint(" ");
	if((w.s5)||(w.f5)) sr=w.s5/(w.s5+w.f5);
	else sr=0;
	bprint(ftos(sr));
	bprint(" ");
	if((w.s6)||(w.f6)) sr=w.s6/(w.s6+w.f6);
	else sr=0;
	bprint(ftos(sr));
	bprint("\n");
};

void() waypointlist=
{	local entity head;
	head=wlist;
	while(head)
	{	waypointdetails(head);
		head=head.wnext;
	}
};