//Launches a nail in a offset spread (jweier)
void launch_spread(float offset)
{
	local	vector	offang;
	local	vector	org, vec;
   local entity   mis;

	org = self.origin;

	offang = vectoangles (self.movedir - org);
	offang_y = offang_y + offset * 6;
   
   makevectors (offang);

	vec = normalize (v_forward);

	vec_z = 0;

	mis = spawn ();
	mis.owner = self;
	mis.movetype = MOVETYPE_FLYMISSILE;
	mis.solid = SOLID_BBOX;

	mis.angles = vectoangles(vec);
	
	mis.touch = spike_touch;
	mis.classname = "spike";
	mis.think = SUB_Remove;
	thinktime mis : 6;
	setmodel (mis, "models/spike.mdl");
	setsize (mis, VEC_ORIGIN, VEC_ORIGIN);		
	setorigin (mis, org);

	mis.velocity = vec * 1000;
}

void spikeshooter_use()
{
	self.enemy = other.enemy;

	sound (self, CHAN_VOICE, "weapons/spike2.wav", 1, ATTN_NORM);
	launch_spike (self.origin, self.movedir);
	newmis.velocity = self.movedir * 500;
	if (self.spawnflags & SPAWNFLAG_SUPERSPIKE)
 		newmis.touch = spike_touch;
}

void shooter_think()
{
	spikeshooter_use ();
	thinktime self : self.wait;
}

void sprayshooter_use()
{
   sound (self, CHAN_VOICE, "weapons/spike2.wav", 1, ATTN_NORM);
   launch_spread(random(10));
}

void sprayshooter_think()
{
	sprayshooter_use ();
	thinktime self : self.wait;
}

/*QUAKED trap_spikeshooter_spray (0 .5 .8) (-8 -8 -8) (8 8 8)
When triggered, fires a spike in the direction set in QuakeEd.
*/
void trap_spikeshooter_spray()
{
	SetMovedir ();
	self.use = sprayshooter_use;
	precache_sound ("weapons/spike2.wav");

	if (self.wait == 0)
		self.wait = 1;
	self.nextthink = self.nextthink + self.wait + self.ltime;
	self.think = sprayshooter_think;
}

/*QUAKED trap_spikeshooter (0 .5 .8) (-8 -8 -8) (8 8 8) superspike laser
When triggered, fires a spike in the direction set in QuakeEd.
Laser is only for REGISTERED.
*/

void trap_spikeshooter()
{
	SetMovedir ();
	self.use = spikeshooter_use;

		precache_sound ("weapons/spike2.wav");
}


/*QUAKED trap_shooter (0 .5 .8) (-8 -8 -8) (8 8 8) superspike laser
Continuously fires spikes.
"wait" time between spike (1.0 default)
"nextthink" delay before firing first spike, so multiple shooters can be stagered.
*/
void trap_shooter()
{
	trap_spikeshooter ();
	
	if (self.wait == 0)
		self.wait = 1;
	self.nextthink = self.nextthink + self.wait + self.ltime;
	self.think = shooter_think;
}

void () trap_lightning_track =
{
	local vector p1,p2;
	local entity targ;
	local float len;
	
	targ = find (world, classname, "player");  // Get ending point
	
	if (!targ)
	{
		dprint("No target for lightning");
		return;
	}

	if (targ.health <= 0) 
	{
		self.nextthink = -1;
		return;
	}

	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	
	p1 = self.origin;
	p2 = targ.origin;

	len = vlen(p2 - p1);

	traceline(p1, p2, TRUE, self);

	if (len >= self.aflag || trace_fraction < 1)
	{
		if (self.wait == -1 || self.spawnflags & 2)
			self.nextthink = -1;
		else if (self.wait == 1)
			thinktime self : random(self.wait,self.wait+2);
		else 
			thinktime self : self.wait;

		return;
	}
				
	do_lightning (self,1,0,4, p1, p2, self.dmg);

	fx_flash (p2);		// Flash of light

	self.think = trap_lightning_track;
	
	if (self.wait == -1 || self.spawnflags & 2)
		self.nextthink = -1;
	else if (self.wait == 1)
		thinktime self : random(self.wait,self.wait+2);
	else 
		thinktime self : self.wait;
};

void () trap_lightning_use =
{
	local vector p1,p2;
	local entity targ;

	if (!self.target)
	{
		dprint("No target for lightning");
		return;
	}
	
	targ = find (world, targetname, self.target);  // Get ending point
	
	if (!targ)
	{
		dprint("No target for lightning");
		return;
	}

	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	
	p1 = self.origin;
	p2 = targ.origin;
				
	WriteByte (MSG_ALL, SVC_TEMPENTITY);
	WriteByte (MSG_ALL, TE_LIGHTNING1);
	WriteEntity	(MSG_ALL, self);
	
	WriteCoord (MSG_ALL, p1_x);
	WriteCoord (MSG_ALL, p1_y);
	WriteCoord (MSG_ALL, p1_z);

	WriteCoord (MSG_ALL, p2_x);
	WriteCoord (MSG_ALL, p2_y);
	WriteCoord (MSG_ALL, p2_z);

	LightningDamage (p1, p2, self, self.dmg,"lightning");

	fx_flash (p2);		// Flash of light
};

/*QUAKED trap_lightning (0 1 1) (-8 -8 -8) (8 8 8) TRACK ONCE
Generates a bolt of lightning which ends at the weather_lightning_end that is the target
-------------------------FIELDS-------------------------
noise  - sound generated when lightning appears
      1 - no sound
      2 - lightning (default)

wait - time between shots
aflag - radius limiter
target - be sure to give this a target fx_lightning_end to hit
dmg - damage this bolt does
--------------------------------------------------------
*/
void () trap_lightning =
{
	self.movetype = MOVETYPE_NOCLIP;
	self.owner = self;
	self.solid = SOLID_NOT;
	setorigin (self,self.origin);
	setmodel (self,self.model);
	setsize (self,self.mins, self.maxs);

	if (!self.noise)
		self.noise = "raven/lightng1.wav"; 

	if (!self.dmg)
		self.dmg = 10;

	if (!self.wait)
		self.wait = 1;

	if (!self.aflag)
		self.aflag = 500;

	self.ltime = time;

	self.noise = "raven/lightng1.wav"; 
	precache_sound ("raven/lightng1.wav");

	if (self.spawnflags & 1) 
		self.use = trap_lightning_track;
	else
		self.use = trap_lightning_use;		// For triggered lightning
};

