void() train_blocked =
{
	if (time < self.attack_finished) return;
	self.attack_finished = time + 0.5;
	T_Damage (other, self, self, self.dmg,"train block");
};

void() train_use =
{
	if(self.wait==-1)
		self.use=SUB_Null;

	if (self.spawnflags & TRAIN_GLOW)
	{
	  self.effects = EF_BRIGHTLIGHT;
	}

	if (self.decap != 1) 
	{ 
	 self.decap = 1;
  	 if (self.think != train_next)
	 { 
	   self.think = func_train_find;
	   train_next();
	 }
	}
	else 
	{
	  if (self.spawnflags & TRAIN_RETURN) self.decap = 0;
	   else self.decap = 2;
   }
};

void() train_wait =
{
	//Check to make sure train is active
	if(self.decap!=2)
	{
		self.think = train_next;
		if(self.wait==-2)
		{
			if(self.th_die)
			{
				if(self.pausetime)
				{
					self.think=self.th_die;
					self.nextthink=self.ltime+self.pausetime;
				}
				else
				{
					self.th_die();
					return;
				}
			}
			else
			{
				if(self.pausetime)
				{
					self.think=chunk_death;
					self.nextthink=self.ltime+self.pausetime;
				}
				else
				{
					chunk_death();
					return;
				}
			}
		}
		else if(self.wait==-1)
			self.nextthink=-1;
		else if (self.wait)
		{
			self.nextthink = self.ltime + self.wait;
			sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
		}
		else self.nextthink = self.ltime + 0.1;
	}	
  if (self.decap == 0 || self.decap == 2) self.effects = 0;
};

void() train_rotate =
{
	local entity targ;
	local vector dir;

	targ = self.enemy;

	if (targ.mangle_x != 0 || targ.mangle_y != 0 || targ.mangle_z != 0)
	{
		dir = self.angles;
		dir += targ.mangle;

		SUB_CalcAngleMove (dir, self.speed, train_wait);
	}
	else 
		train_wait();
};

void() train_next =
{
	local entity	targ;
	local vector   dir;
	float targ_speed, targ_aspeed;


	targ = find (world, targetname, self.target);
	self.target = targ.target;

	if (!self.decap && self.spawnflags & TRAIN_RETURN) 
		if (self.netname == targ.targetname) 
			 self.decap = 2;

	if (!self.target)
		objerror ("train_next: no next target");
	if (targ.wait)
		self.wait = targ.wait;
	else
		self.wait = 0;
	
	self.enemy = targ;

	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	
	if (targ.mangle_x != 0 || targ.mangle_y != 0 || targ.mangle_z != 0)
	{
		dir = self.angles;
		dir += targ.mangle;

		if(targ.speed)
			targ_speed=targ.speed;
		else
			targ_speed = self.speed;

		if(targ.anglespeed)
			targ_aspeed=targ.anglespeed;
		else
			targ_aspeed = self.anglespeed;

		if(targ.spawnflags&SYNCH)
			SUB_CalcMoveAndAngleInit (targ.origin - self.mins, targ_speed, dir, targ_aspeed, train_wait,TRUE);
		else
			SUB_CalcMoveAndAngleInit (targ.origin - self.mins, targ_speed, dir, targ_aspeed, train_wait,FALSE);
			
	}
	else
		SUB_CalcMove (targ.origin - self.mins, self.speed, train_rotate);

	if (self.spawnflags & TRAIN_WAITTRIG)
		self.decap = 2;
};

void() func_train_find =
{
	local entity	targ;

	targ = find (world, targetname, self.target);
	self.target = targ.target;
	setorigin (self, targ.origin - self.mins);
	if (!self.targetname)
	{	// not triggered, so start immediately
		self.decap = 1;
		self.nextthink = self.ltime + 0.1;
		self.think = train_next;
	}
};

/*QUAKED func_train (0 .5 .8) ? GLOW TOGGLE RETURN TRANSLUCENT
Trains are moving platforms that players can ride.
The targets origin specifies the min point of the train at each corner.
The train spawns at the first target it is pointing at.
If the train is the target of a button or trigger, it will not begin moving until activated.
speed	default 100
dmg		default	2
soundtype
1) ratchet metal

if train is only moving to one spot
"angle"    - to tell it's direction
"distance" - in pixels, how far to move
"speed" - how fast it moves between spots (default=100)
"anglespeed" - how fast it rotates to a new angle (default = 100)
"wait" - -1 will make it stop forever, -2 will make it blow up (you can put the waits on the pathcorners and it will take the wait from there.
"pausetime" - How long to wait after getting to the end of it's path before blowing up, default is 0
NOTE: If you give it a wait of -2, be sure to set the thingtype.
thingtype - type of chunks and sprites it will generate
    0 - glass
    1 - grey stone (default for trains)
    2 - wood
    3 - metal
    4 - flesh 
    5 - fire
    6 - clay
    7 - leaves
    8 - hay
    9 - brown stone
   10 - cloth
   11 - wood & leaf
   12 - wood & metal
   13 - wood stone
   14 - metal stone
   15 - metal cloth

The train will modify it's angles by whatever angles it's next path point has, so if it heads towards a path corner with an angle of '0 90 0', the train will rotate '0 90 0' on it's way to the pathpoint.  If you make the anglespeed the same as the angle, the turn should finish right as the train gets to the new spot.

NOTE: A path_corner using spawnflag "SYNCH" will make the train automatically calculate a new anglespeed based on the distance it's going and will finish the turn at the same time the move is done.

As usual, any rotating brush needs an origin brush.

"abslight" - to set the absolute light level

if TRAIN_GLOW is checked, changes to a light globe sprite and lights up an area
*/
void() func_train =
{	
	local entity targ;

	self.decap = 0;

	if (self.spawnflags & TRAIN_GLOW) {
	  self.solid = SOLID_NOT;
  	  setmodel (self, "models/s_light.spr");
	}
	else 
	{
		self.solid = SOLID_BSP;
		setmodel (self, self.model);
	}

	if (!self.speed) self.speed = 100;

	if (!self.anglespeed) self.anglespeed = 100;
	
	if (!self.target) objerror ("func_train without a target");
		
	if (!self.dmg) self.dmg = 2;

	if (self.soundtype == 1)
	{
		self.noise = ("plats/train2.wav");
		precache_sound ("plats/train2.wav");
		self.noise1 = ("plats/train1.wav");
		precache_sound ("plats/train1.wav");
	}
	else
	{
		self.noise = self.noise1 = "misc/null.wav";
		precache_sound ("misc/null.wav");
	}

	if(self.wait==-2)
	{
		if(!self.thingtype)
			self.thingtype=1;
		if(!self.th_die)
			self.th_die=chunk_death;
	}

	self.cnt = 1;
	self.movetype = MOVETYPE_PUSH;
	self.blocked = train_blocked;
	self.use = train_use;
	self.classname = "train";
   
	setsize (self, self.mins , self.maxs);
	setorigin (self, self.origin);
	
	targ = find(world, target, self.target);
	self.netname = targ.target;

	if (self.abslight)
		self.drawflags(+)MLS_ABSLIGHT;
	if (self.spawnflags & 8)
	{
		self.drawflags(+)DRF_TRANSLUCENT;
		self.solid = SOLID_NOT;
	}
		

// start trains on the second frame, to make sure their targets have had
// a chance to spawn
	self.nextthink = self.ltime + 0.1;
	self.think = func_train_find;
};

