/*
==============================================================================

ice shard (IMP)

==============================================================================
*/

// For building the model
$cd q:/art/models/monsters/imp/final
$base shrdbase 64 128 
$skin shrdskin

$frame shard


void() shardTouch =
{
float	damg;

	if (other == self.owner)
		return;		// don't explode on owner

	if (pointcontents(self.origin) == CONTENT_SKY)
	{
		remove(self);
		return;
	}

	if(self.owner.classname=="monster_imp_lord")
		damg = random(33,77);
	else
		damg = random(5,10);
	
	if(other.health<=damg&&other.thingtype==THINGTYPE_FLESH&&random()<0.1)
		SnowJob(other,self);
	else if (other.health)
	{
		T_Damage (other, self, self.owner, damg,"shard" );
	    	sound (self, CHAN_BODY, "crusader/icehit.wav", 1, ATTN_NORM);
		if((other.classname=="player")||(other.classname=="bot"))
		{
			other.artifact_active(+)ARTFLAG_FROZEN;
			newmis=spawn();
			newmis.enemy=other;
			newmis.artifact_active=ARTFLAG_FROZEN;
			newmis.think=remove_artflag;
			thinktime newmis : 0.1;
		}
	}
	remove(self);
};

void()  shard_1  =[ $shard ,  shard_1   ] { };


void(vector offset, float set_speed, vector dest_offset) do_shard =
{
entity missile;
vector vec;

	missile = spawn ();
	missile.owner = self;
	missile.movetype = MOVETYPE_FLYMISSILE;
	missile.solid = SOLID_BBOX;
	missile.health = 10;

	if(self.classname=="monster_imp_lord")
	{
		set_speed*=2;
		missile.scale=2;
	}

	setmodel (missile, "models/shardice.mdl");
	setsize (missile, '0 0 0', '0 0 0');		

// set missile speed	

	makevectors (self.angles);
	vec = self.origin + self.view_ofs + v_factor(offset);
	setorigin (missile, vec);

	vec = self.enemy.origin - missile.origin + self.enemy.proj_ofs + dest_offset;
	vec = normalize(vec);

	missile.velocity = (vec+aim_adjust(self.enemy))*set_speed;
	missile.angles = vectoangles(missile.velocity);
	
	missile.touch = shardTouch;

	missile.think = shard_1;
	missile.nextthink = time + HX_FRAME_TIME;
};

void ice_melt (void)
{
	self.scale -= 0.05;
	if (self.scale<=0.05)
		remove(self);
	else
		self.think=ice_melt;
	thinktime self : 0.05;
}

void ice_think (void)
{
	if(self.velocity=='0 0 0')
	{
		self.touch=SUB_Null;
		self.think=ice_melt;
		thinktime self : 1.5;
	}
	else
	{
		self.think=ice_think;
		thinktime self : 0.1;
	}
}

void ice_hit (void)
{
	if (random()<0.2)
	{
		particleexplosion(self.origin,14,20,5);
		remove(self);
	}
}

void todust (void)
{
		particleexplosion(self.origin,self.aflag,20,5);
		remove(self);
}

void pebble_hit (void)
{
	self.wait=self.wait + 1;
	sound(self,CHAN_BODY,"misc/rubble.wav",1,ATTN_NORM);
	if(self.wait>=3||random()<0.1)
		todust();
	else
	{
		self.think=todust;
		thinktime self : 2;
	}
}

void throw_shard (vector org,vector dir,vector spin,string type,vector ownersize)
{
float chunk_size;
		newmis=spawn_temp();
		newmis.movetype=MOVETYPE_BOUNCE;
		newmis.solid=SOLID_TRIGGER;
		newmis.velocity=dir;
		newmis.avelocity=spin;
		chunk_size=(ownersize_x+ownersize_y+ownersize_z)/3;
		newmis.scale=random(0.5)*chunk_size/24;
		if(!newmis.scale)
			newmis.scale=0.3;
		newmis.classname="type";
		setmodel(newmis,"models/shard.mdl");
		if(type=="ice")
		{
			newmis.skin=0;
			newmis.frame=0;
			newmis.touch=ice_hit;
			newmis.think=ice_think;
			thinktime newmis : 1;
			newmis.drawflags(+)DRF_TRANSLUCENT|MLS_ABSLIGHT;
			newmis.abslight=0.75;
		}
		else if(type=="pebbles")
		{
			newmis.skin=1;
			newmis.frame=rint(random(1,2));
			newmis.touch=pebble_hit;
			newmis.speed=16;
			newmis.aflag=10;
		}
		setsize(newmis,'0 0 0','0 0 0');
		setorigin(newmis,org);
}

void shatter ()
{
vector dir,spin,org;
float numshards,maxshards,rng;
string type;
	if(self.movechain!=world&&!self.movechain.flags&FL_CLIENT)
		remove(self.movechain);
	if(self.scale==0)
		self.scale=1;
	if(self.classname=="snowball")
		maxshards=random(4,2);
	else
		maxshards=random(7,10);
	org=(self.absmin+self.absmax)*0.5;
	if(self.deathtype=="ice shatter"||self.deathtype=="ice melt")
	{
//origin color radius count
		particleexplosion(org,14,25,50);
//		particle2(org,'-50 -50 -50','50 50 50',145,14,50);
		if(self.deathtype=="ice shatter")
			rng=600;
		else
			rng=self.size_x/2;
		if(self.classname!="snowball")
			sound(self,CHAN_BODY,"misc/icestatx.wav",1,ATTN_NORM);
		type="ice";
	}
	else if(self.deathtype=="stone crumble")
	{
		sound(self,CHAN_BODY,"misc/sshatter.wav",1,ATTN_NORM);
		particleexplosion(org,10,60,50);
//		particle2(org,'-30 -30 -30','30 30 30',16,10,50);
		rng=450;
		type="pebbles";
	}
	while(numshards<maxshards)
	{
		dir_x=random(0-rng,rng);
		dir_y=random(0-rng,rng);
		dir_z=random(0-rng,rng);
		spin_x=random(300,-300);
		spin_y=random(300,-300);
		spin_z=random(300,-300);
		throw_shard(org,dir,spin,type,self.size);
		numshards+=1;
	}
	if(self.movechain!=world&&!self.movechain.flags&FL_CLIENT)
		remove(self.movechain);
	if((self.classname!="player")&&(self.classname!="bot"))
		remove(self);
}


