/*QUAKED func_rotating (0 .5 .8) ? START_ON REVERSE X_AXIS Y_AXIS BREAK GRADUAL TOGGLE_REVERSE KEEP_START
You need to have an origin brush as part of this entity.  The  
center of that brush will be the point around which it is rotated. 
It will rotate around the Z axis by default.  You can
check either the X_AXIS or Y_AXIS box to change that.
BREAK makes the brush breakable
REVERSE will cause the it to rotate in the opposite direction.
GRADUAL will make it slowly speed up and slow down.
TOGGLE_REVERSE will make it go in the other direction next time it's triggered
KEEP_START means it will return to it's starting position when turned off

"speed" determines how fast it moves; default value is 100.
"dmg"	damage to inflict when blocked (2 default)
"lifetime" this will make it stop after a while, then start up again after "wait".  Default is staying on.
"wait" if it has a lifetime, this is how long it will wait to start up again.  default is 3 seconds.
"thingtype" type of brush (if breakable - default is wood)
"health" (if breakable - default is 25)
"abslight" - to set the absolute light level
"anglespeed" - If using GRADUAL, this will determine how fast the speed up and down will occur.  1 will be very slow, 100 will be instant.  (Default is 10)

thingtype - type of chunks and sprites it will generate
    0 - glass (default)
    1 - stone
    2 - wood
    3 - metal
    4 - flesh 
    
health - amount of damage item can take.  Default is based on thingtype
   glass -  25
   stone -  75
   wood -   50
   metal - 100
   flesh -  30
*/
void rotate_wait (void)
{
	thinktime self : 10000000000;
}

void rotate_reset (void)
{
	if(self.wait)
	{
		self.think=rotating_use;
		thinktime self : self.wait;
	}
	else
	{
		self.think=SUB_Null;
		self.nextthink=-1;
	}
}

void rotate_wait_startpos (void)
{
	if(self.angles==self.o_angle)
	{
		self.avelocity='0 0 0';
		rotate_reset();
	}
	else
		thinktime self : 0.05;
}

void rotate_slowdown (void)
{
	self.level-=(self.speed/self.anglespeed);
	if((self.dmg==-1||self.dmg==666)&&self.level<100)
		self.touch=SUB_Null;

	if(self.level<1||(self.level<=self.speed/self.anglespeed&&self.spawnflags&KEEP_START))
	{
		if(self.spawnflags&KEEP_START)
		{
			self.think=rotate_wait_startpos;
			thinktime self : 0;
		}
		else		
		{
			self.avelocity='0 0 0';
			rotate_reset();
		}
	}
	else 
	{
		self.avelocity=self.movedir*self.level;
		self.think=rotate_slowdown;
		thinktime self : 0.01;
	}
}

void rotate_startup (void)
{
	self.level+=(self.speed/self.anglespeed);
	if((self.dmg==-1||self.dmg==666)&&self.level>=100&&self.touch==SUB_Null)
		self.touch=rotating_touch;

	if(self.pain_finished<=time&&self.lifetime)
	{
		self.think=rotating_use;
		thinktime self : 0;
		return;
	}

	if(self.level<self.speed)
	{
		self.avelocity = self.movedir * self.level;
		self.think=rotate_startup;
		thinktime self : 0.01;
	}
	else 
	{
		//dprint("reached max speed\n");
		self.level = self.speed;
		self.avelocity = self.movedir * self.speed;
		if(self.pain_finished>time&&self.lifetime)
		{
			self.think=rotating_use;
			thinktime self : self.pain_finished;
			return;
		}
		else
		{
			self.think=rotate_wait;
			thinktime self : 10000000000;
		}
	}
}

void rotating_use()
{
	if (self.avelocity != '0 0 0')
	{
		if(!self.spawnflags&GRADUAL)
		{
			self.avelocity='0 0 0';
			rotate_reset();
		}
		else if(self.think==rotate_slowdown)
			return;
		else
		{
			sound (self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
			self.think=rotate_slowdown;
			thinktime self : 0;
		}
	}
	else
	{
		if(self.lifetime)
			self.pain_finished=time+self.lifetime;
		if(self.spawnflags&TOGGLE_REVERSE)
			self.movedir= self.movedir*-1;
		if(!self.spawnflags&GRADUAL)
		{
			self.avelocity = self.movedir * self.speed;
			self.think=rotating_use;
			thinktime self : 10000000000;
		}
		else
		{
			sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
			self.think=rotate_startup;
			thinktime self : 0;
		}
	}
}

void rotating_damage (entity chopped_liver)
{
	if(self.dmg==666)
	{
		if(((chopped_liver.classname=="player")||(chopped_liver.classname=="bot"))&&chopped_liver.flags2&FL_ALIVE)
		{
			chopped_liver.decap=TRUE;
			T_Damage (chopped_liver, self, self, chopped_liver.health+300,"rotate");
		}
		else
			T_Damage (chopped_liver, self, self, chopped_liver.health+50,"rotate2");
	}
	else if(self.dmg==-1&&chopped_liver.health)
	{
	float damg;
		chopped_liver.deathtype="chopped";
		damg=vlen(self.avelocity);
		T_Damage (chopped_liver, self, self, damg,"rot chopped");
	}
}
	
void rotating_touch()
{
	if(!other.takedamage)
		return;
	rotating_damage(other);		
}

void rotating_blocked (void)
{
	if(!other.takedamage)
		return;

	rotating_damage(other);		

	if(other.health>100&&!other.flags2&FL_ALIVE)//allow for blockage
	{
		self.avelocity='0 0 0';
		self.level=0;
		self.touch=SUB_Null;
		self.think=rotating_use;
		thinktime self : self.wait;
	}
}

void func_rotating()
{
	// set the axis of rotation
	if (self.spawnflags & 4)
		self.movedir = '0 0 1';
	else if (self.spawnflags & 8)
		self.movedir = '1 0 0';
	else
		self.movedir = '0 1 0';

	// check for reverse rotation
	if (self.spawnflags & 2)
		self.movedir = self.movedir * -1;

	if(self.spawnflags&TOGGLE_REVERSE)
		self.movedir = self.movedir * -1;

	self.solid = SOLID_BSP;
	self.movetype = MOVETYPE_PUSH;
	self.classname="rotating non-door";
	setorigin (self, self.origin);	
	setmodel (self, self.model);

	self.use = rotating_use;
	self.blocked = rotating_blocked;
	self.touch=SUB_Null;

	if (!self.speed)
		self.speed = 100;

	if(!self.anglespeed)
		self.anglespeed = 10;

	if (self.dmg==0)
		self.dmg = 2;

	if(self.lifetime)
		if(!self.wait)
			self.wait=3;

//	self.noise1 = "doors/hydro1.wav";
//	self.noise2 = "doors/hydro2.wav";

//	precache_sound ("doors/hydro1.wav");
//	precache_sound ("doors/hydro2.wav");

	if (self.abslight)
		self.drawflags(+)MLS_ABSLIGHT;

	if (self.spawnflags & ROTATE_BREAK)
	{
	  if (!self.thingtype)
	   self.thingtype = THINGTYPE_WOOD;
	  if (!self.health)
	  {
		if ((self.thingtype == THINGTYPE_GLASS) || (self.thingtype == THINGTYPE_CLEARGLASS))
			self.health = 25;
		else if ((self.thingtype == THINGTYPE_GREYSTONE) || (self.thingtype == THINGTYPE_BROWNSTONE))
			self.health = 75;
		else if (self.thingtype == THINGTYPE_WOOD)
			self.health = 50;
		else if (self.thingtype == THINGTYPE_METAL)
			self.health = 100;
		else if (self.thingtype == THINGTYPE_FLESH)
			self.health = 30;
		else
			self.health = 25;
	  }
	  self.takedamage = DAMAGE_YES;
	  self.th_die = chunk_death;
	}

	if(self.spawnflags&KEEP_START)
		self.o_angle=self.angles;

	if (self.spawnflags & 1)
		self.use();

	if (self.flags2)
	{
		self.touch = rotating_touch;
		self.flags2=FALSE;
	}
}


void trigger_find_owner (void)
{
entity found;
	found=find(world,target,self.targetname);
	if(found==world)
		remove(self);
	else
		self.owner=found;
}


void() angletrigger_done =
{
	self.level = FALSE;
};

void() angletrigger_blocked =
{
	T_Damage (other, self, self, self.dmg,"angletrig block");
};

void() angletrigger_use =
{
vector newvect;

	if (self.level)
		return;
	else
		self.level = TRUE;

	if(self.angles_x>=360)
		self.angles_x-=360;
	else if(self.angles_x<=-360)
		self.angles_x+=360;
	if(self.angles_y>=360)
		self.angles_y-=360;
	else if(self.angles_y<=-360)
		self.angles_y+=360;
	if(self.angles_z>=360)
		self.angles_z-=360;
	else if(self.angles_z<=-360)
		self.angles_z+=360;
	newvect = self.movedir * self.cnt;

	if (self.angles + newvect == self.mangle) 
	{
		self.check_ok = TRUE;
		SUB_UseTargets();
	}
	else if (self.check_ok)
	{
		self.check_ok = FALSE;
		SUB_UseTargets();
	}
	
	SUB_CalcAngleMove(self.angles + newvect, self.speed, angletrigger_done);
};

/*QUAKED func_angletrigger (0 .5 .8) ? REVERSE X_AXIS Y_AXIS
Rotates at certain intervals, and fires off when a set angle is met

mangle = desired angle to trigger at (relative to the world!)
cnt	 = degrees to turn each move
dmg	 = damage if blocked
*/

void() func_angletrigger =
{
	
	// set the axis of rotation
	if (self.spawnflags & 2)
		self.movedir = '0 0 1';
	else if (self.spawnflags & 4)
		self.movedir = '1 0 0';
	else
		self.movedir = '0 1 0';

	// check for clockwise rotation
	if (self.spawnflags & 1)
		self.movedir = self.movedir*-1;

	self.pos1 = self.angles;
	self.pos2 = self.angles + self.movedir * self.cnt;

	self.max_health = self.health;
	self.solid = SOLID_BSP;
	self.movetype = MOVETYPE_PUSH;
	setorigin (self, self.origin);	
	setmodel (self, self.model);
	self.classname = "angletrigger";

	if (self.abslight)
		self.drawflags(+)MLS_ABSLIGHT;

	if (!self.speed)
		self.speed = 100;
	if (self.wait==0)
		self.wait = 1;
	if (!self.dmg)
		self.dmg = 2;
	
	self.blocked = angletrigger_blocked;
	self.use = angletrigger_use;
	
	if (!self.targetname)
		self.touch = angletrigger_use;

	self.inactive = FALSE;	
};

