void() plat_spawn_inside_trigger =
{
	local entity	trigger;
	local vector	tmin, tmax;

   //middle trigger

	trigger = spawn();

	if (self.classname == "newplat")
		trigger.touch = newplat_center_touch;
	else
		trigger.touch = plat_center_touch;

	trigger.movetype = MOVETYPE_NONE;
	trigger.solid = SOLID_TRIGGER;
	trigger.enemy = self;
	
	tmin = self.mins + '25 25 0';
	tmax = self.maxs - '25 25 -8';
	tmin_z = tmax_z - (self.pos1_z - self.pos2_z + 8);
	if (self.spawnflags & PLAT_LOW_TRIGGER)
		tmax_z = tmin_z + 8;
	
	if (self.size_x <= 50)
	{
		tmin_x = (self.mins_x + self.maxs_x) / 2;
		tmax_x = tmin_x + 1;
	}
	if (self.size_y <= 50)
	{
		tmin_y = (self.mins_y + self.maxs_y) / 2;
		tmax_y = tmin_y + 1;
	}
	
	setsize (trigger, tmin, tmax);
};

void() plat_hit_top =
{
	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	self.state = STATE_TOP;
	self.think = plat_go_down;
	self.nextthink = self.ltime + 3;
};

void() plat_hit_bottom =
{
	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	self.state = STATE_BOTTOM;
};

void() plat_go_down =
{
	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	self.state = STATE_DOWN;
	SUB_CalcMove (self.pos2, self.speed, plat_hit_bottom);
};

void() plat_go_up =
{
	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	self.state = STATE_UP;
	SUB_CalcMove (self.pos1, self.speed, plat_hit_top);
};

void() plat_center_touch =
{
	if (other.classname != "player"&&other.classname != "bot"&&other.movetype!=MOVETYPE_PUSHPULL)//Monsters too?
		return;
		
	if (other.health <= 0)
		return;

	self = self.enemy;
	if (self.state == STATE_BOTTOM)
		plat_go_up ();
	else if (self.state == STATE_TOP)
		self.nextthink = self.ltime + 1;	// delay going down
};

void() plat_outside_touch =
{
	if (other.classname != "player"&&other.classname != "bot"&&other.movetype!=MOVETYPE_PUSHPULL)
		return;

	if (other.health <= 0)
		return;
		
	self = self.enemy;
	if (self.state == STATE_TOP)
		plat_go_down ();
};

void() plat_trigger_use =
{
	if (self.think)
		return;		// allready activated
	plat_go_down();
};

void() plat_crush =
{

	T_Damage (other, self, self, 1,"plat crush");
	
	if (self.state == STATE_UP)
		plat_go_down ();
	else if (self.state == STATE_DOWN)
		plat_go_up ();
	else
		objerror ("plat_crush: bad self.state\n");
};

void() plat_use =
{
	self.use = SUB_Null;
	if (self.state != STATE_UP)
		objerror ("plat_use: not in up state");
	plat_go_down();
};


/*QUAKED func_plat (0 .5 .8) ? PLAT_LOW_TRIGGER
speed	default 150

Plats are always drawn in the extended position, so they will light correctly.

If the plat is the target of another trigger or button, it will start out disabled in the extended position until it is trigger, when it will lower and become a normal plat.

If the "height" key is set, that will determine the amount the plat moves, instead of being implicitly determined by the model's height.
Set "soundtype" to one of the following:
1) pulley
2) chain 
*/

void() func_plat =
{

	if (!self.t_length)
		self.t_length = 80;
	if (!self.t_width)
		self.t_width = 10;

	if (self.soundtype == 0)
		self.soundtype = 2;
// FIX THIS TO LOAD A GENERIC PLAT SOUND

	if (self.soundtype == 1)
	{
		precache_sound ("plats/pulyplt1.wav");
		precache_sound ("plats/pulyplt2.wav");
		self.noise = "plats/pulyplt1.wav";
		self.noise1 = "plats/pulyplt2.wav";
	}

	if (self.soundtype == 2)
	{
		precache_sound ("plats/chainplt1.wav");
		precache_sound ("plats/chainplt2.wav");
		self.noise = "plats/chainplt1.wav";
		self.noise1 = "plats/chainplt2.wav";
	}


	self.mangle = self.angles;
	self.angles = '0 0 0';

	self.classname = "plat";
	self.solid = SOLID_BSP;
	self.movetype = MOVETYPE_PUSH;
	setorigin (self, self.origin);	
	setmodel (self, self.model);
	setsize (self, self.mins , self.maxs);

	self.blocked = plat_crush;
	if (!self.speed)
		self.speed = 150;

// pos1 is the top position, pos2 is the bottom
	self.pos1 = self.origin;
	self.pos2 = self.origin;
	if (self.height)
		self.pos2_z = self.origin_z - self.height;
	else
		self.pos2_z = self.origin_z - self.size_z + 8;

	self.use = plat_trigger_use;

	plat_spawn_inside_trigger ();	// the "start moving" trigger	

	if (self.targetname)
	{
		self.state = STATE_UP;
		self.use = plat_use;
	}
	else
	{
		setorigin (self, self.pos2);
		self.state = STATE_BOTTOM;
	}
};

void() newplat_hit_bottom =
{
	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	self.state = STATE_BOTTOM;
	self.lifetime = time + self.wait;
	if (((self.spawnflags & START_RTRN) && !(self.spawnflags & START_BOTTOM)) ||
		(self.spawnflags & CONTINUE))
	{
		self.nextthink = self.ltime + self.wait;
		self.think=newplat_go_up;
	}
	setorigin (self.enemy, self.origin);	
};

void() newplat_hit_top =
{
	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	self.state = STATE_TOP;
	self.lifetime = time + self.wait;

	if (((self.spawnflags & START_RTRN) && (self.spawnflags & START_BOTTOM)) ||
		(self.spawnflags & CONTINUE))
	{
		self.nextthink = self.ltime + self.wait;
		self.think=newplat_go_down;
	}

	setorigin (self.enemy, self.origin);	
};

void() newplat_trigger_use =
{
	if (self.think)
		return;		// already activated

	if ((self.state==STATE_MOVING) || (self.lifetime > time))
 		return;

	if (self.state == STATE_BOTTOM)
		newplat_go_up ();
	else
		newplat_go_down ();
};



void() newplat_calc_down =
{
	self.state=STATE_MOVING;
	SUB_CalcMove (self.pos2, self.speed, newplat_hit_bottom);
};

void() newplat_go_down =
{
	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	newplat_calc_down();
};

void() newplat_calc_up =
{
	self.state=STATE_MOVING;
	SUB_CalcMove (self.pos1, self.speed, newplat_hit_top);
};

void() newplat_go_up =
{
	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	newplat_calc_up();
};

void() newplat_crush =
{
	T_Damage (other, self, self, 1,"newplat crush");
	if (self.velocity_z < 0)
		newplat_calc_down ();
	else if (self.velocity_z > 0)
		newplat_calc_up();
	else
		objerror ("newplat_crush: bad self.state\n");
};

void() newplat_center_touch =
{

	if ((other.classname != "player"&&other.classname != "bot"&&other.movetype!=MOVETYPE_PUSHPULL) || (other.health <= 0))
		return;
	
	self = self.enemy;
	if ((self.state==STATE_MOVING) || (self.lifetime > time))
 		return;

	if (self.state == STATE_BOTTOM)
		newplat_go_up ();
	else
		newplat_go_down ();
};

void() newplat_spawn_inside_trigger =
{
	local entity	trigger;

   //middle trigger
	trigger = spawn();

	trigger.touch = newplat_center_touch;

	trigger.movetype = MOVETYPE_PUSH;
	trigger.solid = SOLID_TRIGGER;
	trigger.enemy = self;
	self.enemy = trigger;
	
	setsize (trigger, self.mins,self.maxs);
};

/*QUAKED func_newplat (0 .5 .8) ? START_BOTTOM STRT_RTRN CONTINUE
speed	default 150

If the "height" key is set, that will determine the amount the plat moves, instead of being implicitly determined by the model's height.

Set "soundtype" to one of the following:
1) base fast
2) chain slow

START_BOTTOM - where plat starts at
if checked plat starts at the bottom of it's movement

START_RTRN - if check will return plat to start position.

CONTINUE - plat will never stop moving


height - distance plat moves up or down

wait - amount of time plat waits before moving (default 3)


*/
void() func_newplat =
{

	if (!self.t_length)
		self.t_length = 80;
	if (!self.t_width)
		self.t_width = 10;

	if (self.soundtype == 0)
		self.soundtype = 2;

	if (self.soundtype == 1)
	{
		precache_sound ("plats/pulyplt1.wav");
		precache_sound ("plats/pulyplt2.wav");
		self.noise = "plats/pulyplt1.wav";
		self.noise1 = "plats/pulyplt2.wav";
	}

	if (self.soundtype == 2)
	{
		precache_sound ("plats/chainplt1.wav");
		precache_sound ("plats/chainplt2.wav");
		self.noise = "plats/chainplt1.wav";
		self.noise1 = "plats/chainplt2.wav";
	}



	self.mangle = self.angles;
	self.angles = '0 0 0';

	self.classname = "newplat";
	self.solid = SOLID_BSP;
	self.movetype = MOVETYPE_PUSH;
	setorigin (self, self.origin);	
	setmodel (self, self.model);
	setsize (self, self.mins , self.maxs);

	if (!self.speed)
		self.speed = 150;

	if (!self.wait)
		self.wait = 3;

// pos1 is the top position, pos2 is the bottom
	self.pos1 = self.origin;
	self.pos2 = self.origin;

	if (self.spawnflags & START_BOTTOM)
		self.state=STATE_BOTTOM;
	else
		self.state=STATE_TOP;

   if (self.state==STATE_BOTTOM)
	{
		self.pos1_z = self.origin_z + self.height;
		self.pos2_z = self.origin_z;
	}
	else
	{
		self.pos1_z = self.origin_z;
		self.pos2_z = self.origin_z - self.height;
	}

	self.use = newplat_trigger_use;
	self.blocked = newplat_crush;

	newplat_spawn_inside_trigger ();	//set the "start moving" trigger	

};



void reset_solid (void)
{

}

void rot_mov_dmg (void)
{
	if(other==world)
		return;

	if((other.classname=="player")||(other.classname=="bot"))
	{
		self.solid=SOLID_TRIGGER;
		self.think=reset_solid;
		thinktime self : 0.1;
	}

	if(other.takedamage)
	{
		if(self.noise1)
			sound(self,CHAN_VOICE,self.noise1,1,ATTN_NORM);
		self.pain_finished=time+self.wait;
		T_Damage(other,self,self.owner,self.dmg,"rot mov dmg");
	}
}

void rot_mov_snd (void)
{
	if(self.pain_finished<=time)
	{
		sound(self,CHAN_VOICE,self.noise,1,ATTN_NORM);
		self.pain_finished=time+self.wait;
	}
	self.think=rot_mov_snd;
	thinktime self : self.wait;
}

void rot_mov_activate (void)
{
	if(self.dmg)
		self.touch=rot_mov_dmg;

	if(!self.avelocity)
		self.avelocity=self.o_angle;

	if(self.noise)
		if(!self.wait)
			objerror ("func_rotating_movechain: sound, but no delay time");
		else
		{
			self.think=rot_mov_snd;
			thinktime self : 0;
		}
}

float NOANGLECHAIN = 1;

/*QUAKED func_rotating_movechain (0 .5 .8) ? NOANGLECHAIN

Only one other object in the world should have the same netname.  If not, it will find and use only the first one it finds!

If you're making multiple sawblades, for instance, label the mover and the rotater "sawblade1" for the first one, "sawblade2" for the second, and so on.

If you give it a targetname, it will wait to be activated, this can be seperate from the object it's attached to.

It will not do damage until it's been activated.

NOANGLECHAIN = Setting this flag will stop it from modifying it's angles by the owner's angles, but will still movechain.
dmg	= How much damage it should do when it touches.
noise = Noise it should make, if any, be sure to set the wait time
noise1 = noise it should make when it hits something
wait = Length of the sound so it knows when to loop it.
avelocity = The direction and speed it should spin: pitch yaw roll (this is relative to it's own axis, not the world)
netname = the name of the object it's linked to, that object must have a matching netname!!!


Needs something to tell it to stop?

A way to make it die at the end of a path or if triggered again?

Maybe make movechain_angle optional spawnflag?

What do YOU think?  We'd like to know...
*/
void func_rotating_movechain (void)
{
	if(!self.netname)
		objerror ("func_rotating_movechain has no netname");

	self.owner=find(world,netname,self.netname);
	if(self.owner.classname=="world")
		objerror ("func_rotating_movechain has no owner!");

	self.solid=SOLID_TRIGGER;
	self.movetype=MOVETYPE_NOCLIP;

	setmodel(self,self.model);
	setsize(self,self.mins,self.maxs);
	setorigin(self,self.origin);
	//dprint(vtos(self.avelocity));

	self.owner.movechain=self;
	if(!self.spawnflags&NOANGLECHAIN)
		self.flags+=FL_MOVECHAIN_ANGLE;
	
	if(self.targetname)
	{
		self.use=rot_mov_activate;
		self.o_angle=self.avelocity;
		self.avelocity='0 0 0';
	}
	else
	{
		self.think=rot_mov_activate;
		thinktime self : 3;//wait a few secs for board to start
	}
}
