// routines for moving objects

/*
 * obj_push() -- Allows players to push objects when they walk toward them.
 */

void obj_fly_hurt (entity loser)
{//MG
//FIXME: Check for sky
//dprint("hit\n");
float magnitude,my_mass;
	if(self.frozen>0&&other.classname=="snowball")
		return;

	if((self.classname=="player")||(self.classname=="bot"))
		my_mass=self.mass;
	else if(!self.mass)
		my_mass = 1;
	else if(self.mass<=10)
		my_mass=10;
	else
		my_mass = self.mass/10;

	magnitude=vlen(self.velocity)*my_mass/10;
	if(pointcontents(self.absmax)==CONTENT_WATER)//FIXME: or other watertypes
		magnitude/=3;							//water absorbs 2/3 velocity

	if(self.classname=="barrel"&&self.aflag)//rolling barrels are made for impacts!
		magnitude*=3;

	if(self.frozen>0&&magnitude<300&&self.flags&FL_ONGROUND&&loser==world&&self.velocity_z<-20&&self.last_onground+0.3<time)
		magnitude=300;
  if(self.last_onground+0.3<time||(self.last_onground+0.1<time&&loser.thingtype>=THINGTYPE_GLASS))
  {
	vector dir1, dir2;
	float force,dot;
		if(loser.thingtype>=THINGTYPE_GLASS)
			magnitude*=2;

		if(magnitude>=100&&loser.takedamage&&loser.classname!="catapult"&&loser!=world)
		{

			dir1=normalize(self.velocity);
			if(loser.origin=='0 0 0')
				dir2=dir1;
			else
				dir2=normalize(loser.origin-self.origin);
	
			dot= dir1*dir2;
	
		    if(dot >= 0.2)
				force=dot;		
			else
				force=0;

			force*=magnitude/50;

			if(pointcontents(loser.absmax)==CONTENT_WATER||(self.classname=="barrel"&&self.aflag))//FIXME: or other watertypes
				force/=3;							//water absorbs 2/3 velocity

			if(self.flags&FL_MONSTER&&loser==world)
				force/=2;

			if(self.frozen>0&&force>10)
				force=10;

			// exclude bots for the mo - problems with dying bots
			if(((force>=1&&loser.classname!="player")||force>=10)&&((loser.classname!="bot")||(loser.frozen)))
			{
				T_Damage (loser, self, self, force,"obj_fly");  
			}
		}

		if(self.classname!="monster_mezzoman"&&self.netname!="spider")//Cats always land on their feet
			if((magnitude>=100+self.health&&self.classname!="player"&&self.classname!="bot")||magnitude>=700)//health here is used to simulate structural integrity
			{
				if(((self.classname=="player")||(self.classname=="bot"))&&self.flags&FL_ONGROUND&&magnitude<1000)
				{
					//allow for some lenience on high falls
					magnitude/=2;
					if(self.absorb_time>=time)//crouching on impact absorbs 1/2 the damage
						magnitude/=2;
				}
				magnitude/=40;
				magnitude=magnitude - force/2;//If damage other, subtract half of that damage off of own injury
				if(magnitude>=1)
				{
//FIXME: Put in a thingtype impact sound function
					// exclude bots for the mo - problems with dying bots
					if((self.classname=="player_sheep"&&self.flags&FL_ONGROUND&&self.velocity_z>-50)||(self.classname=="bot"))
						return;
					T_Damage(self,world,world,magnitude,"obj fly2");
				}
			}

	self.last_impact=time;
	if(self.flags&FL_ONGROUND)
		self.last_onground=time;
	}
}

void obj_push()
{//MG
vector pushdir,pushangle;
float ontop,pushed,inertia,force,walkforce;

	if(other.solid==SOLID_PHASE||other.movetype==MOVETYPE_FLYMISSILE||other.movetype==MOVETYPE_BOUNCEMISSILE)
		return;

	if(self.classname=="barrel"&&pointcontents(self.origin)!=CONTENT_EMPTY&&(!self.spawnflags&BARREL_SINK))
	{
		self.classname="barrel_floating";
		self.think=floater;
		self.nextthink=time;
	}

	if(self.classname=="player_sheep"&&other.classname=="catapult")
		self.spawnflags(+)1;	//Sheep won't move once on catapult

	if(self.last_impact + 0.1<=time)
		obj_fly_hurt(other);

	if(other!=world&&other.absmin_z >= self.origin_z+self.maxs_z - 5&&other.velocity_z<1)
	{		
		if(!other.frozen&&
			(
			 (!other.flags2&FL_ALIVE&&other.flags&FL_MONSTER)||
			 (self.flags&FL_MONSTER&&self.model!="models/spider.mdl"&&self.model!="models/scorpion.mdl")
			)
		  )
		{
			makevectors(other.angles);
			v_forward_z=1;
			other.velocity=v_forward*300;
			other.flags(-)FL_ONGROUND;
		}
		if(other.flags&FL_CLIENT&&!other.frozen)
			ontop = FALSE;
		else
		{
			ontop=TRUE;
//			other.flags(+)FL_ONGROUND;
		}
	}

	if(self.flags&FL_MONSTER)
	{
		if(other!=world&&self.absmin_z >= other.absmax_z - 3&&self.velocity_z<1&&other.movetype!=MOVETYPE_FLYMISSILE&&other.movetype!=MOVETYPE_BOUNCE&&other.movetype!=MOVETYPE_BOUNCEMISSILE)
			self.flags(+)FL_ONGROUND;
		if(self.frozen<=0&&!self.artifact_active&ARTFLAG_STONED)
			return;
	}

	if(!other.velocity)
		return;

	if (self.impulse == 20)
		return;

	if(!self.mass)
		inertia=1;
	if(self.mass<=30)
		inertia=self.mass/3;
	else
		inertia=self.mass/33;

	if(other.strength)
		force=vlen(other.velocity)*(other.strength/40+0.5);
	else
		force=vlen(other.velocity);

	if(pointcontents(self.origin)==CONTENT_WATER||pointcontents(self.origin)==CONTENT_SLIME||pointcontents(self.origin)==CONTENT_LAVA)
		force/=3;

//FIXME: mass should determine how fast the object can be pushed
//	if (self.mass > 199*force)	// Too heavy to move
	if (self.mass >= 1000)	// Too heavy to move
		return;

//So you can push frozen guys around before they melt
	if(self.frozen>0)
	{
		self.freeze_time=time+10;
		self.wait=time + 10;
	}

	if(ontop)
		return;	

	walkforce=force/inertia/40;//20 is the frame time...
	if(self.classname=="barrel"&&self.aflag)
	{
		vector dir1, dir2;
		float dot_forward,dot_right;
		self.angles_z=0;
		self.v_angle_x=self.v_angle_z=0;
		makevectors(self.v_angle);

		if(ontop)
			dir1=normalize(other.velocity);
		else
			dir1=normalize(self.origin-other.origin);

		dir2=normalize(v_forward);
		dir1_z=dir2_z=0;

		dot_forward= dir1*dir2;

		self.enemy=other;
	    if(dot_forward>=0.9)
		{
			self.movedir=dir2;//test
			self.movedir_z=0;
			self.speed += force/inertia;
			if(self.speed>other.strength*300)
				self.speed=other.strength*300;
			traceline(self.origin,self.origin+dir2*48,FALSE,self);
			if(trace_fraction==1.0)
			{
				self.velocity=self.movedir*self.speed;
				self.think=obj_barrel_roll;
				self.nextthink=time;
			}
		}
		else if(dot_forward<=-0.9)
		{
			self.movedir=dir2;//test
			self.movedir_z=0;
			self.speed += force/inertia*-1;
			if(self.speed<other.strength*-300)
				self.speed=other.strength*-300;
			traceline(self.origin,self.origin+dir2*-48,FALSE,self);
			if(trace_fraction==1.0)
			{
				self.velocity=self.movedir*self.speed;
				self.think=obj_barrel_roll;
				self.nextthink=time;
			}
		}
		else
		{
			dir1=normalize(other.velocity);
			dir2=normalize(v_right);
			dot_right= dir1*dir2;
		    if(dot_right >0.2)
			{
			    if(dot_forward >0.1)
				{
					self.angles_y-=walkforce*10;
				}
				else if(dot_forward<-0.1)
				{
					self.angles_y+=walkforce*10;
				}
			}
			else if(dot_right<-0.2)
			{
			    if(dot_forward >0.1)
				{
					self.angles_y+=walkforce*10;
				}
				else if(dot_forward<-0.1)
				{
					self.angles_y-=walkforce*10;
				}
			}
			self.v_angle_y=self.angles_y;
		}
	}
	else
	{
		pushdir=normalize(other.velocity);
		pushangle=vectoangles(pushdir);

		pushed=FALSE;
		walkforce=force/inertia/20;//20 is the frame time...
		if(!walkmove(pushangle_y,walkforce,FALSE))//FIXME: check mass
		{
			if(other.absmax_z<=self.origin_z+self.mins_z*0.75)
				pushdir_z*=2;
			self.velocity=(pushdir*force*2*(1/inertia)+self.velocity)*0.5;
			if(self.flags&FL_ONGROUND)
			{
				if(self.velocity_z<0)
					self.velocity_z=0;
				self.flags-=FL_ONGROUND;
			}
			if(self.velocity)
				pushed=TRUE;
		}
		else
			pushed=TRUE;
	
		if(pushed&&self.classname!="barrel_floating")
		{
			if(self.pain_finished<=time)
			{
				if(self.classname=="player_sheep")
				{
					sheep_sound(.75);
					if(!infront(other)&&random()<0.5)
//FIXME- find current think and set transition to run
						self.think=sheep_trot;
				}
				else if(self.thingtype==THINGTYPE_WOOD)
				{
					sound(self,CHAN_VOICE,"misc/pushwood.wav",1,ATTN_NORM);		
					self.pain_finished=time + 1.041;
				}
				else if ((self.thingtype==THINGTYPE_GREYSTONE) || (self.thingtype==THINGTYPE_BROWNSTONE))
				{
					sound(self,CHAN_VOICE,"misc/pushston.wav",1,ATTN_NORM);
					self.pain_finished=time + .711;
				}
				else if(self.thingtype==THINGTYPE_METAL)
				{
					sound(self,CHAN_VOICE,"misc/pushmetl.wav",1,ATTN_NORM);
					self.pain_finished=time + .835;
				}
			}
		}
	}
}
