/*QUAKED obj_beefslab (0.3 0.1 0.6) (-16 -16 0) (16 16 40)
A slab of beef.
-------------------------FIELDS-------------------------
health = 50
--------------------------------------------------------
*/
void obj_beefslab (void)
{
	precache_model3("models/beefslab.mdl");
	CreateEntityNew(self,ENT_BEEFSLAB,"models/beefslab.mdl",chunk_death);
}

/*QUAKED obj_seaweed (0.3 0.1 0.6) (-8 -8 0) (8 8 32)
An animate seaweed that sways from side to side.
-------------------------FIELDS-------------------------
health = 10
--------------------------------------------------------
*/
void obj_seaweed (void)
{
	precache_model("models/seaweed.mdl");
	CreateEntityNew(self,ENT_SEAWEED,"models/seaweed.mdl",chunk_death);
}

/*QUAKED obj_statue_lion (0.3 0.1 0.6) (-56 -14 0) (56 14 60)
Statue of a lion.
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------

*/
void obj_statue_lion(void)
{
	precache_model2("models/lion.mdl");
	CreateEntityNew(self,ENT_STATUE_LION,"models/lion.mdl",chunk_death);

	self.drawflags += SCALE_ORIGIN_BOTTOM;

}

/*QUAKED obj_statue_athena(0.3 0.1 0.6) (-30 -30 0) (30 30 90)
Statue of a Athena
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------

*/
void obj_statue_athena (void)
{
	precache_model2("models/athena.mdl");
	CreateEntityNew(self,ENT_STATUE_ATHENA,"models/athena.mdl",chunk_death);

	self.drawflags += SCALE_ORIGIN_BOTTOM;

}


/*QUAKED obj_statue_neptune(0.3 0.1 0.6) (-30 -30 0) (30 30 100)
Statue of Neptune (I think)
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------

*/
void obj_statue_neptune (void)
{
	precache_model2("models/neptune.mdl");
	CreateEntityNew(self,ENT_STATUE_NEPTUNE,"models/neptune.mdl",chunk_death);

	self.drawflags += SCALE_ORIGIN_BOTTOM;

}

/*QUAKED obj_bonepile(0.3 0.1 0.6) (-10 -10 0) (10 10 10)
A pile of bones. Uses the model of the puzzle keep1
-------------------------FIELDS-------------------------
health = 
--------------------------------------------------------
*/
void obj_bonepile (void)
{
	precache_model3("models/bonepile.mdl");
	CreateEntityNew(self,ENT_BONEPILE,"models/bonepile.mdl",chunk_death);

	self.use = chunk_death;

	self.drawflags += SCALE_ORIGIN_BOTTOM;
}

/*QUAKED obj_statue_caesar(0.3 0.1 0.6) (-24 -24 0) (24 24 90)
Statue of a Caesar Romero
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------
*/
void obj_statue_caesar (void)
{
	precache_model2("models/caesar.mdl");
	CreateEntityNew(self,ENT_STATUE_CAESAR,"models/caesar.mdl",chunk_death);

	self.drawflags += SCALE_ORIGIN_BOTTOM;

}

/*QUAKED obj_statue_snake_coil (0.3 0.1 0.6) (-44 -44 0) (44 44 90)
Statue of a coiled snake (just like the one that comes to life) but this one doesn't come to life.
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------
*/
void obj_statue_snake_coil (void)
{
	precache_model2 ("models/snake.mdl");
	CreateEntityNew(self,ENT_STATUE_SNAKE_COIL,"models/snake.mdl",chunk_death);

	self.scale = .5;
	self.drawflags += SCALE_ORIGIN_BOTTOM;

}

/*QUAKED obj_skull (0.3 0.1 0.6) (-8 -8 0) (8 8 16)
A skull, suitable for over the fireplace or perhaps a colorful holiday display
-------------------------FIELDS-------------------------
health = 10
--------------------------------------------------------
*/
void obj_skull (void)
{
	precache_model("models/skull.mdl");
	CreateEntityNew(self,ENT_SKULL,"models/skull.mdl",chunk_death);
}

/*QUAKED obj_pew (0.3 0.1 0.6) (-16 -40 0) (16 40 50)
A church pew - like you might find in a church.
-------------------------FIELDS-------------------------
health = 50
--------------------------------------------------------
*/
void obj_pew (void)
{
	precache_model("models/pew.mdl");
	CreateEntityNew(self,ENT_PEW,"models/pew.mdl",chunk_death);
}

/*QUAKED obj_statue_olmec (0.3 0.1 0.6) (-40 -40 0) (40 40 130)
A olmec statue, of course. What the heck is an olmec?
-------------------------FIELDS-------------------------
health = 50
--------------------------------------------------------
*/
void obj_statue_olmec (void)
{
	precache_model2("models/olmec1.mdl");
	CreateEntityNew(self,ENT_STATUE_OLMEC,"models/olmec1.mdl",chunk_death);
}

/*QUAKED obj_statue_mars (0.3 0.1 0.6) (-30 -30 0) (30 30 80)
A statue of Mars.
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------
*/
void obj_statue_mars (void)
{
	precache_model2("models/mars.mdl");
	CreateEntityNew(self,ENT_STATUE_MARS,"models/mars.mdl",chunk_death);
}

/*QUAKED obj_playerhead_paladin (0.3 0.1 0.6) (-8 -8 0) (8 8 16)
The head of the paladin.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_playerhead_paladin (void)
{
	precache_model("models/h_pal.mdl");
	CreateEntityNew(self,ENT_PLAYERHEAD,"models/h_pal.mdl",chunk_death);
	self.use=chunk_death;
}

/*QUAKED obj_playerhead_assassin (0.3 0.1 0.6) (-8 -8 0) (8 8 16)
The head of the assassin.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_playerhead_assassin (void)
{
	precache_model("models/h_ass.mdl");
	CreateEntityNew(self,ENT_PLAYERHEAD,"models/h_ass.mdl",chunk_death);
	self.use=chunk_death;
}

/*QUAKED obj_playerhead_necromancer (0.3 0.1 0.6) (-8 -8 0) (8 8 16)
The head of the necromancer.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_playerhead_necromancer (void)
{
	precache_model3("models/h_nec.mdl");
	CreateEntityNew(self,ENT_PLAYERHEAD,"models/h_nec.mdl",chunk_death);
	self.use=chunk_death;
}

/*QUAKED obj_playerhead_crusader (0.3 0.1 0.6) (-8 -8 0) (8 8 16)
The head of the crusader.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_playerhead_crusader (void)
{
	precache_model3("models/h_cru.mdl");
	CreateEntityNew(self,ENT_PLAYERHEAD,"models/h_cru.mdl",chunk_death);
	self.use=chunk_death;
}

/*QUAKED obj_statue_king (0.3 0.1 0.6) (-30 -30 0) (30 30 120)
A statue of a king holding a sword in front of him.
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------
*/
void obj_statue_king (void)
{
	precache_model3("models/king.mdl");
	CreateEntityNew(self,ENT_STATUE_KING,"models/king.mdl",chunk_death);
	self.mins -= '0 0 80';
	self.maxs -= '0 0 80';
	setsize(self, self.mins, self.maxs);
}

/*QUAKED obj_plant_generic (0.3 0.1 0.6) (-10 -10 0) (10 10 20)
A generic plant that should have some kind of pot placed below it.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_plant_generic (void)
{
	precache_model3("models/plantgen.mdl");
	CreateEntityNew(self,ENT_PLANT_GENERIC,"models/plantgen.mdl",chunk_death);
}

/*QUAKED obj_plant_meso (0.3 0.1 0.6) (-10 -10 0) (10 10 40)
A generic plant that should have some kind of pot placed below it.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_plant_meso (void)
{
	precache_model2("models/plantmez.mdl");
	CreateEntityNew(self,ENT_PLANT_MESO,"models/plantmez.mdl",chunk_death);
}

/*QUAKED obj_plant_rome (0.3 0.1 0.6) (-24 -24 0) (24 24 90)
A plant for the Rome area.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_plant_rome (void)
{
	precache_model2("models/plantrom.mdl");
	CreateEntityNew(self,ENT_PLANT_ROME,"models/plantrom.mdl",chunk_death);
}

/*QUAKED obj_skullstick (0.3 0.1 0.6) (-16 -16 0) (16 16 40)
A skull on a stick - mmm,mmm, good
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_skullstick (void)
{
	precache_model2("models/skllstk1.mdl");
	CreateEntityNew(self,ENT_SKULLSTICK,"models/skllstk1.mdl",chunk_death);
}


/*QUAKED obj_skull_stick2 (0.3 0.1 0.6) (-16 -16 0) (16 16 40)
Two skulls on a stick
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_skull_stick2 (void)
{
	precache_model2("models/skllstk2.mdl");
	CreateEntityNew(self,ENT_SKULLSTICK,"models/skllstk2.mdl",chunk_death);
}

/*QUAKED obj_corpse1 (0.3 0.1 0.6) (-32 -32 0) (32 32 10)
A body laying face down
-------------------------FIELDS-------------------------
health = 20
mass = 200;

skin = determines the skin of the model
 0 - burnt, nude guy
 1 - normal, nude guy
 2 - yucky diseased, nude guy
 3 - wound in back, has on pants
--------------------------------------------------------
*/
void obj_corpse1 (void)
{
	precache_model3("models/corps1.mdl");
	CreateEntityNew(self,ENT_CORPSE1,"models/corps1.mdl",chunk_death);
	self.use = chunk_death;
}

/*QUAKED obj_corpse2 (0.3 0.1 0.6) (-32 -32 0) (32 32 10)
A body laying face up
-------------------------FIELDS-------------------------
health = 20
mass = 200;
skin = determines the skin of the model
 0 - shoulder and facial wounds
 1 - clawed chest
 2 - stomach wound
 3 - just dead
 4 - webbed 
--------------------------------------------------------
*/
void obj_corpse2 (void)
{
	precache_model("models/corps2.mdl");
	CreateEntityNew(self,ENT_CORPSE2,"models/corps2.mdl",chunk_death);
	self.use = chunk_death;
}

/*QUAKED obj_hedge1 (0.3 0.1 0.6) (-16 -16 0) (16 16 80)
A hedge that looks like an X-mas tree
-------------------------FIELDS-------------------------
health = 20
mass = 200;
--------------------------------------------------------
*/
void obj_hedge1 (void)
{
	precache_model2("models/hedge1.mdl");
	CreateEntityNew(self,ENT_HEDGE1,"models/hedge1.mdl",chunk_death);
}


/*QUAKED obj_hedge2 (0.3 0.1 0.6) (-16 -16 0) (16 16 80)
A hedge that is square and of medium height
-------------------------FIELDS-------------------------
health = 20
mass = 200;
--------------------------------------------------------
*/
void obj_hedge2 (void)
{
	precache_model2("models/hedge2.mdl");
	CreateEntityNew(self,ENT_HEDGE2,"models/hedge2.mdl",chunk_death);
}

/*QUAKED obj_hedge3 (0.3 0.1 0.6) (-16 -16 0) (16 16 80)
A hedge that is tall and thin
-------------------------FIELDS-------------------------
health = 20
mass = 200;
--------------------------------------------------------
*/
void obj_hedge3 (void)
{
	precache_model2("models/hedge3.mdl");
	CreateEntityNew(self,ENT_HEDGE3,"models/hedge3.mdl",chunk_death);
}

/*QUAKED obj_book_open (0.3 0.1 0.6) (-8 -8 0) (8 8 10)
A book that is open
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_book_open (void)
{
	precache_model("models/bookopen.mdl");
	CreateEntityNew(self,ENT_BOOKOPEN,"models/bookopen.mdl",chunk_death);
	if(self.targetname)
		self.use=chunk_death;
}

/*QUAKED obj_book_closed (0.3 0.1 0.6) (-8 -8 0) (8 8 10)
A book that is closed
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_book_closed (void)
{
	precache_model("models/bookclos.mdl");
	CreateEntityNew(self,ENT_BOOKCLOSED,"models/bookclos.mdl",chunk_death);
	if(self.targetname)
		self.use=chunk_death;
}


/*QUAKED obj_fence (0.3 0.1 0.6) (-26 -26 0) (26 26 70)
A section of fence
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_fence (void)
{
	precache_model3("models/fence.mdl");
	CreateEntityNew(self,ENT_FENCE,"models/fence.mdl",chunk_death);
}


/*QUAKED obj_bush1 (0.3 0.1 0.6) (-16 -16 0) (16 16 40)
A small round bush
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_bush1 (void)
{
	precache_model("models/bush1.mdl");
	CreateEntityNew(self,ENT_BUSH1,"models/bush1.mdl",chunk_death);
}


/*QUAKED obj_tombstone1 (0.3 0.1 0.6) (-24 -24 0) (24 24 60)
A tombstone in the shape of a cross
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_tombstone1 (void)
{
	precache_model("models/tombstn1.mdl");
	CreateEntityNew(self,ENT_TOMBSTONE1,"models/tombstn1.mdl",chunk_death);
}

/*QUAKED obj_tombstone2 (0.3 0.1 0.6) (-16 -16 0) (16 16 40)
A tombstone with a rounded top
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_tombstone2 (void)
{
	precache_model("models/tombstn2.mdl");
	CreateEntityNew(self,ENT_TOMBSTONE2,"models/tombstn2.mdl",chunk_death);
}

/*QUAKED obj_statue_angel (0.3 0.1 0.6) (-60 -60 0) (60 60 120)
A statue of Xena in all her glory, sorry - just wishful thinking. It's a statue of an angle praying.
-------------------------FIELDS-------------------------
health = 20
--------------------------------------------------------
*/
void obj_statue_angel (void)
{
	precache_model("models/anglstat.mdl");
	CreateEntityNew(self,ENT_STATUE_ANGEL,"models/anglstat.mdl",chunk_death);
}

/*QUAKED obj_statue_tut (0.3 0.1 0.6) (-36 -36 0) (36 36 248)
An Egyptian statue of a guy with a flat head hat
-------------------------FIELDS-------------------------
health = 1000
mass = 2000
--------------------------------------------------------
*/
void obj_statue_tut (void)
{
	precache_model2("models/tutstatu.mdl");

	CreateEntityNew(self,ENT_STATUE_TUT,"models/tutstatu.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	
	self.drawflags += SCALE_ORIGIN_BOTTOM;
}

/*QUAKED obj_flag (0.3 0.1 0.6) (-16 -16 0) (16 16 160)
A flag that wave in the breeze
-------------------------FIELDS-------------------------
health = 50
--------------------------------------------------------
*/
void obj_flag (void)
{
	precache_model("models/flag.mdl");
	CreateEntityNew(self,ENT_FLAG,"models/flag.mdl",chunk_death);
//	self.frame = random(0,40);
}

/*QUAKED obj_statue_snake (0.3 0.1 0.6) (-16 -16 0) (16 16 80) INVINCIBLE
The front of a snake
INVINCIBLE = Won't take damage
-------------------------FIELDS-------------------------
defaults:
health = 100
mass = 200;
--------------------------------------------------------
*/
void obj_statue_snake (void)
{
	precache_model2("models/snkstatu.mdl");

	CreateEntityNew(self,ENT_STATUE_SNAKE,"models/snkstatu.mdl",chunk_death);

	if(self.spawnflags&1)
	{
		self.health=0;
		self.takedamage=DAMAGE_NO;
	}
}

/*QUAKED obj_chair (0.3 0.1 0.6) (-10 -10 -5) (10 10 40)
A wooden chair. 
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void obj_chair()
{
	precache_model("models/chair.mdl");

	CreateEntityNew(self,ENT_CHAIR,"models/chair.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;
}


/*QUAKED obj_barstool (0.3 0.1 0.6) (-10 -10 -5) (10 10 32)
A bar stool - Drinks on the house!
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void obj_barstool()
{
	precache_model3("models/stool.mdl");

	CreateEntityNew(self,ENT_BARSTOOL,"models/stool.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	
}


/*QUAKED obj_tree (0.3 0.1 0.6) (-42 -42 0) (42 42 160)
A tree that has no leaves
-------------------------FIELDS-------------------------
health : 1000
--------------------------------------------------------
*/
void obj_tree()
{
	precache_model2("models/tree.mdl");
	CreateEntityNew(self,ENT_TREEDEAD,"models/tree.mdl",chunk_death);
}

void tree2_death (void)
{
	self.owner.nextthink = time + .01;
	self.owner.think = chunk_death;
	chunk_death();
}

/*QUAKED obj_tree2 (0.3 0.1 0.6) (-140 -140 -16) (140 140 220)
A tree with a round top of leaves 
-------------------------FIELDS-------------------------
health : 1000
--------------------------------------------------------
*/
void obj_tree2()
{
	entity top;

	precache_model("models/tree2.mdl");
	CreateEntityNew(self,ENT_TREE,"models/tree2.mdl",tree2_death);

	top = spawn();
	top.scale = self.scale;

	CreateEntityNew(top,ENT_TREETOP,top.model,tree2_death);

	top.origin = self.origin;

	if (self.scale)		// Move top according to scale
		top.origin_z += top.scale * 104;
	else 
		top.origin_z += 104; 

	top.health = self.health;
	top.classname = "tree2top";

	top.owner = self;
	self.owner = top;

}

/*QUAKED obj_bench (0.3 0.1 0.6) (-30 -30 0) (30 30 40)
A wooden bench 
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void obj_bench()
{
	precache_model3("models/bench.mdl");
	CreateEntityNew(self,ENT_BENCH,"models/bench.mdl",chunk_death);

	self.touch	= obj_push;
}


/*QUAKED obj_cart (0.3 0.1 0.6) (-36 -32 -10) (36 75 64)
A cart 
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void obj_cart()
{
	precache_model("models/cart.mdl");
	CreateEntityNew(self,ENT_CART,"models/cart.mdl",chunk_death);
	self.hull=HULL_SCORPION;

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	
}


/*QUAKED obj_chest1 (0.3 0.1 0.6) (-16 -16 0) (16 16 32)
A treasure chest
-------------------------FIELDS-------------------------
skin - 0 - generic texture (default)
       1 - roman texture
--------------------------------------------------------
*/
void obj_chest1()
{
	precache_model("models/chest1.mdl");
	CreateEntityNew(self,ENT_CHEST1,"models/chest1.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	
}


/*QUAKED obj_chest2 (0.3 0.1 0.6) (-16 -16 0) (16 16 32)
A treasure chest on legs
-------------------------FIELDS-------------------------
skin - 0 - generic texture (default)
       1 - meso texture
       2 - egypt texture
--------------------------------------------------------
*/
void obj_chest2()
{
	precache_model3("models/chest2.mdl");
	CreateEntityNew(self,ENT_CHEST2,"models/chest2.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	

}

/*QUAKED obj_chest3 (0.3 0.1 0.6) (-16 -16 0) (16 16 32)
A treasure chest on legs
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void obj_chest3()
{
	precache_model2("models/chest3.mdl");
	CreateEntityNew(self,ENT_CHEST3,"models/chest3.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	

}

/*QUAKED obj_sword (0.3 0.1 0.6) (-16 -16 -8) (16 16 8)
A sword 
-------------------------FIELDS-------------------------
health = 50
--------------------------------------------------------
*/
void obj_sword (void)
{
	precache_model("models/sword.mdl");
	CreateEntityNew(self,ENT_SWORD,"models/sword.mdl",chunk_death);

	if(self.targetname)
		self.use=chunk_death;
}

void cauldron_run (void)
{
	vector spot1;

	spot1= self.origin;
	spot1_z= self.origin_z + 35;
	CreateWhiteSmoke(spot1,'0 0 8',HX_FRAME_TIME * 2);
	self.think = cauldron_run;
	self.nextthink = time + random(0.5,1.5);
}

/*QUAKED obj_cauldron (0.3 0.1 0.6) (-16 -16 0) (16 16 40)
A cauldron
-------------------------FIELDS-------------------------
health = 50
mass = 15
--------------------------------------------------------
*/
void obj_cauldron (void)
{
	precache_model("models/cauldron.mdl");
	CreateEntityNew(self,ENT_CAULDRON,"models/cauldron.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	
	self.drawflags += SCALE_ORIGIN_BOTTOM;
	
	self.think = cauldron_run;
	self.nextthink = time + random(0.5,1.5);

}

/*QUAKED brush_pushable (0.3 0.1 0.6) ?
A brush the player can push
-------------------------FIELDS-------------------------
mass - (default 5)
--------------------------------------------------------
*/
void brush_pushable()
{

	self.max_health = self.health;
	self.solid = SOLID_SLIDEBOX;
	self.movetype = MOVETYPE_PUSHPULL;
	setorigin (self, self.origin);	
	setmodel (self, self.model); 
	self.classname="pushable brush";
	self.touch	= obj_push;
    self.hull = HULL_BIG;
	setsize(self,self.mins,self.maxs);
	if(!self.mass)
		self.mass = 5;
}

void statue_death (void)
{
	if (self.enemy)   // The head must die first
	{
		self.enemy.nextthink = time + .01;
		self.enemy.think = chunk_death;
		chunk_death();
	}
	else
		chunk_death();
}

/*QUAKED obj_statue_mummy_head (0.3 0.1 0.6) (-16 -16 -26) (16 16 160)
Statue of the nubis head
-------------------------FIELDS-------------------------
health = 200
--------------------------------------------------------

*/
void() obj_statue_mummy_head =
{
	precache_model2("models/mhdstatu.mdl");
	CreateEntityNew(self,ENT_STATUE_MUMMYHEAD,"models/mhdstatu.mdl",chunk_death);

	self.touch	= obj_push;
	self.flags	= self.flags | FL_PUSH;	
	self.drawflags += SCALE_ORIGIN_BOTTOM;

};

/*QUAKED obj_statue_mummy (0.3 0.1 0.6) (-16 -16 0) (16 16 160)
Statue of the mummy monster
-------------------------FIELDS-------------------------
health = 200
mass = 150
--------------------------------------------------------
*/
void() obj_statue_mummy =
{
	entity head;

	head=spawn();
	head.scale = self.scale;

	if (self.scale)
	{
		head.origin_z = 132 * self.scale;
		head.mass = 150 * self.scale;
	}
	else
	{
		head.origin_z = 132;
	}

	head.origin += self.origin;
	head.angles = self.angles;
	self.enemy = head;

	precache_model2 ("models/mumstatu.mdl");
	CreateEntityNew(self,ENT_STATUE_MUMMY_BODY,"models/mumstatu.mdl",statue_death);

	self.drawflags += SCALE_ORIGIN_BOTTOM;

	precache_model2 ("models/mhdstatu.mdl");
	CreateEntityNew(head,ENT_STATUE_MUMMY_HEAD,"models/mhdstatu.mdl",statue_death);

	head.health = self.health;	
	head.drawflags += SCALE_ORIGIN_BOTTOM;

};

