/*QUAKED obj_ice (0 0 1) ? NOTRANS
Slippery, slidey ice
NOTRANS = No translucency
-------------------------FIELDS-------------------------
health = default = 20
friction = default is 0.2, 0 is none, 1 is normal, 10 is max
abslight = default is 0.5
--------------------------------------------------------
*/
void ice_touch (void)
{
	if(other.flags&FL_ONGROUND)
		if(random()>self.friction)
			other.flags-=FL_ONGROUND;
}

void ice_slab_melt (void)
{
	if(self.scale>0.05)
	{
		self.scale-=0.05;
		setsize(self,self.mins*0.9,self.maxs*0.9);
		thinktime self : 0.1;
	}
	else
		remove(self);
}

void obj_ice (void)
{
//thingtype_ice, need ice chunks
	if(self.flags2&FL_SUMMONED)
	{
//Make pushable, floating?!
		self.solid = SOLID_BBOX;
		self.movetype = MOVETYPE_NONE;
		self.drawflags(+)SCALE_TYPE_XYONLY;
		self.scale = 1;
		self.think = ice_slab_melt;
		thinktime self : 10;
	}
	else
	{
		self.solid = SOLID_BSP;
		self.movetype = MOVETYPE_PUSH;
	}
	self.takedamage=DAMAGE_YES;
	self.thingtype = THINGTYPE_ICE;
	setorigin (self, self.origin);	
	setmodel (self, self.model);

	self.frozen=TRUE;
	self.classname="ice";

	self.use = chunk_death;

	self.drawflags+=MLS_ABSLIGHT;

	if(!self.abslight)
		self.abslight = 0.75;

	if(!self.spawnflags&1)
		self.drawflags+=DRF_TRANSLUCENT;

	if(!self.health)
		self.health = 20;
	self.max_health = self.health;

	if(!self.friction)
		self.friction = 0.2;

	self.touch = ice_touch;
	self.th_die = chunk_death;
}

