/*
==============================================================================

FIREBALL

==============================================================================
*/

// For building the model
$cd c:\model\fireball		// Directory to find model in
$origin 0 0 0		
// baseframe is in iceimp.3ds
$base fireball		
// skin is in iceimp.lbm
$skin fireball		

// Imp throwing 
$frame firbal1  firbal2  firbal3  firbal4  firbal5
$frame firbal6  firbal7  firbal8  firbal9  firbal10


//============================================================================
void FireFizzle (void)
{
	sound (self, CHAN_WEAPON, "misc/fout.wav", 1, ATTN_NORM);
	DeathBubbles(1);
	remove(self);
}

void() fireballTouch =
{
	local float	damg;

	if (other == self.owner)
		return;		// don't explode on owner

	if (pointcontents(self.origin) == CONTENT_SKY)
	{
		remove(self);
		return;
	}

	if (self.dmg == -1)
		damg = random(5,10);
	else if (self.dmg)
		damg = self.dmg;
	else
		damg = random(12,22);
	
	if (other.health)
	{
		if (self.owner.classname == "cube_of_force")
			T_Damage (other, self.owner, self.owner.owner, damg ,"fireball touch");
		else
			T_Damage (other, self, self.owner, damg ,"fireball");
	}

	// don't do radius damage to the other, because all the damage
	// was done in the impact
	T_RadiusDamage (self, self.owner, damg, other);

	self.origin = self.origin - 8*normalize(self.velocity);

	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
	WriteCoord (MSG_BROADCAST, self.origin_x);
	WriteCoord (MSG_BROADCAST, self.origin_y);
	WriteCoord (MSG_BROADCAST, self.origin_z);

	remove(self);
};

void fireball_1(void)
{
	float retval;

	self.nextthink = time + HX_FRAME_TIME;

	retval = AdvanceFrame($firbal1,$firbal10);

	if (retval == AF_BEGINNING)
	{
		if (pointcontents(self.origin) != CONTENT_EMPTY) 
			FireFizzle();
	}
}

void(vector offset) do_fireball =
{
entity missile;
vector vec;

	missile = spawn ();
	missile.owner = self;
	missile.speed=500;
	if(self.classname=="monster_imp_lord")
	{
		missile.dmg=random(80,120);
		missile.speed+=500;
		missile.scale=2;
	}
	else
		missile.dmg = self.dmg;

	missile.movetype = MOVETYPE_FLYMISSILE;
	missile.solid = SOLID_BBOX;
	missile.health = 10;

	setmodel (missile, "models/fireball.mdl");
	setsize (missile, '0 0 0', '0 0 0');		

// set missile speed	

	makevectors (self.angles);
	vec = self.origin + self.view_ofs + v_factor(offset);
	setorigin (missile, vec);

	vec = self.enemy.origin - missile.origin + self.enemy.view_ofs;
	vec = normalize(vec);

	missile.velocity = (vec+aim_adjust(self.enemy))*missile.speed;
	missile.angles = vectoangles('0 0 0'-missile.velocity);
	
	missile.touch = fireballTouch;

	missile.think = fireball_1;
	missile.nextthink = time + HX_FRAME_TIME;
};

void()trap_fireball_use;
void trap_fireball_wait ()
{
	self.use = trap_fireball_use;
	self.think=SUB_Null;
	self.nextthink=-1;
}

void fireball_think ()
{
	particle4(self.origin,3,random(160,176),PARTICLETYPE_FIREBALL,random(10,20));
	self.think=fireball_think;
	thinktime self : 0.1;
}

void trap_fireball_use ()
{
	entity fireball;
	vector vec;
	float dot;

	if(self.spawnflags&1)
	{
		self.think=trap_fireball_wait;
		thinktime self : 0;
	}
	else
	{
		self.use=trap_fireball_wait;
	    	self.think = trap_fireball_use;
		thinktime self : self.wait;
	}

	if(self.goalentity)
		self.enemy=self.goalentity;
	else
		self.enemy = find (world, classname, "player");

	if((visible(self.enemy)&&self.enemy!=world)||self.goalentity==self.enemy)
	{
		vec=normalize((self.enemy.absmin+self.enemy.absmax)*0.5-self.origin);
		makevectors(self.angles);
		dot = v_forward*vec;
		if(dot>0.6||self.goalentity==self.enemy)
		{
			sound (self, CHAN_WEAPON, "imp/fireball.wav", 1, ATTN_NORM);
			fireball = spawn ();
			fireball.movetype = MOVETYPE_FLYMISSILE;
			fireball.solid = SOLID_BBOX;
			fireball.speed=1000;
			fireball.velocity=vec*fireball.speed;
	        	fireball.touch = fireballTouch;
			fireball.dmg=self.dmg;
			fireball.owner = self;
	        	fireball.angles = vectoangles (fireball.velocity);
			fireball.think = fireball_think;
			thinktime fireball : 0.05;
			self.last_attack=time;
			setmodel (fireball, "models/drgnball.mdl");
			setsize (fireball, '0 0 0', '0 0 0');     
			setorigin (fireball,self.origin);
		}
	}
}

void locate_first_target ()
{
	self.goalentity=find(world,targetname,self.target);
	if(!self.goalentity)
		dprint("ERROR: Targeted Fireball can't find target\n");
}

/*QUAKED trap_fireball (1 0.3 0) (0 0 0) (16 16 16) TRIGGER_ONLY
New item for QuakeEd
It works!  It really works!
If TRIGGER_ONLY is turned on, it will fire once each time it's triggered (used)
otherwise, each time it's used, it's turned on or off.
If it's targetted to something, it will fire at that rather than tracking the player.
-------------------------FIELDS-------------------------
.wait = How long to wait between firings (default 0.5)
.dmg = How much damage to do with each shot (default 10)
--------------------------------------------------------
*/
void () trap_fireball =
{
	precache_sound2("imp/fireball.wav");
	precache_model2("models/drgnball.mdl");
	if(!self.wait)
		self.wait=0.5;
	if(!self.dmg)
		self.dmg=10;
	if(self.target)
	{
		self.think=locate_first_target;
		thinktime self : 0.5;
	}

	self.use = trap_fireball_use;
};

/*QUAKED misc_fireball (0 .5 .8) (-8 -8 -8) (8 8 8)
Lava Balls
*/

void fire_fly();
void fire_touch();

void misc_fireball()
{
	precache_model ("models/lavaball.mdl");
	self.classname = "fireball";
	thinktime self : random(5);
	self.think = fire_fly;
	if (!self.speed)
		self.speed == 1000;
}

void fire_fly()
{
local entity	fireball;

	fireball = spawn();
	fireball.solid = SOLID_TRIGGER;
	fireball.movetype = MOVETYPE_TOSS;
	fireball.velocity = '0 0 1000';
	fireball.velocity=RandomVector('50 50 0');
	fireball.velocity_z = self.speed + random(200);
	fireball.classname = "fireball";
	setmodel (fireball, "models/lavaball.mdl");
	setsize (fireball, '0 0 0', '0 0 0');
	setorigin (fireball, self.origin);
	thinktime fireball : 5;
	fireball.think = SUB_Remove;
	fireball.touch = fire_touch;
	
	thinktime self : random(3,8);
	self.think = fire_fly;
}

void fire_touch()
{
	T_Damage (other, self, self, 20,"fire touch");
	remove(self);
}

