/*
===============================================================================

FUNC_CRUSHER

===============================================================================
*/

void() crusher_slide_next =
{
   local vector	vdestdelta;
   local float		len, tspeed;

	tspeed = self.speed;

	if (!tspeed) objerror("No speed defined!");

	//Make sure we're not already at the destination
	if (self.finaldest == self.origin)
	{
		self.velocity = '0 0 0';
		
      if (self.state == STATE_DOWN) self.think = crusher_hit_bottom;
	    else if (self.state == STATE_UP) self.think = crusher_hit_top;

    	self.nextthink = self.ltime + 0.1;
		
		return;
	}
		
	//Set destdelta to the vector needed to move
	vdestdelta = self.finaldest - self.origin;
	
   //Get the length of the vector
	len = vlen (vdestdelta);
	
	//If the length is this small, just stop
	if (len < 1) 
	{
	  if (self.state == STATE_DOWN) crusher_hit_bottom();
	   else if (self.state == STATE_UP) crusher_hit_top();
		 else dprint("NO STATE\n");
	  return;
	}
   		
	self.nextthink = self.ltime + 0.1;
	self.think = crusher_slide_next;
	
	self.velocity = vdestdelta * ((len / (len / 3)) / (self.speed / 100));
};

void(vector tdest) crusher_slide =
{
    self.finaldest = tdest;
	 crusher_slide_next();
};

void() crusher_hit_top =
{
	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	self.state = STATE_TOP;

	if (self.spawnflags & CRUSH_MULT) 
		return;
	
   if (!self.level)
   {
    self.think = crusher_go_down;
	 self.nextthink = self.ltime + 1;
	}
	else 
		self.nextthink = -1;
};

void() crusher_hit_bottom =
{
	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
	self.state = STATE_BOTTOM;
	if (self.level && self.spawnflags & CRUSH_ENDPOS) return;
	self.think = crusher_go_up;
	self.nextthink = self.ltime + 1;
};

void() crusher_go_down =
{
	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	self.state = STATE_DOWN;
	if (self.spawnflags & CRUSH_SLIDE) crusher_slide(self.pos2);
    else SUB_CalcMove (self.pos2, self.speed, crusher_hit_bottom);
};

void() crusher_go_up =
{
	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
	self.state = STATE_UP;
	if (self.spawnflags & CRUSH_SLIDE) crusher_slide(self.pos1);
	 else SUB_CalcMove (self.pos1, self.speed, crusher_hit_top);
};

void() crusher_trigger_use =
{
	if (!self.level) 
	 self.level = TRUE;
   else 
	  self.level = FALSE;

//HCC doesn't like these together in one statement
	if (self.think) 
	 if (self.spawnflags & CRUSH_MULT)
	 	return;		// already activated
	 	
	crusher_go_down();
};

void() crusher_crush =
{
	//Crusher does not return like a plat, it just keeps on crushin'
	T_Damage (other, self, self, self.dmg,"crusher");
};

void() crusher_use =
{
	if (!self.level) 
	 self.level = TRUE;
   else 
    self.level = FALSE;

	crusher_go_down();
};

/*QUAKED func_crusher (0 .5 .8) ? multiple slide start_open end_open
speed	default 150
dmg default 10

If not targetname is given, crushers will start working immediatly

Crushers are always drawn in the extended position, so they will light correctly.

start_open = start in open position
multiple = go once, return, and wait to be triggered again
slide = slide move (like doors)
end_open = stop in the position opposite what they were drawn in

"lip" same as doors
"speed" speed of the crusher
"wait pause until going in the other direction
"targetname" if set, no trigger is needed (use with multiple)
"dmg" damage the crusher does to a victim

Set "soundtype" to one of the following:
1) base fast
2) chain slow
3) Guillotine
*/

void() func_crusher =
{
	SetMovedir();

	if (self.soundtype == 0) self.soundtype = 2;

	if (self.soundtype == 1)
	{
		precache_sound ("plats/plat1.wav");
		precache_sound ("plats/plat2.wav");
		self.noise = "plats/plat1.wav";
		self.noise1 = "plats/plat2.wav";
	}
	else if (self.soundtype == 2)
	{
		precache_sound ("plats/medplat1.wav");
		precache_sound ("plats/medplat2.wav");
		self.noise = "plats/medplat1.wav";
		self.noise1 = "plats/medplat2.wav";
	}
	else if (self.soundtype == 3)
	{
		precache_sound3 ("plats/guiltin1.wav");
		precache_sound3 ("plats/guiltin2.wav");
		self.noise = "plats/guiltin1.wav";
		self.noise1 = "plats/guiltin2.wav";
	}

	self.mangle = self.angles;
	self.angles = '0 0 0';

	self.classname = "crusher";
	self.solid = SOLID_BSP;
	self.movetype = MOVETYPE_PUSH;
	setorigin (self, self.origin);	
	setmodel (self, self.model);
	setsize (self, self.mins , self.maxs);

	self.level = TRUE;

	if (!self.dmg) self.dmg = 10;

	self.blocked = crusher_crush;
	
	if (!self.speed) self.speed = 150;

	self.pos1 = self.origin;
	self.pos2 = self.pos1 + self.movedir*(fabs(self.movedir*self.size) - self.lip);

	if (self.spawnflags & CRUSH_START_OPEN)
	{
	   setorigin (self, self.pos2);
		self.pos2 = self.pos1;
		self.pos1 = self.origin;
	}

	self.use = crusher_trigger_use;

	if (self.targetname)
	{
		self.state = STATE_UP;
		self.use = crusher_use;
	}
	else
	{
		setorigin (self, self.pos2);
		self.state = STATE_BOTTOM;
		self.nextthink = self.ltime + 0.1;
		self.think = crusher_use;
	}
};
