/*
==============================================================================

SIMPLE BMODELS

==============================================================================
*/

void() func_wall_use =
{	// change to alternate textures
	self.frame = 1 - self.frame;
};

/*QUAKED func_wall (0 .5 .8) ? TRANSLUCENT
This is just a solid wall if not inhibitted
TRANSLUCENT - makes it see-through
abslight = how bright to make it
*/
void func_wall()
{
	self.angles = '0 0 0';
	self.movetype = MOVETYPE_PUSH;	// so it doesn't get pushed by anything
	self.solid = SOLID_BSP;
	self.classname="solid wall";
	self.use = func_wall_use;
	setmodel (self, self.model);
	if(self.spawnflags&1)
		self.drawflags=DRF_TRANSLUCENT;
	if(self.abslight)
		self.drawflags(+)MLS_ABSLIGHT;
}


/*QUAKED func_illusionary (0 .5 .8) ? TRANSLUCENT LIGHT
A simple entity that looks solid but lets you walk through it.
*/
void func_illusionary()
{
	if (self.spawnflags & 1) 
		self.drawflags (+) DRF_TRANSLUCENT;

	if (self.abslight)
		self.drawflags (+) MLS_ABSLIGHT;

	if (self.spawnflags & 2)
		self.drawflags (+) MLS_ABSLIGHT;

	self.classname="illusionary wall";
	self.angles = '0 0 0';
	self.movetype = MOVETYPE_NONE;
	self.solid = SOLID_NOT;
	setmodel (self, self.model);
	makestatic (self);
}

/*QUAKED info_null (0 0.5 0) (-4 -4 -4) (4 4 4)
Used as a positional target for spotlights, etc.
*/
void info_null()
{
	remove(self);
}

