// Knocks you back if in it's way 
void bell_attack(float anim)
{
	vector spot1,spot2,bell_angle;

	if (!anim)
		bell_angle = self.v_angle;
	else
	{	
		bell_angle = self.v_angle;
		bell_angle_y = self.v_angle_y - 180;
	}		

	makevectors (bell_angle);
	spot1 = self.origin + '0 0 -180';  // from the bottom of the bell	
	spot2 = spot1 + v_forward * 150;			

	tracearea (spot1,spot2,'-80 -80 0','80 80 64',FALSE,self);

	if (trace_fraction == 1.0)  
		return;
	
	if (trace_ent.takedamage)
	{
		sound (self, CHAN_WEAPON, "weapons/gauntht1.wav", 1, ATTN_NORM);

		if (!trace_ent.movetype == MOVETYPE_NONE)
		{
			if(trace_ent.flags&FL_ONGROUND)
				trace_ent.flags = trace_ent.flags - FL_ONGROUND;
			trace_ent.velocity =  trace_ent.origin - self.origin;
			trace_ent.velocity_z = 280;
		}
	}
}

void bell_smallring (void) [++ 31 .. 51]
{
	self.nextthink = time + HX_FRAME_TIME + HX_FRAME_TIME + HX_FRAME_TIME;

	if (cycle_wrapped)
	{
		self.frame = 0;
		self.nextthink = time - 1;
		self.think = SUB_Null;
	}
}

void bell_bigring (void) [++ 0 .. 30]
{
	self.nextthink = time + HX_FRAME_TIME + HX_FRAME_TIME + HX_FRAME_TIME;

	if (self.frame == 2) 
	{
		sound (self, CHAN_VOICE, "misc/bellring.wav", 1, ATTN_IDLE);
		bell_attack(0);
	}

	if (self.frame == 8)
	{
		sound (self, CHAN_VOICE, "misc/bellring.wav", 1, ATTN_IDLE);
		bell_attack(1);
	}

	if (cycle_wrapped)
	{
		self.frame = 0;
		self.nextthink = time - 1;
		self.think = SUB_Null;
	}
}

void bell_ring (void)
{

	if (self.frame != 0)
		return;

	if ((self.last_health - self.health) < 20)
		bell_smallring();
	else
		bell_bigring();

	self.last_health = self.health;
}

/*QUAKED obj_bell (0.3 0.1 0.6) (-100 -100 -210) (100 100 8)
A big bell that rings when hit. 
-------------------------FIELDS-------------------------
health = 250
--------------------------------------------------------
*/
void obj_bell (void)
{
	precache_sound("misc/bellring.wav");
	precache_model("models/bellring.mdl");

	CreateEntityNew(self,ENT_BELL,"models/bellring.mdl",chunk_death);

	self.last_health = self.health;
	self.th_pain = bell_ring;
	self.use = bell_bigring;
}

