float SPAWNFLAG_BALLISTA_TRACK = 1;

void BalBoltTouch (void)
{
	if(other.takedamage)
	{
//FIXME: Sound
	vector dir;
		if(other!=self.goalentity&&self.velocity!='0 0 0')
		{
			self.goalentity=other;
			dir=normalize(self.velocity);
			traceline(self.origin-dir*25,self.origin+dir*25,FALSE,self);
			if(other.thingtype==THINGTYPE_FLESH)
				MeatChunks (trace_endpos,self.velocity*0.5+'0 0 200', 3,trace_ent);
			SpawnPuff (trace_endpos, self.velocity*0.5+'0 0 200', self.dmg,trace_ent);
			T_Damage(other,self,self.owner.enemy.enemy,self.dmg,"ballista");
		}
		self.think=chunk_death;
		thinktime self : 0.2;
		if(other.solid==SOLID_BSP||normalize(self.velocity)!=self.movedir)
			chunk_death();
	}
	else
		chunk_death();
}

void FireBalBolt (void)
{
vector org;

	newmis=spawn();
	newmis.owner=self;
	makevectors(self.angles);
	org=self.origin+self.proj_ofs+v_forward*10;
	if(self.spawnflags&SPAWNFLAG_BALLISTA_TRACK)
	{
		newmis.velocity=normalize((self.enemy.absmax+self.enemy.absmin)*0.5-org)*1000;
	}
	else
	{
		newmis.velocity=normalize(self.view_ofs-org)*1000;
		traceline(org,org+newmis.velocity,FALSE,self);
		if(trace_ent!=self.goalentity&&self.goalentity.health)
			newmis.velocity=normalize((self.goalentity.absmin+self.goalentity.absmax)*0.5-org)*1000;
	}
	newmis.movedir=normalize(newmis.velocity);
	newmis.movetype=MOVETYPE_FLYMISSILE;
	newmis.solid=SOLID_PHASE;
	newmis.thingtype=THINGTYPE_WOOD;
	newmis.touch=BalBoltTouch;
	newmis.angles=vectoangles(newmis.velocity);
	newmis.avelocity_z=500;
	newmis.dmg=self.dmg;
	newmis.goalentity=newmis;

	setmodel(newmis,"models/balbolt.mdl");
	setsize(newmis,'0 0 0','0 0 0');
	setorigin(newmis,org);
}

void()ballista_think;
void() ballista_fire = [++ 1 .. 30 ]
{
	if (self.frame == 2)
		sound (self, CHAN_WEAPON, "weapons/ballista.wav", 1, ATTN_NORM);
	else if (self.frame==4)
		FireBalBolt();
	else if (self.frame == 15)
		sound (self, CHAN_WEAPON, "weapons/ballwind.wav", 1, ATTN_NORM);

	if(cycle_wrapped)
	{
		self.frame=0;
		self.last_attack=time;
		if(self.spawnflags&SPAWNFLAG_BALLISTA_TRACK)
			self.think=ballista_think;
		else
			self.think=SUB_Null;
	}
};

void ballista_think()
{
	entity targ;
	float pitchmod,checklooped,bestdist,lastdist;
	vector my_pitch, ideal_pitch;

	if(!self.enemy||!visible(self.enemy)||!self.enemy.flags2&FL_ALIVE&&!self.enemy.artifact_active&ART_INVISIBILITY&&!self.enemy.artifact_active&ART_INVINCIBILITY)
	{
//		dprint("looking\n");
		self.enemy=targ = world;
		bestdist=9999;
		while(!checklooped)
		{	
			targ = find (targ, classname, "player");
			if(visible(targ)&&targ.flags2&FL_ALIVE&&!targ.artifact_active&ART_INVISIBILITY&&!targ.artifact_active&ART_INVINCIBILITY)
			{
				lastdist=vlen(targ.origin-self.origin);
				if(lastdist<bestdist)
				{
//					dprint("acquired one\n");
					bestdist=lastdist;
					self.enemy=targ;
				}
			}
			if(targ==world)
				checklooped=TRUE;
		}
		targ=world;
		while(!checklooped)
		{	
			targ = find (targ, classname, "bot");
			if(visible(targ)&&targ.flags2&FL_ALIVE&&!targ.artifact_active&ART_INVISIBILITY&&!targ.artifact_active&ART_INVINCIBILITY)
			{
				lastdist=vlen(targ.origin-self.origin);
				if(lastdist<bestdist)
				{
//					dprint("acquired one\n");
					bestdist=lastdist;
					self.enemy=targ;
				}
			}
			if(targ==world)
				checklooped=TRUE;
		}
	}

	if (self.enemy)
	{
//		dprint("tracking\n");
//Yaw
		enemy_yaw = vectoyaw(self.enemy.origin - self.origin);

		ai_attack_face();
//Pitch
		makevectors(self.angles);	
		my_pitch=normalize(v_forward);
		ideal_pitch=normalize(self.enemy.origin-self.origin);
		ideal_pitch=vectoangles(ideal_pitch);
		if(ideal_pitch_z>my_pitch_z)
		{
			if(ideal_pitch_z-my_pitch_z>self.count)
				pitchmod=self.count;
			else
				pitchmod=ideal_pitch_z-my_pitch_z;
			self.angles_z+=pitchmod;
		}
		else if(ideal_pitch_z<my_pitch_z)
		{	
			if(my_pitch_z-ideal_pitch_z>self.count)
				pitchmod=self.count;
			else
				pitchmod=my_pitch_z-ideal_pitch_z;
			self.angles_z-=pitchmod;
		}
		if(self.last_attack+self.speed<time)
			if(visible(self.enemy))
				if(infront(self.enemy))
				{
					if(random()<0.2)
						ballista_fire();
				}
		
	}
	self.nextthink = self.ltime + 0.1;
	self.think = ballista_think;
}
		
/*QUAKED obj_ballista (0.3 0.1 0.6) (-45 -45 0) (45 45 60) SPAWNFLAG_BALLISTA_TRACK
A ballista which is animated to shoot an arrow
-------------------------FIELDS-------------------------
health = default = 0 (indestructable)
cnt    = degrees of pitch off the starting point pos & neg (default = 30)
count  = degrees per movement (default = 5)
dmg	   = amount of damage projectile will do (default  = 50)
speed  = delay, in seconds, between firings (higher number means longer wait) (default = 5)
--------------------------------------------------------
*/
void obj_ballista (void)
{
	precache_model("models/ballista.mdl");
	precache_model("models/balbolt.mdl");
	precache_sound ("weapons/ballista.wav");	// firing
	precache_sound ("weapons/ballwind.wav");	// ballista winding back to fire

	if(!self.mass)
		self.mass=1000;

	CreateEntityNew(self,ENT_BALLISTA,"models/ballista.mdl",chunk_death);
	self.hull=HULL_SCORPION;

	if (!self.cnt) 
	  self.cnt = 30;

	if (!self.count)
	  self.count = 5;

	if(!self.health)
		self.takedamage=DAMAGE_NO;

	if(!self.dmg)
		self.dmg = 50;

	if(!self.speed)
		self.speed = 5;

	self.oldorigin = self.angles;

	if (self.spawnflags & SPAWNFLAG_BALLISTA_TRACK)
	{
		self.yaw_speed = self.count;
		self.th_missile = ballista_fire;
		self.think = ballista_think;
		self.nextthink = time + 0.5;
		self.last_attack=time+0.5;
	}

	self.th_weapon = ballista_fire;
	self.view_ofs=self.proj_ofs='0 0 48';
//	self.use = ballista_use;
}

void() control_return =
{	
	if(self.goalentity.classname!="catapult")
	{
		self.goalentity.oldthink=SUB_Null;
		self.goalentity.think=reset_mangle;
		thinktime self.goalentity : 0;
	}

	if(self.check_ok)
	{
		self.enemy.oldweapon=0;
		self.enemy.th_weapon=W_SetCurrentAmmo;
		self.check_ok = FALSE;
		self.enemy=world;
	}
};

void() control_touch =
{
vector org, dir; 
float fire_range;
	if ((other.classname != "player")&&(other.classname != "bot"))
		return;

	if (self.enemy != world && other != self.enemy) return;

	if(self.goalentity.health<=0&&self.health)
	{
		self.think=SUB_Remove;
		thinktime self : 0;
		return;
	}

	other.attack_finished=time+0.1;
	if(other.weaponmodel!="models/xhair.mdl");
	{
		other.weaponmodel="models/xhair.mdl";
		other.weaponframe = 0;
		other.th_weapon=SUB_Null;
		self.check_ok = TRUE;
	}

	if(self.enemy!=other)
		centerprint(other,"You're in control!\n");

	self.enemy = other;
	self.goalentity.enemy = self;

	makevectors(self.enemy.v_angle);
	if(self.goalentity.classname=="catapult")
	{
		if(self.enemy.angles_y<self.goalentity.angles_y+5&&self.enemy.angles_y>self.goalentity.angles_y - 5)
			self.goalentity.angles_y=self.enemy.angles_y;
		if(self.goalentity.think==catapult_ready)
			if(self.enemy.button0)
			{
				self.goalentity.think=self.goalentity.th_weapon;
				thinktime self.goalentity : 0;
			}
	}
	else
	{
		org=self.enemy.origin+self.enemy.proj_ofs;
		dir=normalize(v_forward);
		traceline(org,org+dir*10000,FALSE,self.enemy);
		org=self.goalentity.origin+self.goalentity.proj_ofs;
	
		fire_range=vlen(org-trace_endpos);
		if(fire_range>128)
		{
			dir=normalize(trace_endpos-org);
			if(trace_ent.health&&trace_ent.origin!='0 0 0')//Many breakable brishes have no origin
				self.goalentity.goalentity=trace_ent;
			else
				self.goalentity.goalentity=world;
			self.goalentity.view_ofs=trace_endpos;
			dir=vectoangles(dir);
			self.goalentity.angles=dir;
			self.goalentity.angles_z=dir_z/10;
	
			if(self.goalentity.think!=self.goalentity.th_weapon)
				if(self.enemy.button0&&self.goalentity.th_weapon!=SUB_Null)
				{
//					self.goalentity.oldthink = control_return;
					self.goalentity.think=self.goalentity.th_weapon;
					thinktime self.goalentity : 0;
				}
//				else 
//				{
//					self.goalentity.think = control_return;
//					thinktime self.goalentity : 0.1;
//				}
		}
	}
	self.think = control_return;
	thinktime self : 0.1;
};

/*QUAKED trigger_control (.5 .5 .5) ?

Takes over a ballista when the player is inside of it
*/
void trigger_control_find_target (void)
{
	if (!self.target)
		objerror("Nothing to control!\n");

	self.goalentity = find(world, targetname, self.target);

	if(self.goalentity.takedamage)
		self.health=TRUE;

	if (!self.goalentity)
		objerror("Could not find target\n");
	else if(self.goalentity.classname=="catapult"||self.goalentity.classname=="obj_catapult2")
	{
		self.goalentity.movechain=self;
		self.flags(+)FL_MOVECHAIN_ANGLE;
		self.movetype=MOVETYPE_NOCLIP;
	}
	else
		self.goalentity.mangle = self.goalentity.angles;
}

void() trigger_control = 
{
	self.enemy = world;
	self.touch = control_touch;
	self.ltime = time;
	InitTrigger();
	self.think=trigger_control_find_target;
	thinktime self : 1;
};

