//====================================================================================================
//
//   Model names
//
//   Paladin: 
//			2   -  w_l2_c1   -  vorpal sword
//			3   -  w_l3_c1   -  axe
//			4.1 -  w_l41_c1  -  purifier head 
//			4.2 -  w_l42_c1  -  purifier staff
//
//   Crusader:
//			2   -  w_l2_c2   -  ice staff
//			3   -  w_l3_c2   -  meteor wand
//			4.1 -  w_l41_c2  -  sun staff head 
//			4.2 -  w_l42_c2  -  sun staff staff
//
//   Necromancer:
//			2   -  w_l2_c3   -  magic missile
//			3   -  w_l3_c3   -  bone shard
//			4.1 -  w_l41_c3  -  set staff head
//			4.2 -  w_l42_c3  -  set staff staff
//
//   Assassin:
//			2   -  w_l2_c4   -  crossbow
//			3   -  w_l3_c4   -  grenade
//			4.1 -  w_l41_c4  -  vindictus head
//			4.2 -  w_l42_c4  -  vindctus staff
//
//
//====================================================================================================

/*
=============
weapon_touch
=============
*/
void weapon_touch (void)
{
	float	new, old;
	entity	stemp;
	float	leave,hadweap;

	if (!other.flags & FL_CLIENT||other.model=="models/sheep.mdl")
		return;

	if ((!(deathmatch & 1)) || coop)
	{
		if(other.items&self.items)
			return;
		else
			leave = 1;
	}
	else
		leave = 0;

	other.oldweapon = other.weapon;


	new = self.items;
	// Give player weapon and mana
	if (self.classname=="wp_weapon2")
	{
		if (other.playerclass == CLASS_PALADIN)
			self.netname = STR_VORPAL;
		else if (other.playerclass == CLASS_CRUSADER)
			self.netname = 	STR_ICESTAFF;
		else if (other.playerclass == CLASS_NECROMANCER)
			self.netname = 	STR_MAGICMISSILE;
		else if (other.playerclass == CLASS_ASSASSIN)
			self.netname = 	STR_CROSSBOW;

		other.bluemana += 25;		
	}
	else if (self.classname=="wp_weapon3")
	{
		if (other.playerclass == CLASS_PALADIN)
			self.netname = STR_AXE;
		else if (other.playerclass == CLASS_CRUSADER)
			self.netname = 	STR_METEORSTAFF;
		else if (other.playerclass == CLASS_NECROMANCER)
			self.netname = 	STR_BONESHARD;
		else if (other.playerclass == CLASS_ASSASSIN)
			self.netname = 	STR_GRENADES;

		other.greenmana += 25;		

	}
	else if (self.classname=="wp_weapon4_head")
	{
		if (other.playerclass == CLASS_PALADIN)
			self.netname = STR_PURIFIER1;
		else if (other.playerclass == CLASS_CRUSADER)
			self.netname = 	STR_SUN1;
		else if (other.playerclass == CLASS_NECROMANCER)
			self.netname = 	STR_RAVENSTAFF1;
		else if (other.playerclass == CLASS_ASSASSIN)
			self.netname = 	STR_SET1;

		other.bluemana += 25;		
		other.greenmana += 25;	

		if (other.items & IT_WEAPON4_2)
		   new += IT_WEAPON4;				

	}
	else if (self.classname=="wp_weapon4_staff")
	{
		if (other.playerclass == CLASS_PALADIN)
			self.netname = STR_PURIFIER2;
		else if (other.playerclass == CLASS_CRUSADER)
			self.netname = 	STR_SUN2;
		else if (other.playerclass == CLASS_NECROMANCER)
			self.netname = 	STR_RAVENSTAFF2;
		else if (other.playerclass == CLASS_ASSASSIN)
			self.netname = 	STR_SET2;

		other.bluemana += 25;		
		other.greenmana += 25;	

		if (other.items & IT_WEAPON4_1)
		   new += IT_WEAPON4;				

	}
	else
		objerror ("weapon_touch: unknown classname");

	sprint (other, STR_YOUGOTTHE);
	sprint (other, self.netname);
	sprint (other, "\n");

	sound (other, CHAN_ITEM, "weapons/weappkup.wav", 1, ATTN_NORM);  // touch sound
	stuffcmd (other, "bf\n");

	max_playermana ();	// Check mana limits

// change to the weapon
	if(other.items&new)
		hadweap=TRUE;

	old = other.items;
	other.items = other.items | new;
	
	stemp = self;
	self = other;

	max_playermana();

	if(self.attack_finished<time)
	{//So you don't interrupt another selection or firing frame
		if(!deathmatch||!hadweap)	//In DM, don't switch to new weapon if already had it
			NewBestWeapon (old, new);

		W_SetCurrentWeapon();
	}

	self = stemp;

	if (leave)
		return;

// remove it in single player, or setup for respawning in deathmatch
	self.model = string_null;
	self.solid = SOLID_NOT;
	if (deathmatch & 1)
		self.nextthink = time + 30;
	self.think = SUB_regen;
	
	activator = other;
	SUB_UseTargets();				// fire all targets / killtargets
}

//====================================================================================================
//
//   GENERIC WEAPON ARTIFACTS - DETERMINED BY PLAYER CLASS
//
//====================================================================================================

/*QUAKED wp_weapon2 (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
In world weapon 2 pickup for single player mode
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void wp_weapon2 (void)
{
	precache_model("models/w_l2_c1.mdl");
	precache_model3("models/w_l2_c2.mdl");
	precache_model3("models/w_l2_c3.mdl");
	precache_model("models/w_l2_c4.mdl");

	CreateEntityNew(self,ENT_WEAPON2_ART,"models/w_l2_c1.mdl",SUB_Null);
	setsize(self,'0 0 0','0 0 0');
	self.hull=HULL_POINT;

	self.flags(+)FL_CLASS_DEPENDENT;
	self.touch = weapon_touch;	
	self.items=IT_WEAPON2;
	StartItem ();

}


/*QUAKED wp_weapon3 (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
In world weapon 3 pickup for single player mode
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void wp_weapon3 (void)
{
	precache_model("models/w_l3_c1.mdl");
	precache_model3("models/w_l3_c2.mdl");
	precache_model3("models/w_l3_c3.mdl");
	precache_model("models/w_l3_c4.mdl");

	CreateEntityNew(self,ENT_WEAPON41_ART,"models/w_l3_c1.mdl",SUB_Null);
	setsize(self,'0 0 0','0 0 0');
	self.hull=HULL_POINT;

	self.flags(+)FL_CLASS_DEPENDENT;
	self.touch = weapon_touch;	
	self.items=IT_WEAPON3;
	StartItem ();

}

/*QUAKED wp_weapon4_head (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
In world weapon 4 pickup (staff head) for single player mode
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void wp_weapon4_head (void)
{
	precache_model("models/w_l41_c1.mdl");
	precache_model3("models/w_l41_c2.mdl");
	precache_model3("models/w_l41_c3.mdl");
	precache_model("models/w_l41_c4.mdl");

	CreateEntityNew(self,ENT_WEAPON41_ART,"models/w_l41_c1.mdl",SUB_Null);
	setsize(self,'0 0 0','0 0 0');
	self.hull=HULL_POINT;

	self.flags(+)FL_CLASS_DEPENDENT;
	self.touch = weapon_touch;	
	self.items=IT_WEAPON4_1;
	StartItem ();

}

/*QUAKED wp_weapon4_staff (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
In world weapon 4 pickup (staff) for single player mode
-------------------------FIELDS-------------------------
none
--------------------------------------------------------
*/
void wp_weapon4_staff (void)
{
	precache_model("models/w_l42_c1.mdl");
	precache_model3("models/w_l42_c2.mdl");
	precache_model3("models/w_l42_c3.mdl");
	precache_model("models/w_l42_c4.mdl");

	CreateEntityNew(self,ENT_WEAPON42_ART,"models/w_l42_c1.mdl",SUB_Null);
	setsize(self,'0 0 0','0 0 0');
	self.hull=HULL_POINT;

	self.flags(+)FL_CLASS_DEPENDENT;
	self.touch = weapon_touch;	
	self.items=IT_WEAPON4_2;
	StartItem ();

}

