void ring_touch (void)
{
	float		amount;
	entity holdself;

	if (((other.classname != "player")&&(other.classname != "bot")) || (other.health <= 0))
		return;

	// Was it thrown out by player just a frame of two ago?????
	if (self.owner == other && self.artifact_ignore_owner_time > time)
		return;
	if (self.artifact_ignore_time > time) 
		return;

	amount = random();
	if (amount < 0.5)
	{
		sprint (other, STR_YOUPOSSESS);
		sprint (other, self.netname);
	}
	else
	{
		sprint (other, STR_YOUHAVEACQUIRED);
		sprint (other, self.netname);
	}

	sprint (other,"\n");

	if (deathmatch||(self.classname == "Ring_Flight"&&!self.owner))
	{	if(deathmatch<=2)
		{	self.mdl = self.model;
			self.nextthink = time + 60;
			self.think = SUB_regen;
		}
	}

	sound (other, CHAN_VOICE, "items/ringpkup.wav", 1, ATTN_NORM);
	stuffcmd (other, "bf\n");
	self.solid = SOLID_NOT;
	self.model = string_null;

	// take appropriate action
	if ((self.classname == "Ring_Flight") && (deathmatch))
	{
		other.cnt_flight += 1;
	}
	else if (self.classname == "Ring_Flight") 
	{
		if(other.rings_active&RING_FLIGHT)//add time to current ring
		{
			other.ring_flight = 100;
			other.ring_flight_time = time + 1;
		}
		else
		{
			other.rings(+)RING_FLIGHT;
			other.ring_flight = 100;
			other.ring_flight_time = time + 1;
			holdself = self;
			self = other;
			player_fly();
			self = holdself;
			other.rings_active (+) RING_FLIGHT;
		}
		other.rings_low (-) RING_FLIGHT;
	}
	else if (self.classname == "Ring_WaterBreathing")
	{
		other.rings = other.rings | RING_WATER;
		other.ring_water = 100;
		other.ring_water_time = time + 1;

		if (other.rings_low & RING_WATER)
			other.rings_low (-) RING_WATER;

	}
	else if (self.classname == "Ring_Turning")
	{
		other.rings = other.rings | RING_TURNING;
		other.ring_turning = 100;
		other.ring_turning_time = time + 1;

		other.rings_active (+) RING_TURNING;

		if (other.rings_low & RING_TURNING)
			other.rings_low (-) RING_TURNING;
	}
	else if (self.classname == "Ring_Regeneration")
	{
		other.rings = other.rings | RING_REGENERATION;
		other.ring_regeneration = 100;
		other.rings_active (+) RING_REGENERATION;

		if (other.rings_low & RING_REGENERATION)
			other.rings_low (-) RING_REGENERATION;
	}

	activator = other;
	SUB_UseTargets();				// fire all targets / killtargets
}

/*QUAKED Ring_WaterBreathing (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
Ring of Water Breathing
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void Ring_WaterBreathing (void)
{
	precache_model("models/ringwb.mdl");
	Ring_Init("models/ringwb.mdl",STR_RINGWATERBREATHING);
}

/*QUAKED Ring_Flight (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
Ring of Flight
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void Ring_Flight (void)
{
	precache_model("models/ringft.mdl");
	Ring_Init("models/ringft.mdl",STR_RINGFLIGHT);
}

/*QUAKED Ring_Regeneration (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
Ring of Regeneration
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void Ring_Regeneration (void)
{
	precache_model("models/ringre.mdl");
	Ring_Init("models/ringre.mdl",STR_RINGREGENERATION);
}

/*QUAKED Ring_Turning (0 0 0) (-8 -8 -44) (8 8 20) FLOATING
Ring of Turning
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void Ring_Turning (void)
{
	precache_model("models/ringtn.mdl");
	Ring_Init("models/ringtn.mdl",STR_RINGTURNING);
}

void Ring_Init(string modelname,string name)
{
	setmodel(self, modelname);
	self.netname = name;

	setsize(self,'0 0 0','0 0 0');
	self.hull=HULL_POINT;
	self.touch = ring_touch;
	if((deathmatch==3)||(deathmatch==4)||(deathmatch==7)||(deathmatch==8))
	{	remove(self);
		return;
	}
	StartItem();
}

void CheckRings (void)
{
	entity victim;
	vector dir;
	float chance;

	if (self.health <= 0)
		return;

	if (self.rings & RING_REGENERATION)
	{	
		if (self.ring_regen_time < time)
		{
			if (self.health < self.max_health)
			{
				self.ring_regeneration -= 100/RING_REGENERATION_MAX;
				self.health += 1;				
				self.ring_regen_time = time + 1;
			}	

			if ((self.ring_regeneration < 10)  && (!self.rings_low & RING_REGENERATION))
			{
				self.rings_low (+) RING_REGENERATION;
				centerprint (self, "Ring of Regeneration is running low");
				sound (self, CHAN_BODY, "misc/comm.wav", 1, ATTN_NORM);
			}

			if (self.ring_regeneration <=0)
			{
				self.ring_regeneration = 0;
				self.rings (-) RING_REGENERATION;
				self.rings_active (-) RING_REGENERATION;
			}
		}
	}

	if (self.rings & RING_FLIGHT)
	{	
		if (self.ring_flight_time < time)
		{
			self.ring_flight -= 100/RING_FLIGHT_MAX;

			if ((self.ring_flight < 25)  && (!self.rings_low & RING_FLIGHT))
			{
				self.rings_low (+) RING_FLIGHT;
				centerprint (self, "Ring of Flight is running low");
				sound (self, CHAN_BODY, "misc/comm.wav", 1, ATTN_NORM);
			}

			if (self.ring_flight <=0)
			{
				self.ring_flight = 0;
				self.rings (-) RING_FLIGHT;
				self.rings_active (-) RING_FLIGHT;
				player_stopfly();
				if (deathmatch)
					self.cnt_flight -= 1;
			}
			self.ring_flight_time = time + 1;
		}
	}


	if ((self.rings & RING_WATER) && (self.waterlevel == 3) && (self.air_finished < time))
	{	
		self.rings_active (+) RING_WATER;
		if (self.ring_water_time < time)
		{
			self.ring_water -= 100/RING_WATER_MAX;

			if ((self.ring_water < 25)  && (!self.rings_low & RING_WATER))
			{
				self.rings_low (+) RING_WATER;
				centerprint (self, "Ring of Water Breathing is running low");
				sound (self, CHAN_BODY, "misc/comm.wav", 1, ATTN_NORM);
			}

			if (self.ring_water <=0)
			{
				self.ring_water = 0;
				self.rings (-) RING_WATER;
				self.rings_active (-) RING_WATER;
			}
			self.ring_water_time = time + 1;
		}
	}
	else
		self.rings_active (-) RING_WATER;

	if (self.rings & RING_TURNING)
	{	
		victim = findradius( self.origin, 100);
		while(victim)
		{
			if ((victim.movetype == MOVETYPE_FLYMISSILE) && (victim.owner != self))
			{
				victim.owner = self;
				chance = random();
				dir = victim.origin + (v_forward * -1);
				CreateLittleWhiteFlash(dir);
				sound (self, CHAN_WEAPON, "weapons/vorpturn.wav", 1, ATTN_NORM);
				if (chance < 0.9)  // Deflect it
				{
					victim.v_angle = self.v_angle + randomv('0 0 0', '360 360 360'); 
					makevectors (victim.v_angle);
					victim.velocity = v_forward * 1000;
				}
				else  // reflect missile
					victim.velocity = '0 0 0' - victim.velocity;
			}
			victim = victim.chain;
		}


		if (self.ring_turning_time < time)
		{
			self.ring_turning -= 100/RING_TURNING_MAX;

			if ((self.ring_turning < 10)  && (!self.rings_low & RING_TURNING))
			{
				self.rings_low (+) RING_TURNING;
				centerprint (self, "Ring of Reflection is running low");
				sound (self, CHAN_BODY, "misc/comm.wav", 1, ATTN_NORM);
			}

			if (self.ring_turning <=0)
			{
				self.ring_turning = 0;
				self.rings (-) RING_TURNING;
				self.rings_active (-) RING_TURNING;
			}

			self.ring_turning_time = time + 1;
		}
	}

}
	
