void ItemHitFloorWait ()
{
	if(self.flags&FL_ONGROUND||(pointcontents(self.origin-'0 0 38')==CONTENT_SOLID&&self.velocity_z<=0))
	{
		traceline(self.origin,self.origin-'0 0 38',TRUE,self);
		self.flags(+)FL_ITEM;		// make extra wide
		self.velocity='0 0 0';
		self.solid=SOLID_TRIGGER;
		if(self.touch==puzzle_touch)
		{
			setorigin(self,trace_endpos+'0 0 28');
			setsize (self, '-8 -8 -28', '8 8 8');
		}
		else 
		{
			setorigin(self,trace_endpos+'0 0 38');
			setsize (self, '-8 -8 -38', '8 8 24');
		}
		self.nextthink=-1;
		return;
	}
	else
		thinktime self : 0.05;
}
/*
============
PlaceItem

plants the object on the floor
============
*/
void() PlaceItem =
{
	float oldz;
	float oldHull;

	self.mdl = self.model;		// so it can be restored on respawn
	self.flags(+)FL_ITEM;		// make extra wide
	self.solid = SOLID_TRIGGER;
	self.movetype = MOVETYPE_TOSS;
	setsize (self, self.mins,self.maxs);
	self.velocity = '0 0 0';
	self.origin_z = self.origin_z + 6;
	oldz = self.origin_z;
	if(!self.spawnflags&FLOATING)
	{
		oldHull=self.hull;
		self.hull = HULL_POINT;
		if(!droptofloor())
		{
			remove(self);
			return;
		}
		self.hull=oldHull;
		if(self.touch==puzzle_touch)
		{
			setorigin(self,self.origin+'0 0 28');
			setsize (self, '-8 -8 -28', '8 8 8');
		}
		else
		{
			setorigin(self,self.origin+'0 0 38');
			setsize (self, '-8 -8 -38', '8 8 24');
		}
	}
	else
		self.movetype = MOVETYPE_NONE;	
};

/*
============
StartItem

Sets the clipping size and plants the object on the floor
============
*/
void() StartItem =
{
	if (self.owner)  // Spawned by the backpack function
	{
		self.movetype = MOVETYPE_PUSHPULL;
		if(self.touch==puzzle_touch)
			setsize (self, '-8 -8 -28', '8 8 8');
		else 
			setsize (self, '-16 -16 -38', '16 16 24');
		if(self.think!=SUB_Remove&&((self.owner.classname=="player")||(self.owner.classname=="bot"))&&self.model!="models/bag.mdl")
		{
			self.think=SUB_Remove;
			thinktime self : 30;//Go away after 30 sec if thrown by player & not a backpack
		}
	}
	else
	{
		self.nextthink = time + 0.2;	// items start after other solids
		self.think = PlaceItem;
	}
};


