/*
====================================================================================================

SUPER HP BOOST

====================================================================================================
*/

void DecrementSuperHealth()
{
	float wait_time,over,decr_health;

	if (self.health > self.max_health)
	{
		if (self.health<200)
		{
			wait_time = 2;
			decr_health = 1;
		}
		else if (self.health<400)  // Vary rate of update time
		{
			decr_health = 1;
			over = 200 - (self.health - 200);
			wait_time = over/400;
			if (wait_time < .10)
				wait_time = .10;
		}
		else						// Vary the amount of the decrement
		{
			wait_time = .10;
			over = self.health - 400;
			decr_health = over * .016;
			decr_health = ceil(decr_health);
			if (decr_health < 2)
				decr_health = 2;
		}
		
		self.health = self.health - decr_health;

		self.healthtime = time + wait_time;
	}
	else  // All done, get rid of it
		self.artifact_flags (-) AFL_SUPERHEALTH;  

}


void use_super_healthboost()
{
	self.healthtime = time + .05;

	if(self.health<-100)
		self.health=1;
	else if(self.health<0)
		self.health+=100;
	else if (self.health < 899)
		self.health = self.health + 100;
	else if (self.health > 999)
		self.health = 999;

	self.cnt_sh_boost -= 1;
	self.artifact_flags(+)AFL_SUPERHEALTH;   // Show the health is in use
}

/*QUAKED art_SuperHBoost (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for the Super Health Boost
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_SuperHBoost()
{
	spawn_artifact(ARTIFACT_SUPER_HP_BOOST,RESPAWN);
}


/*
====================================================================================================

HP BOOST

====================================================================================================
*/

void use_healthboost()
{
	if(self.health >= self.max_health)
	{ // Already at max health
		return;
	}
	self.cnt_h_boost -= 1;
	self.health += 25;
  	if(self.health > self.max_health)
	{
  		self.health = self.max_health;
	}
}


/*QUAKED art_HealthBoost (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for the Health Boost
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_HealthBoost()
{
	spawn_artifact(ARTIFACT_HP_BOOST,RESPAWN);
}

void ihealth_touch(void)
{

	if (((other.classname!="player")&&(other.classname!="bot")) || (other.health < 1)||other.model=="models/sheep.mdl")
		return;

	if (other.health < other.max_health)
	{
		sound (other, CHAN_VOICE, "items/itempkup.wav", 1, ATTN_NORM);
		other.health += 10;

		if (other.health > other.max_health)
			other.health = other.max_health;

		self.model = string_null;
		self.solid = SOLID_NOT;
		if (deathmatch & 1)
			self.nextthink = time + RESPAWN_TIME;
		self.think = SUB_regen;

		sprint(other, STR_YOUHAVETHE);
		sprint(other,self.netname);
		sprint(other,"\n");

		activator = other;
		SUB_UseTargets();				// fire all targets / killtargets
	}
}


void spawn_instant_health(void)
{
	self.touch = ihealth_touch;
	setmodel (self, "models/i_hboost.mdl");
	setsize (self, '0 0 0', '0 0 0');
	self.hull=HULL_POINT;
	self.classname = "item_health";
	self.netname = STR_INSTANTHEALTH;
	StartItem ();
}

/*QUAKED item_health (0 .5 .8) (-8 -8 -45) (8 8 20) FLOATING
Player is given 10 health instantly
-------------------------FIELDS-------------------------

--------------------------------------------------------
*/
void item_health (void)
{
	spawn_instant_health();
}

