/*
===============================================================================

PLAYER BACKPACKS

===============================================================================
*/

void BackpackTouch(void)
{
	string	s;
	float	old, new;
	float	ItemCount;
		
	if (((other.classname != "player")&&(other.classname != "bot"))||other.model=="models/sheep.mdl")
		return;
	if (other.health <= 0)
		return;
	if (self.owner == other && self.artifact_ignore_owner_time > time)
		return;
	if (self.artifact_ignore_time > time) 
		return;

	ItemCount = 0;
	sprint (other, "You get ");

	max_ammo2 (other,self);

	if (self.cnt_torch > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_torch += self.cnt_torch;

		s = ftos(self.cnt_torch);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_TORCH);
		if (self.cnt_torch > 1)	// Plural
			sprint(other,"es");
	}
	if (self.cnt_h_boost > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_h_boost += self.cnt_h_boost;

		s = ftos(self.cnt_h_boost);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_HEALTHBOOST);
		if (self.cnt_h_boost > 1)	// Plural
			sprint(other,"s");
	}
	if (self.cnt_sh_boost > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_sh_boost += self.cnt_sh_boost;

		s = ftos(self.cnt_sh_boost);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_SUPERHEALTHBOOST);
		if (self.cnt_sh_boost > 1)	// Plural
			sprint(other,"s");
	}
	if (self.cnt_mana_boost > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_mana_boost += self.cnt_mana_boost;

		s = ftos(self.cnt_mana_boost);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_mana_boost == 1)
			sprint(other,STR_MANABOOST);
		else
			sprint(other,"Kraters of Might");
	}
	if (self.cnt_teleport > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_teleport += self.cnt_teleport;

		s = ftos(self.cnt_teleport);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_TELEPORT);
		if (self.cnt_teleport > 1)	// Plural
			sprint(other,"s");
	}
	if (self.cnt_tome > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_tome += self.cnt_tome;

		s = ftos(self.cnt_tome);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_tome == 1)
			sprint(other,STR_TOME);
		else
			sprint(other,"Tomes of Power");
	}
	if (self.cnt_summon > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_summon += self.cnt_summon;

		s = ftos(self.cnt_summon);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_summon == 1)
			sprint(other,STR_SUMMON);
		else
			sprint(other,"Stones of Summoning");

	}
	if (self.cnt_flight > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_flight += self.cnt_flight;

		s = ftos(self.cnt_flight);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_flight == 1)
			sprint(other,STR_RINGFLIGHT);
		else
			sprint(other,"Rings of Flight");

	}
	if (self.cnt_glyph > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_glyph += self.cnt_glyph;

		s = ftos(self.cnt_glyph);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_glyph == 1)
			sprint(other,STR_GLYPH);
		else
			sprint(other,"Glyphs Of The Ancients");
	}

	if (self.cnt_haste > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_haste += self.cnt_haste;

		s = ftos(self.cnt_haste);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_HASTE);
	}
	if (self.cnt_blast > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_blast += self.cnt_blast;

		s = ftos(self.cnt_blast);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_blast == 1)
			sprint(other,STR_BLAST);
		else
			sprint(other,"Discs of Repulsion");
	}
	if (self.cnt_polymorph > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_polymorph += self.cnt_polymorph;

		s = ftos(self.cnt_polymorph);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_polymorph == 1)
			sprint(other,STR_POLYMORPH);
		else
			sprint(other,"Seals of the Ovinomancer");
	}
	if (self.cnt_invisibility > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_invisibility += self.cnt_invisibility;

		s = ftos(self.cnt_invisibility);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_INVISIBILITY);
		if (self.cnt_polymorph > 1)
			sprint(other,"s"); 
	}
	if (self.cnt_cubeofforce > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_cubeofforce += self.cnt_cubeofforce;

		s = ftos(self.cnt_cubeofforce);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_CUBEOFFORCE);
		if (self.cnt_cubeofforce > 1)
			sprint(other,"s"); 

	}
	if (self.cnt_invincibility > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.cnt_invincibility += self.cnt_invincibility;

		s = ftos(self.cnt_invincibility);
		sprint(other,s);
		sprint(other," ");
		if (self.cnt_invincibility == 1)
			sprint(other,STR_INVINCIBILITY);
		else
			sprint(other,"Icons of the Defender");
	}
	if (self.bluemana > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.bluemana += self.bluemana;

		s = ftos(self.bluemana);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_BLUEMANA);
	}
	if (self.greenmana > 0)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.greenmana += self.greenmana;

		s = ftos(self.greenmana);
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_GREENMANA);
	}
	
	if (self.armor_amulet)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.armor_amulet = self.armor_amulet;
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_ARMORAMULET);
	}

	if (self.armor_bracer)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.armor_bracer = self.armor_bracer;
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_ARMORBRACER);
	}

	if (self.armor_breastplate)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.armor_breastplate = self.armor_breastplate;
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_ARMORBREASTPLATE);
	}

	if (self.armor_helmet)
	{
		if (ItemCount) sprint(other,", ");
		ItemCount += 1;

		other.armor_helmet = self.armor_helmet;
		sprint(other,s);
		sprint(other," ");
		sprint(other,STR_ARMORHELMET);
	}

	if (!ItemCount) sprint(other,"...Nothing!");

//	if the player was using his best weapon, change up to the new one if better

	new = self.items;
	if (!new)
		new = other.weapon;
	old = other.items;
	other.items (+) new;

//	change weapons
	sprint (other, "\n");

//	backpack touch sound
	sound (other, CHAN_ITEM, "weapons/ammopkup.wav", 1, ATTN_NORM);
	stuffcmd (other, "bf\n");

//	remove the backpack, change self to the player
	remove(self);
	self = other;

//	change to the weapon
	if (!deathmatch)
		self.weapon = new;
	else
		NewBestWeapon (old, new);

	W_SetCurrentWeapon ();
}

void MonsterDropStuff(void)
{
	float chance;

	if(!self.flags&FL_MONSTER)
		return;

	if (self.monsterclass < CLASS_GRUNT)
		return;

	// Grunts drop only instant items
	if (self.monsterclass == CLASS_GRUNT)
	{
		if (random() < .15) // %15 chance he'll drop something	
		{
			chance = random();
			if (chance < .25)
				self.greenmana = 10;
			else if (chance < .50)
				self.bluemana = 10;
			else if (chance < .75)
			{
				self.greenmana = 10;
				self.bluemana = 10;
			}
			else
			{
				self.spawn_health = 1;
			}
		}
	}

	// Henchmen drop instant items or lesser artifacts
	else if (self.monsterclass == CLASS_HENCHMAN)
	{
		if (random() < .15) // %15 chance he'll drop something	
		{
			chance = random();

			if (chance < .08)
				self.greenmana = 10;
			else if (chance < .16)
				self.bluemana = 10;
			else if (chance < .24)
			{
				self.greenmana = 10;
				self.bluemana = 10;
			}
			else if (chance < .32)
			{
				self.spawn_health = 1;
			}
			else if (chance < .40)
				self.cnt_torch = 1;
			else if (chance < .48)
				self.cnt_h_boost = 1;
			else if (chance < .56)
				self.cnt_mana_boost = 1;
			else if (chance < .64)
				self.cnt_teleport = 1;
			else if (chance < .72)
				self.cnt_tome = 1;
			else if (chance < .80)
				self.cnt_haste = 1;
			else if (chance < .90)
				self.cnt_blast = 1;
		}		
	}
	// Leaders drop armor or artifacts
	else if (self.monsterclass == CLASS_LEADER)
	{		
		if (random() < .15) // %15 chance he'll drop something	
		{
			chance = random();
		
			 if (chance < .05)
				self.cnt_torch = 1;
			else if (chance < .10)
				self.cnt_h_boost = 1;
			else if (chance < .15)
				self.cnt_sh_boost = 1;
			else if (chance < .20)
				self.cnt_mana_boost = 1;
			else if (chance < .25)
				self.cnt_teleport = 1;
			else if (chance < .30)
				self.cnt_tome = 1;
			else if (chance < .35)
				self.cnt_summon = 1;
			else if (chance < .40)
				self.cnt_invisibility = 1;
			else if (chance < .45)
				self.cnt_glyph = 1;
			else if (chance < .50)
				self.cnt_haste = 1;
			else if (chance < .55)
				self.cnt_blast = 1;
			else if (chance < .60)
				self.cnt_polymorph = 1;
			else if (chance < .65)
				self.cnt_cubeofforce = 1;
			else if (chance < .70)
				self.cnt_invincibility = 1;
			else if (chance < .75)
				self.armor_amulet = 20;
			else if (chance < .80)
				self.armor_bracer = 20;
			else if (chance < .85)
				self.armor_breastplate = 20;
			else
				self.armor_helmet = 20;
		}
	}

	DropBackpack();
}

/*
===============
DropBackpack
===============
*/
void DropBackpack(void)
{
	entity item,old_self;
	float total;

	item = spawn();

	if(self.playerclass==CLASS_NECROMANCER)
		self.cnt_glyph=rint(self.cnt_glyph/5);
	total = 0;

	if (self.cnt_torch > 3)
		total += item.cnt_torch = 3;
	else
		total += item.cnt_torch = self.cnt_torch;

	if (self.cnt_h_boost > 3)
		total += item.cnt_h_boost = 3;
	else
		total += item.cnt_h_boost = self.cnt_h_boost;

	if (self.cnt_sh_boost > 3)
		total += item.cnt_sh_boost = 3;
	else
		total += item.cnt_sh_boost = self.cnt_sh_boost;

	if (self.cnt_mana_boost > 3)
		total += item.cnt_mana_boost = 3;
	else
		total += item.cnt_mana_boost = self.cnt_mana_boost;

	if (self.cnt_teleport > 3)
		total += item.cnt_teleport = 3;
	else
		total += item.cnt_teleport = self.cnt_teleport;

	if (self.cnt_tome > 3)
		total += item.cnt_tome = 3;
	else
		total += item.cnt_tome = self.cnt_tome;

	if (self.cnt_summon > 3)
		total += item.cnt_summon = 3;
	else
		total += item.cnt_summon = self.cnt_summon;

	if (self.cnt_invisibility > 3)
		total += item.cnt_invisibility = 3;
	else
		total += item.cnt_invisibility = self.cnt_invisibility;

	if (self.cnt_glyph > 3)
		total += item.cnt_glyph = 3;
	else
		total += item.cnt_glyph = self.cnt_glyph;

	if (self.cnt_haste > 3)
		total += item.cnt_haste = 3;
	else
		total += item.cnt_haste = self.cnt_haste;

	if (self.cnt_blast > 3)
		total += item.cnt_blast = 3;
	else
		total += item.cnt_blast = self.cnt_blast;

	if (self.cnt_polymorph > 3)
		total += item.cnt_polymorph = 3;
	else
		total += item.cnt_polymorph = self.cnt_polymorph;

	if (self.cnt_flight > 3)
		total += item.cnt_flight = 3;
	else
		total += item.cnt_flight = self.cnt_flight;

	if (self.cnt_cubeofforce > 3)
		total += item.cnt_cubeofforce = 3;
	else
		total += item.cnt_cubeofforce = self.cnt_cubeofforce;

	if (self.cnt_invincibility > 3)
		total += item.cnt_invincibility = 3;
	else
		total += item.cnt_invincibility = self.cnt_invincibility;

	// Full armor on this body?
	if (self.armor_amulet==20)
	{
		total += 1;
		item.armor_amulet = self.armor_amulet;
	}

	if (self.armor_bracer==20)
	{
		total += 1;
		item.armor_bracer = self.armor_bracer;
	}

	if (self.armor_breastplate==20)
	{
		total += 1;
		item.armor_breastplate = self.armor_breastplate;
	}

	if (self.armor_helmet==20)
	{
		total += 1;
		item.armor_helmet = self.armor_helmet;
	}

	// Any mana or instant health 	
	item.bluemana = self.bluemana;
	item.greenmana = self.greenmana;
	item.spawn_health = self.spawn_health;

//	total = 1;
//	item.cnt_tome = 1;

	if (!total && !item.bluemana && !item.greenmana && !item.spawn_health) 
	{	// Nothing to put in the backpack
		remove(item);
		return;
	}

	setorigin(item,self.origin);
	item.origin = self.origin + '0 0 40';
	item.flags(+)FL_ITEM;
	item.solid = SOLID_TRIGGER;
	item.movetype = MOVETYPE_TOSS;
	item.owner = self;
	item.artifact_ignore_owner_time = time + 2;
	item.artifact_ignore_time = time + 0.1;

	if ((total == 1 && !item.bluemana && !item.greenmana && !item.spawn_health) ||
	    (total == 0 &&  item.bluemana && !item.greenmana && !item.spawn_health)  ||
		(total == 0 && !item.bluemana &&  item.greenmana && !item.spawn_health)  ||
	    (total == 0 && !item.bluemana && !item.greenmana &&  item.spawn_health))
	{	// throw out the individual item
		item.velocity_z = 200;
//		item.velocity_x = random(-20,20);
//		item.velocity_y = random(-20,20);

		old_self = self;
		self = item;

		if (item.cnt_torch)
		{
			spawn_artifact(ARTIFACT_TORCH,NO_RESPAWN);
		}
		else if (item.cnt_h_boost)
		{
			spawn_artifact(ARTIFACT_HP_BOOST,NO_RESPAWN);
		}
		else if (item.cnt_sh_boost)
		{
			spawn_artifact(ARTIFACT_SUPER_HP_BOOST,NO_RESPAWN);
		}
		else if (item.cnt_mana_boost)
		{
			spawn_artifact(ARTIFACT_MANA_BOOST,NO_RESPAWN);
		}
		else if (item.cnt_teleport)
		{
			spawn_artifact(ARTIFACT_TELEPORT,NO_RESPAWN);
		}
		else if (item.cnt_tome)
		{
			spawn_artifact(ARTIFACT_TOME,NO_RESPAWN);
		}
		else if (item.cnt_summon)
		{
			spawn_artifact (ARTIFACT_SUMMON,NO_RESPAWN);
		}
		else if (item.cnt_invisibility)
		{
			spawn_artifact (ARTIFACT_INVISIBILITY,NO_RESPAWN);
		}
		else if (item.cnt_glyph)
		{
			spawn_artifact (ARTIFACT_GLYPH,NO_RESPAWN);
		}
		else if (item.cnt_haste)
		{
			spawn_artifact (ARTIFACT_HASTE,NO_RESPAWN);
		}
		else if (item.cnt_blast)
		{
			spawn_artifact(ARTIFACT_BLAST,NO_RESPAWN);
		}
		else if (item.cnt_polymorph)
		{
			spawn_artifact (ARTIFACT_POLYMORPH,NO_RESPAWN);
		}
		else if (item.cnt_flight)
		{
			spawn_artifact (ARTIFACT_FLIGHT,NO_RESPAWN);
		}
		else if (item.cnt_cubeofforce)
		{
			spawn_artifact (ARTIFACT_CUBEOFFORCE,NO_RESPAWN);
		}
		else if (item.cnt_invincibility)
		{
			spawn_artifact (ARTIFACT_INVINCIBILITY,NO_RESPAWN);
		}
		else if ((item.bluemana) && (item.greenmana))
		{
			spawn_item_mana_both(self.bluemana);
		}
		else if (item.bluemana)
		{
			spawn_item_mana_blue(self.bluemana);
		}
		else if (item.greenmana)
		{
			spawn_item_mana_green(self.greenmana);
		}
		else if (item.spawn_health)
		{
			spawn_instant_health();
		}
		else if (item.armor_amulet)
		{
			spawn_item_armor_amulet();
		}
		else if (item.armor_bracer)
		{
			spawn_item_armor_bracer();
		}
		else if (item.armor_breastplate)
		{
			spawn_item_armor_breastplate();
		}
		else if (item.armor_helmet)
		{
			spawn_item_armor_helmet();
		}
		else
		{
			dprint("Bad backpack!");
			remove(item);
			self = old_self;
			return;
		}

		self = old_self;
	}
	else
	{
		item.velocity_z = 300;
//		item.velocity_x = random(-20,20);
//		item.velocity_y = random(-20,20);

		setmodel (item, "models/bag.mdl");
		setsize (item, '-16 -16 -45', '16 16 10');
		item.hull=HULL_POINT;
		item.touch = BackpackTouch;
	
		item.nextthink = time + 120;	// remove after 2 minutes
		item.think = SUB_Remove;

		if (!total)
		{
			remove(item);
			return;
		}
	}

	self.cnt_torch=0;
    self.cnt_h_boost=0;
    self.cnt_sh_boost=0;
    self.cnt_mana_boost=0;
    self.cnt_teleport=0;
    self.cnt_tome=0;
    self.cnt_summon=0;
    self.cnt_invisibility=0;
    self.cnt_glyph=0;
    self.cnt_haste=0;
    self.cnt_blast=0;
    self.cnt_polymorph=0;
    self.cnt_flight=0;
    self.cnt_cubeofforce=0;
    self.cnt_invincibility=0;

	self.armor_amulet=0;
	self.armor_bracer=0;
	self.armor_breastplate = 0;
	self.armor_helmet = 0;
	self.bluemana=0;
	self.greenmana=0;
	self.spawn_health=0;
}

