/*
 * artifact_touch() -- Called when an artifact is being touched.
 *                     Awards players random amounts of whatever they represent.
 */

void artifact_touch()
{
	float amount;

	if(((other.classname != "player")&&(other.classname != "bot"))||other.model=="models/sheep.mdl")
	{ // Only players can take artifacts
		return;
	}
	if(other.health <= 0)
	{ // Player is dead
		return;
	}

	if (self.owner == other && self.artifact_ignore_owner_time > time)
		return;

	if (self.artifact_ignore_time > time) 
		return;

	// Take appropriate action
	if(self.netname == STR_TORCH)
	{
		if ((other.cnt_torch + 1)  > 15)
			return;	
		else
			other.cnt_torch += 1;		
	}
	else if(self.netname == STR_HEALTHBOOST)   // 25 limit
	{
		if ((other.cnt_h_boost + 1)  > 30||(other.playerclass!=CLASS_CRUSADER&&other.cnt_h_boost + 1  > 15))
			return;	
		else
			other.cnt_h_boost += 1; 
	}
	else if(self.netname == STR_SUPERHEALTHBOOST) // 5 limit
	{
		if (deathmatch&&(other.cnt_sh_boost + 1) > 2)
			return;	
		else if ((other.cnt_sh_boost + 1) > 5)
			return;	
		else
			other.cnt_sh_boost += 1; 
	}
	else if(self.netname == STR_MANABOOST)
	{
		if ((other.cnt_mana_boost + 1) > 15)
			return;	
		else
			other.cnt_mana_boost += 1; 
	}
	else if(self.netname == STR_TELEPORT)
	{
		if ((other.cnt_teleport + 1) > 15)
			return;	
		else
			other.cnt_teleport += 1;
	}
	else if(self.netname == STR_TOME)
	{
		if ((other.cnt_tome + 1)  > 15)
			return;	
		else
			other.cnt_tome += 1;
	}
	else if(self.netname == STR_SUMMON)
	{
		if ((other.cnt_summon + 1) > 15)
			return;	
		else
			other.cnt_summon += 1;
	}
	else if(self.netname == STR_INVISIBILITY)
	{
		if ((other.cnt_invisibility + 1) > 15)
			return;	
		else
			other.cnt_invisibility += 1;
	}
	else if(self.netname == STR_GLYPH)
	{
		if(other.playerclass==CLASS_CRUSADER)
		{
			if ((other.cnt_glyph + 5) > 50)
				return;	
			else	
				other.cnt_glyph += 5;
		}
		else
		{
			if ((other.cnt_glyph + 1) > 15)
				return;	
			else	
				other.cnt_glyph += 1;
		}
	}
	else if(self.netname == STR_HASTE)
	{
		if ((other.cnt_haste + 1)  > 15)
			return;	
		else
			other.cnt_haste += 1;
	}
	else if(self.netname == STR_BLAST)
	{
		if ((other.cnt_blast + 1)  > 15)
			return;	
		else
			other.cnt_blast += 1;
	}
	else if(self.netname == STR_POLYMORPH)
	{
		if ((other.cnt_polymorph + 1)  > 15)
			return;	
		else
			other.cnt_polymorph += 1;
	}
	else if(self.netname == STR_FLIGHT)
	{
		if ((other.cnt_flight + 1)  > 15)
			return;	
		else
			other.cnt_flight += 1;
	}
	else if(self.netname == STR_CUBEOFFORCE)
	{
		if ((other.cnt_cubeofforce + 1)  > 15)
			return;	
		else
			other.cnt_cubeofforce += 1;
	}
	else if(self.netname == STR_INVINCIBILITY)
	{
		if ((other.cnt_invincibility + 1)  > 15)
			return;	
		else
			other.cnt_invincibility += 1;
	}

	amount = random();
	if (amount < 0.5)
	{
		sprint (other, STR_YOUPOSSESS);
		sprint (other, self.netname);
	}
	else
	{
		sprint (other, STR_YOUHAVEACQUIRED);
		sprint (other, self.netname);
	}

	sprint (other,"\n");

	if (self.artifact_respawn<=4)
	{
		self.mdl = self.model;
		if(self.netname==STR_INVINCIBILITY)
			thinktime self : 120;
		else if(self.netname==STR_INVISIBILITY)
			thinktime self : 90;
		else
			thinktime self : 60;
		self.think = SUB_regen;
	}
	else if (self.artifact_respawn>4)
	{
		self.mdl = self.model;
		thinktime self : 120;
		self.think = SUB_regen;
	}

	sound(other, CHAN_VOICE, "items/artpkup.wav", 1, ATTN_NORM);
	stuffcmd(other, "bf\n");
	self.solid = SOLID_NOT;
//	other.items = other.items | self.items;
	self.model = string_null;

	activator = other;
	SUB_UseTargets(); // Fire all targets / killtargets

	if(!self.artifact_respawn)
	{
		remove(self);
	}
}


/*-----------------------------------------
	GenerateArtifactModel - generate the artifact 
  -----------------------------------------*/
void GenerateArtifactModel(string modelname,string art_name,float respawnflag) 
{
	if (respawnflag)	// Should this thing respawn
		self.artifact_respawn = deathmatch;

	setmodel(self, modelname);
	self.netname = art_name;

	if (modelname == "models/ringft.mdl")
	{
		self.netname = "Ring of Flight";
		self.touch	 = ring_touch;
	}
	else if (modelname != "models/a_xray.mdl")
		self.touch	 = artifact_touch;
	setsize (self, '0 0 0', '0 0 0');

	StartItem();
}


/*-----------------------------------------
	spawn_artifact - decide which artifact to spawn
  -----------------------------------------*/
void spawn_artifact (float artifact,float respawnflag)
{
	if (artifact == ARTIFACT_HASTE)
		GenerateArtifactModel("models/a_haste.mdl",STR_HASTE,respawnflag);
	else if (artifact == ARTIFACT_POLYMORPH)
		GenerateArtifactModel("models/a_poly.mdl",STR_POLYMORPH,respawnflag);
	else if (artifact == ARTIFACT_GLYPH)
		GenerateArtifactModel("models/a_glyph.mdl",STR_GLYPH,respawnflag);
	else if (artifact == ARTIFACT_INVISIBILITY)
		GenerateArtifactModel("models/a_invis.mdl",STR_INVISIBILITY,respawnflag);
	else if (artifact == ARTIFACT_INVINCIBILITY)
		GenerateArtifactModel("models/a_invinc.mdl",STR_INVINCIBILITY,respawnflag);
	else if (artifact == ARTIFACT_CUBEOFFORCE)
		GenerateArtifactModel("models/a_cube.mdl",STR_CUBEOFFORCE,respawnflag);
	else if (artifact == ARTIFACT_SUMMON)
		GenerateArtifactModel("models/a_summon.mdl",STR_SUMMON,respawnflag);
	else if (artifact == ARTIFACT_TOME)
		GenerateArtifactModel("models/a_tome.mdl",STR_TOME,respawnflag);
	else if (artifact == ARTIFACT_TELEPORT)
		GenerateArtifactModel("models/a_telprt.mdl",STR_TELEPORT,respawnflag);
	else if (artifact == ARTIFACT_MANA_BOOST)
		GenerateArtifactModel("models/a_mboost.mdl",STR_MANABOOST,respawnflag);
	else if (artifact == ARTIFACT_BLAST)
		GenerateArtifactModel("models/a_blast.mdl",STR_BLAST,respawnflag);
	else if (artifact == ARTIFACT_TORCH)
		GenerateArtifactModel("models/a_torch.mdl",STR_TORCH,respawnflag);
	else if (artifact == ARTIFACT_HP_BOOST)
		GenerateArtifactModel("models/a_hboost.mdl",STR_HEALTHBOOST,respawnflag);
	else if (artifact == ARTIFACT_SUPER_HP_BOOST)
		GenerateArtifactModel("models/a_shbost.mdl",STR_SUPERHEALTHBOOST,respawnflag);
	else if (artifact == ARTIFACT_FLIGHT)
		GenerateArtifactModel("models/ringft.mdl",STR_FLIGHT,respawnflag);
}


/*QUAKED art_blastradius (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Blast Radius
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_blastradius()
{
	spawn_artifact(ARTIFACT_BLAST,RESPAWN);
}



/*QUAKED art_teleport (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Teleportation
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_teleport()
{
	spawn_artifact(ARTIFACT_TELEPORT,RESPAWN);
}


/*QUAKED art_tomeofpower (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Tome of Power
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_tomeofpower()
{
	spawn_artifact(ARTIFACT_TOME,RESPAWN);
}


/*QUAKED art_summon (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Summoning
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_summon()
{	if(deathmatch>4)return;
	spawn_artifact(ARTIFACT_SUMMON,RESPAWN);
}

/*QUAKED art_glyph (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Glyph of the Ancients
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_glyph()
{
	spawn_artifact(ARTIFACT_GLYPH,RESPAWN);
}


/*QUAKED art_haste (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Haste
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_haste()
{
	spawn_artifact(ARTIFACT_HASTE,RESPAWN);
}


/*QUAKED art_polymorph (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Polymorph
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_polymorph()
{
	spawn_artifact(ARTIFACT_POLYMORPH,RESPAWN);
}

/*QUAKED art_cubeofforce (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Cube Of Force
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_cubeofforce()
{
	spawn_artifact(ARTIFACT_CUBEOFFORCE,RESPAWN);
}


/*QUAKED art_invincibility (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Invincibility
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_invincibility()
{
	spawn_artifact(ARTIFACT_INVINCIBILITY,RESPAWN);
}

/*QUAKED art_invisibility (.0 .0 .5) (-8 -8 -44) (8 8 20) FLOATING
Artifact for Invisibility
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void art_invisibility()
{
	spawn_artifact(ARTIFACT_INVISIBILITY,RESPAWN);
}

void item_spawner_use(void)
{
	DropBackpack();
}

/*QUAKED item_spawner (.0 .0 .5) (-8 -8 -44) (8 8 20) 
Generic item spawner
-------------------------FIELDS-------------------------
None
--------------------------------------------------------
*/
void item_spawner()
{
	setmodel(self, self.model);       // set size and link into world
	self.solid		= SOLID_NOT;
	self.movetype	= MOVETYPE_NONE;
	self.modelindex = 0;
	self.model		= "";
	self.effects = EF_NODRAW;
	
	self.use = item_spawner_use;
}

void remove_invincibility(entity loser)
{
	loser.artifact_low(-)ART_INVINCIBILITY;
	loser.artifact_active (-) ART_INVINCIBILITY;
	loser.invincible_time = 0;
	loser.air_finished = time + 12;
	if(loser.playerclass==CLASS_CRUSADER)
		loser.skin = 0;
	else if(loser.playerclass==CLASS_PALADIN)
		loser.effects(-)EF_BRIGHTLIGHT; 
	else if(loser.playerclass==CLASS_ASSASSIN)
		loser.colormap=0;
	else if(loser.playerclass==CLASS_NECROMANCER)
		loser.effects(-)EF_DARKLIGHT;
}
/*
================
CheckPowerups

Check for turning off powerups
================
*/
void() CheckPowerups =
{
	if (self.health <= 0)
		return;

	if (self.divine_time < time)
		self.artifact_active (-) ARTFLAG_DIVINE_INTERVENTION;
		
	// Crusader's special ability to smite 
	if (self.super_damage)
	{
		if (self.super_damage_time < time) 
		{
			self.super_damage = 0;		
		}
		else if (((self.super_damage_time - 10) < time) && (!self.super_damage_low))
		{
			self.super_damage_low = 1;
			sprint (self, "Holy Strength begins to wane\n");
			stuffcmd (self, "bf\n");
		}
	}

	if (self.artifact_active & ART_HASTE)
	{
		if (self.haste_time < time)
		{
			self.artifact_low =self.artifact_low - (self.artifact_low & ART_HASTE);
			self.artifact_active =self.artifact_active - (self.artifact_active & ART_HASTE);
			self.effects(-)EF_DARKFIELD;
			PlayerSpeed_Calc();
			self.haste_time = 0;
			self.air_finished = time + 12;
		}
		else if ((self.haste_time - 10) < time)
			self.artifact_low = self.artifact_low | ART_HASTE;
	}


	if (self.artifact_active & ART_INVINCIBILITY)
	{
		if (self.invincible_time < time)
			remove_invincibility(self);
		else if ((self.invincible_time - 10) < time)
			self.artifact_low = self.artifact_low | ART_INVINCIBILITY;
	}

	if ((self.drawflags & MLS_MASKIN) != MLS_POWERMODE)
		self.drawflags = (self.drawflags & MLS_MASKOUT)| MLS_POWERMODE;

	if (self.tome_time < time)
	{
		self.artifact_low = self.artifact_low - (self.artifact_low & ART_TOMEOFPOWER);
		self.artifact_active = self.artifact_active - (self.artifact_active & ART_TOMEOFPOWER);
		self.tome_time = 0;
		self.drawflags = (self.drawflags & MLS_MASKOUT)| 0;
	}
	else if ((self.tome_time - 10) < time)
		self.artifact_low = self.artifact_low | ART_TOMEOFPOWER;
	

// invisibility
	if (self.artifact_active & ART_INVISIBILITY)
	{
		if (self.invisible_time < time)
		{	// just stopped
			self.artifact_low = self.artifact_low - (self.artifact_low & ART_INVISIBILITY);
			self.artifact_active = self.artifact_active - (self.artifact_active & ART_INVISIBILITY);
			self.invisible_time = 0;
			msg_entity=self;
			if(self.classname!="bot")
			{	WriteByte(MSG_ONE, SVC_CLEAR_VIEW_FLAGS);
				WriteByte(MSG_ONE,DRF_TRANSLUCENT);
			}
			self.effects(-)EF_NODRAW|EF_LIGHT;
		}
		else if ((self.invisible_time - 10) < time)
			self.artifact_low = self.artifact_low | ART_INVISIBILITY;
	}

	if (self.sheep_time<time+3&&self.model=="models/sheep.mdl")//self.modelindex==modelindex_sheep)
	{
		// sound and screen flash when items starts to run out
		if (!self.sheep_sound_time)
		{
			sprint (self, "Polymorph Spell is wearing off...");
			stuffcmd (self, "bf\n");
			self.sheep_sound_time=TRUE;
		}
			
		if (self.sheep_time < time)
		{
			sound(self,CHAN_VOICE,"misc/sheepfly.wav",1,ATTN_NORM);
			particleexplosion((self.absmin+self.absmax)*0.5,random(144,159),self.absmax_z-self.absmin_z,50);
			GenerateTeleportEffect(self.origin,1);

			self.oldweapon = FALSE;
			self.weapon = IT_WEAPON1;
			restore_weapon();
			SetModelAndThinks();

			setsize (self, '-16 -16 0', '16 16 28');	
			self.hull=HULL_CROUCH;
			PlayerSpeed_Calc();

			if(self.classname!="bot")
			{	self.think=player_frames;
				thinktime self : 0;
			}
			else
			{	self.think=bot_frames;
				thinktime self : 0.1;
			}
		}
	}

	if(self.cameramode != world)
		if(deathmatch)
		{
			if(self.velocity!='0 0 0'||self.pain_finished>time||self.button0||self.button2)
				CameraReturn ();
		}
		else if (self.camera_time < time)
			CameraReturn ();
};

