float ClassArmorProtection[16] =
{
	// Paladin Armor Protection
	.05,	// AMULET
	.10,	// BRACERS
	.25,	// BREASTPLATE
	.15,	// HELMET

	// Crusader Armor Protection
	.15,	// AMULET
	.05,	// BRACER
	.10,	// BREASTPLATE
	.25,	// HELMET

	// Necromancer Armor Protection
	.25,	// AMULET
	.15,	// BRACER
	.05,	// BREASTPLATE
	.10,	// HELMET

	// Assassin Armor Protection
	.10,	// AMULET
	.15,	// BRACER
	.25,	// BREASTPLATE
	.05		// HELMET

};

/*
===============================================================================

ARMOR

===============================================================================
*/

void armor_touch(void)
{
	if(((other.classname != "player")&&(other.classname != "bot")) || (other.health <= 0)||other.model=="models/sheep.mdl")
	{
		return;
	}

	if(self.classname == "item_armor_amulet")
	{
		other.armor_amulet = 20;
	}
	else if(self.classname == "item_armor_bracer")
	{
		other.armor_bracer = 20;
	}
	else if(self.classname == "item_armor_breastplate")
	{
		other.armor_breastplate = 20;
	}
	else if(self.classname == "item_armor_helmet")
	{
		other.armor_helmet = 20;
	}

	self.solid = SOLID_NOT;
	self.model = string_null;
	if(deathmatch & 1)
	{
		self.nextthink = time + RESPAWN_TIME;
	}
	self.think = SUB_regen;

	sprint(other, STR_YOUHAVETHE);
	sprint(other, self.netname);
	sprint(other, "\n");

	sound(other, CHAN_ITEM, "items/armrpkup.wav", 1, ATTN_NORM);
	stuffcmd(other, "bf\n");

	activator = other;
	SUB_UseTargets();
}


void spawn_item_armor_helmet(void)
{
	setmodel (self, "models/i_helmet.mdl");
	setsize (self, '0 0 0', '0 0 0');
	self.hull=HULL_POINT;
	self.touch = armor_touch;
	self.netname = STR_ARMORHELMET;

	StartItem ();
}

/*QUAKED item_armor_helmet (0 .5 .8) (-8 -8 -45) (8 8 20) FLOATING
-------------------------FIELDS-------------------------

--------------------------------------------------------
*/
void item_armor_helmet (void)
{
	spawn_item_armor_helmet();
}

void spawn_item_armor_breastplate (void)
{
	setmodel (self, "models/i_bplate.mdl");
	setsize (self, '0 0 0', '0 0 0');
	self.hull=HULL_POINT;
	self.touch = armor_touch;
	self.netname = STR_ARMORBREASTPLATE;

	StartItem ();
}

/*QUAKED item_armor_breastplate (0 .5 .8) (-8 -8 -45) (8 8 20) FLOATING
-------------------------FIELDS-------------------------

--------------------------------------------------------
*/
void item_armor_breastplate (void)
{
	spawn_item_armor_breastplate();
}

void spawn_item_armor_bracer(void)
{
	setmodel (self, "models/i_bracer.mdl");
	setsize (self, '0 0 0', '0 0 0');
	self.hull=HULL_POINT;
	self.touch = armor_touch;
	self.netname = STR_ARMORBRACER;

	StartItem ();
}

/*QUAKED item_armor_bracer (0 .5 .8) (-8 -8 -45) (8 8 20) FLOATING
-------------------------FIELDS-------------------------

--------------------------------------------------------
*/
void item_armor_bracer (void)
{
	spawn_item_armor_bracer();
}

void spawn_item_armor_amulet(void)
{
	setmodel (self, "models/i_amulet.mdl");
	setsize (self, '0 0 0', '0 0 0');
	self.hull=HULL_POINT;
	self.touch = armor_touch;
	self.netname = STR_ARMORAMULET;

	StartItem ();
}

/*QUAKED item_armor_amulet (0 .5 .8) (-8 -8 -45) (8 8 20) FLOATING
-------------------------FIELDS-------------------------

--------------------------------------------------------
*/
void item_armor_amulet (void)
{
	spawn_item_armor_amulet();
}

float armor_inv(entity victim)
{
	float armor_cnt;

	armor_cnt =0;

	if (victim.armor_amulet)
		armor_cnt += 1;

	if (victim.armor_bracer)
		armor_cnt += 1;

	if (victim.armor_breastplate)
		armor_cnt += 1;

	if (victim.armor_helmet)
		armor_cnt += 1;

	return(armor_cnt);
}

float armor_calc(entity targ,float damage)
{
	float total_armor_protection;
	float armor_cnt;
	float armor_damage;
	float perpiece;
	float curr_damage,armor_damage;

	total_armor_protection = 0;

	if (targ.armor_amulet)
		total_armor_protection += ClassArmorProtection[targ.playerclass - 1]; 

	if (targ.armor_bracer)
		total_armor_protection += ClassArmorProtection[targ.playerclass - 1 + 1];

	if (targ.armor_breastplate)
		total_armor_protection += ClassArmorProtection[targ.playerclass - 1 + 2];

	if (targ.armor_helmet)
		total_armor_protection += ClassArmorProtection[targ.playerclass - 1 + 3];

	total_armor_protection += targ.level * .001;

	armor_cnt = armor_inv(targ);

	if (armor_cnt) // There is armor
	{
		armor_damage = total_armor_protection * damage;

		// Damage is greater than all the armor
		if (armor_damage > (targ.armor_amulet + targ.armor_bracer + 
				targ.armor_breastplate + targ.armor_helmet))
		{
			targ.armor_amulet		= 0;
			targ.armor_bracer		= 0;
			targ.armor_breastplate	= 0;
			targ.armor_helmet		= 0;
		}	
		else			// Damage the armor
		{
			curr_damage = armor_damage;
			// FIXME: Commented out the loop for E3 because of a runaway loop message
		//	while (curr_damage>0)
		//	{
				armor_cnt = armor_inv(targ);

				perpiece = curr_damage / armor_cnt;

				if ((targ.armor_amulet) && (curr_damage))
				{
					targ.armor_amulet -= perpiece;	
					curr_damage -= perpiece;
					if (targ.armor_amulet < 0)
					{
						curr_damage -= targ.armor_amulet;
						targ.armor_amulet = 0;
					}	

					if (targ.armor_amulet < 1)
						targ.armor_amulet = 0;
				}				

				if ((targ.armor_bracer) && (curr_damage))
				{
					targ.armor_bracer -= perpiece;	
					curr_damage -= perpiece;
					if (targ.armor_bracer < 0)
					{
						curr_damage -= targ.armor_bracer;
						targ.armor_bracer = 0;
					}	
					
					if (targ.armor_bracer < 1)
						targ.armor_bracer = 0;
				}				

				if ((targ.armor_breastplate) && (curr_damage))
				{
					targ.armor_breastplate -= perpiece;	
					curr_damage -= perpiece;
					if (targ.armor_breastplate < 0)
					{
						curr_damage -= targ.armor_breastplate;
						targ.armor_breastplate = 0;
					}	
					
					if (targ.armor_breastplate < 1)
						targ.armor_breastplate = 0;
				}				

				if ((targ.armor_helmet) && (curr_damage))
				{
					targ.armor_helmet -= perpiece;	
					curr_damage -= perpiece;
					if (targ.armor_helmet < 0)
					{
						curr_damage -= targ.armor_helmet;
						targ.armor_helmet = 0;
					}	

					if (targ.armor_helmet < 1)
						targ.armor_helmet = 0;
				}	

		//	}
		}
	}
	else
		armor_damage =0;

	return(armor_damage);
}


