void CheckWaterJump()
{
vector start, end;

// check for a climb out of water
	makevectors (self.angles);
	start = self.origin + self.proj_ofs - '0 0 8';
	v_forward_z = 0;
	normalize(v_forward);
	end = start + v_forward*24;
	traceline (start, end, TRUE, self);
	if (trace_fraction < 1)
	{	// solid at waist
		if(self.model=="models/sheep.mdl")
			start_z = self.origin_z + self.proj_ofs_z + 26;//was absmax - 8
		else
			start_z = self.origin_z + self.proj_ofs_z + 6;//was absmax - 8
		end = start + v_forward*24;
		self.movedir = trace_plane_normal * -50;
		traceline (start, end, TRUE, self);
		if (trace_fraction == 1)
		{	// open at eye level
			self.flags(+)FL_WATERJUMP;
			self.velocity_z = 225;
			if(self.classname=="bot") 
			{	self.flags(+)FL_ONGROUND; // cheat!
				add_velocity(v_forward);  // takes it off again
			}
			self.flags(-)FL_JUMPRELEASED;
			self.teleport_time = time + 2;	// safety net
			return;
		}
	}
}

/*
===========
WaterMove

============
*/

void() WaterMove =
{

//dprint (ftos(self.waterlevel));
	if (self.movetype == MOVETYPE_NOCLIP)
		return;
	if (self.health <= 0)
		return;

	if ((self.flags & FL_INWATER) && (self.watertype == CONTENT_WATER) && (self.waterlevel == 3) && (!self.lefty))
	{
		DeathBubbles(10);
		self.lefty = 1;
	}

	if (self.waterlevel != 3) // Not up to the eyes
	{
		if (self.air_finished < time)
		{
			if (self.model=="models/sheep.mdl")
				sheep_sound(1);
			else if(self.playerclass==CLASS_ASSASSIN)
				sound (self, CHAN_VOICE, "player/assgasp1.wav", 1, ATTN_NORM);
			else
				sound (self, CHAN_VOICE, "player/palgasp1.wav", 1, ATTN_NORM);
		}
		else if (self.air_finished < time + 9)
		{
			if (self.model=="models/sheep.mdl")
				sheep_sound(1);
			else if(self.playerclass==CLASS_ASSASSIN)
				sound (self, CHAN_VOICE, "player/assgasp2.wav", 1, ATTN_NORM);
			else
				sound (self, CHAN_VOICE, "player/palgasp2.wav", 1, ATTN_NORM);
		}
		self.air_finished = time + 12;
		self.dmg = 2;
	}
	// Completely submerged and no air
	else if ((self.air_finished < time) && (!self.rings & RING_WATER))
	{
		if(self.playerclass==CLASS_PALADIN&&self.flags&FL_SPECIAL_ABILITY1)
		{
			self.air_finished = time + 12;
			self.dmg = 2;
		}
		else if (self.pain_finished < time)
		{// Drown
			self.dmg = self.dmg + 2;
			if (self.dmg > 15)
				self.dmg = 10;
			T_Damage (self, world, world, self.dmg,"Drowning");
			self.pain_finished = time + 1;
		}
	}
	
	if (!self.waterlevel)
	{  // Getting out of the water
		if (self.flags & FL_INWATER)	
		{	// play leave water sound
			sound (self, CHAN_BODY, "raven/outwater.wav", 1, ATTN_NORM);
			self.flags(-)FL_INWATER;
			self.lefty = 0;
		}
		return;
	}

	if (self.watertype == CONTENT_LAVA)
	{	// do damage
		if (self.dmgtime < time)
		{
			self.dmgtime = time + 0.5;

			if(other.flags&FL_FIREHEAL)
				other.health=other.health+5*self.waterlevel;
			else if(!other.flags&FL_FIRERESIST)
				T_Damage (self, world, world, 5*self.waterlevel,"Lava");
		}
	}
	else if (self.watertype == CONTENT_SLIME)
	{	// do damage
		if (self.dmgtime < time)
		{
			self.dmgtime = time + 1;
			T_Damage (self, world, world, 4*self.waterlevel,"Slime");
		}
	}

	// Just entering fluid
	if (!(self.flags & FL_INWATER))
	{
		self.splash_time = time + .05;

		// player enter water sound
		if (self.watertype == CONTENT_LAVA)
			sound (self, CHAN_BODY, "raven/inlava.wav", 1, ATTN_NORM);
		else if (self.watertype == CONTENT_WATER)
		{
			sound (self, CHAN_BODY, "raven/inh2o.wav", 1, ATTN_NORM);
		}
		else if (self.watertype == CONTENT_SLIME)
			sound (self, CHAN_BODY, "player/slimbrn1.wav", 1, ATTN_NORM);

		self.flags(+)FL_INWATER;
		self.dmgtime = 0;

	}
	
	if (! (self.flags & FL_WATERJUMP) )
		self.velocity = self.velocity - 0.8*self.waterlevel*frametime*self.velocity;
};

// bots waterlevel function, called by prethink
void () WaterLevel =
{
  	local   float   pc;

  	makevectors (self.angles);
	
  	v_forward_z = 0;
  	pc = pointcontents (self.origin + v_forward * 16);
  	if ((pc == CONTENT_WATER) || (pc == CONTENT_SLIME) || (pc == CONTENT_LAVA))
    		self.watertype = pc;
  	else self.watertype = 0;

  	if (self.last_waterlevel < 3)
    		self.air_finished = time + 12;

  	pc = pointcontents (self.origin + v_forward * 16 + v_up * 51);
  	// all the way under
  	if ((pc == CONTENT_WATER) || (pc == CONTENT_SLIME) || (pc == CONTENT_LAVA))
  	{	self.watertype=pc; // funny mid-air pool in start map.
    		self.waterlevel = 3;
    		if (self.last_waterlevel < 2)
      			self.velocity = self.velocity * 0.5;
    		if (self.deadflag == DEAD_NO)
      			self.movetype = MOVETYPE_FLY;
    		return;
  	}

  	pc = pointcontents (self.origin + v_forward * 16 + v_up * 36);
  	// head out
  	if ((pc == CONTENT_WATER) || (pc == CONTENT_SLIME) || (pc == CONTENT_LAVA))
  	{
    		self.waterlevel = 2;
    		if (self.last_waterlevel < 2)
      			self.velocity = self.velocity * 0.5;
    		if (self.deadflag == DEAD_NO)
      			self.movetype = MOVETYPE_FLY;
    		return;
  	}

  	// lower body and/or feet
  	if ((self.watertype == CONTENT_WATER) || (self.watertype == CONTENT_SLIME) ||
      	(self.watertype == CONTENT_LAVA))
  	{
    		self.waterlevel = 1;
    		if (self.last_waterlevel > 1)
      			self.movetype = MOVETYPE_STEP;
    		return;
  	}

	self.movetype = MOVETYPE_STEP;
  	self.waterlevel = 0;
  	self.watertype = 0;
};

