void PlayerUnCrouching ()
{
	tracearea (self.origin,self.origin+'0 0 28','-16 -16 0','16 16 28',FALSE,self);
	if (trace_fraction < 1)
	{
		centerprint(self,STR_NOROOM);
		self.crouch_stuck = 1;
		return;
	}

	setsize (self, '-16 -16 0', '16 16 56');	
	self.hull=HULL_PLAYER;
	if (self.viewentity.classname=="chasecam")
		self.view_ofs = '0 0 0';

	PlayerSpeed_Calc();
	self.crouch_time = time;

	if (self.velocity_x || self.velocity_y)
		self.act_state=ACT_RUN;
	else
		self.act_state=ACT_STAND;
}

void PlayerCrouching ()
{
	if (self.health <= 0)
		return;

	setsize (self,'-16 -16 0','16 16 28');
	self.hull=HULL_CROUCH;
	if (self.viewentity.classname=="chasecam")
		self.view_ofs = '0 0 0';
	self.absorb_time=time + 0.3;

	PlayerSpeed_Calc();
	self.crouch_time = time;

	self.crouch_stuck = 0;

	self.act_state=ACT_CROUCH_MOVE;
}

void PlayerCrouch () 
{
	if (self.hull==HULL_PLAYER)
		PlayerCrouching();
	else if (self.hull==HULL_CROUCH)
		PlayerUnCrouching();	
}

void() PlayerJump =
{
	if(self.flags&FL_ONGROUND)
	{
		traceline(self.origin,self.origin-'0 0 3',FALSE,self);
		if(trace_ent.classname=="catapult"&&trace_ent.frame==20)
		{
			trace_ent.think=catapult_fire;
			thinktime trace_ent : 0;
		}
	}

	if (self.flags & FL_WATERJUMP)
		return;

	if (self.movetype==MOVETYPE_FLY)
		return;

	if (self.waterlevel >= 2)
	{
		if (self.watertype == CONTENT_WATER)
			self.velocity_z = 100*self.scale;
		else if (self.watertype == CONTENT_SLIME)
			self.velocity_z = 80*self.scale;
		else
			self.velocity_z = 50*self.scale;

// play swiming sound
		if (self.swim_flag < time)
		{
			self.swim_flag = time + 1;
			if (random() < 0.5)
				sound (self, CHAN_BODY, "player/swim1.wav", 1, ATTN_NORM);
			else
				sound (self, CHAN_BODY, "player/swim2.wav", 1, ATTN_NORM);
		}

		return;
	}

	if (!(self.flags & FL_ONGROUND))
	{
		return;
	}
	
	if ( !(self.flags & FL_JUMPRELEASED) )
		return;		// don't pogo stick

	self.act_state=ACT_JUMP;

	self.flags(-)FL_JUMPRELEASED;

	self.flags(-)FL_ONGROUND;	// don't stairwalk
	
	self.button2 = 0;
// player jumping sound

	if(self.model=="models/sheep.mdl")//self.modelindex==modelindex_sheep)
		sheep_sound(1);
	else if(self.playerclass==CLASS_ASSASSIN)
		sound (self, CHAN_BODY,"player/assjmp.wav", 1, ATTN_NORM);
	else
		sound (self, CHAN_BODY,"player/paljmp.wav", 1, ATTN_NORM);

	self.velocity_z = self.velocity_z + 270*self.scale;
};

void CheckCrouch (void)
{
	if ((self.crouch_time) && (self.crouch_time < time))  // Time to crouch or uncrouch a little
	{
		if (self.hull==HULL_CROUCH) // Player crouching
		{
			self.crouch_stuck = 0;
			self.view_ofs_z -= 10;
			self.proj_ofs_z -= 10;
			if (self.view_ofs_z < 24)
			{
				self.view_ofs_z = 24;
				self.proj_ofs_z = 18;
				self.crouch_time = 0;
			}	 
			else
				self.crouch_time = time + HX_FRAME_TIME/4;
		}
		else
		{
			self.view_ofs_z += 10;
			self.proj_ofs_z += 10;
			if (self.view_ofs_z > 50)
			{
				self.view_ofs_z = 50;
				self.proj_ofs_z = 44;
				self.crouch_time = 0;
			}	 
			else
				self.crouch_time = time + HX_FRAME_TIME/4;
		}
	}

	if ((self.flags2 & FL2_CROUCHED||self.model=="models/sheep.mdl"||self.flags2&FL2_CROUCH_TOGGLE) && (self.hull!=HULL_CROUCH)) 
		PlayerCrouching ();
	else if (((!self.flags2 & FL2_CROUCHED&&self.model!="models/sheep.mdl"&&!self.flags2&FL2_CROUCH_TOGGLE) && (self.hull==HULL_CROUCH)) ||
			(self.crouch_stuck))  // If stuck, constantly try to unstick
		PlayerUnCrouching();

}
