/*
 * crandom() -- Returns a random number between -1 and 1.
 */

float crandom()
{
	return random(-1,1);
}

float fexp(float base,float exponent)
{
	float exp_count,r;

	exponent=rint(exponent);
	if(exponent==0)
		return 1;
	if(exponent<0)
	{
		base=1/base;
		exponent=fabs(exponent);
	}

	if(exponent==1)
		return base;
	exp_count=0;
	r=1;
	while(exp_count<exponent)
	{
		exp_count+=1;
		r=r*base;
	}
	return r;
}

float byte_me(float mult)
{
	float mult_count,base;

	mult=rint(mult);
	if(mult==0)
		return 0;
	if(mult==1)
		return 1;
	if(mult==-1)
		return -1;

	if(mult<0)
	{
		base= -1;
		mult=fabs(mult);
	}
	else
		base=1;
	mult_count=0;
	mult-=1;	
	while(mult_count<mult)
	{
		mult_count+=1;
		base=base*2;
	}
	return base;
}

vector RandomVector (vector vrange)
{
	vector newvec;
	newvec_x=random(vrange_x,0-vrange_x);
	newvec_y=random(vrange_y,0-vrange_y);
	newvec_z=random(vrange_z,0-vrange_z);
	return newvec;
}

vector VelocityForDamage (float dm)
{
	local vector v;

	v = randomv('-100 -100 200', '100 100 300');

	if (dm > -50)
		v = v * 0.7;
	else if (dm > -200)
		v = v * 2;
	else
		v = v * 10;

	return v;
}

float(float v) anglemod =
{
	while (v >= 360)
		v = v - 360;
	while (v < 0)
		v = v + 360;
	return v;
};

float (entity item) CheckPitch=
{
  	local   vector  vec,vitem,vself;
  	local   float   dist;

  	if ((item==self)||(noorigin(item.classname)))
    		return TRUE;

  	// if the angle to the item is >45 degrees and < 315 degrees, exclude it
  	// because it is probably unreachable from current position

	vitem=item.origin;
	vitem_z=vitem_z+item.mins_z;
	vself=self.origin;
	vself_z=vself_z+self.mins_z;

  	vec = vectoangles (vitem - vself);
  	dist = vlen (item.origin - self.origin);
  	if ((vec_x < 285) && (vec_x > 75) && (dist>100))
		return FALSE;
  	if ((vec_x < 300) && (vec_x > 60) && (dist>150))
		return FALSE;
  	if ((vec_x < 315) && (vec_x > 45) && (dist>200))
		return FALSE;
	if ((vec_x < 340) && (vec_x > 20) && (dist > 400))
		return FALSE;

  	return TRUE;
};

vector(entity item) entityorigin=
{  	local vector d;
	if ((item==self)||(noorigin(item.classname)))
	{	d=0.5*(item.absmin+item.absmax);
		return d;
	}
	return item.origin;
};

float(string cname) noorigin=
{	if((cname=="trigger_teleport")||(cname=="func_button")
     		||(cname=="plat")||(cname=="door")||(cname=="trigger_once")
     		||(cname=="trigger_secret")||(cname=="worldspawn")||(cname=="func_wall")
     		||(cname=="trigger_multiple"))
		return TRUE;
	return FALSE;
};

float (entity targ) wall_visible =
{
	local vector	spot1, spot2;

	// calculate origin
	spot1 = self.origin + self.view_ofs;
	spot2 = entityorigin(targ);

	traceline (spot1, spot2, TRUE, self);	// see through other monsters

	if (trace_inopen && trace_inwater)
		return FALSE;			// sight line crossed contents

	if ((trace_fraction == 1) || (trace_ent == targ))
		return TRUE;

	return FALSE;

};


