void() testing_think;

void() initiate_testing =
{
	local entity mach;
	bprint("Testing impulse is disabled:Release version\n");
	return;
	mach=find(world,classname,"testing");
	if(mach!=world) return;
	mach = spawn();
	mach.owner = self;
	mach.waytime=time;
	mach.classname="testing";
	mach.think = testing_think;
	mach.nextthink = time + 0.1;
};

void() testing_think =
{	float mtime;
	local entity b;
	self.nextthink = time + 0.1;
	mtime=time - self.waytime;

	if (mtime < 5)
	{	centerprint(self.owner, "Test Sequence Initiated\n");
	}
	else if (mtime < 15)
	{	centerprint(self.owner, "bot test1\n");
		b=find(world,classname,"bot");
		while(b!=world)
		{	b.light_level=128;
			b=find(b,classname,"bot");
		}
	}
	else if (mtime < 25)
	{	centerprint(self.owner, "bot test2\n");
		b=find(world,classname,"bot");
		while(b!=world)
		{	b.abslight=2;
			b=find(b,classname,"bot");
		}
	}
	else if (mtime < 35)
	{	centerprint(self.owner, "bot test3\n");
		b=find(world,classname,"bot");
		while(b!=world)
		{	b.drawflags=MLS_ABSLIGHT;
			b=find(b,classname,"bot");
		}
	}
	else if (mtime < 45)
	{	centerprint(self.owner, "bot test4\n");
		b=find(world,classname,"bot");
		while(b!=world)
		{	b.abslight=128;
			b=find(b,classname,"bot");
		}
	}
	else if (mtime < 55)
	{	centerprint(self.owner, "bot test5\n");
		b=find(world,classname,"bot");
		while(b!=world)
		{	b.colormap=1;
			b=find(b,classname,"bot");
		}
	}
	else if (mtime < 65)
	{	centerprint(self.owner, "bot test6\n");
		b=find(world,classname,"bot");
		while(b!=world)
		{	b.colormap=0;
			b=find(b,classname,"bot");
		}
	}
	else remove(self);
};

void () CheckBotImpulses =
{	local float r;
	local vector vp;
	if ((self.impulse == BOT_CREATE)||(self.impulse == BOT_ADDONE))
        {
                if (deathmatch)
                {	// added multi characters - cronos
			if(self.impulse==BOT_CREATE)
			{	BotAdd();
				BotAdd();
				BotAdd();
			}
			BotAdd();
                }
                else 
                {	indbots=65536;
			bot_readd();
		}
        }
	else if (self.impulse == BOT_CAM)
		make_bot_cam();

	else if (self.impulse == BOT_LIST)
		botlist();

	else if (self.impulse == BOT_REMOVE)
		botremove();

	else if ((self.impulse >= BOT_ADD1)&&(self.impulse<=BOT_ADD1 + 16))
	{	r=self.impulse - BOT_ADD1 + 1;
		bottrytoadd(r);
	}

	else if(self.impulse==WAYPOINT_LIST)
	{	waypointlist();
	}
	else if(self.impulse==WAYPOINT_SHOWPOINT)
	{	bprint("Current Coords:");
		vp=self.origin+self.view_ofs;
		bprint(vtos(vp));
		bprint("\n");
	}
	else if(self.impulse==BOT_TEST)
	{	initiate_testing();
	}
};

void see_coop_view ()
{
entity startent,found;
float gotone;
	if(!coop&&!teamplay)
	{
		centerprint(self,"Ally vision not available\n");
		return;
	}

	startent=self.viewentity;
	found=startent;
	while(!gotone)
	{
		found=find(found,classname,"player");
		if(found.flags2&FL_ALIVE)
			if((deathmatch&&found.team==self.team)||coop)
				gotone=TRUE;
		if(found==startent)
		{
			centerprint(self,"No allies available\n");
			return;
		}
	}

	sprint(self,found.netname);
	sprint(self," found!\n");
	self.viewentity=found;
	CameraViewPort(self,found);
	CameraViewAngles(self,found);
	if(self.viewentity==self)
	{
		self.oldweapon=self.weapon;//for deselection animation
		restore_weapon();
	}
	else
	{
		self.weaponmodel=self.viewentity.weaponmodel;
		self.weaponframe=self.viewentity.weaponframe;
	}
}


void PrintFrags()
{
entity lastent;
	lastent=nextent(world);
	while(lastent)
	{
		if((lastent.classname=="player")||(lastent.classname=="bot"))
		{
			bprint(lastent.netname);
			bprint(" (L-");
			bprint(ftos(lastent.level));
			if(lastent.playerclass==CLASS_ASSASSIN)
				bprint(" Assassin) ");
			else if(lastent.playerclass==CLASS_PALADIN)
				bprint(" Paladin) ");
			else if(lastent.playerclass==CLASS_CRUSADER)
				bprint(" Crusader) ");
			else
				bprint(" Necromancer) ");
			bprint(" FRAGS: ");
			bprint(ftos(lastent.frags));
			bprint(" (LF: ");
			bprint(ftos(lastent.level_frags));
			bprint(")\n");
		}
		lastent=nextent(lastent);
	}
}


void player_stopfly(void)
{	if(self.classname=="bot")
		self.movetype = MOVETYPE_STEP;
	else
		self.movetype = MOVETYPE_WALK;
	self.idealpitch = cvar("sv_walkpitch");
	self.idealroll = 0;
}

void player_fly(void)
{
	self.movetype = MOVETYPE_FLY;
	self.velocity_z = 100;   // A little push up
	self.hoverz = .4;  
}

void HeaveHo (void)
{
vector dir;
float inertia, lift;
	makevectors(self.v_angle);
	dir=normalize(v_forward);	

	traceline(self.origin+self.proj_ofs,self.origin+self.proj_ofs+dir*48,FALSE,self);
	if(trace_ent.movetype&&trace_ent.solid&&trace_ent!=world&&trace_ent.flags&FL_ONGROUND&&trace_ent.solid!=SOLID_BSP)
	{
		if(!trace_ent.mass)
			inertia = 1;
		else if(trace_ent.mass<=50)
			inertia=trace_ent.mass/10;
		else
			inertia=trace_ent.mass/100;
		lift=(self.strength/40+0.5)*300/inertia;
		if(lift>300)
			lift=300;
		trace_ent.velocity_z+=lift;

		if (trace_ent.flags&FL_ONGROUND)
			trace_ent.flags-=FL_ONGROUND;

		if(self.playerclass==CLASS_ASSASSIN)
			sound (self, CHAN_BODY,"player/assjmp.wav", 1, ATTN_NORM);
		else
			sound (self, CHAN_BODY,"player/paljmp.wav", 1, ATTN_NORM);
		self.attack_finished=time+1;
	}
}

void AddServerFlag(float addflag)
{
	addflag=byte_me(addflag+8);
	dprintf("Serverflags were: %s\n",serverflags);
	dprintf("Added flag %s\n",addflag);
	serverflags(+)addflag;
	dprintf("Serverflags are now: %s\n",serverflags);
}

/*
============
ImpulseCommands

============
*/
void() ImpulseCommands =
{
	entity search;

	CheckBotImpulses();

	if(self.flags2&FL_CHAINED&&self.impulse!=23)
		return;

	else if (self.impulse == IMPULSE_POLYMORPH)
		Polymorph(self);
	else if (self.impulse == IMPULSE_SUICIDE)
		ClientKill();
	else if (self.impulse == IMPULSE_USEITEM )  // To use inventory item
		UseInventoryItem ();
	else if(self.impulse== IMPULSE_COOPVIEW)
		see_coop_view();
	else if(self.impulse== IMPULSE_PANICBUTTON)
		PanicButton();
	else if (self.impulse == IMPULSE_MAKECAMERA)//Uncomment this for a good time!
		MakeCamera();
	else if(self.impulse== IMPULSE_DROPITEM)
		DropInventoryItem();
	else if (self.impulse >= IMPULSE_INVQUICKLOW && self.impulse <= IMPULSE_INVQUICKHIGH)
	{
		Inventory_Quick(self.impulse - 99);
	}
	else if (self.impulse == IMPULSE_SHOWKINGOFHILL)
	{
		sprint(self,"King of the Hill is ");
		search=FindExpLeader();
		sprint(self,search.netname);
		sprint(self," (EXP = ");
		sprint(self,ftos(search.experience));
		sprint(self,") \n");
	}
	else if (self.impulse == IMPULSE_PRINTFRAGS)
		PrintFrags();
	else if (self.impulse>=IMPULSE_PALADIN&&self.impulse<=IMPULSE_ASSASSIN&&cvar("registered"))
	{
		if(self.level<3)
		{
			sprint(self,"You must have achieved level 3 or higher to change class!\n");
			self.impulse=0;
			return;
		}

		if(self.impulse==IMPULSE_PALADIN)//Quick Class-change hot-keys
			if(self.playerclass==CLASS_PALADIN)
			{
				self.impulse=0;
				return;
			}
			else
				self.newclass=CLASS_PALADIN;
		else if(self.impulse==IMPULSE_CRUSADER)
			if(self.playerclass==CLASS_CRUSADER)
			{
				self.impulse=0;
				return;
			}
			else
				self.newclass=CLASS_CRUSADER;
		else if(self.impulse==IMPULSE_NECROMANCER)
			if(self.playerclass==CLASS_NECROMANCER)
			{
				self.impulse=0;
				return;
			}
			else
				self.newclass=CLASS_NECROMANCER;
		else if(self.impulse==IMPULSE_ASSASSIN)
			if(self.playerclass==CLASS_ASSASSIN)
			{
				self.impulse=0;
				return;
			}
			else
				self.newclass=CLASS_ASSASSIN;
		self.effects=self.drawflags=FALSE;
		self.playerclass=self.newclass;//So it drops exp the right amount
		drop_level(self,2);

		newmis=spawn();
		newmis.classname="classchangespot";
		newmis.angles=self.angles;
		setorigin(newmis,self.origin);

		if(!deathmatch&&!coop)
			parm7=self.newclass;//Just to tell respawn() not to use restart
		else
		{
			self.model=self.init_model;
			GibPlayer();
			self.frags -= 2;	// extra penalty
		}
		respawn ();
	}

	if(self.model=="models/sheep.mdl")
	{
		self.impulse=0;
		return;
	}
	else if (self.impulse >= 1 && self.impulse <= 4)
		W_ChangeWeapon ();
	else if ((self.impulse == IMPULSE_CYCLEWEAP) && (wp_deselect == 0))
		CycleWeaponCommand ();
	else if (self.impulse == IMPULSE_CYCLEWEAPR)
		CycleWeaponReverseCommand ();
	else if(self.impulse == IMPULSE_HEAVEHO)
		HeaveHo();
	else if (self.impulse == IMPULSE_CROUCH &&!self.flags2 & FL2_CROUCHED)  // To crouch
	{
		if(self.flags2 & FL2_CROUCH_TOGGLE)
			self.flags2(-)FL2_CROUCH_TOGGLE;
		else
			self.flags2(+)FL2_CROUCH_TOGGLE;
	}
	self.impulse = 0;
};

