// botcam routines for watching bots
// disabled in competitions (through impulses)

// player think is now the botcam
void() bot_cam_think =
{	local string cv;
	local float ds,inf,pitch;
	local vector posn,eo,oldpos;

	if(!self.camview) 
	{	make_bot_cam();
		return;
	}
	self.weaponmodel = "";
	self.weaponframe=0;

	makevectors(self.angles);

	// sets the position for the botcam to view from
	posn=self.camview.origin - v_forward*CAM_BACK + v_up*CAM_UP;
	traceline(self.camview.origin,posn,TRUE,self);
	trace_fraction=trace_fraction*0.9;
	posn=self.camview.origin-v_forward*CAM_BACK*trace_fraction+v_up*CAM_UP*trace_fraction;

	// now see how far the cam would have moved (moving has been disabled as it wasnt very good)
	oldpos=self.origin;
	ds=vlen(oldpos - posn);
	traceline(oldpos,self.camview.origin,TRUE,self);

	// see if we want to move the cam
	inf=infront(self.camview);
	pitch=CheckPitch(self.camview);
	if((ds>600)||(trace_fraction<1)||(!inf)||(!pitch))
	{	setorigin(self,posn);
		self.velocity=self.camview.velocity;
		self.avelocity=self.camview.avelocity;
		self.angles = self.camview.angles;
		self.v_angle=self.camview.angles+self.camview.view_ofs;
		self.fixangle = TRUE;
	}

	// now show goalentity details on the cam screen
	eo=entityorigin(self.camview.goalentity);
	ds=vlen(self.camview.origin-eo);
	cv=ftos(ds);
	if(self.camview.followpath)
	{	if(self.camview.way3==self.camview.stuff)
			centerprint5(self," @@@@@@@GoalEntity:","2 point path","@distance:",cv,"@");
		else if (self.camview.way2==self.camview.stuff)
			centerprint5(self," @@@@@@@GoalEntity:","1 point path","@distance:",cv,"@");
		else
			centerprint5(self," @@@@@@@GoalEntity:","path(unknown)","@distance:",cv,"@");
	}
	else if((self.camview.way1!=world)&&(self.camview.way2==world)&&(self.camview.goalentity==self.camview))
		centerprint5(self," @@@@@@@GoalEntity:","roaming(from a point)","@distance:",cv,"@");
	else if((self.camview.way1==world)&&(self.camview.way2!=world)&&(self.camview.goalentity==self.camview.way2))
		centerprint5(self," @@@@@@@GoalEntity:","roaming(to a point)","@distance:",cv,"@");
	else if((self.camview.way2!=world)&&(self.camview.goalentity==self.camview.way2))
		centerprint5(self," @@@@@@@GoalEntity:","roaming(between points)","@distance:",cv,"@");
	else if((self.camview.goalentity.classname=="player")||(self.camview.goalentity.classname=="bot"))
		centerprint5(self," @@@@@@@GoalEntity:",self.camview.goalentity.netname,"@distance:",cv,"@");
	else
		centerprint5(self," @@@@@@@GoalEntity:",self.camview.goalentity.classname,"@distance:",cv,"@");
	
	self.think = bot_cam_think;
	self.nextthink = time + 0.01;
};

void() make_bot_cam =
{	clbob=cvar("cl_bob");
	if(self.health<=0) return;

	if(self.goalentity.classname!="bot") self.goalentity=world;
	self.goalentity = find(self.goalentity, classname, "bot");

	if (self.goalentity.classname != "bot" )
	{	kill_cam_view();
		return;
	}
	cvar_set("cl_bob","0.0");
	self.camview=self.goalentity;
	self.movetype=MOVETYPE_NONE;
	self.solid=SOLID_NOT;
	self.think = bot_cam_think;
	self.nextthink = time + 0.01;

	bprint("Following ");
	bprint(self.goalentity.netname);
	bprint(".\n");
};

void() kill_cam_view=
{	string clbobb;
	if(!self.camview) return;
	self.camview=world;
	self.goalentity=world;

	self.fixangle=TRUE;
	makevectors(self.angles);
	setorigin(self,self.camorigin);
	self.solid = SOLID_SLIDEBOX;
	self.velocity='0 0 0';
	self.avelocity='0 0 0';

	spawn_tfog (self.origin + v_forward*20);
	spawn_tdeath (self.origin, self);

	W_SetCurrentAmmo ();
	self.movetype=MOVETYPE_WALK;
	self.think=player_frames;
	clbobb=ftos(clbob);
	if(clbob) cvar_set("cl_bob",clbobb);
	bprint("Back into your body.\n");
};

