void Polymorph (entity loser)
{
//MODEL
	sound(loser,CHAN_VOICE,"misc/sheepfly.wav",1,ATTN_NORM);
//FIXME: Need to make it so this reverses after 30 sec.
	loser.sheep_time=time+30;
	GenerateTeleportEffect(loser.origin,1);

	if((loser.classname=="player")||(loser.classname=="bot"))
	{
		if(loser.effects&EF_BRIGHTLIGHT&&loser.playerclass==CLASS_CRUSADER)
			loser.effects(-)EF_BRIGHTLIGHT;//Sunstaff

		if (loser.artifact_active & ART_TOMEOFPOWER)
			loser.tome_time=0;

		if(loser.hull!=HULL_CROUCH)
			if (loser.hasted)
				loser.hasted*= .6;
			else
				loser.hasted = .6;
		loser.mass=3;
		if(loser.health>25)
			loser.health=25;
		loser.th_missile=player_sheep_baa;
		loser.th_melee=player_sheep_baa;
		loser.th_stand=player_sheep_stand;
		loser.th_run=player_sheep_run;
		loser.th_walk=player_sheep_run;
		loser.th_pain=player_sheep_pain;
		loser.th_jump=player_sheep_jump;

		setmodel (loser, "models/sheep.mdl");
		setsize (loser,'-16 -16 0','16 16 28');
		loser.model="models/sheep.mdl";
		loser.th_weapon=player_sheep_snout_pain1;
		loser.hull=HULL_CROUCH;
		loser.view_ofs = '0 0 24';
		loser.proj_ofs='0 0 18';
		loser.attack_finished=0;
		loser.weapon=FALSE;
		loser.weaponmodel="models/snout.mdl";
		loser.weaponframe=0;
		loser.sheep_sound_time=FALSE;

		if(loser.classname=="bot")
		{	loser.think=player_sheep_run;
			thinktime loser : 0.1;
		}
		else
		{	loser.think=player_sheep_stand;
			thinktime loser : 0;
		}
	}
	else
	{
//Stop all auto-looping sounds on removed monster
		sound(loser,CHAN_BODY,"misc/null.wav",1,ATTN_NONE);
		sound(loser,CHAN_WEAPON,"misc/null.wav",1,ATTN_NONE);
		sound(loser,CHAN_ITEM,"misc/null.wav",1,ATTN_NONE);
		newmis=spawn();
		setorigin(newmis,loser.origin);

//For restoring monster:
		newmis.th_spawn=loser.th_spawn;
		newmis.skin=0;
		newmis.oldskin=loser.skin;
		newmis.max_health=loser.health;
		if(!loser.enemy)
			newmis.enemy=self.owner;
		else
			newmis.enemy=loser.enemy;
		newmis.goalentity=newmis.enemy;
		newmis.angles=loser.angles;
		newmis.target=loser.target;//So it will still activate targets
		newmis.killtarget=loser.killtarget;
		remove(loser);
		newmis.flags2(+)FL_SUMMONED;
		newmis.spawnflags(+)NO_DROP;
		newmis.think=player_sheep;
		thinktime newmis : 0;
	}
}

void poly_touch ()
{
	if(other.monsterclass >= CLASS_BOSS&&other!=self.owner)
	{
		self.velocity=normalize((self.owner.absmin+self.owner.absmax)*0.5-self.origin)*700;
		self.owner=other;
	}
	else if(other.flags2&FL_ALIVE&&other.model!="models/sheep.mdl"&&other.classname!="monster_golem_crystal")
	{
		self.touch=SUB_Null;
		Polymorph(other);
		remove(self);
	}
	else if(other.movetype!=MOVETYPE_FLYMISSILE&&other.movetype!=MOVETYPE_BOUNCE&&other.movetype!=MOVETYPE_BOUNCEMISSILE)
	{
		self.touch=SUB_Null;
		particleexplosion(self.origin,random(144,159),self.absmax_z-self.absmin_z,10);
		remove(self);
	}
}

void polymorph_anim () [++ 0 .. 3]
{
	particle4(self.origin,7,random(144,159),PARTICLETYPE_EXPLODE2,random(1,5));
}

void FirePoly (float ofs)
{
	makevectors(self.v_angle);
	newmis=spawn();
	newmis.movetype=MOVETYPE_FLYMISSILE;
	newmis.solid=SOLID_BBOX;
	newmis.owner=self;
	newmis.touch=poly_touch;
	newmis.speed=700;
	newmis.velocity=v_forward*newmis.speed+v_right*ofs;
	
	newmis.drawflags=MLS_POWERMODE;

	newmis.think=polymorph_anim;
	thinktime newmis : 0;
	setmodel(newmis,"models/polymrph.spr");
	setsize(newmis,'0 0 0','0 0 0');
	setorigin(newmis,self.origin+self.proj_ofs+v_forward*10);
}

void Use_Polymorph ()
{
	FirePoly(-150);
	FirePoly(-75);
	FirePoly(0);
	FirePoly(75);
	FirePoly(150);
	self.cnt_polymorph -= 1;
}
