float WHITE_PUFF	= 0;
float RED_PUFF		= 1;
float GREEN_PUFF	= 2;
float GREY_PUFF		= 3;


void CreateTeleporterBodyEffect (vector org,vector vel,float framelength)
{
	starteffect(CE_TELEPORTERBODY, org,vel,framelength);
}


void CreateTeleporterSmokeEffect (vector org,vector vel,float framelength)
{
	starteffect(CE_TELEPORTERPUFFS, org,vel,framelength);
}

// ============= SMOKE ================================

void CreateWhiteSmoke (vector org,vector vel,float framelength)
{
	starteffect(CE_WHITE_SMOKE, org,vel,framelength);
}

void CreateRedSmoke (vector org,vector vel,float framelength)
{
	starteffect(CE_RED_SMOKE, org,vel, framelength);
}

void CreateGreySmoke (vector org,vector vel,float framelength)
{
	starteffect(CE_GREY_SMOKE, org,vel, framelength);
}

void CreateGreenSmoke (vector org,vector vel,float framelength)
{
	starteffect(CE_GREEN_SMOKE, org,vel, framelength);
}

void CreateRedCloud (vector org,vector vel,float framelength)
{
	starteffect(CE_REDCLOUD, org,vel, framelength);
}

// ============= FLASHES ================================

void CreateLittleWhiteFlash (vector spot)
{
	starteffect(CE_SM_WHITE_FLASH,spot);
}

void CreateLittleBlueFlash (vector spot)
{
	starteffect(CE_SM_BLUE_FLASH,spot);
}

void CreateBlueFlash (vector spot) 
{
	starteffect(CE_BLUE_FLASH,spot);
}

void CreateWhiteFlash (vector spot) 
{
	starteffect(CE_WHITE_FLASH, spot);
}

void CreateYRFlash (vector spot)
{
	starteffect(CE_YELLOWRED_FLASH,spot);
}

// ============= EXPLOSIONS =============================

void CreateBlueExplosion (vector spot)
{
	starteffect(CE_BLUE_EXPLOSION,spot);
}

void CreateExplosion29 (vector spot)
{
	starteffect(CE_BG_CIRCLE_EXP,spot);
}

void CreateFireCircle (vector spot)
{
	starteffect(CE_SM_CIRCLE_EXP,spot);
}

// ============= SPARKS =============================

void CreateRedSpark (vector spot) 
{
	starteffect(CE_REDSPARK,spot);
}

void CreateGreenSpark (vector spot) 
{
	starteffect(CE_GREENSPARK,spot);
}

void CreateBSpark (vector spot) 
{
	starteffect(CE_BLUESPARK,spot);
}

void CreateSpark (vector spot)
{
	starteffect(CE_YELLOWSPARK,spot);
}

//FIXME:This should be a temp entity
void splash_run (void)
{
	float result;

	result = AdvanceFrame(0,5);

	self.nextthink = time + HX_FRAME_TIME;
	self.think = splash_run;

	if (result == AF_END)
	{
		self.nextthink = time + HX_FRAME_TIME;
		self.think = SUB_Remove;
	}
}

void CreateWaterSplash (vector spot)
{
	entity newent;

	newent = spawn();
  	setmodel (newent, "models/wsplash.spr");

	setorigin (newent, spot);
	newent.movetype = MOVETYPE_NOCLIP;
	newent.solid = SOLID_NOT;
	newent.velocity = '0 0 0';
	newent.nextthink = time + 0.05;
	newent.think = splash_run;

}


/*
================
SpawnPuff
================
*/
void  SpawnPuff (vector org, vector vel, float damage,entity victim)
{
	float part_color;
	float rad;

	if (victim.thingtype==THINGTYPE_FLESH && victim.classname!="mummy" && victim.netname != "spider")
		part_color = 256 + 8 * 16 + random(9);				//Blood red
	else if ((victim.thingtype==THINGTYPE_GREYSTONE) || (victim.thingtype==THINGTYPE_BROWNSTONE))
		part_color = 256 + 20 + random(8);			// Gray
	else if (victim.thingtype==THINGTYPE_METAL)	
		part_color = 256 + (8 * 15);			// Sparks
	else if (victim.thingtype==THINGTYPE_WOOD)	
		part_color = 256 + (5 * 16) + random(8);			// Wood chunks
	else if (victim.thingtype==THINGTYPE_ICE)	
		part_color = 406+random(8);				// Ice particles
	else if (victim.netname == "spider")	
		part_color = 256 + 183 + random(8);		// Spider's have green blood
	else
		part_color = 256 + (3 * 16) + 4;		// Dust Brown

	rad=vlen(vel);
	if(!rad)
		rad=random(10,20);
	particle4(org,rad,part_color,PARTICLETYPE_FASTGRAV,2 * damage);
}

/*-----------------------------------------
	redblast - the red flash sprite
  -----------------------------------------*/
void(vector spot) CreateRedFlash =
{
	starteffect(CE_RED_FLASH,spot);
};

void () flash_remove =
{
	remove(self);
};

void GenerateTeleportSound (entity center)
{
	string telesnd;
	float r;
	r=rint(random(4))+1;
	if(r==1)
		telesnd="misc/teleprt1.wav";
	else if(r==2)
		telesnd="misc/teleprt2.wav";
	else if(r==3)
		telesnd="misc/teleprt3.wav";
	else if(r==4)
		telesnd="misc/teleprt4.wav";
	else
		telesnd="misc/teleprt5.wav";
	sound(center,CHAN_AUTO,telesnd,1,ATTN_NORM);
}

void GenerateTeleportEffect(vector spot1,float teleskin)
{
	entity sound_ent;

	if (self.attack_finished > time)
		return;

	sound_ent = spawn();
	setorigin(sound_ent,spot1);
	GenerateTeleportSound(sound_ent);
	sound_ent.think = SUB_Remove;
	thinktime sound_ent : 2;

	CreateTeleporterBodyEffect (spot1,'0 0 0',teleskin);  // 3rd parameter is the skin

	CreateTeleporterSmokeEffect (spot1,'0 0 0',HX_FRAME_TIME);
	CreateTeleporterSmokeEffect (spot1 + '0 0 64','0 0 0',HX_FRAME_TIME);

}

void smoke_generator_use(void)
{
	self.use = smoke_generator_use;
	self.nextthink = time + HX_FRAME_TIME;
	if (!self.wait)
		self.wait = 2;	
	self.owner = other;

	if (self.lifespan)
		self.lifetime = time + self.lifespan;

}

void smoke_generator_run(void)
{
	if (self.thingtype == WHITE_PUFF)
		CreateWhiteSmoke(self.origin, '0 0 8', HX_FRAME_TIME *3);
	else if (self.thingtype == RED_PUFF)
		CreateRedSmoke(self.origin, '0 0 8', HX_FRAME_TIME *3);
	else if (self.thingtype == GREEN_PUFF)
		CreateRedSmoke(self.origin, '0 0 8', HX_FRAME_TIME *3);
	else if (self.thingtype == GREY_PUFF)
		CreateGreySmoke(self.origin, '0 0 8', HX_FRAME_TIME *3);

	self.nextthink = time + random(self.wait);
	self.think = smoke_generator_run;

	if ((self.lifespan) && (self.lifetime < time))
		remove(self);
}

/*QUAKED fx_smoke_generator (0 1 1) (-8 -8 -8) (8 8 8)
Generates smoke puffs
-------------------------FIELDS-------------------------
wait - how often it should generate smoke (default 2)
thingtype - type of smoke to generate
 0 - white puff       (fire place)
 1 - red              (lava)
 2 - green            (slime)
 3 - grey             (oil)

lifespan - fill this in and it will only puff for this long
--------------------------------------------------------
*/
void() fx_smoke_generator =
{

	setmodel(self, "models/null.spr");

	self.solid = SOLID_NOT;
	self.movetype = MOVETYPE_NONE;

	setsize (self,'0 0 0' , '0 0 0');

	self.th_die = SUB_Remove;

	if (!self.targetname)	//	Not targeted by anything so puff away
		self.nextthink = time + HX_FRAME_TIME;

	self.use = smoke_generator_use;

	if (!self.wait)
		self.wait = 2;


	self.think = smoke_generator_run;
};


void (vector org) fx_flash =
{
	local entity newent;

	newent = spawn();
  	setmodel (newent, "models/s_bubble.spr");

	setorigin (newent, org + '0 0 24');
	newent.movetype = MOVETYPE_NOCLIP;
	newent.solid = SOLID_NOT;
	newent.velocity = '0 0 0';
	newent.nextthink = time + 0.5;
	newent.think = flash_remove;
	newent.classname = "bubble";

   	newent.effects = EF_BRIGHTLIGHT;

	setsize (newent, '-8 -8 -8', '8 8 8');

};


void() explosion_done =
{
	self.effects=EF_DIMLIGHT;
};

void() explosion_use =
{
	sound (self, CHAN_BODY, self.noise1, 1, ATTN_NORM);

	particleexplosion(self.origin,self.color,self.exploderadius,self.counter);

};

/*
================
spawn_touchpuff
================
*/
void(float damage,entity victim) spawn_touchpuff =
{
	local vector	vel;

	vel = wall_velocity () * 0.2;
	SpawnPuff (self.origin + vel*0.01, vel, damage,victim);
};

