void DeathBubblesSpawn ()
{
	entity	bubble;
	vector   offset;
	
	offset_x = random(18,-18);
	offset_y = random(18,-18);

	if (pointcontents(self.owner.origin+self.owner.view_ofs)!=CONTENT_WATER) 
	{
		remove(self);
		return;
	}

	bubble = spawn_temp();
	setmodel (bubble, "models/s_bubble.spr");
	setorigin (bubble, self.owner.origin+self.owner.view_ofs+offset);
	bubble.movetype = MOVETYPE_NOCLIP;
	bubble.solid = SOLID_NOT;
	bubble.velocity = '0 0 17';
	thinktime bubble : 0.5;
	bubble.think = bubble_bob;
	bubble.classname = "bubble";
	bubble.frame = 0;
	bubble.cnt = 0;
	bubble.abslight=0.5;
	bubble.drawflags(+)DRF_TRANSLUCENT|MLS_ABSLIGHT;
	setsize (bubble, '-8 -8 -8', '8 8 8');
	thinktime self : 0.1;
	self.think = DeathBubblesSpawn;
	self.air_finished = self.air_finished + 1;
	if (self.air_finished >= self.bubble_count)
		remove(self);
}

void DeathBubbles (float num_bubbles)
{
	entity	bubble_spawner, bubble_owner;
	
	if(self.classname=="contents damager")
		bubble_owner = self.enemy;
	else
		bubble_owner = self;
	bubble_spawner = spawn();
	setorigin (bubble_spawner, bubble_owner.origin+bubble_owner.view_ofs);
	bubble_spawner.movetype = MOVETYPE_NONE;
	bubble_spawner.solid = SOLID_NOT;
	bubble_spawner.owner = bubble_owner;
	thinktime bubble_spawner : 0.1;
	bubble_spawner.think = DeathBubblesSpawn;
	bubble_spawner.air_finished = 0;
	bubble_spawner.bubble_count = num_bubbles;
	return;
}

void() bubble_split =
{
	local entity	bubble;
	bubble = spawn_temp();
	setmodel (bubble, "models/s_bubble.spr");
	setorigin (bubble, self.origin);
	bubble.movetype = MOVETYPE_NOCLIP;
	bubble.solid = SOLID_NOT;
	bubble.velocity = self.velocity;
	thinktime bubble : 0.5;
	bubble.think = bubble_bob;
	bubble.touch = bubble_remove;
	bubble.classname = "bubble";
	bubble.frame = 1;
	bubble.cnt = 10;
	setsize (bubble, '-8 -8 -8', '8 8 8');
	self.frame = 1;
	self.cnt = 10;
	if (self.waterlevel != 3)
		remove (self);
};

void() bubble_remove =
{
	if (other.classname == self.classname)
	{
		return;
	}
	remove(self);
};


void() bubble_bob =
{
local float		rnd1, rnd2, rnd3;

local float waterornot;
	waterornot=pointcontents(self.origin);
	if (waterornot!=CONTENT_WATER&&waterornot!=CONTENT_SLIME)
		remove(self);
	self.cnt = self.cnt + 1;
	if (self.cnt == 4)
		bubble_split();
	if (self.cnt == 20)
		remove(self);

	rnd1 = self.velocity_x + random(-10,10);
	rnd2 = self.velocity_y + random(-10,10);
	rnd3 = self.velocity_z + random(10,20);

	if (rnd1 > 10)
		rnd1 = 5;
	if (rnd1 < -10)
		rnd1 = -5;
		
	if (rnd2 > 10)
		rnd2 = 5;
	if (rnd2 < -10)
		rnd2 = -5;
		
	if (rnd3 < 10)
		rnd3 = 15;
	if (rnd3 > 30)
		rnd3 = 25;
	
	self.velocity_x = rnd1;
	self.velocity_y = rnd2;
	self.velocity_z = rnd3;
		
	thinktime self : 0.5;
	self.think = bubble_bob;
};
