/*
===============================================================================

PLAYER WEAPON USE

===============================================================================
*/
void W_SetCurrentAmmo (void)
{
	if(self.sheep_time>time)
		return;

	wp_deselect = 0;

	self.button0=FALSE;
	attck_cnt=0;

	if (self.oldweapon==self.weapon)		// Until we get multi skinned weapons
		return;

	if(self.attack_finished<time)
		self.attack_finished=time;

	if (self.weapon == IT_WEAPON1)
	{		
		self.weaponmodel="";
		self.weaponframe = 0;
		if (self.playerclass == CLASS_PALADIN)
			gauntlet_select();
		else if (self.playerclass == CLASS_NECROMANCER)
			sickle_select();
		else if (self.playerclass == CLASS_CRUSADER)
			warhammer_select();
		else if (self.playerclass == CLASS_ASSASSIN)
			punchdagger_select();
	}
	else if (self.weapon == IT_WEAPON2)
	{
		self.weaponmodel="";
		self.weaponframe = 0;
		if (self.playerclass == CLASS_PALADIN)
			vorpal_select();
		else if (self.playerclass == CLASS_ASSASSIN)
			crossbow_select();
		else if (self.playerclass == CLASS_CRUSADER)
			icestaff_select();
		else if (self.playerclass == CLASS_NECROMANCER)
			if(self.oldweapon!=IT_WEAPON3)
				magicmis_select();
			else
				magicmis_select_from_bone();
	}
	else if (self.weapon == IT_WEAPON3)
	{	
		self.weaponmodel="";
		self.weaponframe = 0;
		if (self.playerclass == CLASS_PALADIN)
			axe_select();
		else if (self.playerclass == CLASS_ASSASSIN)
			grenade_select();
		else if (self.playerclass == CLASS_CRUSADER)
			meteor_select();
		else if (self.playerclass == CLASS_NECROMANCER)
			if(self.oldweapon!=IT_WEAPON2)
				boneshard_select();
			else
				boneshard_select_from_mmis();
	}
	else if (self.weapon == IT_WEAPON4)
	{		
		self.weaponmodel="";
		self.weaponframe = 0;
		if (self.playerclass == CLASS_PALADIN)
			purifier_select();
		else if (self.playerclass == CLASS_CRUSADER)
			sunstaff_select();
		else if(self.playerclass==CLASS_ASSASSIN)
			setstaff_select();
		else if (self.playerclass == CLASS_NECROMANCER)
			ravenstaff_select();
	}

//All players will have to do this eventually, to reset
//the stand, pain, run & fly functions for the different weapons
	if(self.weapon!=self.oldweapon)
	{
		if(self.playerclass==CLASS_NECROMANCER)
			Nec_Change_Weapon();
		else if(self.playerclass==CLASS_PALADIN)
			Pal_Change_Weapon();
		else if(self.playerclass==CLASS_CRUSADER)
			Cru_Change_Weapon();
		else if(self.playerclass==CLASS_ASSASSIN)
			Ass_Change_Weapon();
		if(self.hull!=HULL_CROUCH)
			self.act_state=ACT_STAND;
	}

	if(self.flags2&FL_SUMMONED&&self.weapon!=IT_WEAPON3)
	{
		self.flags2(-)FL_SUMMONED;
		self.effects(-)EF_DARKLIGHT;
	}
//	if (self.deselect_time < time)
		self.oldweapon=self.weapon;	
}

float W_CheckNoAmmo (float check_weapon)
{
	if (check_weapon == IT_WEAPON1)
		return TRUE;
	
	if(self.playerclass==CLASS_ASSASSIN)
	{
		if (check_weapon==IT_WEAPON4)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.bluemana >= 30 && self.greenmana >= 30)
					return TRUE;
			}
			else if(self.bluemana >= 1 && self.greenmana >= 1)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON3)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.greenmana >= 12)
					return TRUE;
			}
			else if(self.greenmana >= 3)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON2)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.bluemana >= 10)
					return TRUE;
			}
			else if(self.bluemana >= 3)
					return TRUE;
		}
	}
	else if(self.playerclass==CLASS_CRUSADER)
	{
		if (check_weapon==IT_WEAPON4)
		{
			if(self.bluemana >= 2 && self.greenmana >= 2)
				return TRUE;
			self.effects(-)EF_BRIGHTLIGHT;
		}
		else if (check_weapon==IT_WEAPON3)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.greenmana >= 20)
					return TRUE;
			}
			else if(self.greenmana >= 8)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON2)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.bluemana >= 10)
					return TRUE;
			}
			else if(self.bluemana >= 1)
					return TRUE;
		}
	}
	else if(self.playerclass==CLASS_NECROMANCER)
	{
		if (check_weapon==IT_WEAPON4)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.bluemana >= 16 && self.greenmana >= 16)
					return TRUE;
			}
			else if(self.bluemana >= 8 && self.greenmana >= 8)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON3)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.greenmana >= 20)
					return TRUE;
			}
			else if(self.greenmana >= 1)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON2)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.bluemana >= 10)
					return TRUE;
			}
			else if(self.bluemana >= 2)
					return TRUE;
		}
	}
	else if(self.playerclass==CLASS_PALADIN)
	{
		if (check_weapon==IT_WEAPON4)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.bluemana >= 8 && self.greenmana >= 8)
					return TRUE;
			}
			else if(self.bluemana >= 2 && self.greenmana >= 2)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON3)
		{
			if(self.artifact_active&ART_TOMEOFPOWER)
			{
				if(self.greenmana >= 8)
					return TRUE;
			}
			else if(self.greenmana >= 2)
					return TRUE;
		}
		else if (check_weapon==IT_WEAPON2)
		{
			return TRUE;
		}
	}
	return FALSE;
}

//=========================
// W_BestWeapon : choose the most powerful weapon the player has ammo for
//=========================
void() W_BestWeapon =
{
	if (W_CheckNoAmmo (IT_WEAPON4) && (self.items & IT_WEAPON4))
		self.weapon = IT_WEAPON4;
	else if (W_CheckNoAmmo (IT_WEAPON3) && (self.items & IT_WEAPON3))
		self.weapon = IT_WEAPON3;
	else if (W_CheckNoAmmo (IT_WEAPON2) && (self.items & IT_WEAPON2))
		self.weapon = IT_WEAPON2;
	else self.weapon = IT_WEAPON1;

};

/*
============
W_Attack

An attack impulse can be triggered now
============
*/
void() W_Attack =
{
	if (!W_CheckNoAmmo (self.weapon))
	{
		W_BestWeapon ();
		W_SetCurrentWeapon ();
		return;
	}
	
	if(self.attack_finished>time)
		return;

	if(self.sheep_time>time)
	{
		player_sheep_baa();
		return;
	}

	if(self.viewentity!=self&&self.viewentity.classname!="chasecam")
		return;

	self.show_hostile = time + 1;	// wake monsters up
	self.last_attack=time;			//In attack state

	if(self.hull==HULL_PLAYER)
		self.act_state=ACT_ATTACK;
	else
		self.act_state=ACT_CROUCH_MOVE;

	if (self.weapon == IT_WEAPON1)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_gauntlet_fire();
		else if (self.playerclass==CLASS_NECROMANCER)
			self.th_missile();
		else if (self.playerclass==CLASS_ASSASSIN)
			Ass_Pdgr_Fire();
		else if (self.playerclass==CLASS_CRUSADER)
			Cru_Wham_Fire();
	}
	else if (self.weapon == IT_WEAPON2)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_vorpal_fire();
		else if(self.playerclass==CLASS_ASSASSIN)
			crossbow_fire();
		else if(self.playerclass==CLASS_CRUSADER)
		{
			if(self.th_weapon==icestaff_idle)
				Cru_Ice_Fire();
		}
		else if(self.playerclass==CLASS_NECROMANCER)
			self.th_missile();
	}
	else if (self.weapon == IT_WEAPON3)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_axe_fire();
		else if (self.playerclass==CLASS_ASSASSIN)
			grenade_throw();
		else if (self.playerclass==CLASS_CRUSADER)
			Cru_Met_Attack();
		else if(self.playerclass==CLASS_NECROMANCER)
			self.th_missile();
	}
	else if (self.weapon == IT_WEAPON4)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_purifier_fire();
		else if(self.playerclass==CLASS_ASSASSIN)
			ass_setstaff_fire();
		else if (self.playerclass==CLASS_CRUSADER)
			Cru_Sun_Fire();
		else if(self.playerclass==CLASS_NECROMANCER)
			ravenstaff_fire();
	}
};

void W_DeselectWeapon (void)
{
	wp_deselect = 1;

	if (self.oldweapon == IT_WEAPON1)
	{
		if (self.playerclass==CLASS_PALADIN)
			gauntlet_deselect();
		else if (self.playerclass==CLASS_CRUSADER)
			warhammer_deselect();
		else if (self.playerclass==CLASS_ASSASSIN)
			punchdagger_deselect();
		else if (self.playerclass==CLASS_NECROMANCER)
			sickle_deselect();
		else
			W_SetCurrentAmmo();
	}
	else if (self.oldweapon == IT_WEAPON2)
	{
		if (self.playerclass==CLASS_PALADIN)
			vorpal_deselect();
		else if (self.playerclass==CLASS_CRUSADER)
			icestaff_deselect();
		else if (self.playerclass==CLASS_ASSASSIN)
			crossbow_deselect();
		else if (self.playerclass==CLASS_NECROMANCER)
			if(self.weapon!=IT_WEAPON3)
				magicmis_deselect();
		else
			W_SetCurrentAmmo();
	}
	else if (self.oldweapon == IT_WEAPON3)
	{
		if (self.playerclass==CLASS_PALADIN)
			axe_deselect();
		else if (self.playerclass==CLASS_CRUSADER)
			meteor_deselect();
		else if (self.playerclass==CLASS_ASSASSIN)
			grenade_deselect();
		else if (self.playerclass==CLASS_NECROMANCER)
			if(self.weapon!=IT_WEAPON2)
				boneshard_deselect();
		else
			W_SetCurrentAmmo();
	}
	else if (self.oldweapon == IT_WEAPON4)
	{
		if (self.playerclass==CLASS_PALADIN)
			purifier_deselect();
		else if (self.playerclass==CLASS_CRUSADER)
			sunstaff_deselect();
		else if (self.playerclass==CLASS_ASSASSIN)
			setstaff_deselect();
		else if (self.playerclass==CLASS_NECROMANCER)
			ravenstaff_deselect();
		else
			W_SetCurrentAmmo();
	}
	else
		W_SetCurrentAmmo();
}

/*
============
W_ChangeWeapon

============
*/
void() W_ChangeWeapon =
{
	if(self.sheep_time>time)
		return;

	if(self.viewentity!=self&&self.viewentity.classname!="chasecam")
		return;

	if(self.attack_finished>time)
		return;

float	it, am, fl;
	

	it = self.items;
	am = 0;
	
	if (self.impulse == 1)
	{
		fl = IT_WEAPON1;
	}
	else if (self.impulse == 2)
	{
		fl = IT_WEAPON2;
	}
	else if (self.impulse == 3)
	{
		fl = IT_WEAPON3;
		if (self.bluemana < 2)
			am = 1;
	}		
	else if (self.impulse == 4)
	{
		fl = IT_WEAPON4;
		if ((self.bluemana < 1) && (self.greenmana <1))
			am = 1;
	}

	self.impulse = 0;

	if (!(self.items & fl))
	{
		sprint (self, STR_NOCARRYWEAPON);
		return;
	}

	if(!W_CheckNoAmmo(fl))
	{
		sprint (self, STR_NOTENOUGHMANA);
		return;
	}

//
// set weapon, set ammo
//
	self.oldweapon=self.weapon;//for deselection animation
	self.weapon = fl;		
	W_SetCurrentWeapon ();
};

/*
============
CycleWeaponCommand

Go to the next weapon with ammo
============
*/
void() CycleWeaponCommand =
{
float	it, am;

	if(self.attack_finished>time)
		return;

	self.impulse = 0;

	self.items (+) IT_WEAPON1;
	it = self.items;

	while (1)
	{
		am = 0;

		if (self.weapon == IT_WEAPON4)
		{
			self.weapon = IT_WEAPON1;
		}
		else if (self.weapon == IT_WEAPON1)
		{
			self.weapon = IT_WEAPON2;
			if (self.bluemana < 1)
			{
				if (self.playerclass != CLASS_PALADIN)
					am = 1;
			}
		}
		else if (self.weapon == IT_WEAPON2)
		{
			self.weapon = IT_WEAPON3;
			if (self.greenmana < 1)
				am = 1;
		}		
		else if (self.weapon == IT_WEAPON3)
		{
			self.weapon = IT_WEAPON4;
			if ((self.bluemana < 1) || (self.greenmana<1))
				am = 1;
		}
	
		if ((it & self.weapon) && am == 0)
		{
			W_SetCurrentWeapon ();
			return;
		}
	}

};

/*
============
CycleWeaponReverseCommand

Go to the prev weapon with ammo
============
*/
void() CycleWeaponReverseCommand =
{
	local	float	it, am;
	
	it = self.items;
	self.impulse = 0;

	while (1)
	{
		am = 0;

		if (self.weapon == IT_WEAPON4)
		{
			self.weapon = IT_WEAPON3;
			if (self.greenmana < 1)
				am = 1;
		}
		else if (self.weapon == IT_WEAPON3)
		{
			self.weapon = IT_WEAPON2;
		}
		else if (self.weapon == IT_WEAPON2)
		{
			self.weapon = IT_WEAPON1;
		}
		else if (self.weapon == IT_WEAPON1)
		{
			self.weapon = IT_WEAPON4;
			if ((self.bluemana < 1) && (self.greenmana<1))
				am = 1;
		}
	
		if ( (it & self.weapon) && am == 0)
		{
			W_SetCurrentWeapon ();
			return;
		}
	}

};

/*
========
	ClassChangeWeapon - Player is changing class so change weapon model to match. Called from C code
========
*/
void ClassChangeWeapon(void)
{
	self.drawflags(-)MLS_ABSLIGHT|DRF_TRANSLUCENT;

	if(self.sheep_time>time)
		return;

	self.weaponframe = 0;
	if (self.playerclass==CLASS_PALADIN)
	{
		if (self.weapon == IT_WEAPON1)
		{
			self.th_weapon=gauntlet_select;
			self.weaponmodel = "models/gauntlet.mdl";
		}
		else if (self.weapon == IT_WEAPON2)
		{
			self.th_weapon=vorpal_select;
			self.weaponmodel = "models/vorpal.mdl";
		}
		else if (self.weapon == IT_WEAPON3)
		{
			self.th_weapon=axe_select;
			self.weaponmodel = "models/axe.mdl";
		}
		else if (self.weapon == IT_WEAPON4)
		{
			self.th_weapon=purifier_select;
			self.weaponmodel = "models/purifier.mdl";
		}
	}
	else if (self.playerclass==CLASS_CRUSADER)
	{
		if (self.weapon == IT_WEAPON1)
		{
			self.th_weapon=warhammer_select;
			self.weaponmodel = "models/warhamer.mdl";
		}
		else if (self.weapon == IT_WEAPON2)
		{
			self.th_weapon=icestaff_select;
			self.weaponmodel = "models/icestaff.mdl";
		}
		else if (self.weapon == IT_WEAPON3)
		{
			self.th_weapon=meteor_select;
			self.weaponmodel = "models/meteor.mdl";
		}
		else if (self.weapon == IT_WEAPON4)
		{
			self.th_weapon=sunstaff_select;
			self.weaponmodel = "models/sunstaff.mdl";
		}
	}
	else if (self.playerclass==CLASS_NECROMANCER)
	{
		if (self.weapon == IT_WEAPON1)
		{
			self.th_weapon=sickle_select;
			self.weaponmodel = "models/sickle.mdl";
		}
		else if (self.weapon == IT_WEAPON2)
		{
			self.th_weapon=sickle_select;
			self.weaponmodel = "models/sickle.mdl";  // FIXME: still need these models
		}
		else if (self.weapon == IT_WEAPON3)
		{
			self.th_weapon=sickle_select;
			self.weaponmodel = "models/sickle.mdl";
		}
		else if (self.weapon == IT_WEAPON4)
		{
			self.th_weapon=ravenstaff_select;
			self.weaponmodel = "models/ravenstf.mdl";
		}
	}
	else if (self.playerclass==CLASS_ASSASSIN)
	{
		if (self.weapon == IT_WEAPON1)
		{
			self.th_weapon=punchdagger_select;
			self.weaponmodel = "models/punchdgr.mdl";
		}
		else if (self.weapon == IT_WEAPON2)
		{
			self.th_weapon=crossbow_select;
			self.weaponmodel = "models/crossbow.mdl";
		}
		else if (self.weapon == IT_WEAPON3)
		{
			self.th_weapon=grenade_select;
			self.weaponmodel = "models/v_assgr.mdl";
		}
		else if (self.weapon == IT_WEAPON4)
		{
			self.th_weapon=setstaff_select;
			self.weaponmodel = "models/scarabst.mdl";
		}
	}
//FIXME: take off all timed effects, lighting tinting, drawflags,
//	power-ups, etc.  Reset max health, abilities, etc.
	SetModelAndThinks();
	self.act_state=ACT_STAND;
}

void W_SetCurrentWeapon (void) 
{
	if(self.attack_finished>time)
		return;

	if(self.sheep_time>time)
		return;

	self.button0=FALSE;
	attck_cnt=0;

	if (self.oldweapon==self.weapon)		// Until we get multi skinned weapons
		return;

	self.attack_finished=time + 999;
	W_DeselectWeapon ();
}

void Pal_Change_Weapon (void)
{
	if(self.weapon==IT_WEAPON1)
		self.th_missile=pal_gauntlet_fire;
	else if(self.weapon==IT_WEAPON4)
		self.th_missile=pal_purifier_fire;
	else if(self.weapon==IT_WEAPON2)
		self.th_missile=pal_vorpal_fire;
	else
		self.th_missile=pal_axe_fire;
}

void Cru_Change_Weapon (void)
{
	if(self.weapon==IT_WEAPON1)
		self.th_missile=Cru_Wham_Fire;
	else if(self.weapon==IT_WEAPON2)
		self.th_missile=Cru_Ice_Fire;
	else if(self.weapon==IT_WEAPON3)
		self.th_missile=Cru_Met_Attack;
	else
		self.th_missile=Cru_Sun_Fire;
}

void Nec_Change_Weapon (void)
{
	if(self.weapon==IT_WEAPON1)
		self.th_missile=sickle_decide_attack;
	else if(self.weapon==IT_WEAPON4)
		self.th_missile=setstaff_decide_attack;
	else if(self.weapon==IT_WEAPON2)
		self.th_missile=Nec_Mis_Attack;
	else
		self.th_missile=Nec_Bon_Attack;
}

void Ass_Change_Weapon (void)
{
	if(self.weapon==IT_WEAPON4)
		self.th_missile=ass_setstaff_fire;
	else if(self.weapon==IT_WEAPON2)
		self.th_missile=crossbow_fire;
	if(self.weapon==IT_WEAPON3)
		self.th_missile=grenade_throw;
	else
		self.th_missile=Ass_Pdgr_Fire;
}

float MAX_INV = 25;

void max_ammo2 (entity AddTo, entity AddFrom)
{
	// FIXME: I assume the max will be different between classes and levels

	if (AddTo.cnt_torch + AddFrom.cnt_torch > MAX_INV)
		AddFrom.cnt_torch = MAX_INV - AddTo.cnt_torch;
	if (AddTo.cnt_h_boost + AddFrom.cnt_h_boost > MAX_INV)
		AddFrom.cnt_h_boost = MAX_INV - AddTo.cnt_h_boost;
	if (AddTo.cnt_sh_boost + AddFrom.cnt_sh_boost > MAX_INV)
		AddFrom.cnt_sh_boost = MAX_INV - AddTo.cnt_sh_boost;
	if (AddTo.cnt_mana_boost + AddFrom.cnt_mana_boost > MAX_INV)
		AddFrom.cnt_mana_boost = MAX_INV - AddTo.cnt_mana_boost;
	if (AddTo.cnt_teleport + AddFrom.cnt_teleport > MAX_INV)
		AddFrom.cnt_teleport = MAX_INV - AddTo.cnt_teleport;
	if (AddTo.cnt_tome + AddFrom.cnt_tome > MAX_INV)
		AddFrom.cnt_tome = MAX_INV - AddTo.cnt_tome;
	if (AddTo.cnt_summon + AddFrom.cnt_summon > MAX_INV)
		AddFrom.cnt_summon = MAX_INV - AddTo.cnt_summon;
	if (AddTo.cnt_invisibility + AddFrom.cnt_invisibility > MAX_INV)
		AddFrom.cnt_invisibility = MAX_INV - AddTo.cnt_invisibility;
	if (AddTo.cnt_glyph + AddFrom.cnt_glyph > MAX_INV)
		AddFrom.cnt_glyph = MAX_INV - AddTo.cnt_glyph;
	if (AddTo.cnt_haste + AddFrom.cnt_haste > MAX_INV)
		AddFrom.cnt_haste = MAX_INV - AddTo.cnt_haste;
	if (AddTo.cnt_blast + AddFrom.cnt_blast > MAX_INV)
		AddFrom.cnt_blast = MAX_INV - AddTo.cnt_blast;
	if (AddTo.cnt_polymorph + AddFrom.cnt_polymorph > MAX_INV)
		AddFrom.cnt_polymorph = MAX_INV - AddTo.cnt_polymorph;
	if (AddTo.cnt_flight + AddFrom.cnt_flight > MAX_INV)
		AddFrom.cnt_flight = MAX_INV - AddTo.cnt_flight;
	if (AddTo.cnt_cubeofforce + AddFrom.cnt_cubeofforce > MAX_INV)
		AddFrom.cnt_cubeofforce = MAX_INV - AddTo.cnt_cubeofforce;
	if (AddTo.cnt_invincibility + AddFrom.cnt_invincibility > MAX_INV)
		AddFrom.cnt_invincibility = MAX_INV - AddTo.cnt_invincibility;

	if (AddTo.bluemana + AddFrom.bluemana > AddTo.max_mana)
		AddFrom.bluemana = AddTo.max_mana - AddTo.bluemana;

	if (AddTo.greenmana + AddFrom.greenmana > AddTo.max_mana)
		AddFrom.greenmana = AddTo.max_mana - AddTo.greenmana;
}

float(float w) RankForWeapon =
{
	if (w&IT_WEAPON4)
		return 1;
	if (w == IT_WEAPON3)
		return 2;
	if (w == IT_WEAPON2)
		return 3;
	return 4;
};

/*
=============
Deathmatch_Weapon

Deathmatch weapon change rules for picking up a weapon

=============
*/
void(float old, float new) NewBestWeapon =
{	float or, nr;

	// change self.weapon if desired
	or = RankForWeapon (self.weapon);
	nr = RankForWeapon (new);
	if ( nr < or )
		if(new&IT_WEAPON4)
			self.weapon=IT_WEAPON4;
		else
			self.weapon = new;
};

void restore_weapon ()
{//FIXME: use idle, not select
	self.weaponframe = 0;
	if (self.playerclass==CLASS_PALADIN)
	{
		if (self.weapon == IT_WEAPON1)
			self.weaponmodel = "models/gauntlet.mdl";
		else if (self.weapon == IT_WEAPON2)
			self.weaponmodel = "models/vorpal.mdl";
		else if (self.weapon == IT_WEAPON3)
			self.weaponmodel = "models/axe.mdl";
		else if (self.weapon == IT_WEAPON4)
			self.weaponmodel = "models/purifier.mdl";
	}
	else if (self.playerclass==CLASS_CRUSADER)
	{
		if (self.weapon == IT_WEAPON1)
			self.weaponmodel = "models/warhamer.mdl";
		else if (self.weapon == IT_WEAPON2)
			self.weaponmodel = "models/icestaff.mdl";
		else if (self.weapon == IT_WEAPON3)
			self.weaponmodel = "models/meteor.mdl";
		else if (self.weapon == IT_WEAPON4)
			self.weaponmodel = "models/sunstaff.mdl";
	}
	else if (self.playerclass==CLASS_NECROMANCER)
	{
		if (self.weapon == IT_WEAPON1)
			self.weaponmodel = "models/sickle.mdl";
		else if (self.weapon == IT_WEAPON2)
			self.weaponmodel = "models/sickle.mdl";  // FIXME: still need these models
		else if (self.weapon == IT_WEAPON3)
			self.weaponmodel = "models/sickle.mdl";
		else if (self.weapon == IT_WEAPON4)
			self.weaponmodel = "models/ravenstf.mdl";
	}
	else if (self.playerclass==CLASS_ASSASSIN)
	{
		if (self.weapon == IT_WEAPON1)
			self.weaponmodel = "models/punchdgr.mdl";
		else if (self.weapon == IT_WEAPON2)
			self.weaponmodel = "models/crossbow.mdl";
		else if (self.weapon == IT_WEAPON3)
			self.weaponmodel = "models/v_assgr.mdl";
		else if (self.weapon == IT_WEAPON4)
			self.weaponmodel = "models/scarabst.mdl";
	}
}

float IsMeleeWeapon(float class, float weap,float artinuse)
{	if(class==CLASS_ASSASSIN)
	{	if(weap==IT_WEAPON1)
			return TRUE;
	}
	else if(class==CLASS_NECROMANCER)
	{	if(weap==IT_WEAPON1)
			return TRUE;
	}
	else if(class==CLASS_CRUSADER)
	{	if(weap==IT_WEAPON1)
			return TRUE;
	}
	else if(class==CLASS_PALADIN)
	{	if(weap==IT_WEAPON1)
			return TRUE;
		if((weap==IT_WEAPON2)&&(!(artinuse&ART_TOMEOFPOWER)))
			return TRUE;
	}
	return FALSE;
}