/*
===========
ClientObituary

called when a player dies
============
*/
void(entity targ, entity attacker, entity inflictor,string caller) ClientObituary =
{
	float rnum,tclass,aclass,reversed,powered_up, exp_mult;
	string deathstring, deathstring2,iclass;

	if ((targ.classname != "player")&&(targ.classname != "bot"))
		return;
		
	tclass=targ.playerclass;
	aclass=attacker.playerclass;
	iclass=inflictor.classname;
	powered_up=inflictor.frags;
	exp_mult=1;
	rnum = random();

	if (targ.deathtype == "teledeath")
	{
		bprint (targ.netname);
		bprint (STR_WASTELEFRAGGEDBY);
		bprint (attacker.netname);
		bprint ("\n");

		attacker.frags += 1;
		msgUpdateFragsToAll(attacker.fClientNo, attacker.frags);
		return;
	}

	if (targ.deathtype == "teledeath2")
	{
		bprint ("The power of invincibility reflects ");
		bprint (targ.netname);
		bprint ("'s telefrag\n");

		targ.frags -= 1;
		msgUpdateFragsToAll(targ.fClientNo, targ.frags);
		return;
	}

	if (targ.deathtype == "teledeath3")
	{
		bprint (attacker.netname);
		bprint (" telefragged ");
		bprint (targ.netname);
		bprint (", his own teammate!\n");

		attacker.frags -= 1;
		msgUpdateFragsToAll(attacker.fClientNo, attacker.frags);
		return;
	}

	if (targ.deathtype == "teledeath4")
	{
		bprint (attacker.netname);
		bprint ("'s invincibility met ");
		bprint (targ.netname);
		bprint ("'s invincibility and mutual annihilation resulted!\n");

		targ.frags -= 1;
		msgUpdateFragsToAll(targ.fClientNo, targ.frags);
		return;
	}

	// Was killed by a player
	if ((attacker.classname == "player")||(attacker.classname == "bot"))
	{
		if (targ == attacker)
		{
			// killed self
			attacker.frags -= 1;
			msgUpdateFragsToAll(attacker.fClientNo, attacker.frags);
			bprint (targ.netname);
			
			if(random()<0.5)
				bprint (" must be a masochist!\n");
			else
				bprint (" becomes bored with life...\n");
			if(targ.classname=="bot") botcomment(COMMENT_SUICIDE,targ);
			return;
		}
		else if ( (teamplay == 2) && (targ.team > 0)&&(targ.team == attacker.team) )
		{
			if (rnum < 0.25)
				deathstring = " mows down a teammate\n";
			else if (rnum < 0.50)
				deathstring = " checks his glasses\n";
			else if (rnum < 0.75)
				deathstring = " gets a frag for the other team\n";
			else
				deathstring = " loses another friend\n";
			bprint (attacker.netname);
			bprint (deathstring);
			attacker.frags -= 1;
			msgUpdateFragsToAll(attacker.fClientNo, attacker.frags);
			return;
		}
		else
		{
			attacker.frags += 1;
			msgUpdateFragsToAll(attacker.fClientNo, attacker.frags);

			rnum = attacker.weapon;
			if(attacker.model=="models/sheep.mdl")
			{
				deathstring = " was nibbled to death by ";
				deathstring2 = " the sheep!!\n";
			}
			else if(targ.decap==1)
			{
				if(tclass==CLASS_ASSASSIN)
					deathstring = " lost her head over ";
				else
					deathstring = " lost his head over ";
				deathstring2="\n";
			}
			else if (targ.decap==2)
			{
				if (tclass==CLASS_ASSASSIN)
				{
					deathstring = " got her head blown clean off by ";
					deathstring2 = "!\n";
				}
				else
				{
					deathstring = " got his head blown clean off by ";
					deathstring2 = "!\n";
				}
			}
			else if (iclass=="cube_of_force")
			{
				deathstring = " was ventilated by ";
				deathstring2 = "'s Force Cube!\n";
			}
			else if(iclass=="tripwire")
			{
				deathstring = " tripped on ";
				deathstring2 = "'s tripwire glyph!\n";
			}
			else if(iclass=="fireballblast")
			{
				deathstring = " was blown away by ";
				deathstring2 = "'s delayed fireball glyph!\n";
			}
			else if(iclass=="proximity")
			{
				deathstring = " got too close for comfort to ";
				deathstring2 = "'s proximity glyph!\n";
			}
			else if(iclass=="timebomb")
			{
				deathstring = " was in the wrong place at the wrong time thanks to ";
				deathstring2 = "'s timebomb glyph!\n";
			}
			else if(iclass=="tornato")
			{
				deathstring = " isn't in kansas anymore thanks to ";
				deathstring2 = "'s tornado!\n";
			}
			else if(iclass=="blizzard")
			{
				deathstring = " was snowed in by ";
				deathstring2 = "'s blizzard!\n";
			}
			else if(targ.deathtype=="hammercrush")
			{
				deathstring = " was crushed by the righteous might of ";
				deathstring2 = "'s Hammer!\n";
			}
			else if (iclass == "monster_imp_lord")
			{
				deathstring =" was jacked up by ";
				deathstring2 ="'s Summoned Imp Lord!\n";
			}
			else if(inflictor.frags==2)
			{
				deathstring = " was destroyed by the power of ";
				deathstring2 = "'s Disc of Repulsion!\n";
			}
			else if (rnum == IT_WEAPON1) 
			{
				if(attacker.artifact_active&ART_TOMEOFPOWER)
					exp_mult=1.5;
				else
					exp_mult=2;
				if(aclass==CLASS_ASSASSIN)
				{
					deathstring = " got penetrated by ";
					deathstring2 = "'s Katar\n";
				}
				else if(aclass==CLASS_CRUSADER)
				{
					if(exp_mult==1.5)
					{
						deathstring = " was fried by the holy lightning of ";
						deathstring2 = "'s Mjolnir!\n";
					}
					else
					{
						deathstring = " was whalloped by ";
						deathstring2 = "'s hammer!\n";
					}
				}
				else if(aclass==CLASS_PALADIN)
				{
					deathstring = " got KO'd by ";
					deathstring2 = "'s fists of fury!\n";
				}
				else
				{
					deathstring = " was sliced and diced by ";
					deathstring2 = "'s sickle!\n";
				}
			}
			else if (rnum == IT_WEAPON2) 
			{
				if(powered_up)
					exp_mult=1;
				else
					exp_mult=1.2;
				if(aclass==CLASS_ASSASSIN)
				{
					if(powered_up)
					{
						deathstring = " was stuck like a pig by ";
						deathstring2 = "'s arrows!\n";
					}
					else
					{
						deathstring = " took one of ";
						deathstring2 = "'s arrows to the heart!\n";
					}
				}
				else if(aclass==CLASS_CRUSADER)
				{
					if(powered_up)
					{
						deathstring = " befell the subzero temperatures of ";
						deathstring2 = "'s blizzard!\n";
					}
					else
					{
						deathstring = " gets the cold shoulder from ";
						deathstring2 = "!\n";
					}
				}
				else if(aclass==CLASS_PALADIN)
				{
					if(powered_up)
					{
						deathstring = " took a shock to the system from ";
						deathstring2 = "'s Vorpal Shockwave!\n";
					}
					else
					{
						deathstring = " was cut to pieces by ";
						deathstring2 = "'s vorpal sword!\n";
					}
				}
				else
				{
					if(powered_up)
					{
						deathstring = " was tracked down by ";
						deathstring2 = "'s Magic Missiles!\n";
					}
					else
					{
						deathstring = " was mowed down by ";
						deathstring2 = "'s Magic Missiles!\n";
					}
				}
			}
			else if (rnum == IT_WEAPON3) 
			{
				if(powered_up)
					exp_mult=0.8;
				else
					exp_mult=1;
				if(aclass==CLASS_ASSASSIN)
				{
					if(powered_up)
					{
						reversed=TRUE;
						deathstring = " opened up a nice big can o' whoop-ass on ";
						deathstring2 = "!\n";
					}
					else
					{
						deathstring = " sucked down ";
						deathstring2 = "'s grenade!\n";
					}
				}
				else if(aclass==CLASS_CRUSADER)
				{
					if(powered_up)
					{
						deathstring = " was whisked away by ";
						deathstring2 = "'s tornado!\n";
					}
					else
					{
						deathstring = " took a nice hot meteor shower courtesy of ";
						deathstring2 = "!\n";
					}
				}
				else if(aclass==CLASS_PALADIN)
				{
					if(powered_up)
					{
						deathstring = " was cut down by ";
						deathstring2 = "'s magic axeblades!\n";
					}
					else
					{
						deathstring = " got a nasty papercut from ";
						deathstring2 = "'s axeblade!\n";
					}
				}
				else
				{
					if(powered_up)
					{
						deathstring = " was fragged by ";
						deathstring2 = "'s Frag Bones!\n";
					}
					else
					{
						reversed=TRUE;
						deathstring = " broke  ";
						deathstring2 = "'s bones with the bone shard spell!\n";
					}
				}
			}
			else if (rnum == IT_WEAPON4) 
			{
				if(powered_up)
					exp_mult=0.5;
				else
					exp_mult=0.8;
				if(aclass==CLASS_ASSASSIN)
				{
					if(powered_up)
					{
						deathstring = " got into a little S&M with ";
						deathstring2 = "'s chains!\n";
					}
					else
					{
						deathstring = " got cored by ";
						deathstring2 = "'s Scarab Staff!\n";
					}
				}
				else if(aclass==CLASS_CRUSADER)
				{
					if(attacker.artifact_active&ART_TOMEOFPOWER)
					{
						exp_mult=0.5;
						deathstring = " needs some Factor 5,000,000 suncream to stop ";
						deathstring2 = "'s Sunstaff!\n";
					}
					else
					{
						deathstring = " smells like fried chicken thanks to ";
						deathstring2 = "'s Sunstaff!\n";
					}
				}
				else if(aclass==CLASS_PALADIN)
				{
					if(powered_up)
					{
						deathstring = " was blown into next week by ";
						deathstring2 = "'s Purifier Seeker!\n";
					}
					else
					{
						deathstring = "'s evil ways were purified by ";
						deathstring2 = "!\n";
					}
				}
				else
				{
					if(powered_up)
					{
						deathstring = " succumbed to the black death of ";
						deathstring2 = "'s Ravens!\n";
					}
					else
					{
						deathstring = " befell the black magic of ";
						deathstring2 = "'s Ravenstaff!\n";
					}
				}
			}
			if(reversed)
			{
				bprint (attacker.netname);
				bprint (deathstring);
				bprint (targ.netname);
				bprint (deathstring2);
				if(attacker.classname=="bot") botcomment(COMMENT_DIED,attacker);
				if(targ.classname=="bot") botcomment(COMMENT_FRAG,targ);
			}
			else
			{
				bprint (targ.netname);
				bprint (deathstring);
				bprint (attacker.netname);
				bprint (deathstring2);
				if(targ.classname=="bot") botcomment(COMMENT_DIED,targ);
				if(attacker.classname=="bot") botcomment(COMMENT_FRAG,attacker);
			}
		}
		return;
	}

	// was not killed by a player
	else
	{
		targ.frags -= 1;
		msgUpdateFragsToAll(targ.fClientNo, targ.frags);
		bprint (targ.netname);

		if (attacker.flags & FL_MONSTER)
		{
			if(attacker.model=="models/sheep.mdl")
				if(random()<0.5)
					bprint (" was savagely mauled by a sheep!\n");
				else
					bprint (" says 'HELLO DOLLY!'\n");
			if (attacker.classname == "monster_archer")
				bprint (" was skewered by an Archer!\n");
			if (attacker.classname == "monster_archer_lord")
				bprint (" got Horshacked!\n");
			if (attacker.classname == "monster_fallen_angel")
				bprint (" was felled by the Fallen Angel\n");
			if (attacker.classname == "monster_fallen_angel_lord")
				bprint (" was decimated by a Fallen Angel Lord!\n");
			if (attacker.classname == "monster_golem_bronze")
				if(targ.decap==1)
					bprint ("'s head was taken as a trophy for the Bronze Golem!\n");
				else if(targ.decap==2)
					bprint (" became a permanent stain on the wall!\n");
				else
					bprint (" was squished like an insect by a Bronze Golem!\n");
			if (attacker.classname == "monster_golem_iron")
			{
				if (inflictor.classname == "golem_iron_proj")
					bprint(" felt the sting of the Iron Golem's jewel!\n");
				else if(targ.decap==2)
					bprint ("'s brains make nice wall decorations!\n");
				else
					bprint (" was crushed by the Iron Golem's fist!\n");
			}
			if (attacker.classname == "monster_golem_stone")
				if(targ.decap==2)
					bprint (" is feeling a little light-headed!\n");
				else
					bprint (" was pummeled by a Stone Golem!\n");
			if (attacker.classname == "monster_golem_crystal")
				bprint (" was mangled by the Enchanted Crystal Golem!\n");
			if (attacker.classname == "monster_hydra")
				bprint (" becomes food for the Hydra!\n");
			if (attacker.classname == "monster_imp_fire")
				bprint (" was roasted by a Fire Imp!\n");
			if (attacker.classname == "monster_imp_ice")
				bprint (" chills out with the Ice Imps!\n");
			if (attacker.classname == "monster_medusa")
				if (attacker.skin==1)
					bprint (" was stricken by the beauty of the Crimson Medusa!\n");
				else
					bprint (" is helpless in the face of the Medusa's beauty!\n");
			if (attacker.classname == "monster_mezzoman")
				if (attacker.skin==1)
					bprint (" is not yet worthy of facing the WerePanther!\n");
				else
					bprint (" is no match for the WereJaguar!\n");
			if (attacker.classname == "monster_mummy")
				bprint (" got mummified!\n");
			if (attacker.classname == "monster_mummy_lord")
				bprint (" was escorted to the Underworld by a Mummy Lord!\n");
			if (attacker.classname == "monster_scorpion_black")
				bprint (" submits to the sting of the Black Scorpion!\n");
			if (attacker.classname == "monster_scorpion_yellow")
				bprint (" was poisoned by the fatal Golden Scorpion!\n");
			if (attacker.classname == "monster_skull_wizard")
				bprint (" succumbed to the Skull Wizard's magic!\n");
			if (attacker.classname == "monster_skull_wizard_lord")
				bprint (" was Skull-duggeried!\n");
			if (attacker.classname == "monster_snake")
				bprint (" was bitten by the lethal Cobra!\n");
			if (attacker.classname == "monster_spider_red_large")
				bprint (" was overcome by the Crimson Spiders!\n");
			if (attacker.classname == "monster_spider_red_small")
				bprint (" was eaten alive by the spiders!\n");
			if (attacker.classname == "monster_spider_yellow_large")
				bprint (" was overwhelmed by the Golden Spiders!\n");
			if (attacker.classname == "monster_spider_yellow_small")
				bprint (" is a meal for the spiders!\n");
			if (attacker.classname == "rider_famine")
				bprint(" was drained of life-force by Famine!\n");
			if (attacker.classname == "rider_death")
				if(inflictor==attacker)
					bprint(" was snuffed out of existance by Death!\n");
				else if(inflictor.netname=="deathbone")
					bprint(" had his bones crushed to a fine powder by Death!\n");
				else if(iclass=="deathmissile")
					bprint(" was shot down by Death's crimson bolts!\n");
				else
					bprint(" was smitten by Death's unholy fire\n");
			if (attacker.classname == "rider_pestilence")
				if(targ.deathtype=="poison")
					bprint(" was poisoned to death by Pestilence's Crossbow!\n");
				else
					bprint("'s rotted corpse is the possession of Pestilence!\n");
			if (attacker.classname == "rider_war")
				bprint(" was taught the true meaning of War!\n");
			if (attacker.classname == "monster_eidolon")
				if(inflictor==attacker)
					bprint(" was squashed like an insect by Eidolon!\n");
				else if(inflictor.classname=="eidolon fireball")
					bprint(" was obliterated by Eidolon's fireballs!\n");
				else if(inflictor.classname=="eidolon spell")
					bprint(" was introduced to a new level of pain by Eidolon's Magic!\n");
				else if(inflictor.classname=="eidolon flames")
					bprint(" was roasted to a crisp by Eidolon's Hellfire!\n");
			return;
		}

		// tricks and traps
		if(targ.decap==1)
		{
			if(targ.playerclass==CLASS_ASSASSIN)
				bprint(" should have quit while she was a head... oh, she IS a head!\n");
			else
				bprint(" should have quit while he was a head... oh, he IS a head!\n");
			return;
		}
		if(targ.decap==2)
		{
			if(targ.playerclass==CLASS_ASSASSIN)
				bprint(" got her head blown off!\n");
			else
				bprint(" got his head blown off!\n");
			return;
		}
		if(attacker.classname=="light_thunderstorm")
		{
			if(mapname=="eidolon")
				bprint(" was smited by Eidolon's unholy lightning!\n");
			else
				bprint(" shouldn't mess with Mother Nature!\n");
			return;
		}
		if(targ.deathtype=="zap")
		{
			bprint(" was electrocuted!\n");
			return;
		}
		if(targ.deathtype=="chopped")
		{
			bprint(" was sliced AND diced!\n");
			return;
		}
		if (attacker.solid == SOLID_BSP && attacker != world)
		{	
			bprint (" was squished\n");
			return;
		}
		if (attacker.classname == "trap_shooter" || attacker.classname == "trap_spikeshooter")
		{
			bprint (" was spiked");
			if (((attacker.enemy.classname == "player")||(attacker.enemy.classname == "bot")) && attacker.enemy != targ)
			{
			 bprint(" by ");
			 bprint(attacker.enemy.netname);
			 attacker.enemy.frags += 1;
			 msgUpdateFragsToAll(attacker.enemy.fClientNo, attacker.enemy.frags);
			}
			bprint("\n");
			return;
		}
		if (attacker.classname == "fireball")
		{
			bprint (" ate a lavaball\n");
			return;
		}
		if (attacker.classname == "trigger_changelevel")
		{
			bprint (" tried to leave\n");
			return;
		}

		// in-water deaths
		rnum = targ.watertype;
		if (rnum == -3)
		{
			if (random() < 0.5)
				bprint (" takes a nice, deep breath of H2O!\n");
			else
				bprint (" needed gills\n");
			if(targ.classname=="bot") botcomment(COMMENT_WATER,targ);
			return;
		}
		else if (rnum == -4)
		{
			if (random() < 0.5)
				bprint (" gulped a load of slime\n");
			else
				bprint (" can't exist on slime alone\n");
			if(targ.classname=="bot") botcomment(COMMENT_SLIME,targ);
			return;
		}
		else if (rnum == -5)
		{
			if (random() < 0.3)
				bprint (" needs a cold shower\n");
			else if (random() < 0.5)
				bprint (" likes it HOT!\n");
			else
				bprint (" smells like burnt hair\n");
			if(targ.classname=="bot") botcomment(COMMENT_LAVA,targ);
			return;
		}

		// fell to their death?
		if ((targ.deathtype == "falling")||(targ.felltodeath))
		{
			targ.deathtype = "";
			bprint (STR_CHUNKYSALSA);
			return;
		}

		// hell if I know; he's just dead!!!
		bprint (" died under strange circumstances:");
		bprint(caller);
		bprint("\n");
	}
};
