float() found_something=
{	if (BotFindTarget()) return TRUE;
	if (avoid_items())   return TRUE;
	if (BotFindStuff())  return TRUE;
	return FALSE;
};

// search for items and start walking next think.
void() bot_ai_stand =
{
	bot_prethink();

	if((self.movetype==MOVETYPE_NONE)||(self.deadflag>=DEAD_DYING)
		||(intermission_running)||(self.health<=0))
		return;

        if (found_something())
                return;

	if(self.waterlevel>=2)
	{	bot_ai_swim();
		return;
	}

	// stand still...think i'll move
        self.think=self.th_walk;
	self.act_state=ACT_RUN;
};

void(entity attacker, float damage) bot_pain =
{
	if(self.pain_finished>time)
	{	self.act_state=ACT_RUN;
		return;
	}

	PainSound();

	// eyes don't have pain frames
	// no pain frames in water (gives endless loop too)
	if ((self.invisible_finished > time)||(self.waterlevel))
	{	self.act_state=ACT_RUN;
		return;
	}

	if((self.bot_num>=BOT_15)||((self.bot_num>=BOT_13)&&(random()>0.7)))
	{	self.act_state=ACT_RUN;
		return;
	}

	if((attacker.classname=="player")||(attacker.classname=="bot"))
	{	self.enemy=attacker;
		self.goalentity=attacker;
	}
	self.think=bot_frames;
	self.act_state=ACT_PAIN;
};

void(float dist) bot_painmove =
{
	movedist=dist;
	bot_prethink();

	if((self.movetype==MOVETYPE_NONE)||(self.deadflag>=DEAD_DYING)
		||(intermission_running)||(self.health<=0))
	{	self.act_state=ACT_RUN;
		return;
	}

	if(self.waterlevel>=2)
	{	bot_ai_swim();
		return;
	}

	if(self.pain_finished>time)
	{	self.act_state=ACT_RUN;
		bot_combat(10);
		return;
	}

	if((self.bot_num>=BOT_9)||((self.bot_num>=BOT_3)&&(random()>0.7)))
	{	self.act_state=ACT_RUN;
		return;
	}
	//bot_combat(10);
	self.think=bot_frames;
	self.act_state=ACT_PAIN;
};

void(float dist) bot_explore =
{
	movedist=dist;
	bot_prethink();

	if((self.movetype==MOVETYPE_NONE)||(self.deadflag>=DEAD_DYING)
		||(intermission_running)||(self.health<=0))
		return;

        if (found_something())
		return;

	if(self.waterlevel>=2)
	{	bot_ai_swim();
		return;
	}

	if((!limitjumps)||(!self.way1)||(!self.way2))
        	if(check_for_ledge()) return;
	if(BotNormalUseArtifact()) return;
	// no goal - need roam ai here......
        bot_roam_ai (dist);
};

// this is really the combat think
void(float dist) bot_combat =
{
	bot_prethink();

	if ((self.enemy.health <= 0)||((self.enemy.movetype==MOVETYPE_NONE)&&((self.enemy.classname=="bot")||(self.enemy.classname=="player")))||(self.enemy==world)||(self.enemy==self))
	{
		self.enemy = world;
		self.goalentity=self;
		self.think=self.th_walk;
		self.act_state=ACT_RUN;
		return;
	}

	if ((self.movetype==MOVETYPE_NONE)||(intermission_running)
		||(self.deadflag>=DEAD_DYING)||(self.health<=0))
		return;

	if(self.waterlevel>=2)
	{	bot_ai_swim();
		return;
	}

	movedist = dist;

	enemy_vis = visible(self.enemy);
	if (enemy_vis)
	{	self.search_time = time + 5;
		self.lastpos=self.enemy.origin;
		self.lastvis=0;
	}
	else if (!self.lastvis)
		self.lastvis=time+1.5;
	else if(time>self.search_time)
	{
		self.enemy=world;
		self.goalentity=self;
		self.think=self.th_walk;
		self.act_state=ACT_RUN;
		return;
	}

	if ((self.enemy.classname == "door") && (wall_visible(self.enemy)) && (time > self.attack_finished))
	{	if(self.enemy.health<=0)
		{
			self.goalentity=self.enemy;
			self.stuff=self.enemy;
			self.enemy = world;
			self.think=self.th_stuff;
			self.act_state=ACT_RUN;
			return;
		}
		self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
		ChangeYaw ();
		self.th_missile ();
		self.act_state=ACT_ATTACK;
		return;
	}

	enemy_range = range(self.enemy);

	if (BotCombatUseArtifact()) 
		return;
	self.v_angle=vectoangles(self.enemy.origin - self.origin);
	if (BotCheckAttack ())
		return;			// beginning an attack

	if(check_for_ledge()) return;

	botmovetogoal(dist);
};

void() zero_stuffpath=
{	self.goalentity=self;
	self.followpath=FALSE;
	self.reachedgoal=FALSE;
	self.way1=world;
	self.way2=world;
	self.stuff=world;
};

// trying to get something
void(float dist) bot_ai_stuff =
{
        bot_prethink();
	if((self.deadflag>=DEAD_DYING)||(intermission_running)||(self.movetype==MOVETYPE_NONE))
	{	zero_stuffpath();
		self.act_state=ACT_STAND;
		self.nextthink=time+0.1;
		return;
	}

	movedist = dist;

	if(((self.stuff.solid==SOLID_NOT)&&(self.stuff.classname!="trigger_teleport"))
		||(self.goalentity==self)||(self.goalentity==world))
	{ 	zero_stuffpath();
		self.nextthink=time+0.05;
		self.think=self.th_walk;
		self.act_state=ACT_RUN;
		return;
	}

        if (BotFindTarget ())
                return;

	if(self.waterlevel>=2)
	{	bot_ai_swim();
		self.followpath=FALSE;
		self.way1=world;
		self.way2=world;
		return;
	}

        if(avoid_items())
	{	zero_stuffpath();
		self.think=self.th_walk;
		self.act_state=ACT_RUN;
		return;
	}

	if((!limitjumps)||(!self.way1)||(!self.way2)||(!self.way3))
		if(check_for_ledge())
		{	zero_stuffpath();
			return;
		}

	if(self.reachedgoal)
	{	self.reachedgoal=FALSE;
		if(self.followpath)
		{	self.way1=self.way2;
			self.way2=self.way3;
			self.way3=world;
			self.goalentity=self.way1;
			if(self.way1==self.stuff)
			{	self.way1=world;
				self.followpath=FALSE;
			}
			if(self.goalentity==world)
			{	self.goalentity=self;
				self.followpath=FALSE;
			}
		}
	}
	botmovetogoal (dist);
};

void() bot_prethink=
{	if(intermission_running) return;

	if (self.deadflag >= DEAD_DEAD)
	{
		PlayerDeathThink ();
		return;
	}
	if(self.deadflag==DEAD_DYING) return;
	if (self.adjust_velocity_x != -999)
	{
		self.velocity_x = self.adjust_velocity_x;
	}
	if (self.adjust_velocity_y != -999)
	{
		self.velocity_y = self.adjust_velocity_y;
	}
	if (self.adjust_velocity_z != -999)
	{
		self.velocity_z = self.adjust_velocity_z;
	}
	self.adjust_velocity = '-999 -999 -999';

	self.friction=0;   // If in entity FRICTION_TOUCH will reset this

	CheckIncapacities();
	CheckRules ();
	CheckRings ();
	CheckAbilities ();
	CheckCrouch ();
	CheckPowerups();
	CheckRules();

	WaterLevel();
  	self.last_waterlevel=self.waterlevel;
	WaterMove();
	if (self.waterlevel == 2)
		CheckWaterJump ();
	else
	{	if((self.flags&FL_WATERJUMP)&&(self.velocity_z<10))
		{	self.flags(-)FL_WATERJUMP;
			self.velocity=self.velocity+v_forward*10;
		}
	}

	if((self.waterlevel)&&(!self.velocity_z))self.velocity_z=10;
	if((self.health<=0)&&(self.deadflag==DEAD_NO)&&(self.act_state!=ACT_DEAD))
		self.deadflag=DEAD_DYING;
	if(self.deadflag>=DEAD_DYING) return;
	if((self.jump_flag*(self.mass/10)<-500)&&(self.flags&FL_ONGROUND)&&(self.health>0))
	{	self.felltodeath=TRUE;
		T_Damage(self,world,world,5,"Botfall");
	}
	else if(self.health>0)
	{	self.felltodeath=FALSE;
	}
	if (!(self.flags & FL_ONGROUND))
		self.jump_flag = self.velocity_z;
	else
		self.last_onground=time;
	// Change weapon
	if (time > self.attack_finished && self.weapon != IT_WEAPON1)
	{
		if (((self.weapon == IT_WEAPON3) && (self.greenmana<1)) ||
			((self.weapon == IT_WEAPON4) && (self.bluemana<1) && (self.greenmana<1)))
		{
			W_BestWeapon ();
			W_SetCurrentWeapon ();
		}
	}
	// from postthink
	W_WeaponFrame ();
	if ((self.artifact_flags & AFL_TORCH) && (self.torchtime < time))
		self.torchthink ();

	if ((self.artifact_flags & AFL_SUPERHEALTH) && (self.healthtime < time))
		DecrementSuperHealth ();
	self.last_waterlevel=self.waterlevel;
};

