// evaluates the item for this bot
// - hexen weapons done
// - hexen armor done
// - hexen mana added
// - hexen artifacts and rings added
float(entity head) bot_itemvalue=
{       local float weaponstay, itemvalue,mfactor,pc;
	local vector horigin,borigin;

	itemvalue=0;
	mfactor=0;
	horigin=entityorigin(head);

	if ((!(deathmatch &1)) || (coop))
		weaponstay = 1;
	else
		weaponstay = 0;

	if(head.flags&FL_ITEM)
	{	if (head.classname=="wp_weapon2")
		{
			if(weaponstay)
			{	if(!(self.items&IT_WEAPON2))
					itemvalue=10;
				else
					itemvalue=0;
			}
			else
			{	itemvalue=15;
			}
			if(self.weapon==IT_WEAPON1) itemvalue=itemvalue*1.5;
		}
		else if (head.classname=="wp_weapon3")
		{
			if(weaponstay)
			{	if(!(self.items&IT_WEAPON3))
					itemvalue=15;
				else
					itemvalue=0;
			}
			else
			{	itemvalue=20;
			}
			if(self.weapon==IT_WEAPON1) itemvalue=itemvalue*1.5;
		}
		else if (head.classname=="wp_weapon4_staff")
		{
			if(weaponstay)
			{	if(!(self.items&IT_WEAPON4_1))
					itemvalue=20;
				else
					itemvalue=0;
			}
			else
			{	itemvalue=30;
			}
			if(self.items&IT_WEAPON4_1) itemvalue=itemvalue/2;
			if(self.bot_num==BOT_16) itemvalue=itemvalue*2;
			if(self.items&IT_WEAPON4_2) itemvalue=itemvalue*3;
		}
		else if (head.classname=="wp_weapon4_head")
		{
			if(weaponstay)
			{	if(!(self.items&IT_WEAPON4_2))
					itemvalue=20;
				else
					itemvalue=0;
			}
			else
			{	itemvalue=30;
			}
			if(self.items&IT_WEAPON4_2) itemvalue=itemvalue/2;
			if(self.bot_num==BOT_16) itemvalue=itemvalue*2;
			if(self.items&IT_WEAPON4_1) itemvalue=itemvalue*3;
		}
		else if (head.classname == "item_armor_amulet")
		{
			itemvalue=(20-self.armor_amulet)*ClassArmorProtection[self.playerclass - 1];
			itemvalue=itemvalue*5;
		}
		else if (head.classname == "item_armor_bracer")
		{
			itemvalue=(20-self.armor_bracer)*ClassArmorProtection[self.playerclass - 1 + 1];
			itemvalue=itemvalue*5;
		}
		else if (head.classname == "item_armor_breastplate")
		{
			itemvalue=(20-self.armor_breastplate)*ClassArmorProtection[self.playerclass - 1 + 2];
			itemvalue=itemvalue*5;
		}
		else if (head.classname == "item_armor_helmet")
		{
			itemvalue=(20-self.armor_helmet)*ClassArmorProtection[self.playerclass - 1 + 3];
			itemvalue=itemvalue*5;	// gives a max value of 25.
		}
		else if (head.classname == "item_mana_green")
		{
			itemvalue=(self.max_mana - self.greenmana)*0.3;
			itemvalue=itemvalue*(head.count/15);
			if(self.weapon&IT_WEAPON4) itemvalue=itemvalue*3;
			else if(self.weapon&IT_WEAPON3) itemvalue=itemvalue*2;
		}
		else if (head.classname == "item_mana_blue")
		{
			itemvalue=(self.max_mana - self.bluemana)*0.2;
			itemvalue=itemvalue*(head.count/15);
			if(self.weapon&IT_WEAPON4) itemvalue=itemvalue*3;
			else if(self.weapon&IT_WEAPON2) itemvalue=itemvalue*2;
		}
		else if (head.classname == "item_mana_both")
		{
			itemvalue=(self.max_mana - self.bluemana)*0.2+(self.max_mana - self.greenmana)*0.3;
			itemvalue=itemvalue*(head.count/15);
			if(self.weapon&IT_WEAPON4) itemvalue=itemvalue*3;
			else if((self.weapon&IT_WEAPON2)||(self.weapon&IT_WEAPON3)) itemvalue=itemvalue*2;
		}
		else if (head.classname=="item_health")
		{
			itemvalue=self.max_health - self.health;
			if (itemvalue<0) itemvalue=0;
			itemvalue=itemvalue/1.5;
		}
		else if(head.classname == "art_summon")
		{	itemvalue=15;
			if(self.cnt_summon>1) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_glyph")
		{	itemvalue=10;
			if(self.cnt_glyph>3) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_haste")
		{	itemvalue=15;
			if(self.cnt_haste>2) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_torch")
		{	itemvalue=5;
			if(self.cnt_torch>1) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_teleport")
		{	itemvalue=15;
			if(self.cnt_teleport>3) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_tomeofpower")
		{	itemvalue=25;
			if(self.cnt_tome>2) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_blastradius")
		{	itemvalue=18;
			if(self.cnt_blast>3) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_polymorph")
		{	itemvalue=30;
			if(self.cnt_polymorph>2) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_cubeofforce")
		{	itemvalue=20;
			if(self.cnt_cubeofforce>1) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_invincibility")
		{	itemvalue=30;
			if(self.cnt_invincibility>3) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_invisibility")
		{	itemvalue=14;
			if(self.cnt_invisibility>3) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_manaboost")
		{	itemvalue=20;
			if(self.cnt_mana_boost>3) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_SuperHBoost")
		{	itemvalue=40;
			if(self.cnt_sh_boost>5) itemvalue=itemvalue/3;
		}
		else if(head.classname == "art_HealthBoost")
		{	itemvalue=25;
			if(self.cnt_h_boost>10) itemvalue=itemvalue/3;
		}
		else if(head.classname == "Ring_Flight")
		{	itemvalue=10;
		}
		else if(head.classname == "Ring_WaterBreathing")
		{	itemvalue=10;
		}
		else if(head.classname == "Ring_Turning")
		{	itemvalue=10;
		}
		else if(head.classname == "Ring_Regeneration")
		{	itemvalue=35;
		}
		else if((head.classname=="soulcross")&&(self.playerclass==CLASS_CRUSADER))
		{	itemvalue=35;
		}
		else if((head.classname=="soulskull")&&(self.playerclass==CLASS_NECROMANCER))
		{	itemvalue=35;
		}
		else if(head.classname=="backpack")
		{	itemvalue=50;
			pc=pointcontents(head.origin);
			if((pc==CONTENT_LAVA)||(pc==CONTENT_SLIME))
				itemvalue=0;
			borigin=head.origin;
			borigin_z=head.absmin_z;
			pc=pointcontents(head.origin);
			if((pc==CONTENT_LAVA)||(pc==CONTENT_SLIME))
				itemvalue=0;
		}
	}
	else
	{	// keep level things separate - can always be seen unless
		// a specific wall_visible function is evoked.
		// (this is just level knowledge which a player will have).
		if(head.classname == "trigger_teleport")
		{
			if(self.teleport_time< (time - 5))
			{
				if(self.teleport_time< (time - 10))
				{
					if(self.teleport_time< (time - 20))
					{	itemvalue=7;
					}
					else itemvalue=5;
				}
				else itemvalue=3;
			}
			else itemvalue=0;
			if(!wall_visible(head))
			{ 	itemvalue=itemvalue/4;
			 	mfactor=1;
			}
		}
		else if ((head.classname=="door")||(head.classname=="func_button")||(head.classname=="func_wall")
			||(head.classname=="trigger_multiple")||(head.classname=="trigger_once")||(head.classname=="trigger_secret"))
		{	itemvalue=0;
			if((head.takedamage!=DAMAGE_NO)&&(head.health>0)&&(wall_visible(head)))
				itemvalue=7;
			else if((head.takedamage==DAMAGE_NO)&&(wall_visible(head))&&
				((head.state==STATE_BOTTOM)||(head.state==STATE_DOWN)))
				itemvalue=7;
			if(!wall_visible(head))
			{ 	itemvalue=itemvalue/4;
				mfactor=1;
			}
		}
	}

	if(!mfactor)
	{	if((!visible(head))||(head.solid==SOLID_NOT))
			itemvalue=0;
		else
		{	mfactor=vlen(self.origin - horigin) + 100;
			mfactor=500/mfactor;
		}
	}
	itemvalue=itemvalue*mfactor;

	if (self.bot_num<=BOT_2) itemvalue=itemvalue*(random()+0.5);
	if (itemvalue<2) itemvalue=0;
	else if(!CheckPitch(head)) itemvalue=0;

	return itemvalue;
};

// move into 'acquire mode'
void() BotHuntStuff =
{	local vector vp,vpstuff;
	local float dplaystuff,dwaystuff,dplayway,dpts,dplaypts;

	self.way1=world;
	self.way2=world;
	self.followpath=FALSE;
	self.reachedgoal=FALSE;
	self.way3=world;
	vp=self.origin+self.view_ofs;
	self.way5=nearestwaypoint(vp,TRUE);
	vpstuff=entityorigin(self.stuff);
	self.way6=nearestwaypoint(vpstuff,FALSE);

	if((self.way5!=world)&&(self.way6!=world))
	{	dplaystuff=vlen(self.origin - vpstuff);
		dwaystuff=vlen(self.way6.orgwaypt - vpstuff);
		dplayway=vlen(self.way5.orgwaypt - self.origin);
		dpts=vlen(self.way5.orgwaypt - self.way6.orgwaypt);
		dplaypts=vlen(self.way6.orgwaypt - self.origin);
		// quicker to go direct - but if near go through wp anyway
		if(dplaystuff<=dwaystuff - 80)
			self.goalentity = self.stuff;
		// or via one waypoint in between
		else if((self.way5==self.way6)&&(dplayway>64))
		{	self.goalentity=self.way5;
			self.way1=self.way5;
			self.way2=self.stuff;
			self.followpath=TRUE;
		}
		else if(self.way5==self.way6)
		{	self.goalentity=self.stuff;
		}
		else if(arelinked(self.way5,self.way6))
		{	if((dplayway>64)&&(dplaypts>dpts + 64))
			{	self.goalentity=self.way5;
				self.way1=self.way5;
				self.way2=self.way6;
				self.way3=self.stuff;
				self.followpath=TRUE;
			}
			else
			{	self.way1=self.way6;
				self.way2=self.stuff;
				self.way3=world;
				self.goalentity=self.way1;
				self.followpath=TRUE;
			}
		}
		else
		{	self.way1=self.way6;
			self.way2=world;
			self.way3=world;
			self.followpath=TRUE;
			self.goalentity=self.way6;
		}
	}
	else
        {	self.goalentity = self.stuff;
	}
        self.think = self.th_stuff;
	self.act_state=ACT_STUFF;
        self.ideal_yaw = vectoyaw(self.stuff.origin - self.origin);
	self.nextthink = time + 0.1;
};

// looks around for items and things. if it finds anything it wants
// then the bot will go for it.
float() BotFindStuff =
{       local entity head, selected;
	local float dist, itemvalue, bestvalue;
	
	if(self.search_time>time)
	{	if(self.stuff!=world)
		{	if(self.stuff.solid!=SOLID_NOT)
			{	if((self.goalentity!=world)&&(self.goalentity!=self)) return FALSE;
				BotHuntStuff();
				return TRUE;
			}
		}
	}
        dist = 500; 
	selected = world;
	bestvalue=0;
        head = findradius(self.origin, dist);
	while((!head)&&(dist<1000))
	{ 	dist=dist+500;
	  	head=findradius(self.origin,dist);
	}
	while(head)
	{	itemvalue=bot_itemvalue(head);
		if (itemvalue > bestvalue)
		{
			bestvalue = itemvalue;
			selected = head;
		}
		head = head.chain;
	}

	self.search_time = time + 5;
	if (self.bot_num>=BOT_15) self.search_time=time+2;

	if((noorigin(selected.classname))&&(selected.health>0)&&(selected.takedamage!=DAMAGE_NO))
	{
		self.enemy=selected;
		BotHuntTarget();
		self.attack_finished=time+2;
		return TRUE;
	}

        self.stuff = selected;
		
        if (self.stuff == world)
		return FALSE;

        BotHuntStuff();
	return TRUE;
};

// avoids rockets/grenades in a non-combat situation.
float() avoid_items=
{	local entity head,selected;
	local float nearest,dist,mspd,dp;
	local vector dirn,tmp,avpt;

	if(self.bot_num<=BOT_7) 
		return FALSE;
	if((self.bot_num<=BOT_12)&&(random()>0.2)) 
		return FALSE;

	nearest=300;
	head = findradius(self.origin, nearest);
	selected=world;

	while(head)
	{	dist=vlen(head.origin - self.origin);
		if((head.classname=="tornato")||(head.classname=="funnal"))
		{	if(dist<nearest)
			{	nearest=dist;
				selected=head;
			}
		}
		head=head.chain;
	}

	if(selected)
	{	dirn=self.origin - selected.origin;	
		mspd=vlen(selected.velocity);
		if(mspd>200) dirn = self.origin - (selected.origin + selected.velocity * 0.1);
		// just need to check it's not headed straight for us.
		// in which case we will be moving directly toward or away from it.
		// whereas we need to move off to the side.
		dirn_z=0;
		if(dirn=='0 0 0') dirn='1 0 0';
		dirn=normalize(dirn);
		tmp=vectoangles(selected.velocity);
		tmp_x=0;  // pitch
		makevectors(tmp);
		dp=dirn*v_forward;
		if((dp< -0.9)||(dp>0.9)) // about 25 degrees
		{	makevectors(self.angles);
			dirn=v_right;
			avpt=self.origin+dirn*10 - (selected.origin+selected.velocity*0.1);
			dist=vlen(avpt);
			if(dist<vlen(avpt - dirn*10)) dirn= -1.0 * dirn;
		}
		makevectors(self.angles);
		ai_bot_slide(dirn);
		return TRUE;
	}
	return FALSE;
};

float BotNormalUseArtifact()
{	if(time<self.artusedelay) return FALSE;
	if(self.bot_num>=BOT_14)
		self.artusedelay=time+1;
	else if (self.bot_num>=BOT_10)
		self.artusedelay=time+1.75;
	else if (self.bot_num>=BOT_7)
		self.artusedelay=time+2.5;
	else if (self.bot_num>=BOT_4)
		self.artusedelay=time+4;
	else
		self.artusedelay=time+5;
	if((self.cnt_h_boost>0)&&(self.health<0.3*self.max_health))
	{	if((self.bot_num>=BOT_12)||(random()>0.96))
		{	use_healthboost();
			return TRUE;
		}
	}
	else if((self.cnt_h_boost>0)&&(self.health<0.6*self.max_health))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.8)))
		{	use_healthboost();
			return TRUE;
		}
	}
	else if((!(self.artifact_flags&AFL_SUPERHEALTH))&&(self.cnt_sh_boost>0)&&(self.health<0.3*self.max_health))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.8)))
		{	use_super_healthboost();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_INVINCIBILITY))&&(self.cnt_invincibility>0)&&(random()>0.6))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	UseInvincibility();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_TOMEOFPOWER))&&(self.cnt_tome>0)&&(random()>0.5))
	{	if((self.bot_num<=BOT_12)||((self.bot_num<=BOT_8)&&(random()>0.7)))
		{	Use_TomeofPower();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_INVISIBILITY))&&(self.cnt_invisibility>0)&&(random()>0.7))
	{	if((self.bot_num<=BOT_12)||((self.bot_num<=BOT_8)&&(random()>0.7)))
		{	UseInvisibility();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_HASTE))&&(self.cnt_haste>0)&&(random()>0.7))
	{	if((self.bot_num<=BOT_12)||((self.bot_num<=BOT_8)&&(random()>0.7)))
		{	Use_Haste();
			return TRUE;
		}
	}
	if((self.cnt_mana_boost>0)&&(self.greenmana+self.bluemana<50)&&(random()>0.7))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.8))||((self.bot_num<BOT_5)&&(random()>0.9)))
		{	UseManaBoost();
			return TRUE;
		}
	}
	if((self.cnt_summon>0)&&(random()>0.7))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.8))||((self.bot_num<BOT_5)&&(random()>0.9)))
		{	Use_Summoner();
			return TRUE;
		}
	}
	return FALSE;
}
