// cut out normalise so can move diagonal (v_forward+v_right) etc.
void(vector dirn) add_velocity=
{	local float zold;
	if(self.flags&FL_ONGROUND)
	{	self.flags(-)FL_ONGROUND;
		zold=self.velocity_z;
		self.velocity_z=0;
		self.velocity=self.velocity*0.33+dirn*self.speed*self.scale*self.hasted*0.67;
		self.velocity_z=self.velocity_z+zold;
	}
};

// cut out normalise so can move diagonal (v_forward+v_right) etc.
void(vector dirn) set_velocity=
{	local float zold;
	local vector nrm;
	if(self.flags&FL_ONGROUND)
	{	self.flags(-)FL_ONGROUND;
		nrm=normalize(dirn);
		zold=self.velocity_z;
		self.velocity=nrm*self.speed*self.scale*self.hasted;
		self.velocity_z=zold;
	}
};

void(vector targorigin,float mdist) runtotarg=
{	local float pdist;
	local vector foot, footpt;

	pdist=vlen(self.mgorigin - self.origin);
	self.mgorigin=self.origin;

	self.ideal_yaw = vectoyaw(targorigin - self.origin);
	ChangeYaw ();
	self.v_angle=vectoangles(targorigin - self.origin);

	makevectors(self.angles);
	if((pdist <= 0.1 * mdist)&&(random()>0.9)&&(self.lastjump< time - 2))
	{	stuckmove();
		return;
	}
	else if (pdist <= 0.1 * mdist)
	{	movetogoal(mdist);
	}
	else if (pdist<=10)
	{	foot=self.origin+v_forward*16;
		footpt=foot+v_forward*10;
		traceline(foot,footpt,TRUE,self);
		if((trace_fraction<1)&&(self.velocity_z<20))
		{	movetogoal(mdist);
		}
		else botmove_forward();
	}
	else botmove_forward();
};

void(float mdist) botmovetogoal=
{	local entity tent,toldent;
	local float pd;
	local vector d;
	if(!mdist) mdist=20;
	movedist=mdist;
	if(noorigin(self.goalentity.classname))
	{	toldent=self.goalentity;
		tent=spawn(); // only used in movetogoal
		self.goalentity=tent;
		d=entityorigin(toldent);
		setorigin(tent,d);
		setsize (tent, '0 0 0', '0 0 0');
		tent.classname="goalent";
		pd=vlen(tent.origin - self.origin);
		if(pd<200)
		{	runtotarg(tent.origin,mdist);  // remember - uses movetoGOAL
			if(pd<50) self.goalentity=self;
		}
		else 
		{	movetogoal(mdist);
		}
		self.goalentity=toldent;
		remove(tent);
	}
	else if((self.way1!=world)&&(self.way2!=world))
	{	if(!self.followpath)
			runtotarg(self.way2.orgwaypt,mdist);
		else if(self.way1.classname=="botwaypoint")
			runtotarg(self.way1.orgwaypt,mdist);
		else 
		{	d=entityorigin(self.goalentity);
			runtotarg(d,mdist);
		}
	}
	else
	{	movetogoal(mdist);
	}
	makevectors(self.angles);
	add_velocity(v_forward);
};

void() bot_ai_swim=
{  	local   vector  dir;
	local float pdist;
  
	if(!movedist) movedist=20;
	makevectors (self.angles);

	pdist=vlen(self.mgorigin - self.origin);
	self.mgorigin=self.origin;

  	if (self.air_finished < time + 3)
  	{	traceline (self.origin, self.origin + '0 0 1000', TRUE, self);
		if ((trace_inopen) && (trace_inwater))
			dir = v_up;
    		else
    		{	traceline (self.origin, self.origin + v_forward * 32, TRUE, self);
	  		if (trace_fraction == 1.0)
	    			dir = v_forward;
	  		else
	  		{	traceline (self.origin, self.origin - v_right * 32, TRUE, self);
		  		if (trace_fraction == 1.0)
	        			dir = -1 * v_right;
		  		else
		  		{	traceline (self.origin, self.origin - v_forward * 32, TRUE, self);
					if (trace_fraction == 1.0)
  	          				dir = -1 * v_forward;
					else
						dir = v_right;
		  		}
	  		}
		}
  	}
  	else
  	{	if((self.goalentity==self)||(self.goalentity==world))
			self.goalentity=nearestwaypoint(self.origin,FALSE);
		self.ideal_yaw = vectoyaw(self.goalentity.origin - self.origin);
		ChangeYaw ();
		makevectors (self.angles);
		dir=v_forward;
		if (self.goalentity.origin_z>self.origin_z) dir=dir+v_up;
		else if(self.goalentity.origin_z<self.origin_z) dir=dir-v_up;
		dir=normalize(dir);
  	}

	if(pdist<10)
	{	dir=dir+v_right;	// possibly stuck
	}

  	self.velocity = self.velocity*0.45+dir*self.speed*self.hasted*self.scale*0.95;
	self.velocity = self.velocity*0.8;

  	if (self.flags & FL_ONGROUND)
  	{	if (self.velocity_z < 60)
      			self.velocity_z = 60;
    		self.flags(-)FL_ONGROUND;
  	}
	self.movetype=MOVETYPE_FLY;
	self.act_state=ACT_SWIM_FLY;
};

void() stuckmove=
{	local float dir;
	dir=360*random();
	self.ideal_yaw=dir;
	ChangeYaw();
	botmove_forward();
	makevectors(self.angles);

	check_jumpend();
	if(jumpinlava)
		return;	
	self.lastjump=time;
	self.lastjumpv=self.origin;

	makevectors(self.angles);
	add_velocity(v_forward);
	bot_jump();
	//self.think=bot_jump2;
	self.goalentity=self;
	self.way1=world;
	self.way2=world;
	self.way3=world;
};

// simulates player movements by only allowing movements in 45degree increments.
// yaw is just a desired yaw.
float (float yaw, float dist) botwalkmove=
{	local float d,forwst,rtwst;
	local vector vf,forw,rtw,fdir;
	d=vlen(self.wmorigin - self.origin);
	self.wmorigin=self.origin;
	vf='0 0 0';
	vf_y=yaw;

	makevectors(self.angles);
	forw=v_forward;
	rtw=v_right;

	makevectors(vf);
	forwst=v_forward*forw;	// v_forward cos of angle with yaw dir
	rtwst=v_right*rtw;	// v_right cos of angle with yaw dir

	// now approximate to forward/right only ie 45 degree increments
	// straightens angles out.
	if(forwst>0.25) forwst=1;
	else if (forwst<-0.25) forwst= -1;
	else forwst=0;
	if(rtwst>0.25) rtwst=1;
	else if (rtwst<-0.25) rtwst= -1;
	else rtwst=0;

	makevectors(self.angles);
	fdir=v_forward*forwst+v_right*rtwst;	// simulates fore/back with strafe
	add_velocity(fdir);
	if (d<=dist*0.1) return FALSE;
	return TRUE;
};

void() botmove_forward =
{
	makevectors(self.angles);
	add_velocity(v_forward);
};

void() botmove_back =
{	local vector vf;
	makevectors(self.angles);
	vf= -1.0 * v_forward;
	add_velocity(vf);
};
