void ()	bot_jump=
{
	if (self.flags & FL_WATERJUMP)
		return;
	
	if (self.waterlevel >= 2)
	{
		if (self.watertype == CONTENT_WATER)
			self.velocity_z = 100;
		else if (self.watertype == CONTENT_SLIME)
			self.velocity_z = 80;
		else
			self.velocity_z = 50;

		// no swimming sound for bots - it makes loads of noise without this
		if (self.swim_flag < time)
		{
			self.swim_flag = time + 1;
		}
		return;
	}
	self.flags = self.flags - (self.flags & FL_ONGROUND);
	setorigin (self, self.origin + '0 0 1');
	self.velocity_z = self.velocity_z + 270;
	self.think=bot_frames;
	self.act_state=ACT_JUMP;
};

void() jump_forward =
{	local float jdist;
	if (!(self.flags & FL_ONGROUND)) // The bot can ONLY jump if he is on the ground
                return; // If he's not then don't jump

	jdist=vlen(self.lastjumpv-self.origin);

	if((jdist<100)&&(self.lastjump > time - 2)) //stuck are we ?
	{	stuckmove();
		return;
	}

	self.lastjump=time;
	self.lastjumpv=self.origin;
	makevectors(self.angles);
	set_velocity(v_forward*0.707);
	bot_jump();
};

// note - bot can jump 42.4 units high under normal gravity, need to check
// this is achieved in the formula
void() check_jumpend=
{	local vector cvel,cpos,cdir,cposold,pchk,pchk2;
	local float pc,i,j;
	jumphigh=FALSE;
	jumpinlava=FALSE;
	cpos=self.origin;
	cvel=v_forward*self.speed*0.707;
	cvel_z=self.velocity_z+270;
	i=0;
	while(i<25)
	{	cdir=normalize(cvel);
		j=vlen(cvel);
		j=j/20;
		cposold=cpos;
		cpos=cpos+cdir*j;
		cvel=cvel-'0 0 1'*(self.gravity/15.5);
		traceline(cposold,cpos,TRUE,self);
		pc=pointcontents(trace_endpos);
		if(pc==CONTENT_LAVA)
		{	jumpinlava=TRUE;
			return;
		}
		if(pc==CONTENT_SOLID)
		{	// made it - just check a few nearby points in case its a wall
			// and above lava or anything
			cdir_z=0;
			cdir=normalize(cdir);

			// drop a line down from a point before
			pchk=trace_endpos - cdir*16;
			pchk2=pchk;
			pchk2_z=pchk2_z - 1000;
			traceline(pchk,pchk2,TRUE,self);
			pc=pointcontents(trace_endpos);
			if(pc==CONTENT_LAVA) jumpinlava=TRUE;

			// now check even further back
			pchk=trace_endpos - cdir*32;
			pchk2=pchk;
			pchk2_z=pchk2_z - 1000;
			traceline(pchk,pchk2,TRUE,self);
			pc=pointcontents(trace_endpos);
			if(pc==CONTENT_LAVA) jumpinlava=TRUE;

			// finally check just before
			pchk=trace_endpos - cdir;
			pchk2=pchk;
			pchk2_z=pchk2_z - 1000;
			traceline(pchk,pchk2,TRUE,self);
			pc=pointcontents(trace_endpos);
			if(pc==CONTENT_LAVA) jumpinlava=TRUE;

			// is it really high ?
			if(trace_fraction==1) jumphigh=TRUE;
			return;
		}
	}
	jumphigh=TRUE;
};

float() check_for_ledge =
{
	local vector spot,spot2,spot3,spot4;
	local float i,j,prev_frac,cfrac;

        if (!(self.flags & FL_ONGROUND)) // The bot can ONLY jump if he is on the ground
                return FALSE; // If he's not then don't jump

        makevectors (self.angles); // Jump the way he's facing
        spot = self.origin + (v_forward * 15);  // bottom of feet
	spot3= spot + '0 0 25'; // from here
	spot4= spot - '0 0 25'; // to here, a vertical cane to move forward
	spot2=spot3+v_forward*20;
	traceline(spot3,spot2,TRUE,self);
	j=10*trace_fraction;
	if(j<1)return FALSE; // how far can we go before a wall ?
	prev_frac=0.5;
	i=0;
	while(i<j)
	{	traceline(spot3,spot4,TRUE,self);
		cfrac=trace_fraction-prev_frac;
		if(((trace_fraction<0.1)||(trace_fraction>0.9))&&((cfrac>0.4)||(cfrac< -0.4)))
		{	check_jumpend();
			if(jumphigh)
			{	if(self.bot_num>=BOT_14)
				{	if (random()>0.05) return FALSE; 
				}
				else if(self.bot_num>=BOT_9)
				{	if (random()>0.2) return FALSE;
				}
			}
			if(jumpinlava) return FALSE;
			self.act_state=ACT_JUMP;
			jump_forward();
			return TRUE;
		}
		prev_frac=trace_fraction;
		i=i+1;
		spot3=spot3+v_forward*2;
		spot4=spot4+v_forward*2;
	}
	return FALSE;
};

