/*
	range - slightly modified for bots.
*/
float(entity targ) botrange =
{
	vector	spot1, spot2;
	float	r;	

	spot1 = self.origin + self.view_ofs;

	if((targ.solid==SOLID_BSP||targ.solid==SOLID_TRIGGER)&&targ.origin=='0 0 0')
		spot2=(targ.absmax+targ.absmin)*0.5;
	else
		spot2 = targ.origin + targ.view_ofs;
	
	r = vlen (spot1 - spot2);

	if (r < 64)
		return RANGE_MELEE;
	if (r < 500)
		return RANGE_NEAR;
	if (r < 1000)
		return RANGE_MID;
	return RANGE_FAR;
};

/*
 * CheckAttack() -- The player is in view, so decide to move or launch an
 *                  attack.  Returns FALSE if movement should continue.
 */

float BotCheckAttack()
{
	local vector	spot1, spot2;	
	local entity	targ;
	local float	chance;

	targ = self.enemy;
	
// see if any entities are in the way of the shot
	spot1 = self.origin + self.view_ofs;
	spot2 = (targ.absmin+targ.absmax)*0.5;

	traceline (spot1, spot2, FALSE, self);

	if(trace_ent.thingtype>=THINGTYPE_WEBS)
		traceline (trace_endpos, spot2, FALSE, trace_ent);

	if (trace_ent != targ)
		if(trace_ent.health>25||!trace_ent.takedamage||(trace_ent.flags&FL_MONSTER&&trace_ent.classname!="player_sheep"))
			return FALSE;//Don't have a clear shot, and don't want to shoot obstruction
			
//FIXME: check for translucent water?
	if (trace_inopen && trace_inwater)
		return FALSE;			// sight line crossed contents

	enemy_range=botrange(self.enemy);
	
// missile attack
	if (!self.th_missile)
		return FALSE;
		
	if (time < self.attack_finished)
		return FALSE;
		
	if (enemy_range == RANGE_FAR)
		chance=0.02;
	else if (enemy_range == RANGE_MELEE)
	{
		chance = 0.9;
		self.attack_finished = 0;
	}
	else if (enemy_range == RANGE_NEAR)
	{
		chance = 0.4;
	}
	else if (enemy_range == RANGE_MID)
	{
		chance = 0.1;
	}
	else
		chance = 0;
	if(skill>2) 
		chance=(1 - chance)*0.2+chance;
	else if(skill<2)
		chance=chance*0.8;
	if(self.f1) chance=chance+0.8; // aggression!

	if(enemy_range!=RANGE_MELEE)
	{	if(IsMeleeWeapon(self.playerclass,self.weapon,self.artifact_active))
			chance=0;
	}
	if (random () < chance)
	{	W_Attack();
		return TRUE;
	}

	return FALSE;
}

float strength_assess(entity t)
{	float strn;
	strn=t.health;
	if(t.artifact_active&ART_INVINCIBILITY) strn=strn+500;
	if(t.artifact_active&ART_TOMEOFPOWER) strn=strn+t.health*1.5+30;
	if(t.artifact_active&ART_INVISIBILITY) strn=strn+t.health+20;
	if(t.artifact_active&ART_HASTE) strn=strn+15;
	if(t.health<10) strn-=100;
	else if (t.health<20) strn-=30;
	strn=strn+t.cnt_h_boost*5;
	strn=strn+t.cnt_sh_boost*10;
	if(t.weapon==IT_WEAPON4) strn=strn+40;
	else if (t.weapon==IT_WEAPON3) strn=strn+20;
	else if (t.weapon==IT_WEAPON2) strn=strn+10;
	if(t.artifact_active&ARTFLAG_FROZEN)
		strn-=250;
	if(t.sheep_time>time)
		strn-=250;
	return strn;
}

float BotCombatUseArtifact()
{	float	rstrength,r,re;
	r=strength_assess(self);
	re=strength_assess(self.enemy);
	rstrength=r - re;

	// now set v_angle to look up/down along current direction facing.
	self.v_angle=vectoangles(self.enemy.origin - self.origin);
	self.v_angle_y=self.angles_y;

	if((self.cnt_h_boost>0)&&(self.health<50))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	use_healthboost();
			return TRUE;
		}
	}
	if((self.cnt_sh_boost>0)&&(self.health<30))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	use_super_healthboost();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_INVINCIBILITY))&&(self.cnt_invincibility>0)&&(rstrength<-50))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	UseInvincibility();
			return TRUE;
		}
	}
	if((self.cnt_polymorph>0)&&(rstrength<-10))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	Use_Polymorph();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_TOMEOFPOWER))&&(self.cnt_tome>0)&&(rstrength<0))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	Use_TomeofPower();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_INVISIBILITY))&&(self.cnt_invisibility>0)&&(rstrength<20))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	UseInvisibility();
			return TRUE;
		}
	}
	if((self.cnt_teleport>0)&&((rstrength<-40)||(self.health<20))&&(self.cnt_sh_boost==0))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	Use_TeleportCoin();
			return TRUE;
		}
	}
	if((!(self.artifact_active&ART_HASTE))&&(self.cnt_haste>0)&&(rstrength<0))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	Use_Haste();
			return TRUE;
		}
	}
	if((self.cnt_blast>0)&&(rstrength<0))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	UseBlast();
			return TRUE;
		}
	}
	if((self.cnt_cubeofforce>0)&&(rstrength<-20)&&(random()>0.7))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	UseCubeOfForce();
			return TRUE;
		}
	}
	if((self.cnt_glyph>0)&&(rstrength<20)&&(random()>0.85))
	{	if((self.bot_num>=BOT_12)||((self.bot_num>=BOT_5)&&(random()>0.7)))
		{	self.cnt_glyph-=1;
			if(self.playerclass==CLASS_ASSASSIN)
				Use_Tripwire();
			else if(self.playerclass==CLASS_CRUSADER)
				Use_TimeBomb ();
			else if(self.playerclass==CLASS_PALADIN)
				Use_Fireball();
			else if(self.playerclass==CLASS_NECROMANCER)
				Use_Proximity_Mine();
			return TRUE;
		}
	}
	return FALSE;
}

void() bot_attack =
{
	if (!W_CheckNoAmmo (self.weapon))
	{
		W_BestWeapon ();
		if((self.playerclass==CLASS_CRUSADER)&&(self.weapon==IT_WEAPON2)&&(self.enemy.artifact_active & ARTFLAG_FROZEN))
			self.weapon=IT_WEAPON1;
		W_SetCurrentWeapon ();
		return;
	}
	
	if(self.attack_finished>time)
		return;

	if(self.sheep_time>time)
	{
		player_sheep_baa();
		return;
	}

	self.show_hostile = time + 1;	// wake monsters up
	self.last_attack=time;			//In attack state

	if(self.hull==HULL_PLAYER)
		self.act_state=ACT_ATTACK;
	else
		self.act_state=ACT_CROUCH_MOVE;

	if (self.weapon == IT_WEAPON1)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_gauntlet_fire();
		else if (self.playerclass==CLASS_NECROMANCER)
			self.th_missile();
		else if (self.playerclass==CLASS_ASSASSIN)
			Ass_Pdgr_Fire();
		else if (self.playerclass==CLASS_CRUSADER)
			Cru_Wham_Fire();
	}
	else if (self.weapon == IT_WEAPON2)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_vorpal_fire();
		else if(self.playerclass==CLASS_ASSASSIN)
			crossbow_fire();
		else if(self.playerclass==CLASS_CRUSADER)
		{
			if(self.th_weapon==icestaff_idle)
				Cru_Ice_Fire();
		}
		else if(self.playerclass==CLASS_NECROMANCER)
			self.th_missile();
	}
	else if (self.weapon == IT_WEAPON3)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_axe_fire();
		else if (self.playerclass==CLASS_ASSASSIN)
			grenade_throw();
		else if (self.playerclass==CLASS_CRUSADER)
			Cru_Met_Attack();
		else if(self.playerclass==CLASS_NECROMANCER)
			self.th_missile();
	}
	else if (self.weapon == IT_WEAPON4)
	{
		if (self.playerclass==CLASS_PALADIN)
			pal_purifier_fire();
		else if(self.playerclass==CLASS_ASSASSIN)
			ass_setstaff_fire();
		else if (self.playerclass==CLASS_CRUSADER)
			Cru_Sun_Fire();
		else if(self.playerclass==CLASS_NECROMANCER)
			ravenstaff_fire();
	}
};

