void() ai_no_evade=
{ // null function - no evasion
};

void(vector dirn) ai_bot_slide=
{	local float ofs;
	
	// used for pickup of items and avoidance in combat
	ofs=vectoyaw(dirn);
	botwalkmove(ofs,movedist);
};

void() ai_bot_retreat_strafe=
{	local float	ofs,ad;
	local vector	oldorg;

	ofs = self.ideal_yaw + 135 + 90 * self.lefty;
	
	ofs=anglemod(ofs);
	oldorg=self.origin;
	if (botwalkmove (ofs, movedist))
	{	return;
	}
	ad=vlen(self.origin-oldorg);
	if(ad < 0.2 * movedist)
		self.lefty = 1 - self.lefty;
};

void() ai_bot_charge_strafe=
{	local float	ofs,ad;
	local vector	oldorg;

	ofs = self.ideal_yaw - 45 + 90 * self.lefty;
	
	ofs=anglemod(ofs);
	oldorg=self.origin;
	if (botwalkmove (ofs, movedist))
	{	return;
	}
	ad=vlen(self.origin-oldorg);
	if(ad < 0.2 * movedist)
		self.lefty = 1 - self.lefty;
};

void() ai_bot_charge=
{	botmove_forward();
};

void() ai_bot_retreat=
{	botmove_back();
};

// either avoid rockets/grenades or pickup nearby needed items.
float() avoid_pickup_items=
{	local entity head,selected;
	local float avoidai,nearest,dist,mspd,dp;
	local vector dirn,tmp,avpt;

	if(self.bot_num<=BOT_5) 
		return FALSE;
	if((self.bot_num<=BOT_9)&&(random()>0.2)) 
		return FALSE;

	nearest=300;
	head = findradius(self.origin, nearest);
	avoidai=FALSE;
	selected=world;

	while(head)
	{	dist=vlen(head.origin - self.origin);
		if(head.movetype==MOVETYPE_FLYMISSILE||head.movetype==MOVETYPE_BOUNCE||head.movetype==MOVETYPE_BOUNCEMISSILE)
		{	if((dist<nearest)||(avoidai==FALSE))
			{	nearest=dist;
				selected=head;
				avoidai=TRUE;
			}
		}
		else if(!avoidai)
		{	if(bot_itemvalue(head)>40)
				if(dist<nearest)
				{	nearest=dist;
					selected=head;
				}
		}
		head=head.chain;
	}
	if(avoidai)
	{	// avoid selected
		dirn=self.origin - selected.origin;	
		mspd=vlen(selected.velocity);
		if(mspd>200) dirn = self.origin - (selected.origin + selected.velocity * 0.1);
		// just need to check it's not headed straight for us.
		// in which case we will be moving directly toward or away from it.
		// whereas we need to move off to the side.
		dirn_z=0;
		if(dirn=='0 0 0') dirn='1 0 0';
		dirn=normalize(dirn);
		tmp=vectoangles(selected.velocity);
		tmp_x=0; // pitch =0
		makevectors(tmp);
		dp=dirn*v_forward;
		if((dp< -0.9)||(dp>0.9)) // about 25 degrees
		{	makevectors(self.angles);
			dirn=v_right;
			avpt=self.origin+dirn*10 - (selected.origin+selected.velocity*0.1);
			dist=vlen(avpt);
			if(dist<vlen(avpt - dirn*10)) dirn= -1.0 * dirn;
		}
		makevectors(self.angles);
		ai_bot_slide(dirn);
		return TRUE;
	}
	else if(selected)
	{	// pickup selected
		dirn=selected.origin - self.origin;
		dirn_z=0;
		dirn=normalize(dirn);
		ai_bot_slide(dirn);
		return TRUE;
	}
	return FALSE;
};

void() bot_evade=
{	local float dist;
	dist=vlen(self.enemy.origin-self.origin);
	enemy_range = range(self.enemy);
	bot_face();

	if(self.th_evade==ai_no_evade)
	{	self.th_evade();
		return;
	}

	if(avoid_pickup_items())
		return;

	if(self.bot_num>=BOT_9) 
		self.th_evade=ai_run_slide;
	else if((self.bot_num>=BOT_4)&&(random()<0.2)) 
		self.th_evade=ai_run_slide;

	// wounded and outclassed - retreat
	if(((self.health<25)&&(self.enemy.health>self.health))||(self.artifact_active & ART_TOMEOFPOWER)||(self.artifact_active & ART_INVINCIBILITY))
	{	if(self.bot_num>=BOT_10) 
			self.th_evade=ai_bot_retreat_strafe;
		else if((self.bot_num>=BOT_6)&&(random()>0.3)) 
			self.th_evade=ai_bot_retreat_strafe;
		else if(self.bot_num>=BOT_3)
			self.th_evade=ai_bot_retreat;
	}
	else if(self.items&IT_WEAPON4)
	{	if((dist<350)&&(self.weapon==IT_WEAPON4))
		{	if(self.bot_num>=BOT_10)
				self.th_evade=ai_bot_retreat_strafe;
			else if((self.bot_num>=BOT_6)&&(random()>0.4)) 
				self.th_evade=ai_bot_retreat_strafe;
		}
	}

	if(self.weapon==IT_WEAPON1)
	{	if((self.bot_num>=BOT_13)||((self.bot_num>=BOT_6)&&(random()>0.4)))
		{	if(self.health - 25 > self.enemy.health)
				self.th_evade=ai_bot_charge;
			else
			{	if((self.bot_num>=BOT_10)||((self.bot_num>=BOT_3)&&(random()>0.4)))
					self.th_evade=ai_bot_retreat_strafe;
				else
					self.th_evade=ai_bot_retreat;
			}
		}
		else
			self.th_evade=ai_no_evade;
	}
	else if(dist<150)
	{	if((self.bot_num>=BOT_9)||((self.bot_num>=BOT_3)&&(random()>0.4)))
			self.th_evade=ai_bot_retreat_strafe;
		else if(((self.bot_num>=BOT_2)&&(random()>0.6))||((self.bot_num>=BOT_7)&&(random()>0.2)))  
			self.th_evade=ai_bot_retreat;
	}

	if(self.th_evade==SUB_Null)
		self.th_evade=ai_no_evade;

	self.th_evade();
};

