/*
==============================================================================

ALL BOTS FRAME CONTROL!!!
- put after playanim.hc in progs.src

==============================================================================
*/
void bot_frames ()
{
	float weapmod, startframe,endframe,framestate,sas;
	if((self.act_state==ACT_JUMP)&&(self.flags&FL_ONGROUND)) self.act_state=ACT_RUN;
	if(self.deadflag)
		self.act_state=ACT_DEAD;

	if(self.act_state<ACT_JUMP||(self.playerclass==CLASS_NECROMANCER&&self.act_state<=ACT_JUMP))
	{
		if(self.weapon==IT_WEAPON4)
			weapmod=3;
		if(self.weapon==IT_WEAPON3)
			weapmod=2;
		if(self.weapon==IT_WEAPON2)
			weapmod=1;
		if(self.weapon==IT_WEAPON1)
			weapmod=0;
	}
	else
		weapmod=0;
	sas=self.act_state;
	if(sas==ACT_STUFF) sas=ACT_RUN;
	startframe = player_start_frames	[(self.playerclass - 1) * 4 + sas*16 + weapmod];
	if(self.waterlevel<3&&self.movetype==MOVETYPE_FLY)
		endframe=startframe;
	else
		endframe = player_end_frames	[(self.playerclass - 1) * 4 + sas*16 + weapmod];

	if(self.act_state!=ACT_CROUCH_STAND)
		framestate=AdvanceFrame(startframe,endframe);

	self.think=bot_frames;
	thinktime self : 0.1;

	if(self.act_state!=ACT_DEAD)
		if(self.viewentity==self||self.viewentity.classname=="chasecam")
			self.th_weapon();

	if(self.act_state==ACT_SWIM_FLY)
	{	bot_explore(10);		// calls bot_ai_swim
		if(self.waterlevel<2) self.movetype=MOVETYPE_STEP;
		if(self.movetype!=MOVETYPE_FLY)
				self.act_state=ACT_RUN;
	}
	else if(self.act_state==ACT_STAND)
	{	bot_ai_stand();
		if(self.hull==HULL_CROUCH)
			self.act_state=ACT_CROUCH_STAND;
		else
			self.act_state=ACT_RUN;
	}
	else if(self.act_state==ACT_RUN)
	{	bot_explore(10);
		if(self.hull==HULL_CROUCH)
			self.act_state=ACT_CROUCH_MOVE;
	}
	else if(self.act_state==ACT_STUFF)
	{	bot_ai_stuff(10);
		if(self.hull==HULL_CROUCH)
			self.act_state=ACT_CROUCH_MOVE;
	}
	else if(self.act_state==ACT_CROUCH_STAND)
	{//NOTE: all 3 have 20 crouch frames
		bot_explore(10);
		if(self.hull==HULL_PLAYER)
			self.act_state=ACT_STAND;
		else if(self.frame>endframe || self.frame<startframe)
			self.frame=startframe;
		else if (self.velocity_x || self.velocity_y)
			self.act_state=ACT_CROUCH_MOVE;
	}
	else if(self.act_state==ACT_CROUCH_MOVE)
	{	bot_explore(10);
		if(self.hull==HULL_PLAYER)
			self.act_state=ACT_RUN;
		else if (!self.velocity_x && !self.velocity_y)
			self.act_state=ACT_CROUCH_STAND;
	}
	else if(self.act_state==ACT_ATTACK||self.act_state==ACT_JUMP||self.act_state==ACT_PAIN)
	{	if(self.act_state==ACT_ATTACK) bot_combat(10);
		else if((self.act_state==ACT_JUMP)&&(self.flags&FL_ONGROUND)) self.act_state=ACT_RUN;
		else if(self.act_state==ACT_PAIN) bot_painmove(10);
		if(framestate==AF_END)
		{
			self.act_state=ACT_RUN;
		}
	}

	if(self.act_state==ACT_DEAD)
	{
		if(self.frame==startframe&&!deathmatch)
			if(self.enemy.flags2&FL_ALIVE&&visible(self.enemy))
				self.pausetime=time+3;

		if(self.view_ofs_z - 2.5 >= 8)//Drop view
			self.view_ofs_z-=2.5;

		if(framestate==AF_END)
		{
			self.view_ofs='0 0 8';
			self.think=PlayerDead;
			thinktime self : 0.1;
		}
	}
	else if(self.waterlevel>2||self.movetype==MOVETYPE_FLY)//overrides all others
		self.act_state=ACT_SWIM_FLY;
}

void()	bot_frames_behead =
{//Note: give playerclass!
	self.level=player_start_frames[ACT_DECAP * 16 + (self.playerclass - 1) * 4];
	self.dmg=player_end_frames[ACT_DECAP * 16 + (self.playerclass - 1) * 4];
	self.cnt=0;
	player_behead();
};

