/* -- Player.h --
Part of the Worminator 2D game engine
Copyright 1998 by David Layne

For function descriptions and explanations, see proto.h
For a detailed explanation of how the engine works, see
the documents that came with this source code package. */

/*****************\
|** PUSH PLAYER **|
\*****************/
void push_player(float x_amount, float y_amount)
{
unsigned char info_value_1, info_value_2, info_value_3;
int x_rel, y_rel;

// Drop down test
if (x_amount == 512 && y_amount == -512) {
	if (player.on_ground == FALSE) return;
	player.y_position_in_pixels++;
	info_value_1 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 4) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];
	info_value_2 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];
	info_value_3 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 27) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];
	if ((info_value_1 == solid_from_top_allow_ammo_info_tile || info_value_2 == solid_from_top_allow_ammo_info_tile || info_value_3 == solid_from_top_allow_ammo_info_tile) || (info_value_1 == solid_from_top_no_ammo_info_tile || info_value_2 == solid_from_top_no_ammo_info_tile || info_value_3 == solid_from_top_no_ammo_info_tile)) {
		if (info_value_1 == solid_info_tile || info_value_2 == solid_info_tile || info_value_3 == solid_info_tile) player.y_position_in_pixels--;
		else if (info_value_1 == solid_from_top_no_drop_info_tile || info_value_2 == solid_from_top_no_drop_info_tile || info_value_3 == solid_from_top_no_drop_info_tile) player.y_position_in_pixels--;
		else if (info_value_1 == painful_from_top_info_tile || info_value_2 == painful_from_top_info_tile || info_value_3 == painful_from_top_info_tile) player.y_position_in_pixels--;
		else if (info_value_1 == painful_from_bottom_info_tile || info_value_2 == painful_from_bottom_info_tile || info_value_3 == painful_from_bottom_info_tile) player.y_position_in_pixels--;
		else if (info_value_1 == breakable_wall_info_tile || info_value_2 == breakable_wall_info_tile || info_value_3 == breakable_wall_info_tile) player.y_position_in_pixels--;
		else player.on_ground = FALSE;
		}
	else (player.y_position_in_pixels--);
	return;
	}

if (x_amount > 1) x_amount = 1;
else if (x_amount < -1) x_amount = -1;
if (y_amount > 1) y_amount = 1;
else if (y_amount < -1) y_amount = -1;

// Right
if (x_amount > 0) {
	player.x_position_in_pixels += x_amount;
	if (player.x_position_in_pixels > 4064) player.x_position_in_pixels = 4064;
	if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_left_to_right_45_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 15 - x_rel) {player.y_position_in_pixels -= 1; player.on_ground = TRUE; /*return;*/}
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_left_to_right_225_left_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 15 - x_rel / 2) {player.y_position_in_pixels -= 1; player.on_ground = TRUE; /*return;*/}
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_left_to_right_225_right_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 7 - x_rel / 2) {player.y_position_in_pixels -= 1; player.on_ground = TRUE; /*return;*/}
		}
	info_value_1 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 27) / 16)][(int)((player.y_position_in_pixels + 2) / 16)];
	info_value_2 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 27) / 16)][(int)((player.y_position_in_pixels + 15) / 16)];
	info_value_3 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 27) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];

	if (info_value_1 == blank_info_tile && info_value_2 == blank_info_tile && info_value_3 == blank_info_tile) return;

	if (info_value_1 == solid_info_tile || info_value_2 == solid_info_tile || info_value_3 == solid_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == solid_from_left_allow_ammo_info_tile || info_value_2 == solid_from_left_allow_ammo_info_tile || info_value_3 == solid_from_left_allow_ammo_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == solid_from_left_no_ammo_info_tile || info_value_2 == solid_from_left_no_ammo_info_tile || info_value_3 == solid_from_left_no_ammo_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == painful_from_top_info_tile || info_value_2 == painful_from_top_info_tile || info_value_3 == painful_from_top_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == painful_from_bottom_info_tile || info_value_2 == painful_from_bottom_info_tile || info_value_3 == painful_from_bottom_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == breakable_wall_info_tile || info_value_2 == breakable_wall_info_tile || info_value_3 == breakable_wall_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == conveyor_belt_right_info_tile || info_value_2 == conveyor_belt_right_info_tile || info_value_3 == conveyor_belt_right_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == conveyor_belt_left_info_tile || info_value_2 == conveyor_belt_left_info_tile || info_value_3 == conveyor_belt_left_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == half_slippery_info_tile || info_value_2 == half_slippery_info_tile || info_value_3 == half_slippery_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == mostly_slippery_info_tile || info_value_2 == mostly_slippery_info_tile || info_value_3 == mostly_slippery_info_tile) player.x_position_in_pixels -= x_amount;

	player_touched((player.x_position_in_pixels + 27) / 16, (player.y_position_in_pixels + 2) / 16);
	player_touched((player.x_position_in_pixels + 27) / 16, (player.y_position_in_pixels + 15) / 16);
	player_touched((player.x_position_in_pixels + 27) / 16, (player.y_position_in_pixels + 31) / 16);
	return;
	}

// Left
else if (x_amount < 0) {
	player.x_position_in_pixels += x_amount;
	if (player.x_position_in_pixels < 0) player.x_position_in_pixels = 0;
	if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_right_to_left_45_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= x_rel) {player.y_position_in_pixels -= 1; player.on_ground = TRUE; /*return;*/}
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_right_to_left_225_left_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= x_rel / 2) {player.y_position_in_pixels -= 1; player.on_ground = TRUE; /*return;*/}
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_right_to_left_225_right_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 7 + x_rel / 2) {player.y_position_in_pixels -= 1; player.on_ground = TRUE; /*return;*/}
		}
	info_value_1 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 4) / 16)][(int)((player.y_position_in_pixels + 2) / 16)];
	info_value_2 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 4) / 16)][(int)((player.y_position_in_pixels + 15) / 16)];
	info_value_3 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 4) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];

      if (info_value_1 == blank_info_tile && info_value_2 == blank_info_tile && info_value_3 == blank_info_tile) return;

	if (info_value_1 == solid_info_tile || info_value_2 == solid_info_tile || info_value_3 == solid_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == solid_from_right_allow_ammo_info_tile || info_value_2 == solid_from_right_allow_ammo_info_tile || info_value_3 == solid_from_right_allow_ammo_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == solid_from_right_no_ammo_info_tile || info_value_2 == solid_from_right_no_ammo_info_tile || info_value_3 == solid_from_right_no_ammo_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == painful_from_top_info_tile || info_value_2 == painful_from_top_info_tile || info_value_3 == painful_from_top_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == painful_from_bottom_info_tile || info_value_2 == painful_from_bottom_info_tile || info_value_3 == painful_from_bottom_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == breakable_wall_info_tile || info_value_2 == breakable_wall_info_tile || info_value_3 == breakable_wall_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == conveyor_belt_right_info_tile || info_value_2 == conveyor_belt_right_info_tile || info_value_3 == conveyor_belt_right_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == conveyor_belt_left_info_tile || info_value_2 == conveyor_belt_left_info_tile || info_value_3 == conveyor_belt_left_info_tile) player.x_position_in_pixels -= x_amount;

	else if (info_value_1 == half_slippery_info_tile || info_value_2 == half_slippery_info_tile || info_value_3 == half_slippery_info_tile) player.x_position_in_pixels -= x_amount;
	else if (info_value_1 == mostly_slippery_info_tile || info_value_2 == mostly_slippery_info_tile || info_value_3 == mostly_slippery_info_tile) player.x_position_in_pixels -= x_amount;

	player_touched((player.x_position_in_pixels + 4) / 16, (player.y_position_in_pixels + 2) / 16);
	player_touched((player.x_position_in_pixels + 4) / 16, (player.y_position_in_pixels + 15) / 16);
	player_touched((player.x_position_in_pixels + 4) / 16, (player.y_position_in_pixels + 31) / 16);
	return;
	}

// Down
else if (y_amount > 0) {
	player.y_position_in_pixels += y_amount;
	if (player.y_position_in_pixels > 3040) player.y_position_in_pixels = 3040, player.on_ground = TRUE;
	if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_left_to_right_45_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 15 - x_rel) {player.y_position_in_pixels -= y_amount; player.on_ground = TRUE; return;}
		else return;
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_left_to_right_225_left_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 15 - x_rel / 2) {player.y_position_in_pixels -= y_amount; player.on_ground = TRUE; return;}
		else return;
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_left_to_right_225_right_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 7 - x_rel / 2) {player.y_position_in_pixels -= y_amount; player.on_ground = TRUE; return;}
		else return;
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_right_to_left_45_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= x_rel) {player.y_position_in_pixels -= y_amount; player.on_ground = TRUE; return;}
		else return;
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_right_to_left_225_left_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= x_rel / 2) {player.y_position_in_pixels -= y_amount; player.on_ground = TRUE; return;}
		else return;
		}
	else if (worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)] == slope_up_right_to_left_225_right_info_tile) {
		x_rel = abs((((int)player.x_position_in_pixels + 15) / 16 * 16) - player.x_position_in_pixels - 15);
		y_rel = abs((((int)player.y_position_in_pixels + 31) / 16 * 16) - player.y_position_in_pixels - 31);
		if (y_rel >= 8 + x_rel / 2) {player.y_position_in_pixels -= y_amount; player.on_ground = TRUE; return;}
		else return;
		}
	info_value_1 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 4) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];
	info_value_2 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];
	info_value_3 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 27) / 16)][(int)((player.y_position_in_pixels + 31) / 16)];

	if (info_value_1 == blank_info_tile && info_value_2 == blank_info_tile && info_value_3 == blank_info_tile) return;

	if (info_value_1 == solid_info_tile || info_value_2 == solid_info_tile || info_value_3 == solid_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;

	else if ((info_value_1 == solid_from_top_no_drop_info_tile || info_value_2 == solid_from_top_no_drop_info_tile || info_value_3 == solid_from_top_no_drop_info_tile) && (int)player.y_position_in_pixels + 31 == (int)((player.y_position_in_pixels + 31) / 16) * 16) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
	else if ((info_value_1 == solid_from_top_allow_ammo_info_tile || info_value_2 == solid_from_top_allow_ammo_info_tile || info_value_3 == solid_from_top_allow_ammo_info_tile) && (int)player.y_position_in_pixels + 31 == (int)((player.y_position_in_pixels + 31) / 16) * 16) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
	else if ((info_value_1 == solid_from_top_no_ammo_info_tile || info_value_2 == solid_from_top_no_ammo_info_tile || info_value_3 == solid_from_top_no_ammo_info_tile) && (int)player.y_position_in_pixels + 31 == (int)((player.y_position_in_pixels + 31) / 16) * 16) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
	else if ((info_value_1 == slope_filler_info_tile || info_value_2 == slope_filler_info_tile || info_value_3 == slope_filler_info_tile) && (int)player.y_position_in_pixels + 31 == (int)((player.y_position_in_pixels + 31) / 16) * 16) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;

	else if (info_value_1 == painful_from_bottom_info_tile || info_value_2 == painful_from_bottom_info_tile || info_value_3 == painful_from_bottom_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
	else if (info_value_1 == painful_from_top_info_tile || info_value_2 == painful_from_top_info_tile || info_value_3 == painful_from_top_info_tile) {
		player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
		if (player.timer == 0) hurt_player(-1);
		if (player.health_bars_left < 1) return;
		}

	else if (info_value_1 == breakable_wall_info_tile || info_value_2 == breakable_wall_info_tile || info_value_3 == breakable_wall_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;

	else if (info_value_1 == conveyor_belt_right_info_tile || info_value_2 == conveyor_belt_right_info_tile || info_value_3 == conveyor_belt_right_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount, push_player(.615, 0);
	else if (info_value_1 == conveyor_belt_left_info_tile || info_value_2 == conveyor_belt_left_info_tile || info_value_3 == conveyor_belt_left_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount, push_player(-.615, 0);

	else if (info_value_1 == half_slippery_info_tile || info_value_2 == half_slippery_info_tile || info_value_3 == half_slippery_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
	else if (info_value_1 == mostly_slippery_info_tile || info_value_2 == mostly_slippery_info_tile || info_value_3 == mostly_slippery_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;

	player_touched((player.x_position_in_pixels + 4) / 16, (player.y_position_in_pixels + 31) / 16);
	player_touched((player.x_position_in_pixels + 15) / 16, (player.y_position_in_pixels + 31) / 16);
	player_touched((player.x_position_in_pixels + 27) / 16, (player.y_position_in_pixels + 31) / 16);
	return;
	}
// Up
else if (y_amount < 0) {
	player.y_position_in_pixels += y_amount;
	if (player.y_position_in_pixels < 0) player.y_position_in_pixels = 0, player.y_acceleration = 0;

	info_value_1 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 4) / 16)][(int)((player.y_position_in_pixels + 2) / 16)];
	info_value_2 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 15) / 16)][(int)((player.y_position_in_pixels + 2) / 16)];
	info_value_3 = worminator_map.info_tile_grid[(int)((player.x_position_in_pixels + 27) / 16)][(int)((player.y_position_in_pixels + 2) / 16)];

	if (info_value_1 == blank_info_tile && info_value_2 == blank_info_tile && info_value_3 == blank_info_tile) return;

	if (info_value_1 == solid_info_tile || info_value_2 == solid_info_tile || info_value_3 == solid_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;

	else if (info_value_1 == solid_from_bottom_allow_ammo_info_tile || info_value_2 == solid_from_bottom_allow_ammo_info_tile || info_value_3 == solid_from_bottom_allow_ammo_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;
	else if (info_value_1 == solid_from_bottom_no_ammo_info_tile || info_value_2 == solid_from_bottom_no_ammo_info_tile || info_value_3 == solid_from_bottom_no_ammo_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;

	else if (info_value_1 == painful_from_top_info_tile || info_value_2 == painful_from_top_info_tile || info_value_3 == painful_from_top_info_tile) player.on_ground = TRUE, player.y_position_in_pixels -= y_amount;
	else if (info_value_1 == painful_from_bottom_info_tile || info_value_2 == painful_from_bottom_info_tile || info_value_3 == painful_from_bottom_info_tile) {
		player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;
		if (player.timer == 0) hurt_player(-1);
		if (player.health_bars_left < 1) return;
		}

	else if (info_value_1 == breakable_wall_info_tile || info_value_2 == breakable_wall_info_tile || info_value_3 == breakable_wall_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;

	else if (info_value_1 == conveyor_belt_right_info_tile || info_value_2 == conveyor_belt_right_info_tile || info_value_3 == conveyor_belt_right_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;
	else if (info_value_1 == conveyor_belt_left_info_tile || info_value_2 == conveyor_belt_left_info_tile || info_value_3 == conveyor_belt_left_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;

	else if (info_value_1 == half_slippery_info_tile || info_value_2 == half_slippery_info_tile || info_value_3 == half_slippery_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;
	else if (info_value_1 == mostly_slippery_info_tile || info_value_2 == mostly_slippery_info_tile || info_value_3 == mostly_slippery_info_tile) player.y_acceleration = 0, player.y_position_in_pixels -= y_amount;

	player_touched((player.x_position_in_pixels + 4) / 16, (player.y_position_in_pixels + 2) / 16);
	player_touched((player.x_position_in_pixels + 15) / 16, (player.y_position_in_pixels + 2) / 16);
	player_touched((player.x_position_in_pixels + 27) / 16, (player.y_position_in_pixels + 2) / 16);
	return;
	}
}

/********************\
|** PLAYER TOUCHED **|
\********************/
char player_touched(int x_tile_location, int y_tile_location)
{
int touched_info_tile;
int spawn_loop, frame_loop;
int x_tile_loop, y_tile_loop;

// This variable helps shorten the if statements and prevent redundant calculations
touched_info_tile = worminator_map.info_tile_grid[x_tile_location][y_tile_location];

// A lethal tile that will always kill the Worminator
if (touched_info_tile == lethal_info_tile) { player.timer = 0; hurt_player(-10); return; }

// A very painful info tile that will hurt the Worminator a lot
if (touched_info_tile == very_painful_info_tile && player.timer == 0) { hurt_player(-5); return; }

// A painful info tile that will hurt the Worminator
if (touched_info_tile == painful_info_tile && player.timer == 0) { hurt_player(-1); return; }

// Quick teleport info tiles
if (touched_info_tile >= quick_teleporter_1_info_tile && touched_info_tile <= quick_teleporter_16_info_tile) {
	for (x_tile_loop = 0; x_tile_loop < worminator_map.map_width; x_tile_loop++) {
		for (y_tile_loop = 0; y_tile_loop < worminator_map.map_height; y_tile_loop++) {
			if (worminator_map.info_tile_grid[x_tile_loop][y_tile_loop] == touched_info_tile + 80) {
				player.x_position_in_pixels = x_tile_loop * 16;
				player.y_position_in_pixels = y_tile_loop * 16;
				player.y_acceleration = 0;
				check_enemy_ranges();
				} 
			}
		}
	}

// Quick exit level info tiles
if (touched_info_tile >= quick_exit_to_level_1_info_tile && touched_info_tile <= quick_exit_to_level_16_info_tile) {
	game_is_running = FALSE;
	current_level = (touched_info_tile - quick_exit_to_level_1_info_tile) + 1;
	load_map("");
	return TRUE;
	}
}

/***********************\
|** PICK PLAYER FRAME **|
\***********************/
void pick_player_frame()
{
int damage_frame_shift = ((10 - player.health_bars_left) / 2.5);
if (player.skin == DAMAGED_WORM_1_SKIN) damage_frame_shift = 1;
else if (player.skin == DAMAGED_WORM_2_SKIN) damage_frame_shift = 2;
else if (player.skin == DAMAGED_WORM_3_SKIN) damage_frame_shift = 3;
else if (damage_frame_shift > 3) damage_frame_shift = 3;

if (player.skin == WORMINATOR_SKIN || player.skin == DAMAGED_WORM_1_SKIN || player.skin == DAMAGED_WORM_2_SKIN || player.skin == DAMAGED_WORM_3_SKIN) {
	if (player.in_water == FALSE) {
		if (player.on_ground == FALSE) player.frame = WORMINATOR_JUMP_SET_01 + damage_frame_shift;
		else if (player.x_acceleration != 0) {
			if (player.on_ground == TRUE) {
				player.animation_timer++;
				if (player.animation_timer == 16) {
					if (player.frame < WORMINATOR_WALK_01_SET_01 || player.frame > WORMINATOR_WALK_04_SET_04) player.frame = WORMINATOR_WALK_01_SET_01 + damage_frame_shift;
					else player.frame+= 4;
					if (player.frame > WORMINATOR_WALK_04_SET_04) player.frame = WORMINATOR_WALK_01_SET_01 + damage_frame_shift;
					player.animation_timer = 0;
					}
				}
			}
		else player.frame = WORMINATOR_STAND_SET_01 + damage_frame_shift;
		}
	else {
		player.animation_timer++;
		if (player.animation_timer == 16) {
			if (player.frame >= WORMINATOR_SWIM_01_SET_01 && player.frame <= WORMINATOR_SWIM_03_SET_04) {
				player.frame+= 4;
				if (player.frame > WORMINATOR_SWIM_04_SET_04) player.frame = WORMINATOR_SWIM_01_SET_01 + damage_frame_shift;
				}
			else player.frame = WORMINATOR_SWIM_01_SET_01 + damage_frame_shift;
			player.animation_timer = 0;
			}
		}
	}
else if (player.skin == THE_BRAIN_SKIN) {
	if (player.on_ground == FALSE) player.frame = SKIN_THE_BRAIN_JUMP;
	else if (player.x_acceleration != 0) {
		if (player.on_ground == TRUE) {
			player.animation_timer++;
			if (player.animation_timer == 16) {
				if (player.frame < SKIN_THE_BRAIN_WALK_01 || player.frame > SKIN_THE_BRAIN_WALK_04) player.frame = SKIN_THE_BRAIN_WALK_01;
				else player.frame++;
				if (player.frame > SKIN_THE_BRAIN_WALK_04) player.frame = SKIN_THE_BRAIN_WALK_01;
				player.animation_timer = 0;
				}
			}
		}
	else player.frame = SKIN_THE_BRAIN_STAND;
	}
else if (player.skin == THE_YIPNIK_MIKIMBO_SKIN) {
	if (player.on_ground == FALSE) player.frame = SKIN_THE_YIPNIK_MIKIMBO_JUMP;
	else if (player.x_acceleration != 0) {
		if (player.on_ground == TRUE) {
			player.animation_timer++;
			if (player.animation_timer == 16) {
				if (player.frame < SKIN_THE_YIPNIK_MIKIMBO_WALK_01 || player.frame > SKIN_THE_YIPNIK_MIKIMBO_WALK_04) player.frame = SKIN_THE_YIPNIK_MIKIMBO_WALK_01;
				else player.frame++;
				if (player.frame > SKIN_THE_YIPNIK_MIKIMBO_WALK_04) player.frame = SKIN_THE_YIPNIK_MIKIMBO_WALK_01;
				player.animation_timer = 0;
				}
			}
		}
	else player.frame = SKIN_THE_YIPNIK_MIKIMBO_STAND;
	}
else if (player.skin == ORIGINAL_WORMINATOR_SKIN) player.frame = SKIN_ORIGINAL_WORMINATOR_STAND;
else if (player.skin == HOTDOG_HERO_SKIN) {
	if (player.on_ground == FALSE) player.frame = SKIN_HOTDOG_HERO_JUMP;
	else if (player.x_acceleration != 0) {
		if (player.on_ground == TRUE) {
			player.animation_timer++;
			if (player.animation_timer == 16) {
				if (player.frame < SKIN_HOTDOG_HERO_WALK_01 || player.frame > SKIN_HOTDOG_HERO_WALK_02) player.frame = SKIN_HOTDOG_HERO_WALK_01;
				else player.frame++;
				if (player.frame > SKIN_HOTDOG_HERO_WALK_02) player.frame = SKIN_HOTDOG_HERO_WALK_01;
				player.animation_timer = 0;
				}
			}
		}
	else player.frame = SKIN_HOTDOG_HERO_STAND;
	}
else if (player.skin == VOODOO_BADIE_SKIN) {
	if (player.on_ground == FALSE) player.frame = SKIN_VOODOO_BADIE_JUMP;
	else if (player.x_acceleration != 0) {
		if (player.on_ground == TRUE) {
			player.animation_timer++;
			if (player.animation_timer == 16) {
				if (player.frame < SKIN_VOODOO_BADIE_WALK_01 || player.frame > SKIN_VOODOO_BADIE_WALK_02) player.frame = SKIN_VOODOO_BADIE_WALK_01;
				else player.frame++;
				if (player.frame > SKIN_VOODOO_BADIE_WALK_02) player.frame = SKIN_VOODOO_BADIE_WALK_01;
				player.animation_timer = 0;
				}
			}
		}
	else player.frame = SKIN_VOODOO_BADIE_STAND;
	}
else if (player.skin == YUANTI_SKIN) {
	if (player.on_ground == FALSE) player.frame = SKIN_YUANTI_JUMP;
	else if (player.x_acceleration != 0) {
		if (player.on_ground == TRUE) {
			player.animation_timer++;
			if (player.animation_timer == 16) {
				if (player.frame < SKIN_YUANTI_WALK_01 || player.frame > SKIN_YUANTI_WALK_04) player.frame = SKIN_YUANTI_WALK_01;
				else player.frame++;
				if (player.frame > SKIN_YUANTI_WALK_04) player.frame = SKIN_YUANTI_WALK_01;
				player.animation_timer = 0;
				}
			}
		}
	else player.frame = SKIN_YUANTI_STAND;
	}
}

/*****************\
|** DRAW PLAYER **|
\*****************/
void draw_player()
{
int sx_anchor = player.x_position_in_pixels - screen_x_position, sy_anchor = player.y_position_in_pixels - screen_y_position;

// Don't draw any frame if there is no frame selected
if (player.frame != NULL) {

	// This makes the worminator flash when he has been hurt
	if (((int)((int)(player.timer / 24) / 2) == ((int)(player.timer / 24) / 2.0)) || player.timer == 0) {
		if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[player.frame].dat, sx_anchor, sy_anchor);
		else draw_sprite_h_flip(double_buffer, worminator_data_file[player.frame].dat, sx_anchor, sy_anchor);

		// This is the minigun code
                if (player.current_weapon == 1 && player.bullets_left >= 0) {
			if (player.bullets_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 6) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_TURN].dat, sx_anchor + 15, sy_anchor + 12);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_TURN].dat, sx_anchor - 4, sy_anchor + 12);
					}
				else if (fire_key_state > 4) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_FIRE_03].dat, sx_anchor + 15, sy_anchor + 12);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_FIRE_03].dat, sx_anchor - 10, sy_anchor + 12);
					}
				else if (fire_key_state > 2) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_FIRE_02].dat, sx_anchor + 15, sy_anchor + 12);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_FIRE_02].dat, sx_anchor - 10, sy_anchor + 12);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_FIRE_01].dat, sx_anchor + 15, sy_anchor + 12);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINIGUN_FIRE_01].dat, sx_anchor - 9, sy_anchor + 12);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINIGUN].dat, sx_anchor + 15, sy_anchor + 12);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINIGUN].dat, sx_anchor - 4, sy_anchor + 12);
				}
			}

		// This is the shotgun code
		if (player.current_weapon == 2 && player.shells_left >= 0) {
			if (player.shells_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 120) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 108) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_01].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_01].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 96) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_02].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_02].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 84) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_03].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_03].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 72) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_02].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_02].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 60) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_01].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_COCK_01].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 48) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 36) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor - 5, sy_anchor + 11);
					}
				else if (fire_key_state > 24) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_FIRE_03].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_FIRE_03].dat, sx_anchor - 9, sy_anchor + 11);
					}
				else if (fire_key_state > 12) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_FIRE_02].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_FIRE_02].dat, sx_anchor - 9, sy_anchor + 11);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_FIRE_01].dat, sx_anchor + 13, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN_FIRE_01].dat, sx_anchor - 9, sy_anchor + 11);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor + 13, sy_anchor + 11);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_SHOTGUN].dat, sx_anchor - 5, sy_anchor + 11);
				}
			}

		// Only the first two weapons are avalible under water
		if (player.in_water == TRUE) return;

		// This is the rocket launcher code
		if (player.current_weapon == 3 && player.rockets_left >= 0) {
			if (player.rockets_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 25) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER].dat, sx_anchor - 3, sy_anchor + 11);
					}
				else if (fire_key_state > 20) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor - 6, sy_anchor + 11);
					}
				else if (fire_key_state > 15) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor - 7, sy_anchor + 11);
					}
				else if (fire_key_state > 10) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_03].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_03].dat, sx_anchor - 7, sy_anchor + 11);
					}
				else if (fire_key_state > 5) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor - 7, sy_anchor + 11);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor - 6, sy_anchor + 11);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER].dat, sx_anchor + 11, sy_anchor + 11);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_ROCKET_LAUNCHER].dat, sx_anchor - 3, sy_anchor + 11);
				}
			}

		// This is the dual rocket launcher code
		if (player.current_weapon == 4 && player.rockets_left >= 0) {
			if (player.rockets_left > 1 && fire_key_state != 0) {
				if (fire_key_state > 35) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER].dat, sx_anchor + 12, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER].dat, sx_anchor - 2, sy_anchor + 10);
					}
				else if (fire_key_state > 30) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor + 12, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor - 8, sy_anchor + 10);
					}
				else if (fire_key_state > 25) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor + 12, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor - 9, sy_anchor + 10);
					}
				else if (fire_key_state > 20) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_03].dat, sx_anchor + 12, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_03].dat, sx_anchor - 12, sy_anchor + 9);
					}
				else if (fire_key_state > 15) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_04].dat, sx_anchor + 12, sy_anchor + 8);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_04].dat, sx_anchor - 14, sy_anchor + 8);
					}
				else if (fire_key_state > 10) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_03].dat, sx_anchor + 12, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_03].dat, sx_anchor - 12, sy_anchor + 9);
					}
				else if (fire_key_state > 5) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor + 12, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_02].dat, sx_anchor - 9, sy_anchor + 10);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor + 12, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER_FIRE_01].dat, sx_anchor - 8, sy_anchor + 10);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER].dat, sx_anchor + 12, sy_anchor + 10);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_DUAL_ROCKET_LAUNCHER].dat, sx_anchor - 2, sy_anchor + 10);
				}
			}

		// This is the laser gun code
		if (player.current_weapon == 5 && player.cells_left >= 0) {
			if (player.cells_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 15) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN].dat, sx_anchor + 11, sy_anchor + 12);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN].dat, sx_anchor - 6, sy_anchor + 12);
					}
				else if (fire_key_state > 7) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN_FIRE_01].dat, sx_anchor + 11, sy_anchor + 12);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN_FIRE_01].dat, sx_anchor - 11, sy_anchor + 12);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN_FIRE_02].dat, sx_anchor + 11, sy_anchor + 11);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN_FIRE_02].dat, sx_anchor - 17, sy_anchor + 11);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN].dat, sx_anchor + 11, sy_anchor + 12);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_LASER_GUN].dat, sx_anchor - 6, sy_anchor + 12);
				}
			}

		// This is the flamethrower code
		if (player.current_weapon == 6 && player.gasoline_left >= 0) {
			if (player.gasoline_left > 0 && fire_key_state != 0) {
				if (fire_key_state >= 6 && fire_key_state <= 38) {
					if (player.direction == 0) do_damage(player.x_position_in_pixels + 32, player.y_position_in_pixels + 8, 36, 14, .15);
					else do_damage(player.x_position_in_pixels - 37, player.y_position_in_pixels + 8, 36, 14, .05);
					}
				else {
					if (player.direction == 0) do_damage(player.x_position_in_pixels + 32, player.y_position_in_pixels + 7, 64, 16, .15);
					else do_damage(player.x_position_in_pixels - 64, player.y_position_in_pixels + 7, 64, 16, .05);
					}
				if (fire_key_state > 44) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_01].dat, sx_anchor + 10, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_01].dat, sx_anchor - 15, sy_anchor + 10);
					}
				else if (fire_key_state > 42) {

					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_02].dat, sx_anchor + 10, sy_anchor + 8);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_02].dat, sx_anchor - 22, sy_anchor + 8);
					}
				else if (fire_key_state > 40) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_03].dat, sx_anchor + 10, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_03].dat, sx_anchor - 28, sy_anchor + 9);
					}
				else if (fire_key_state > 38) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_04].dat, sx_anchor + 10, sy_anchor + 8);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_04].dat, sx_anchor - 37, sy_anchor + 8);
					}
				else if (fire_key_state > 36) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_05].dat, sx_anchor + 10, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_05].dat, sx_anchor - 39, sy_anchor + 9);
					}
				else if (fire_key_state > 34) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_06].dat, sx_anchor + 10, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_06].dat, sx_anchor - 44, sy_anchor + 9);
					}
				else if (fire_key_state > 32) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_07].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_07].dat, sx_anchor - 56, sy_anchor + 7);
					}
				else if (fire_key_state > 30) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_08].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_08].dat, sx_anchor - 62, sy_anchor + 7);
					}
				else if (fire_key_state > 28) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_09].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_09].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 26) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_10].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_10].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 24) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_11].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_11].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 22) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_12].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_12].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 20) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_11].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_11].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 18) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_10].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_10].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 16) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_09].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_09].dat, sx_anchor - 65, sy_anchor + 7);
					}
				else if (fire_key_state > 14) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_08].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_08].dat, sx_anchor - 62, sy_anchor + 7);
					}
				else if (fire_key_state > 12) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_07].dat, sx_anchor + 10, sy_anchor + 7);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_07].dat, sx_anchor - 56, sy_anchor + 7);
					}
				else if (fire_key_state > 10) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_06].dat, sx_anchor + 10, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_06].dat, sx_anchor - 44, sy_anchor + 9);
					}
				else if (fire_key_state > 8) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_05].dat, sx_anchor + 10, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_05].dat, sx_anchor - 39, sy_anchor + 9);
					}
				else if (fire_key_state > 6) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_04].dat, sx_anchor + 10, sy_anchor + 8);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_04].dat, sx_anchor - 37, sy_anchor + 8);
					}
				else if (fire_key_state > 4) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_03].dat, sx_anchor + 10, sy_anchor + 9);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_03].dat, sx_anchor - 28, sy_anchor + 9);
					}
				else if (fire_key_state > 2) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_02].dat, sx_anchor + 10, sy_anchor + 8);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_02].dat, sx_anchor - 22, sy_anchor + 8);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_01].dat, sx_anchor + 10, sy_anchor + 10);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER_FIRE_01].dat, sx_anchor - 15, sy_anchor + 10);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER].dat, sx_anchor + 10, sy_anchor + 12);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_FLAMETHROWER].dat, sx_anchor - 1, sy_anchor + 12);
				}
			}

		// This is the mortar cannon code
		if (player.current_weapon == 7 && player.mortars_left >= 0) {
			if (player.mortars_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 60) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_07].dat, sx_anchor + 10, sy_anchor + 1);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_07].dat, sx_anchor, sy_anchor + 1);
					}
				else if (fire_key_state > 50) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_06].dat, sx_anchor + 10, sy_anchor + 1);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_06].dat, sx_anchor, sy_anchor + 1);
					}
				else if (fire_key_state > 40) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_05].dat, sx_anchor + 10, sy_anchor + 1);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_05].dat, sx_anchor + 1, sy_anchor + 1);
					}
				else if (fire_key_state > 30) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_04].dat, sx_anchor + 10, sy_anchor + 1);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_04].dat, sx_anchor, sy_anchor + 1);
					}
				else if (fire_key_state > 20) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_03].dat, sx_anchor + 10, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_03].dat, sx_anchor, sy_anchor + 2);
					}
				else if (fire_key_state > 10) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_02].dat, sx_anchor + 10, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_02].dat, sx_anchor, sy_anchor + 2);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_01].dat, sx_anchor + 10, sy_anchor + 3);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON_FIRE_01].dat, sx_anchor + 1, sy_anchor + 3);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON].dat, sx_anchor + 10, sy_anchor + 7);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MORTAR_CANNON].dat, sx_anchor + 4, sy_anchor + 7);
				}
			}

		// This is the BFG code
		if (player.current_weapon == 8 && player.plasma_left >= 0) {
			if (player.plasma_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 160) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG].dat, sx_anchor + 3, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG].dat, sx_anchor, sy_anchor + 2);
					}
				else if (fire_key_state > 150) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_06].dat, sx_anchor + 2, sy_anchor);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_06].dat, sx_anchor - 32, sy_anchor);
					}
				else if (fire_key_state > 120) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_05].dat, sx_anchor + 2, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_05].dat, sx_anchor, sy_anchor + 2);
					}
				else if (fire_key_state > 90) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_04].dat, sx_anchor + 3, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_04].dat, sx_anchor, sy_anchor + 2);
					}
				else if (fire_key_state > 60) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_03].dat, sx_anchor + 3, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_03].dat, sx_anchor, sy_anchor + 2);
					}
				else if (fire_key_state > 30) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_02].dat, sx_anchor + 3, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_02].dat, sx_anchor, sy_anchor + 2);

				}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_01].dat, sx_anchor + 3, sy_anchor + 2);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG_FIRE_01].dat, sx_anchor, sy_anchor + 2);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_BFG].dat, sx_anchor + 3, sy_anchor + 2);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_BFG].dat, sx_anchor, sy_anchor + 2);
				}
			}

		// This is the Minelayer code
		if (player.current_weapon == 9 && player.mines_left >= 0) {
			if (player.mines_left > 0 && fire_key_state != 0) {
				if (fire_key_state > 100) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_11].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_11].dat, sx_anchor + 12, sy_anchor + 4);
					}
				else if (fire_key_state > 90) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_10].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_10].dat, sx_anchor + 11, sy_anchor + 4);
					}
				else if (fire_key_state > 80) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_09].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_09].dat, sx_anchor + 10, sy_anchor + 4);
					}
				else if (fire_key_state > 70) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_08].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_08].dat, sx_anchor + 9, sy_anchor + 4);
					}
				else if (fire_key_state > 60) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_07].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_07].dat, sx_anchor + 9, sy_anchor + 4);
					}
				else if (fire_key_state > 50) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_06].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_06].dat, sx_anchor + 8, sy_anchor + 4);
					}
				else if (fire_key_state > 40) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_05].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_05].dat, sx_anchor + 1, sy_anchor + 4);
					}
				else if (fire_key_state > 30) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_04].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_04].dat, sx_anchor + 2, sy_anchor + 4);
					}
				else if (fire_key_state > 20) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_03].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_03].dat, sx_anchor + 2, sy_anchor + 4);
					}
				else if (fire_key_state > 10) {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_02].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_02].dat, sx_anchor + 3, sy_anchor + 4);
					}
				else {
					if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_01].dat, sx_anchor + 6, sy_anchor + 4);
					else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER_LAY_01].dat, sx_anchor + 4, sy_anchor + 4);
					}
				}
			else {
				if (player.direction == 0) draw_sprite(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER].dat, sx_anchor + 6, sy_anchor + 4);
				else draw_sprite_h_flip(double_buffer, worminator_data_file[WORMINATOR_MINE_LAYER].dat, sx_anchor + 5, sy_anchor + 4);
				}
			}
		}
	}
}

/***************************\
|** CHECK PLAYER TELEPORT **|
\***************************/
char check_player_teleport()
{
unsigned char x_start = NULL, y_start = NULL;
unsigned char test_tile_number, teleport_tile_number;

int x_tile_loop, y_tile_loop;

for(x_tile_loop = player.x_position_in_pixels - 4; x_tile_loop < player.x_position_in_pixels + 19; x_tile_loop += 11) {
	for(y_tile_loop = player.y_position_in_pixels - 8; y_tile_loop <= player.y_position_in_pixels + 24; y_tile_loop += 16) {
		test_tile_number = worminator_map.info_tile_grid[(int)(x_tile_loop / 16)][(int)(y_tile_loop / 16)];
		if (test_tile_number >= teleporter_1_info_tile && test_tile_number <= teleporter_16_info_tile) {
			x_start = (int)(x_tile_loop / 16), y_start = (int)(y_tile_loop / 16);
			teleport_tile_number = test_tile_number;
			}
		else if (test_tile_number >= exit_to_level_1_info_tile && test_tile_number <= exit_to_level_16_info_tile) {
			game_is_running = FALSE;
			if (alert("Do you really want", "to exit this level", "right now?", "Yes", "No", NULL, NULL) == 1) {
				current_level = (test_tile_number - exit_to_level_1_info_tile) + 1;
				load_map("");
				return TRUE;
				}
			game_is_running = TRUE;
			return FALSE;
			}
		}
	}

if (x_start != NULL && y_start != NULL) {
	for (x_tile_loop = 0; x_tile_loop < worminator_map.map_width; x_tile_loop++) {
		for (y_tile_loop = 0; y_tile_loop < worminator_map.map_height; y_tile_loop++) {
			if (worminator_map.info_tile_grid[x_tile_loop][y_tile_loop] == teleport_tile_number && (x_tile_loop != x_start || y_tile_loop != y_start)) {
				player.x_position_in_pixels = x_tile_loop * 16;/* + (player.x_position_in_pixels - x_start * 16);*/
				player.y_position_in_pixels = y_tile_loop * 16;/* + (player.y_position_in_pixels - y_start * 16);*/
				player.y_acceleration = 0;
				check_enemy_ranges();
				} 
			}
		}
	}
return FALSE;
}

/******************\
|** CLEAR PLAYER **|
\******************/
void clear_player()
{
player.timer = NULL;
player.width = NULL;
player.height = NULL;
player.frame = NULL;
player.animation_timer = NULL;
player.direction = NULL;
player.current_weapon = NULL;
player.on_ground = NULL;
player.in_water = FALSE;
player.letter_order = NULL;
player.health_bars_left = 10;
player.has_red_keycard = FALSE, player.has_green_keycard = FALSE, player.has_blue_keycard = FALSE;
player.bullets_left = -1, player.shells_left = -1, player.rockets_left = -1, player.cells_left = -1, player.gasoline_left = -1, player.mortars_left = -1, player.plasma_left = -1, player.mines_left = -1;
player.x_position_in_pixels = NULL;
player.y_position_in_pixels = NULL;
player.x_acceleration = NULL;
player.y_acceleration = NULL;
player.skin = WORMINATOR_SKIN;

desired_weapon = 0;
turbo_launch = FALSE;
}

/*************************\
|** UPDATE PLAYER STATS **|
\*************************/
void update_player_stats()
{
// Refresh the ammo display
blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 292, 140, 292, 140, 20, 8);
if (player.current_weapon == 0)  sprintf(message, "000");
else if (player.current_weapon == 1 && player.bullets_left > 0) sprintf(message, "%-5d", player.bullets_left);
else if (player.current_weapon == 1 && player.bullets_left <= 0) sprintf(message, "000");
else if (player.current_weapon == 2 && player.shells_left > 0) sprintf(message, "%-5d", player.shells_left);
else if (player.current_weapon == 2 && player.shells_left <= 0) sprintf(message, "000");
else if ((player.current_weapon == 3 || player.current_weapon == 4) && player.rockets_left > 0) sprintf(message, "%-5d", player.rockets_left);
else if ((player.current_weapon == 3 || player.current_weapon == 4) && player.rockets_left <= 0) sprintf(message, "000");
else if (player.current_weapon == 5 && player.cells_left > 0) sprintf(message, "%-5d", player.cells_left);
else if (player.current_weapon == 5 && player.cells_left <= 0) sprintf(message, "000");
else if (player.current_weapon == 6 && player.gasoline_left > 0) sprintf(message, "%-5d", player.gasoline_left);
else if (player.current_weapon == 6 && player.gasoline_left <= 0) sprintf(message, "000");
else if (player.current_weapon == 7 && player.mortars_left > 0) sprintf(message, "%-5d", player.mortars_left);
else if (player.current_weapon == 7 && player.mortars_left <= 0) sprintf(message, "000");
else if (player.current_weapon == 8 && player.plasma_left > 0) sprintf(message, "%-5d", player.plasma_left);
else if (player.current_weapon == 8 && player.plasma_left <= 0) sprintf(message, "000");
else if (player.current_weapon == 9 && player.mines_left > 0) sprintf(message, "%-5d", player.mines_left);
else if (player.current_weapon == 9 && player.mines_left <= 0) sprintf(message, "000");

textout(screen, worminator_data_file[SMALL_NUMBERS_FONT].dat, message, 293, 140, -1);

// Highlight the weapons the Worminator has
if (player.bullets_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 2, 84, 293, 129, 18, 9);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 293, 129, 293, 129, 18, 9);

if (player.shells_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 2, 75, 293, 120, 18, 8);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 293, 120, 293, 120, 18, 8);

if (player.rockets_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 2, 67, 293, 112, 18, 8);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 293, 112, 293, 112, 18, 8);

if (player.cells_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 2, 58, 293, 103, 18, 8);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 293, 103, 293, 103, 18, 8);

if (player.gasoline_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 2, 47, 293, 92, 18, 10);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 293, 92, 293, 92, 18, 10);

if (player.mortars_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 5, 36, 296, 81, 13, 10);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 296, 81, 296, 81, 18, 8);

if (player.plasma_left >= 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 2, 22, 293, 67, 18, 13);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 293, 67, 293, 67, 18, 13);

if (player.mines_left > 0) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 6, 15, 297, 60, 10, 6);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 297, 60, 297, 60, 10, 6);

// Highlight the keycards the Worminator has
if (player.has_red_keycard == TRUE) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 5, 5, 296, 50, 2, 4);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 296, 50, 296, 50, 2, 4);

if (player.has_green_keycard == TRUE) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 10, 5, 301, 50, 2, 4);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 301, 50, 301, 50, 2, 4);

if (player.has_blue_keycard == TRUE) blit(worminator_data_file[WORMINATOR_HUD_ITEMS_PATCH].dat, screen, 15, 5, 306, 50, 2, 4);
else blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 306, 50, 306, 50, 2, 4);

// Show the player's score

// Wipe clean the score display area
blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 268, 180, 268, 180, 44, 11);

// Draw in the new score
if (player.score >= 1000000) {
	sprintf(message, "%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score >= 100000) {
	sprintf(message, "0%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score >= 10000) {
	sprintf(message, "00%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score >= 1000) {
	sprintf(message, "000%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score >= 100) {
	sprintf(message, "0000%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score >= 10) {
	sprintf(message, "00000%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score > 0) {
	sprintf(message, "000000%-5d", player.score);
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
else if (player.score == 0) {
	sprintf(message, "0000000");
	textout(screen, worminator_data_file[LARGE_NUMBERS_FONT].dat, message, 269, 182, 167);
	}
}

/*****************\
|** HURT PLAYER **|
\*****************/
void hurt_player(char amount_to_hurt)
{
unsigned char spawn_loop;

// Do actual damage
if (player.frame != NULL && amount_to_hurt < 0) {
	player.health_bars_left += amount_to_hurt;
	player.timer = 128;
	for (spawn_loop = 0; spawn_loop < 16; spawn_loop++) spawn_sprite(SMALL_RED_SPARK_SPRITE, player.x_position_in_pixels + 15, player.y_position_in_pixels + 15, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	}
else if (amount_to_hurt > 0) player.health_bars_left += amount_to_hurt;

// Check for max health
if (player.health_bars_left > 10) player.health_bars_left = 10;

// Update health bars
if (player.health_bars_left >= 10) rectfill(screen, 270, 50, 286, 55, 74);
else rectfill(screen, 270, 50, 286, 55, 255);
if (player.health_bars_left >= 9) rectfill(screen, 270, 60, 286, 65, 74);
else rectfill(screen, 270, 60, 286, 65, 255);
if (player.health_bars_left >= 8) rectfill(screen, 270, 70, 286, 75, 73);
else rectfill(screen, 270, 70, 286, 75, 255);
if (player.health_bars_left >= 7) rectfill(screen, 270, 80, 286, 85, 73);
else rectfill(screen, 270, 80, 286, 85, 255);
if (player.health_bars_left >= 6) rectfill(screen, 270, 90, 286, 95, 72);
else rectfill(screen, 270, 90, 286, 95, 255);
if (player.health_bars_left >= 5) rectfill(screen, 270, 100, 286, 105, 71);
else rectfill(screen, 270, 100, 286, 105, 255);
if (player.health_bars_left >= 4) rectfill(screen, 270, 110, 286, 115, 70);
else rectfill(screen, 270, 110, 286, 115, 255);
if (player.health_bars_left >= 3) rectfill(screen, 270, 120, 286, 125, 70);
else rectfill(screen, 270, 120, 286, 125, 255);
if (player.health_bars_left >= 2) rectfill(screen, 270, 130, 286, 135, 69);
else rectfill(screen, 270, 130, 286, 135, 255);
if (player.health_bars_left >= 1) rectfill(screen, 270, 140, 286, 145, 69);
else rectfill(screen, 270, 140, 286, 145, 255);

// Update worminator face
if (player.health_bars_left == 10) blit(worminator_data_file[WORMINATOR_FACE_PATCH_01].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 9) blit(worminator_data_file[WORMINATOR_FACE_PATCH_02].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 8) blit(worminator_data_file[WORMINATOR_FACE_PATCH_03].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 7) blit(worminator_data_file[WORMINATOR_FACE_PATCH_04].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 6) blit(worminator_data_file[WORMINATOR_FACE_PATCH_05].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 5) blit(worminator_data_file[WORMINATOR_FACE_PATCH_06].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 4) blit(worminator_data_file[WORMINATOR_FACE_PATCH_07].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 3) blit(worminator_data_file[WORMINATOR_FACE_PATCH_08].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 2) blit(worminator_data_file[WORMINATOR_FACE_PATCH_09].dat, screen, 0, 0, 271, 7, 38, 34);
else if (player.health_bars_left == 1) blit(worminator_data_file[WORMINATOR_FACE_PATCH_10].dat, screen, 0, 0, 271, 7, 38, 34);
}

/*****************\
|** KILL PLAYER **|
\*****************/
void kill_player()
{
char done = FALSE;
unsigned char spawn_loop;
int frame_loop = 0;

// Update worminator face
blit(worminator_data_file[WORMINATOR_FACE_PATCH_DEAD].dat, screen, 0, 0, 271, 7, 38, 34);

// Create 128 blood spots and some gibs and shrapnel
for (spawn_loop = 0; spawn_loop < 128; spawn_loop++) spawn_sprite(SMALL_RED_SPARK_SPRITE, player.x_position_in_pixels + 15, player.y_position_in_pixels + 15, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
spawn_shrapgibs(player.x_position_in_pixels + 16, player.y_position_in_pixels + 16, 2, 8);

// Don't let the player be drawn
player.frame = NULL;	

// Run for 256 frames to allow the blood spots to move
do {
	while (speed_counter > 0 && done != TRUE) {
		update_sprites();
		frame_loop++;
		if (frame_loop >= 256) done = TRUE;
		speed_counter--;
		}
	render_map();
	} while (done != TRUE);

// Fade out the display and clear out some junk
fade_out(32);
clear_sprites();
clear_player();

// Properly Re-load the level
if (current_level != -1) {
	player_just_died = TRUE;
	load_map(NULL);
	}
else if (current_level == -1) load_map(file_path);
}
