/* -- Menus.h --
Part of the Worminator 2D game engine
Copyright 1998 by Electroencephlogram Software

For function descriptions and explanations, see proto.h
For a detailed explanation of how the engine works, see
the documents that came with this source code package. */

/****************\
|** WORMY MENU **|
\****************/
void wormy_menu()
{
BITMAP *backup_bitmap = create_bitmap(320, 200);
char close_menu = FALSE;
char close_submenu = FALSE;

// Pause the game while the menu is open
game_is_running = FALSE;

// Draw in the wormy menu bar and show the mouse
draw_sprite(screen, worminator_data_file[WORMY_MENU_BAR].dat, 0, 0);
show_mouse(screen);

// This is the core menu loop
do {
	// Game submenu button
	if (mouse_b & 1 && mouse_x >= 8 && mouse_x <= 50 && mouse_y >= 4 && mouse_y <= 17) {
		while (mouse_b & 1) { };
		if (mouse_x >= 8 && mouse_x <= 50 && mouse_y >= 4 && mouse_y <= 17) {
			// Backup what is currently where the new menu will be and then draw the menu
			show_mouse(NULL);
			blit(screen, backup_bitmap, 12, 20, 0, 0, 80, 64);
			draw_sprite(screen, worminator_data_file[WORMY_GAME_MENU].dat, 12, 20);
			show_mouse(screen);

			// Begin game submenu loop
			do {
				// New game submenu button
				if (mouse_b & 1 && mouse_x >= 25 && mouse_x <= 86 && mouse_y >= 23 && mouse_y <= 32) {
					while (mouse_b & 1) { };
					if (mouse_x >= 25 && mouse_x <= 86 && mouse_y >= 23 && mouse_y <= 32) {
						if (wormy_dummy_box(2, TRUE) == TRUE) {
							current_level = 1;
							clear_player();
							player.score = 0;
							load_map(NULL);
							close_submenu = TRUE;
							close_menu = TRUE;
							}
						else close_submenu = TRUE;
						}
					}

				// Load game submenu button
				else if (mouse_b & 1 && mouse_x >= 29 && mouse_x <= 84 && mouse_y >= 36 && mouse_y <= 46 && exists("saved.dat")) {
					while (mouse_b & 1) { };
					if (mouse_x >= 29 && mouse_x <= 84 && mouse_y >= 36 && mouse_y <= 46) {
						if (wormy_dummy_box(1, TRUE) == TRUE) {
							load_saved_game("saved.dat");
							close_submenu = TRUE;
							close_menu = TRUE;
							}
						else close_submenu = TRUE;
						}
					}

				// Save game submenu button
				else if (mouse_b & 1 && mouse_x >= 29 && mouse_x <= 83 && mouse_y >= 51 && mouse_y <= 61 && current_level != -69) {
					while (mouse_b & 1) { };
					if (mouse_x >= 29 && mouse_x <= 83 && mouse_y >= 51 && mouse_y <= 61) {
						if (wormy_dummy_box(3, TRUE) == TRUE) {
							save_game("saved.dat");
							close_submenu = TRUE;
							close_menu = TRUE;
							}
						else close_submenu = TRUE;
						}
					}

				// Exit game submenu button
				else if (mouse_b & 1 && mouse_x >= 28 && mouse_x <= 85 && mouse_y >= 70 && mouse_y <= 80) {
					while (mouse_b & 1) { };
					if (mouse_x >= 28 && mouse_x <= 85 && mouse_y >= 70 && mouse_y <= 80) {
						if (wormy_dummy_box(0, TRUE) == TRUE) {
							time_to_quit = TRUE;
							close_submenu = TRUE;
							close_menu = TRUE;
							}
						else close_submenu = TRUE;
						}
					}

				// Clicked off submenu - issue return command
				else if (mouse_b & 1 && (mouse_x < 12 || mouse_x > 91 || mouse_y < 20 || mouse_y > 83)) {
					while (mouse_b & 1) { };
					if (mouse_x < 12 || mouse_x > 91 || mouse_y < 20 || mouse_y > 83) close_submenu = TRUE;
					}
				} while (close_submenu == FALSE);

			// Clean up this sub menu
			show_mouse(NULL);
			blit(backup_bitmap, screen, 0, 0, 12, 20, 80, 64);
			show_mouse(screen);
			close_submenu = FALSE;
			}
		}

	// Skins submenu button
	else if (mouse_b & 1 && mouse_x >= 68 & mouse_x <= 95 && mouse_y >= 6 && mouse_y <= 18) {
		while (mouse_b & 1) { };
		if (mouse_x >= 68 & mouse_x <= 95 && mouse_y >= 6 && mouse_y <= 18) {
			// Backup what is currently where the new menu will be and then draw the menu
			show_mouse(NULL);
			blit(screen, backup_bitmap, 64, 21, 0, 0, 128, 160);
			draw_sprite(screen, worminator_data_file[WORMY_SKINS_MENU].dat, 64, 21);
			show_mouse(screen);

			// Begin game submenu loop
			do {
				// Worminator skin submenu button
				if (mouse_b & 1 && mouse_x >= 97 && mouse_x <= 165 && mouse_y >= 25 && mouse_y <= 36) {
					while (mouse_b & 1) { };
					if (mouse_x >= 97 && mouse_x <= 165 && mouse_y >= 25 && mouse_y <= 36) {
						player.skin = WORMINATOR_SKIN;
						close_submenu = TRUE;
						}
					}

				// Damaged Worm 1 skin submenu button
				else if (mouse_b & 1 && mouse_x >= 84 && mouse_x <= 181 && mouse_y >= 39 && mouse_y <= 50) {
					while (mouse_b & 1) { };
					if (mouse_x >= 84 && mouse_x <= 181 && mouse_y >= 39 && mouse_y <= 50) {
						player.skin = DAMAGED_WORM_1_SKIN;
						close_submenu = TRUE;
						}
					}

				// Damaged Worm 2 skin submenu button
				else if (mouse_b & 1 && mouse_x >= 84 && mouse_x <= 180 && mouse_y >= 54 && mouse_y <= 65) {
					while (mouse_b & 1) { };
					if (mouse_x >= 84 && mouse_x <= 180 && mouse_y >= 54 && mouse_y <= 65) {
						player.skin = DAMAGED_WORM_2_SKIN;
						close_submenu = TRUE;
						}
					}

				// Damaged Worm 3 skin submenu button
				else if (mouse_b & 1 && mouse_x >= 84 && mouse_x <= 180 && mouse_y >= 69 && mouse_y <= 80) {
					while (mouse_b & 1) { };
					if (mouse_x >= 84 && mouse_x <= 180 && mouse_y >= 69 && mouse_y <= 80) {
						player.skin = DAMAGED_WORM_3_SKIN;
						close_submenu = TRUE;
						}
					}

				// The Brain skin submenu button
				else if (mouse_b & 1 && mouse_x >= 108 && mouse_x <= 154 && mouse_y >= 85 && mouse_y <= 95) {
					while (mouse_b & 1) { };
					if (mouse_x >= 108 && mouse_x <= 154 && mouse_y >= 85 && mouse_y <= 95) {
						player.skin = THE_BRAIN_SKIN;
						close_submenu = TRUE;
						}
					}

				// The Yipnik Mikimbo skin submenu button
				else if (mouse_b & 1 && mouse_x >= 76 && mouse_x <= 187 && mouse_y >= 100 && mouse_y <= 111) {
					while (mouse_b & 1) { };
					if (mouse_x >= 76 && mouse_x <= 187 && mouse_y >= 100 && mouse_y <= 111) {
						player.skin = THE_YIPNIK_MIKIMBO_SKIN;
						close_submenu = TRUE;
						}
					}

				// Original Worminator skin submenu button
				else if (mouse_b & 1 && mouse_x >= 76 && mouse_x <= 187 && mouse_y >= 117 && mouse_y <= 128) {
					while (mouse_b & 1) { };
					if (mouse_x >= 76 && mouse_x <= 187 && mouse_y >= 117 && mouse_y <= 128) {
						player.skin = ORIGINAL_WORMINATOR_SKIN;
						close_submenu = TRUE;
						}
					}

				// Hotdog Hero skin submenu button
				else if (mouse_b & 1 && mouse_x >= 102 && mouse_x <= 158 && mouse_y >= 133 && mouse_y <= 143) {
					while (mouse_b & 1) { };
					if (mouse_x >= 102 && mouse_x <= 158 && mouse_y >= 133 && mouse_y <= 143) {
						player.skin = HOTDOG_HERO_SKIN;
						close_submenu = TRUE;
						}
					}

				// VooDoo Badie skin submenu button
				else if (mouse_b & 1 && mouse_x >= 100 && mouse_x <= 159 && mouse_y >= 148 && mouse_y <= 158) {
					while (mouse_b & 1) { };
					if (mouse_x >= 100 && mouse_x <= 159 && mouse_y >= 148 && mouse_y <= 158) {
						player.skin = VOODOO_BADIE_SKIN;
						close_submenu = TRUE;
						}
					}

				// Yuanti skin submenu button
				else if (mouse_b & 1 && mouse_x >= 111 && mouse_x <= 145 && mouse_y >= 164 && mouse_y <= 174) {
					while (mouse_b & 1) { };
					if (mouse_x >= 111 && mouse_x <= 145 && mouse_y >= 164 && mouse_y <= 174) {
						player.skin = YUANTI_SKIN;
						close_submenu = TRUE;
						}
					}

				// Clicked off submenu - issue return command
				else if (mouse_b & 1 && (mouse_x < 64 || mouse_x > 191 || mouse_y < 21 || mouse_y > 180)) {
					while (mouse_b & 1) { };
					if (mouse_x < 64 || mouse_x > 191 || mouse_y < 21 || mouse_y > 180) close_submenu = TRUE;
					}
				} while (close_submenu == FALSE);

			// Clean up this sub menu
			show_mouse(NULL);
			blit(backup_bitmap, screen, 0, 0, 64, 21, 128, 160);
			show_mouse(screen);
			close_submenu = FALSE;
			}
		}

	// Help submenu button
	if (mouse_b & 1 && mouse_x >= 116 && mouse_x <= 137 && mouse_y >= 4 && mouse_y <= 16) {
		while (mouse_b & 1) { };
		if (mouse_x >= 116 && mouse_x <= 137 && mouse_y >= 4 && mouse_y <= 16) {
			// Backup what is currently where the new menu will be and then draw the menu
			show_mouse(NULL);
			blit(screen, backup_bitmap, 119, 18, 0, 0, 64, 128);
			draw_sprite(screen, worminator_data_file[WORMY_HELP_MENU].dat, 119, 18);
			show_mouse(screen);

			// Begin help submenu loop
			do {
				// General submenu button
				if (mouse_b & 1 && mouse_x >= 137 && mouse_x <= 175 && mouse_y >= 23 && mouse_y <= 33) {
					while (mouse_b & 1) { };
					if (mouse_x >= 137 && mouse_x <= 175 && mouse_y >= 23 && mouse_y <= 33) {
						display_snapshot(0, TRUE);
						close_submenu = TRUE;
						}
					}

				// Enemies submenu button
				if (mouse_b & 1 && mouse_x >= 134 && mouse_x <= 179 && mouse_y >= 38 && mouse_y <= 48) {
					while (mouse_b & 1) { };
					if (mouse_x >= 134 && mouse_x <= 179 && mouse_y >= 38 && mouse_y <= 48) {
						display_snapshot(1, TRUE);
						close_submenu = TRUE;
						}
					}

				// Weapons submenu button
				if (mouse_b & 1 && mouse_x >= 134 && mouse_x <= 180 && mouse_y >= 50 && mouse_y <= 63) {
					while (mouse_b & 1) { };
					if (mouse_x >= 134 && mouse_x <= 180 && mouse_y >= 50 && mouse_y <= 63) {
						display_snapshot(2, TRUE);
						close_submenu = TRUE;
						}
					}

				// Credits submenu button
				if (mouse_b & 1 && mouse_x >= 139 && mouse_x <= 172 && mouse_y >= 68 && mouse_y <= 79) {
					while (mouse_b & 1) { };
					if (mouse_x >= 139 && mouse_x <= 172 && mouse_y >= 68 && mouse_y <= 79) {
						display_snapshot(3, TRUE);
						close_submenu = TRUE;
						}
					}

				// Story submenu button
				if (mouse_b & 1 && mouse_x >= 142 && mouse_x <= 171 && mouse_y >= 84 && mouse_y <= 95) {
					while (mouse_b & 1) { };
					if (mouse_x >= 142 && mouse_x <= 171 && mouse_y >= 84 && mouse_y <= 95) {
						display_story(TRUE);
						close_submenu = TRUE;
						}
					}

				// Controls submenu button
				if (mouse_b & 1 && mouse_x >= 134 && mouse_x <= 178 && mouse_y >= 99 && mouse_y <= 110) {
					while (mouse_b & 1) { };
					if (mouse_x >= 134 && mouse_x <= 178 && mouse_y >= 99 && mouse_y <= 110) {
						display_snapshot(4, TRUE);
						close_submenu = TRUE;
						}
					}

				// About submenu button
				if (mouse_b & 1 && mouse_x >= 136 && mouse_x <= 173 && mouse_y >= 129 && mouse_y <= 139) {
					while (mouse_b & 1) { };
					if (mouse_x >= 136 && mouse_x <= 173 && mouse_y >= 129 && mouse_y <= 139) {
						display_snapshot(5, TRUE);
						close_submenu = TRUE;
						}
					}

				// Clicked off submenu - issue return command
				else if (mouse_b & 1 && (mouse_x < 119 || mouse_x > 182 || mouse_y < 18 || mouse_y > 145)) {
					while (mouse_b & 1) { };
					if (mouse_x < 119 || mouse_x > 182 || mouse_y < 18 || mouse_y > 145) close_submenu = TRUE;
					}
				} while (close_submenu == FALSE);

			// Clean up this sub menu
			show_mouse(NULL);
			blit(backup_bitmap, screen, 0, 0, 119, 18, 64, 128);
			show_mouse(screen);
			close_submenu = FALSE;
			}
		}

	// Resume game button
	else if (mouse_b & 1 && mouse_x >= 236 && mouse_x <= 311 && mouse_y >= 6 && mouse_y <= 17) {
		while (mouse_b & 1) { };
		if (mouse_x >= 236 && mouse_x <= 311 && mouse_y >= 6 && mouse_y <= 17 && current_level != -69) close_menu = TRUE;
		}
	} while (close_menu == FALSE);

// Hide the mouse pointer and refresh the display
show_mouse(NULL);
blit(worminator_data_file[WORMINATOR_HUD].dat, screen, 0, 0, 0, 0, 320, 200);
update_player_stats();
hurt_player(0);
render_map();
}

/***************************\
|** START NEW CUSTOM GAME **|
\***************************/
void start_new_custom_game()
{
BITMAP *backup_bitmap = create_bitmap(320, 200);

// Back up existing screen
show_mouse(NULL);
blit(screen, backup_bitmap, 0, 0, 0, 0, 320, 200);

if (file_select("Select a map data file (.map files)", file_path, "map") != NULL) {
	current_level = -1;
	clear_player();
	player.score = 0;
	load_map(file_path);
	}

// Restore the previous screen and moust pointer display
show_mouse(NULL);
draw_sprite(screen, backup_bitmap, 0, 0);
}

/*********************\
|** WORMY DUMMY BOX **|
\*********************/
char wormy_dummy_box(char dummy_question_patch_number, char show_mouse_pointer)
{
BITMAP *backup_bitmap = create_bitmap(128, 64);
char close_dummy_box = FALSE;

// Pause the game while the dummy box is open
game_is_running = FALSE;

// Back up existing area under the dummy box
blit(screen, backup_bitmap, 96, 68, 0, 0, 128, 64);

// Draw in the wormy dummy box along with its patch, and then show the mouse pointer
show_mouse(NULL);
draw_sprite(screen, worminator_data_file[WORMY_DUMMY_BOX].dat, 96, 68);
if (dummy_question_patch_number == 0) draw_sprite(screen, worminator_data_file[WORMY_DUMMY_BOX_EXIT_GAME_PATCH].dat, 112, 84);
else if (dummy_question_patch_number == 1) draw_sprite(screen, worminator_data_file[WORMY_DUMMY_BOX_LOAD_GAME_PATCH].dat, 112, 84);
else if (dummy_question_patch_number == 2) draw_sprite(screen, worminator_data_file[WORMY_DUMMY_BOX_NEW_GAME_PATCH].dat, 112, 84);
else if (dummy_question_patch_number == 3) draw_sprite(screen, worminator_data_file[WORMY_DUMMY_BOX_SAVE_GAME_PATCH].dat, 112, 84);
show_mouse(screen);

// This is the core dummy box loop
do {
	// Yes button
	if (mouse_b & 1 && mouse_x >= 113 && mouse_x <= 146 && mouse_y >= 112 && mouse_y <= 128) {
		while (mouse_b & 1) { };
		if (mouse_x >= 113 && mouse_x <= 146 && mouse_y >= 112 && mouse_y <= 128) {
			show_mouse(NULL);
			draw_sprite(screen, backup_bitmap, 96, 68);
			if (show_mouse_pointer == TRUE) show_mouse(screen);
			return TRUE;
			}
		}

	// Optional Y keypress
	if (key[KEY_Y]) {
		while (key[KEY_Y]) { };
		show_mouse(NULL);
		draw_sprite(screen, backup_bitmap, 96, 68);
		if (show_mouse_pointer == TRUE) show_mouse(screen);
		return TRUE;
		}

	// No button
	else if (mouse_b & 1 && mouse_x >= 172 && mouse_x <= 205 && mouse_y >= 111 && mouse_y <= 127) {
		while (mouse_b & 1) { };
		if (mouse_x >= 172 && mouse_x <= 205 && mouse_y >= 111 && mouse_y <= 127) {
			show_mouse(NULL);
			draw_sprite(screen, backup_bitmap, 96, 68);
			if (show_mouse_pointer == TRUE) show_mouse(screen);
			return FALSE;
			}
		}

	// Optional N keypress
	if (key[KEY_N]) {
		while (key[KEY_N]) { };
		show_mouse(NULL);
		draw_sprite(screen, backup_bitmap, 96, 68);
		if (show_mouse_pointer == TRUE) show_mouse(screen);
		return FALSE;
		}
	} while(close_dummy_box == FALSE);

// This should never be reached, but return FALSE just as a precaution
return FALSE;
}

/**********************\
|** DISPLAY SNAPSHOT **|
\**********************/
void display_snapshot(char snapshot_number, char show_mouse_pointer)
{
BITMAP *backup_bitmap = create_bitmap(320, 200);
char close_snapshot = FALSE;

// Pause the game while looking at a snapshot
game_is_running = FALSE;

// Back up existing screen
show_mouse(NULL);
blit(screen, backup_bitmap, 0, 0, 0, 0, 320, 200);

// Draw the snapshot
if (snapshot_number == 0) draw_sprite(screen, worminator_data_file[WORMY_GENERAL_HELP].dat, 0, 0);
else if (snapshot_number == 1) draw_sprite(screen, worminator_data_file[WORMY_ENEMIES_HELP].dat, 0, 0);
else if (snapshot_number == 2) draw_sprite(screen, worminator_data_file[WORMY_WEAPONS_HELP].dat, 0, 0);
else if (snapshot_number == 3) draw_sprite(screen, worminator_data_file[WORMY_CREDITS_HELP].dat, 0, 0);
else if (snapshot_number == 4) draw_sprite(screen, worminator_data_file[WORMY_CONTROLS_HELP].dat, 0, 0);
else if (snapshot_number == 5) draw_sprite(screen, worminator_data_file[WORMY_ABOUT_HELP].dat, 0, 0);
else if (snapshot_number == 6) draw_sprite(screen, worminator_data_file[WORMY_LEVEL_01_BRIEFING].dat, 0, 0);
else if (snapshot_number == 7) draw_sprite(screen, worminator_data_file[WORMY_LEVEL_02_BRIEFING].dat, 0, 0);
else if (snapshot_number == 8) draw_sprite(screen, worminator_data_file[WORMY_LEVEL_03_BRIEFING].dat, 0, 0);
else if (snapshot_number == 9) draw_sprite(screen, worminator_data_file[WORMY_LEVEL_04_BRIEFING].dat, 0, 0);
else if (snapshot_number == 10) draw_sprite(screen, worminator_data_file[WORMY_LEVEL_05_BRIEFING].dat, 0, 0);
else if (snapshot_number == 11) draw_sprite(screen, worminator_data_file[WORMY_LEVEL_06_BRIEFING].dat, 0, 0);
else if (snapshot_number == 12) draw_sprite(screen, worminator_data_file[WORMY_ENDING_MESSAGE].dat, 0, 0);
else if (snapshot_number == 13) draw_sprite(screen, worminator_data_file[WORMY_FAMOUS_LAST_WORDS].dat, 0, 0);
show_mouse(screen);

// This is the core snapshot loop
do {
	// Ok button
	if (mouse_b & 1 && mouse_x >= 271 && mouse_x <= 304 && mouse_y >= 174 && mouse_y <= 190) {
		while (mouse_b & 1) { };
		if (mouse_x >= 271 && mouse_x <= 304 && mouse_y >= 174 && mouse_y <= 190) close_snapshot = TRUE;
		}

	// Optional enter keypress
	if (key[KEY_ENTER]) {
		while (key[KEY_ENTER]) { };
		close_snapshot = TRUE;
		}
	} while(close_snapshot == FALSE);

// Restore the previous screen and moust pointer display
show_mouse(NULL);
draw_sprite(screen, backup_bitmap, 0, 0);
if (show_mouse_pointer == TRUE) show_mouse(screen);
}

/*******************\
|** DISPLAY STORY **|
\*******************/
void display_story(char show_mouse_pointer)
{
BITMAP *backup_bitmap = create_bitmap(320, 200);
char close_story = FALSE;
char story_page_number = 0;

// Pause the game while looking at the story
game_is_running = FALSE;

// Back up existing screen
show_mouse(NULL);
blit(screen, backup_bitmap, 0, 0, 0, 0, 320, 200);

// Draw the current story screen
draw_sprite(screen, worminator_data_file[WORMY_STORY_PAGE_01].dat, 0, 0);
show_mouse(screen);

// This is the core story loop
do {
	// Left Arrow
	if (mouse_b & 1 && mouse_x >= 174 && mouse_x <= 207 && mouse_y >= 174 && mouse_y <= 190) {
		while (mouse_b & 1) { };
		if (mouse_x >= 174 && mouse_x <= 207 && mouse_y >= 174 && mouse_y <= 190) {
			story_page_number--;
			if (story_page_number < 0) story_page_number = 0;
			show_mouse(NULL);
			draw_sprite(screen, worminator_data_file[WORMY_STORY_PAGE_01 + story_page_number].dat, 0, 0);
			show_mouse(screen);
			}
		}

	// Optional left arrow
	if (key[KEY_LEFT]) {
		while (key[KEY_LEFT]) { };
		story_page_number--;
		if (story_page_number < 0) story_page_number = 0;
		show_mouse(NULL);
		draw_sprite(screen, worminator_data_file[WORMY_STORY_PAGE_01 + story_page_number].dat, 0, 0);
		show_mouse(screen);
		}

	// Right Arrow
	if (mouse_b & 1 && mouse_x >= 215 && mouse_x <= 248 && mouse_y >= 174 && mouse_y <= 190) {
		while (mouse_b & 1) { };
		if (mouse_x >= 215 && mouse_x <= 248 && mouse_y >= 174 && mouse_y <= 190) {
			story_page_number++;
			if (story_page_number > 3) story_page_number = 3;
			show_mouse(NULL);
			draw_sprite(screen, worminator_data_file[WORMY_STORY_PAGE_01 + story_page_number].dat, 0, 0);
			show_mouse(screen);
			}
		}

	// Optional right arrow
	if (key[KEY_RIGHT]) {
		while (key[KEY_RIGHT]) { };
		story_page_number++;
		if (story_page_number > 3) story_page_number = 3;
		show_mouse(NULL);
		draw_sprite(screen, worminator_data_file[WORMY_STORY_PAGE_01 + story_page_number].dat, 0, 0);
		show_mouse(screen);
		}

	// Ok button
	if (mouse_b & 1 && mouse_x >= 271 && mouse_x <= 304 && mouse_y >= 174 && mouse_y <= 190) {
		while (mouse_b & 1) { };
		if (mouse_x >= 271 && mouse_x <= 304 && mouse_y >= 174 && mouse_y <= 190) close_story = TRUE;
		}

	// Optional enter keypress
	if (key[KEY_ENTER]) {
		while (key[KEY_ENTER]) { };
		close_story = TRUE;
		}

	} while(close_story == FALSE);

// Restore the previous screen and moust pointer display
show_mouse(NULL);
draw_sprite(screen, backup_bitmap, 0, 0);
if (show_mouse_pointer == TRUE) show_mouse(screen);
}