/* -- Globals.h --
Part of the Worminator 2D game engine
Copyright 1998 by Electroencephlogram Software

This file includes all of the global variables used in the Worminator
game engine.  It also has all of the structure typedefs. */

/*************\
|** DEFINES **|
\*************/
#define WORMINATOR_SKIN 0
#define DAMAGED_WORM_1_SKIN 1
#define DAMAGED_WORM_2_SKIN 2
#define DAMAGED_WORM_3_SKIN 3
#define THE_BRAIN_SKIN 4
#define THE_YIPNIK_MIKIMBO_SKIN 5
#define ORIGINAL_WORMINATOR_SKIN 6
#define HOTDOG_HERO_SKIN 7
#define VOODOO_BADIE_SKIN 8
#define YUANTI_SKIN 9

#define FULL_VERSION 0
#define STRIPPED_VERSION 1

/****************\
|** STRUCTURES **|
\****************/

typedef struct PLAYER {
	int timer;
	int width, height;
	int frame;
	char animation_timer;
	char direction;
	char current_weapon;
	char on_ground;
	char in_water;
	char letter_order;
	int score;
	char health_bars_left;
	char has_red_keycard, has_green_keycard, has_blue_keycard;
	int bullets_left, shells_left, rockets_left, cells_left, gasoline_left, mortars_left, plasma_left, mines_left;
	float x_position_in_pixels, y_position_in_pixels;
	float x_acceleration, y_acceleration;
	char skin;
	} PLAYER;

typedef struct SPRITE {
	int sprite_active;
	int sprite_type;
	char in_range;
	int timer;
	char animation_state;
	int width, height;
	int action_state;
	int frame;
	float hit_points_left;
	float x_position_in_pixels, y_position_in_pixels;
	float x_acceleration, y_acceleration;
	char direction;
	unsigned char rotate_factor;
	} SPRITE;

typedef struct PATRTICLE_BEAM {
	char beam_active;
	int x1, y, x2;
	unsigned char color;
	unsigned char timer;
	unsigned char color_mode;
	} PARTICLE_BEAM;

typedef struct EDITOR_SPRITE {
	short int sprite_type;
	int x_position_in_pixels, y_position_in_pixels;
	} EDITOR_SPRITE;

typedef struct WORMINATOR_MAP_FORMAT {
	unsigned short int map_width;
	unsigned short int map_height;
	char map_name[80];
	short int background_tile_grid[256][192];
	short int foreground_tile_grid[256][192];
	short int info_tile_grid[256][192];
	char graphical_properties_tile_grid[256][192];
	EDITOR_SPRITE starting_sprites[256];
	char weather;
	} WORMINATOR_MAP_FORMAT;

typedef struct TEXT_MESSAGE {
	short int timer;
	unsigned char *message;
	} TEXT_MESSAGE;

/*****************\
|** GLOBAL DATA **|
\*****************/

COLOR_MAP trans_table;

PLAYER player;
SPRITE sprites[1024];
PARTICLE_BEAM particle_beams[16];
WORMINATOR_MAP_FORMAT worminator_map;

DATAFILE *worminator_data_file;

BITMAP *double_buffer;
BITMAP *worminator_tiles;
BITMAP *parallax_background;
BITMAP *spawned_sprite;

// This is used for the text messages in the game
TEXT_MESSAGE text_messages[4];

// These are used for special key functions
unsigned char jump_key_state = 0, up_key_state = 0, fire_key_state = 0;

// These are the coordinates of the current view portal
int screen_x_position = 0, screen_y_position = 0;

// This is used so that we dont need to scan the entire sprite array, just what is used.
int number_of_sprites = 0;

// Built in tile animation:  Layer, X, Y, Add Until, Length, Speed, Speed clock
short int tile_animations[1024][7];

// This is just to let ceratin functions display text.
unsigned char *message;

// Array for weather effects
float weather[64][2];

// Debug mode toggle
char debug_mode_on = FALSE;

// This is used to allow worminator to run at a decent speed on almost any computer
volatile int speed_counter = 0;

// This is used to tell the game timer when to update and when not to
char game_is_running = FALSE;

// This is used to indicate what level we are on
char current_level = 1;

// This is used to decide when to kill the game
char time_to_quit = FALSE;

// Global timer - loops from 0 to 15 on regular intervals
char global_timer = 0;

// Global variable to allow for screen shakes and earthquakes and cool stuff
int quake_timer = 0;

// Global variable to allow weapon switching
char desired_weapon = 0;

// Timer to allow player to look up/down and a look shifter variable
int look_timer = 0;
int look_shift = 0;

// Variable to allow the turbo launch tubes and other scripted stuff to work ok
char turbo_launch = FALSE;

// Variable to help with part of the loading function
char player_just_died = FALSE;

// This is the path of the current level
unsigned char file_path[256] = "";

// This is used to allow the game executable to run all sizes of the datafile versions
char version_size;