/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>


#define ROTATE_NONE  0
#define ROTATE_RIGHT 1
#define ROTATE_LEFT  2


#define SOUND_NONE   0

#ifndef NOSEAL
#define SOUND_SEAL   (SOUND_NONE + 1)
#else
#define SOUND_SEAL   SOUND_NONE
#endif

#ifndef NOMIDAS
#define SOUND_MIDAS  (SOUND_SEAL + 1)
#else
#define SOUND_MIDAS  SOUND_SEAL
#endif

#define SOUND_DIRECT (SOUND_MIDAS + 1)

#define MAX_GAMEDESC 256

enum {
    COLUMN_GAMES = 0,
    COLUMN_ROMS,
    COLUMN_SAMPLES,
    COLUMN_DIRECTORY,
    COLUMN_TYPE,
    COLUMN_TRACKBALL,
    COLUMN_PLAYED,
    COLUMN_MANUFACTURER,
    COLUMN_YEAR,
    COLUMN_CLONE,
    COLUMN_MAX
};

enum {
    VIEW_LARGE_ICONS = 0,
    VIEW_SMALL_ICONS,
    VIEW_INLIST,
    VIEW_REPORT,
    VIEW_MAX
};

enum {
    SPLITTER_LEFT = 0,
    SPLITTER_RIGHT,
    SPLITTER_MAX
};

/* per-game data we calculate */
enum
{
    UNKNOWN = 2,
};

typedef struct
{
    int x, y, width, height;
} AREA;

typedef struct
{
    BOOL use_default; /* only for non-default options */
    
    BOOL is_window;
    BOOL display_best_fit; /* full screen only */
    int width; /* full screen only */
    int height; /* full screen only */
    int skip_lines; /* full screen only */
    int skip_columns; /* full screen only */
    BOOL double_vector;
    BOOL window_ddraw;
    int frame_skip;
    BOOL use_dirty;
    BOOL hscan_lines;
    BOOL vscan_lines;
    BOOL use_blit;
    BOOL disable_mmx;
    int scale;
    int rotate;
    BOOL flipx;
    BOOL flipy;
    double gamma;
    int brightness;
    int depth;
    BOOL antialias;
    BOOL translucency;
    double beam;
    int flicker;

    BOOL use_joystick;
    BOOL use_ai_mouse;
    BOOL di_keyboard;
    BOOL di_joystick;

    int sound;
    int seal_index;
    int sample_rate;
    int sample_bits;
    BOOL stereo;

    BOOL fm_ym3812;

    BOOL cheat;
    BOOL auto_pause;
    BOOL error_log;
    BOOL profile;

    int play_count;
    int has_roms;
    int has_samples;
} options_type;

typedef struct
{
    BOOL     show_all_games;
    BOOL     show_unavailable_games;
    INT      folder_id;
    BOOL     view;
    BOOL     show_folderlist;
    BOOL     show_toolbar;
    BOOL     show_statusbar;
    BOOL     show_screenshot;
    BOOL     large_screenshot;
    BOOL     show_no_clones;
    char     default_game[MAX_GAMEDESC];
    int      column_widths[COLUMN_MAX];
    int      column_order[COLUMN_MAX];
    int      column_shown[COLUMN_MAX];
    AREA     area;
    int      splitter[SPLITTER_MAX];
    LOGFONT  list_font;
    COLORREF list_font_color;
    int      sort_column;
    char*    romdirs;
    char*    sampledirs;
    char*    cfgdir;
    char*    hidir;
    char*    inpdir;
    char*    imgdir;
    char*    statedir;
    char*    artdir;
} settings_type; /* global settings for the UI only */

void OptionsInit(int total_games);
void OptionsExit();

options_type * GetDefaultOptions();
options_type * GetGameOptions(int num_game);

void SetViewMode(int val);
int  GetViewMode(void);

void SetShowAllGames(BOOL val);
BOOL GetShowAllGames(void);

void SetShowUnavailableGames(BOOL val);
BOOL GetShowUnavailableGames(void);

void SetSavedFolderID(UINT val);
UINT GetSavedFolderID(void);

void SetShowScreenShot(BOOL val);
BOOL GetShowScreenShot(void);

void SetLargeScreenShot(BOOL val);
BOOL GetLargeScreenShot(void);

void SetShowNoClones(BOOL val);
BOOL GetShowNoClones(void);

void SetShowFolderList(BOOL val);
BOOL GetShowFolderList(void);

void SetShowStatusBar(BOOL val);
BOOL GetShowStatusBar(void);

void SetShowToolBar(BOOL val);
BOOL GetShowToolBar(void);

void SetDefaultGame(const char *name);
const char *GetDefaultGame(void);

void SetWindowArea(AREA *area);
void GetWindowArea(AREA *area);

void SetColumnWidths(int widths[]);
void GetColumnWidths(int widths[]);

void SetColumnOrder(int order[]);
void GetColumnOrder(int order[]);

void SetColumnShown(int shown[]);
void GetColumnShown(int shown[]);

void SetSplitterPos(int splitterId, int pos);
int  GetSplitterPos(int splitterId);

void SetListFont(LOGFONT *font);
void GetListFont(LOGFONT *font);

void SetListFontColor(COLORREF uColor);
COLORREF GetListFontColor();

void SetSortColumn(int column);
int  GetSortColumn(void);

const char* GetRomDirs(void);
void SetRomDirs(const char* paths);

const char* GetSampleDirs(void);
void  SetSampleDirs(const char* paths);

const char* GetCfgDir(void);
void SetCfgDir(const char* path);

const char* GetHiDir(void);
void SetHiDir(const char* path);

const char* GetInpDir(void);
void SetInpDir(const char* path);

const char* GetImgDir(void);
void SetImgDir(const char* path);

const char* GetStateDir(void);
void SetStateDir(const char* path);

const char* GetArtDir(void);
void SetArtDir(const char* path);

void ResetGameOptions(int num_game);

int  GetHasRoms(int num_game);
void SetHasRoms(int num_game, int has_roms);

int  GetHasSamples(int num_game);
void SetHasSamples(int num_game, int has_samples);

void IncrementPlayCount(int num_game);
int  GetPlayCount(int num_game);

void NewDialogToOptions(HWND hwnd, int iTab, options_type *o);
void NewOptionsToDialog(HWND hwnd, int iTab, options_type *o);

#endif
