/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  YM3812.c

 ***************************************************************************/

#include <conio.h>

#include "mame32.h"
#include "m32util.h"
#include "win32ui.h"
#include "fmsynth.h"

/***************************************************************************
    function prototypes
 ***************************************************************************/

static int              FMSynth_init(options_type *options);
static void             FMSynth_exit(void);
static void             YM3812_control(int reg);
static void             YM3812_write(int data);

static void             SilenceOpl();
static void             WriteOPLRegister(BYTE opl_register,BYTE value);
static void             tenmicrosec(void);

/***************************************************************************
    External variables
 ***************************************************************************/

struct OSDFMSynth FMSynth =
{
    { FMSynth_init },               /* init              */
    { FMSynth_exit },               /* exit              */
    { YM3812_control },             /* ym3812_control    */
    { YM3812_write },               /* ym3812_write      */
};

/***************************************************************************
    Internal variables
 ***************************************************************************/

static BOOL enabled;

/***************************************************************************
    External OSD functions  
 ***************************************************************************/

static int FMSynth_init(options_type *options)
{
   enabled = options->fm_ym3812;

   return 0;
}

static void FMSynth_exit(void)
{
   if (enabled)
      SilenceOpl();
}

static void YM3812_control(int reg)
{
#if defined(_M_IX86)
    if (enabled)
    {
        tenmicrosec();
        _outp(0x388, reg);
    }
#endif
}

static void YM3812_write(int data)
{
#if defined(_M_IX86)
    if (enabled)
    {
        tenmicrosec();
        _outp(0x389, data);
    }
#endif
}

/***************************************************************************
    Internal functions  
 ***************************************************************************/

static void SilenceOpl()
{
   BYTE i;

   for (i = 0x01; i <= 0xf5; i++)
      WriteOPLRegister(i, 0);
}

static void WriteOPLRegister(BYTE opl_register, BYTE value)
{
#if defined(_M_IX86)
   int i;

   _outp(0x388, opl_register);
   for (i = 0; i < 6; i++)
      _inp(0x388);

   _outp(0x389, value);

   for (i = 0; i < 35; i++)
      _inp(0x388);
#endif
}

/* linux sound driver opl3.c does a so called tenmicrosec() delay */
static void tenmicrosec(void)
{
#if defined(_M_IX86)
    int i;
    for (i = 0; i < 16; i++)
        _inp(0x80);
#endif
}
