/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

    directdraw.c

    Direct Draw routines.
 
 ***************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <ddraw.h>
#include "DirectDraw.h"
#include "M32Util.h"

/***************************************************************************
    function prototypes
 ***************************************************************************/

/***************************************************************************
    External variables
 ***************************************************************************/

LPDIRECTDRAW    dd = NULL;

/***************************************************************************
    Internal structures
 ***************************************************************************/

/***************************************************************************
    Internal variables
 ***************************************************************************/

static HANDLE hDLL = NULL;

/***************************************************************************
    External functions  
 ***************************************************************************/

/****************************************************************************
 *      DirectDrawInitialize
 *
 *      Initialize the DirectDraw variables.
 *
 *      This entails the following functions:
 *
 *          DirectDrawCreate
 *
 ****************************************************************************/

typedef HRESULT (WINAPI *ddc_proc)(GUID FAR *lpGUID,LPDIRECTDRAW FAR *lplpDD,
                                   IUnknown FAR *pUnkOuter);

BOOL DirectDrawInitialize()
{
    HRESULT hr;
    UINT error_mode;
    ddc_proc ddc;

    if (hDLL != NULL)
        return TRUE;

    /* Turn off error dialog for this call */
    error_mode = SetErrorMode(0);
    hDLL = LoadLibrary("ddraw.dll");
    SetErrorMode(error_mode);

    if (hDLL == NULL)
       return FALSE;

    ddc = (ddc_proc)GetProcAddress(hDLL,"DirectDrawCreate");
    if (ddc == NULL)
        return FALSE;

    hr = ddc(NULL, &dd, NULL);

    if (FAILED(hr)) 
    {
        ErrorMsg("DirectDrawCreate failed! error=%x\n", hr);
        dd = NULL;
        return FALSE;
    }

    return TRUE;
}

/****************************************************************************
 *
 *      DirectDrawClose
 *
 *      Terminate our usage of DirectDraw.
 *
 ****************************************************************************/

void DirectDrawClose()
{
    /*
        Destroy any lingering IDirectDraw object.
    */
    if (dd) 
    {
        IDirectDraw_Release(dd);
        dd = NULL;
        FreeLibrary(hDLL);
    }
}

/***************************************************************************
    Internal functions
 ***************************************************************************/


