/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  debug.c

  MAME debugging code, using a console

 ***************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "MAME32.h"
#include "osd_dbg.h"

#ifdef MAME_DEBUG

static int keypressed (void);

void ScreenPutString (const char *text, int color, int x, int y)
{
    int written;
    COORD coord;
    
    coord.X = x;
    coord.Y = y;
    
    WriteConsoleOutputCharacter(GetStdHandle(STD_OUTPUT_HANDLE),text,strlen(text),coord,&written);
    FillConsoleOutputAttribute(GetStdHandle(STD_OUTPUT_HANDLE),(WORD)color,strlen(text),coord,&written);
}

void ScreenSetCursor (int x, int y)
{
    COORD coord;
    
    /* unknown why it's backwards */
    coord.X = y;
    coord.Y = x;
    
    SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE),coord);
}

void ScreenClear(void)
{
    HANDLE hConsole;
    COORD coordScreen = { 0, 0 };   /* here's where we'll home the cursor */
    BOOL bSuccess;
    DWORD cCharsWritten;
    CONSOLE_SCREEN_BUFFER_INFO csbi;/* to get buffer info */
    DWORD dwConSize;                /* number of character cells in
                                       the current buffer */
                                     
    hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
                                     
    /* get the number of character cells in the current buffer */
                                     
    bSuccess = GetConsoleScreenBufferInfo( hConsole, &csbi );
    dwConSize = csbi.dwSize.X * csbi.dwSize.Y;
                                     
    /* fill the entire screen with blanks */
                                     
    bSuccess = FillConsoleOutputCharacter( hConsole, (TCHAR) ' ',
        dwConSize, coordScreen, &cCharsWritten );
                                     
    /* get the current text attribute */
                                     
    bSuccess = GetConsoleScreenBufferInfo( hConsole, &csbi );
                                         
    /* now set the buffer's attributes accordingly */
                                     
    bSuccess = FillConsoleOutputAttribute( hConsole, csbi.wAttributes,
        dwConSize, coordScreen, &cCharsWritten );
                                     
    /* put the cursor at (0, 0) */
                                     
    bSuccess = SetConsoleCursorPosition( hConsole, coordScreen );
    return;
}

int osd_debug_readkey (void)
{
    INPUT_RECORD ir;
    int read;

    while (1)
    {
        MAME32App.ProcessMessages();
        
        if (keypressed())
        {
            if (!ReadConsoleInput(GetStdHandle(STD_INPUT_HANDLE),&ir,1,&read))
                break;
            
            if (ir.EventType != KEY_EVENT)
                continue;
            
            if (!ir.Event.KeyEvent.bKeyDown)
                continue;
            
            return (ir.Event.KeyEvent.wVirtualScanCode);
        }
        
    }
    return 0;
}

static int keypressed (void)
{
    int count;
    
    MAME32App.ProcessMessages();
    
    count = 0;
    if (!GetNumberOfConsoleInputEvents(GetStdHandle(STD_INPUT_HANDLE),&count))
        return 0;
    
    return count >= 1;
}

void set_gfx_mode (int mode, int width, int height, int u1, int u2)
{
    /* printf("set_gfx_mode %i, %ix%i, %i, %i\n",mode,width,height,u1,u2); */
}

#endif
