#ifndef TREEVIEW_H
#define TREEVIEW_H

#include "Bitmask.h"
#include "Win32ui.h"

/* TreeView structures */
enum FolderIds
{
    FOLDER_NONE = 0,
    FOLDER_ALLGAMES,
    FOLDER_AVAILABLE,
    FOLDER_UNAVAILABLE,
    FOLDER_NEOGEO,
    FOLDER_MANUFACTURER,
    FOLDER_YEAR,
    FOLDER_WORKING,
    FOLDER_NONWORKING,
    FOLDER_CUSTOM,
    FOLDER_FAVORITE,
    FOLDER_ORIGINAL,
    FOLDER_CLONES,
    FOLDER_RASTER,
    FOLDER_VECTOR,
    FOLDER_TRACKBALL,
    FOLDER_STEREO,
    FOLDER_END
};

typedef enum
{
    IS_ROOT = 1,
    IS_FOLDER
} FOLDERTYPE;

typedef enum
{
    F_CUSTOM = 1
} FOLDERFLAG;

typedef struct {
    LPSTR       m_lpTitle;          /* String contains the folder name */
    FOLDERTYPE  m_nFolderType;      /* Contains enum FolderTypes */
    UINT        m_nFolderId;        /* Index / Folder ID number */
    UINT        m_nParent;          /* Parent folder ID */
    UINT        m_nIconId;          /* Icon to use with this folder */
    DWORD       m_dwFlags;          /* Misc flags */
    LPBITS      m_lpGameBits;       /* Game bits, represent game indices */
} TREEFOLDER, *LPTREEFOLDER;

LPTREEFOLDER    NewFolder(LPSTR lpTitle, FOLDERTYPE nFolderType, UINT nFolderId,
                          int nParent, UINT nIconId, DWORD dwFlags, UINT nBits);
void            DeleteFolder(LPTREEFOLDER lpFolder);

BOOL InitFolders(UINT nGames);
BOOL AddFolder(LPTREEFOLDER lpFolder);
BOOL RemoveFolder(LPTREEFOLDER lpFolder);
void FreeFolders(void);

void SetCurrentFolder(LPTREEFOLDER lpFolder);
LPTREEFOLDER GetCurrentFolder(void);
LPTREEFOLDER GetFolder(UINT nFolder);
LPTREEFOLDER GetFolderByID(UINT nID);
UINT GetCurrentFolderID();

extern TREEFOLDER **    treeFolders;
extern UINT             numFolders;

void AddGame(LPTREEFOLDER lpFolder, UINT nGame);
void RemoveGame(LPTREEFOLDER lpFolder, UINT nGame);
int  FindGame(LPTREEFOLDER lpFolder, int nGame);

void InitTree(HWND hWnd, UINT nGames);
void InitGames(UINT nGames);

void Tree_Initialize(HWND hWnd);

#endif /* TREEVIEW_H */